/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.print;

import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.graphics.print.IPageDescription;

public class PageDescription
implements IPageDescription {
    private final Dimension pageDimension;
    private final Insets printAreaInsets;

    protected PageDescription(Dimension pageDimension, Insets pageAreaInsets) {
        this.pageDimension = pageDimension;
        this.printAreaInsets = pageAreaInsets;
    }

    public static IPageDescription createPrintInfoInMM(double wInMM, double hInMM, Insets insetsInMM) {
        return new PageDescription(new Dimension(wInMM, hInMM), insetsInMM);
    }

    public static IPageDescription createPrintInfoInMM(double wInMM, double hInMM, double insetsInMM) {
        return new PageDescription(new Dimension(wInMM, hInMM), new Insets(insetsInMM));
    }

    @Override
    public Dimension getPageDimension() {
        return this.pageDimension;
    }

    @Override
    public Insets getPrintAreaInsets() {
        return this.printAreaInsets;
    }
}

