/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.devicedrivers;

import com.arcway.lib.geometry.Arc;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.geometry.TurnedRectangle;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.EXNoMoreHandles;
import com.arcway.lib.graphics.IRenderer;
import com.arcway.lib.graphics.device.IDeviceRunnable;
import com.arcway.lib.graphics.devicedrivers.DeviceDriverInterpolating;
import com.arcway.lib.graphics.devicedrivers.IDeviceDriver;
import com.arcway.lib.graphics.devicedrivers.IDeviceDriverMetafile;
import com.arcway.lib.graphics.devicedrivers.IDeviceDriverOffscreenBitmap;
import com.arcway.lib.graphics.image.EXImageTooBig;
import com.arcway.lib.graphics.image.IImageData;
import com.arcway.lib.graphics.image.IOffscreenBitmap;
import com.arcway.lib.graphics.image.IPalette;
import com.arcway.lib.graphics.image.PixelData;
import com.arcway.lib.graphics.print.EXEmptyResult;
import com.arcway.lib.graphics.print.PrintingFailure;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class DeviceDriverWMF
extends DeviceDriverInterpolating
implements IDeviceDriverMetafile {
    private static final int INITIAL_METAFILE_UNITS_PER_INCH = 150;
    private static final ILogger logger = Logger.getLogger(DeviceDriverWMF.class);
    private static final int MIN_COORDINATE = 2000;
    private static final int MAX_COORDINATE = 30000;
    private static final int MAX_METAFILEUNITS_PER_INCH = 1440;
    private int metafileUnitsPerInch = 150;
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private byte[] buffer = null;
    private static final int CREATEBRUSHINDIRECT = 764;
    private static final int META_DIBCREATEPATTERNBRUSH = 322;
    private static final int CREATEFONTINDIRECT = 763;
    private static final int CREATEPENINDIRECT = 762;
    private static final int DELETEOBJECT = 496;
    private static final int ENDOFFILE = 0;
    private static final int DIBBITBLT = 2368;
    private static final int EXTTEXTOUT = 2610;
    private static final int POLYLINE = 805;
    private static final int POLYGON = 804;
    private static final int SAVEDEVICECONTEXT = 30;
    private static final int SELECTOBJECT = 301;
    private static final int SETBKMODE = 258;
    private static final int SETMAPMODE = 259;
    private static final int SETROP2 = 260;
    private static final int SETPOLYFILLMODE = 262;
    private static final int SETSTRETCHBLTMODE = 263;
    private static final int SETTEXTALIGN = 302;
    private static final int SETTEXTCOLOR = 521;
    private static final int SETWINDOWORGEXT = 523;
    private static final int SETWINDOWEXTEXT = 524;
    private static final int META_DIBSTRETCHBLT = 2881;
    private static final int RESTOREDEVICECONTEXT = 295;
    private static final int SOLID = 0;
    private static final int TRANSPARENT = 1;
    private static final int BASELINELEFT = 24;
    private static final int BASELINECENTER = 30;
    private static final int BASELINERIGHT = 26;
    private static final int INVISIBLE = 5;
    private static final int MOSTRECENTSTATE = -1;
    private static final int ANSI_CHARSET = 0;
    private static final int ISOTROPICMAPPING = 8;
    private static final int ZERO = 0;
    private static final int R2_MASKPEN = 9;
    private static final int R2_COPYPEN = 13;
    private static final int BS_DIBPATTERN = 5;
    private static final int DIB_RGB_COLORS = 0;
    private static final int PDSPDAOXXN = 73;
    private final int numberOfObjects = 4;
    private int sizeOfLargestRecord = 0;
    private TransformationAffiliate currentTransformation = TransformationAffiliate.newTransformationNOP();
    private final FillStyleForTransparency FILL_STYLE = new FillStyleForTransparency(8);
    private int fillstyle_rot = 3;
    private WMFPen currentPen = null;
    private WMFBrush currentBrush = null;
    private boolean patternBrushIsActive = false;
    private WMFPatternBrush currentPatternBrush = null;
    private int currentAlignment = -1;
    private WMFFont currentFont = null;
    private Color currentTextColor = null;

    @Override
    public Rectangle calculateTotalDrawingAreaInDriverCoordinates(Rectangle totalDrawingArea) {
        Dimension drawingDimensionInMM = totalDrawingArea == null ? new Dimension(1.0, 1.0) : totalDrawingArea.getDimension();
        Dimension drawingDimensionInInch = new Dimension(drawingDimensionInMM.width * 0.03937007874015748, drawingDimensionInMM.height * 0.03937007874015748);
        double maxDimensionInMetafileUnits = 28000.0;
        double widthPreferedMetafileUnitsPerInch = maxDimensionInMetafileUnits / drawingDimensionInInch.width;
        double heightPreferedMetafileUnitsPerInch = maxDimensionInMetafileUnits / drawingDimensionInInch.height;
        this.metafileUnitsPerInch = (int)Math.round(Math.min(1440.0, Math.min(widthPreferedMetafileUnitsPerInch, heightPreferedMetafileUnitsPerInch)));
        double metafileUnitsPerMM = (double)this.metafileUnitsPerInch * 0.03937007874015748;
        Dimension dimensionInMetafileUnits = new Dimension(drawingDimensionInMM.width * metafileUnitsPerMM, drawingDimensionInMM.height * metafileUnitsPerMM);
        Rectangle sizeInMetafileUnits = new Rectangle(2000.0, 2000.0, dimensionInMetafileUnits);
        return sizeInMetafileUnits;
    }

    @Override
    public IDeviceDriver startPage(TransformationAffiliate mmToDriverCoordinates, Rectangle pageSizeInDriverCoordinates) {
        this.buffer = null;
        this.byteArrayOutputStream.reset();
        this.sizeOfLargestRecord = 0;
        this.currentTransformation = TransformationAffiliate.newTransformationNOP();
        this.metafileUnitsPerInch = 150;
        this.writePlaceableHeader(pageSizeInDriverCoordinates, this.metafileUnitsPerInch);
        this.writePreliminaryHeader();
        this.wmfSetMapMode(8);
        this.wmfSetBkMode(1);
        this.updateAlignment(1);
        int x1 = DeviceDriverWMF.limitTo16BitSigned(pageSizeInDriverCoordinates.x());
        int y1 = DeviceDriverWMF.limitTo16BitSigned(pageSizeInDriverCoordinates.y());
        int x2 = DeviceDriverWMF.limitTo16BitSigned(pageSizeInDriverCoordinates.x() + pageSizeInDriverCoordinates.w());
        int y2 = DeviceDriverWMF.limitTo16BitSigned(pageSizeInDriverCoordinates.y() + pageSizeInDriverCoordinates.h());
        int w = x2 - x1;
        int h = y2 - y1;
        this.wmfSetWindowOrgExt(x1, y1);
        this.wmfSetWindowExtExt(w, h);
        this.wmfSaveDeviceContext();
        this.updatePen(0);
        this.updateBrush();
        int escapement = 0;
        this.updateFont(escapement);
        return this;
    }

    @Override
    public void endPage(IDeviceDriver deviceDriver) {
        this.wmfRestoreDeviceContext(-1);
        this.writeEndOfFile();
        this.buffer = this.byteArrayOutputStream.toByteArray();
        this.patchHeader();
    }

    @Override
    public void saveImageDirectly(OutputStream targetStream) throws PrintingFailure, EXEmptyResult {
        block14: {
            if (this.buffer != null) {
                try {
                    boolean noWriteErrorOccured = false;
                    try {
                        targetStream.write(this.buffer);
                        targetStream.flush();
                        noWriteErrorOccured = true;
                        break block14;
                    }
                    finally {
                        if (noWriteErrorOccured) {
                            targetStream.close();
                        } else {
                            try {
                                targetStream.close();
                            }
                            catch (Exception e) {
                                logger.debug("Problem wile closing Image File stream (probably caused by a previous error)", (Throwable)e);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new PrintingFailure(e);
                }
            }
            try {
                targetStream.close();
            }
            catch (Exception e) {
                logger.debug("Problem wile closing Image File stream", (Throwable)e);
            }
            throw new EXEmptyResult();
        }
    }

    @Override
    public <T extends Throwable> void subElement(String elementName, String elementTypeID, String elementID, TransformationAffiliate optionalTransformation, IDeviceRunnable<T> runnable) throws T {
        if (optionalTransformation != null) {
            TransformationAffiliate currentTrafo = this.currentTransformation;
            this.currentTransformation = optionalTransformation.transform(currentTrafo);
            try {
                runnable.run();
            }
            finally {
                this.currentTransformation = currentTrafo;
            }
        } else {
            runnable.run();
        }
    }

    private static byte getByte(int integer, int bytenumber) {
        switch (bytenumber) {
            case 1: {
                return (byte)(integer & 0xFF);
            }
            case 2: {
                return (byte)(integer >> 8 & 0xFF);
            }
            case 3: {
                return (byte)(integer >> 16 & 0xFF);
            }
            case 4: {
                return (byte)(integer >> 24 & 0xFF);
            }
        }
        return 0;
    }

    private static int getIntegerValueForWord(int integer, int wordNumber) {
        if (wordNumber == 1) {
            if (integer < 65536) {
                return integer;
            }
            return integer - 65536;
        }
        if (wordNumber == 2) {
            if (integer < 65536) {
                return 0;
            }
            return integer - 65536;
        }
        logger.error("getIntegerValueForWord() Invalid arguments: " + wordNumber);
        return 0;
    }

    private void writePreliminaryHeader() {
        int fileType = 1;
        this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(fileType, 1));
        this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(fileType, 2));
        this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(9, 1));
        this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(9, 2));
        this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(768, 1));
        this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(768, 2));
        this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(9, 1));
        this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(9, 2));
        this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(9, 3));
        this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(9, 4));
        this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(0, 1));
        this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(0, 2));
        this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(0, 1));
        this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(0, 2));
        this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(0, 3));
        this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(0, 4));
        this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(0, 1));
        this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(0, 2));
    }

    private void patchHeader() {
        int offset = 0;
        offset = this.buffer[0] == -41 ? 22 : 0;
        int fileSize = this.buffer.length;
        if (fileSize % 2 == 0) {
            fileSize /= 2;
        } else {
            logger.error("Invalid Size of WMF File! File must contain an even number of Bytes.");
        }
        this.buffer[offset + 6] = DeviceDriverWMF.getByte(fileSize, 1);
        this.buffer[offset + 7] = DeviceDriverWMF.getByte(fileSize, 2);
        this.buffer[offset + 8] = DeviceDriverWMF.getByte(fileSize, 3);
        this.buffer[offset + 9] = DeviceDriverWMF.getByte(fileSize, 4);
        this.buffer[offset + 10] = DeviceDriverWMF.getByte(4, 1);
        this.buffer[offset + 11] = DeviceDriverWMF.getByte(4, 2);
        this.buffer[offset + 12] = DeviceDriverWMF.getByte(this.sizeOfLargestRecord, 1);
        this.buffer[offset + 13] = DeviceDriverWMF.getByte(this.sizeOfLargestRecord, 2);
        this.buffer[offset + 14] = DeviceDriverWMF.getByte(this.sizeOfLargestRecord, 3);
        this.buffer[offset + 15] = DeviceDriverWMF.getByte(this.sizeOfLargestRecord, 4);
    }

    private void writePlaceableHeader(Rectangle pageSizeInMetafileUnits, int passedMetafileUnitsPerInch) {
        byte headerByte1 = DeviceDriverWMF.getByte(-1698247209, 1);
        byte headerByte2 = DeviceDriverWMF.getByte(-1698247209, 2);
        byte headerByte3 = DeviceDriverWMF.getByte(-1698247209, 3);
        byte headerByte4 = DeviceDriverWMF.getByte(-1698247209, 4);
        this.byteArrayOutputStream.write(headerByte1);
        this.byteArrayOutputStream.write(headerByte2);
        this.byteArrayOutputStream.write(headerByte3);
        this.byteArrayOutputStream.write(headerByte4);
        byte headerByte5 = DeviceDriverWMF.getByte(0, 1);
        byte headerByte6 = DeviceDriverWMF.getByte(0, 2);
        this.byteArrayOutputStream.write(headerByte5);
        this.byteArrayOutputStream.write(headerByte6);
        byte headerByte7 = DeviceDriverWMF.getByte((int)pageSizeInMetafileUnits.upperLeft.x, 1);
        byte headerByte8 = DeviceDriverWMF.getByte((int)pageSizeInMetafileUnits.upperLeft.x, 2);
        byte headerByte9 = DeviceDriverWMF.getByte((int)pageSizeInMetafileUnits.upperLeft.y, 1);
        byte headerByte10 = DeviceDriverWMF.getByte((int)pageSizeInMetafileUnits.upperLeft.y, 2);
        byte headerByte11 = DeviceDriverWMF.getByte((int)pageSizeInMetafileUnits.lowerRight.x, 1);
        byte headerByte12 = DeviceDriverWMF.getByte((int)pageSizeInMetafileUnits.lowerRight.x, 2);
        byte headerByte13 = DeviceDriverWMF.getByte((int)pageSizeInMetafileUnits.lowerRight.y, 1);
        byte headerByte14 = DeviceDriverWMF.getByte((int)pageSizeInMetafileUnits.lowerRight.y, 2);
        this.byteArrayOutputStream.write(headerByte7);
        this.byteArrayOutputStream.write(headerByte8);
        this.byteArrayOutputStream.write(headerByte9);
        this.byteArrayOutputStream.write(headerByte10);
        this.byteArrayOutputStream.write(headerByte11);
        this.byteArrayOutputStream.write(headerByte12);
        this.byteArrayOutputStream.write(headerByte13);
        this.byteArrayOutputStream.write(headerByte14);
        byte headerByte15 = DeviceDriverWMF.getByte(passedMetafileUnitsPerInch, 1);
        byte headerByte16 = DeviceDriverWMF.getByte(passedMetafileUnitsPerInch, 2);
        this.byteArrayOutputStream.write(headerByte15);
        this.byteArrayOutputStream.write(headerByte16);
        byte headerByte17 = DeviceDriverWMF.getByte(0, 1);
        byte headerByte18 = DeviceDriverWMF.getByte(0, 2);
        byte headerByte19 = DeviceDriverWMF.getByte(0, 3);
        byte headerByte20 = DeviceDriverWMF.getByte(0, 4);
        this.byteArrayOutputStream.write(headerByte17);
        this.byteArrayOutputStream.write(headerByte18);
        this.byteArrayOutputStream.write(headerByte19);
        this.byteArrayOutputStream.write(headerByte20);
        byte checksum1 = (byte)(headerByte1 ^ headerByte3 ^ headerByte5 ^ headerByte7 ^ headerByte9 ^ headerByte11 ^ headerByte13 ^ headerByte15 ^ headerByte17 ^ headerByte19);
        byte checksum2 = (byte)(headerByte2 ^ headerByte4 ^ headerByte6 ^ headerByte8 ^ headerByte10 ^ headerByte12 ^ headerByte14 ^ headerByte16 ^ headerByte18 ^ headerByte20);
        this.byteArrayOutputStream.write(checksum1);
        this.byteArrayOutputStream.write(checksum2);
    }

    private static int limitTo16BitSigned(double in) {
        int out = in <= -32767.5 ? 32768 : (in >= 32766.5 ? Short.MAX_VALUE : (int)Math.round(in));
        return out;
    }

    private void writeRecord(int functionNumber, int[] params) {
        int sizeInWords = 3 + params.length;
        this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(sizeInWords, 1));
        this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(sizeInWords, 2));
        this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(sizeInWords, 3));
        this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(sizeInWords, 4));
        if (sizeInWords > this.sizeOfLargestRecord) {
            this.sizeOfLargestRecord = sizeInWords;
        }
        this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(functionNumber, 1));
        this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(functionNumber, 2));
        int[] nArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(element, 1));
            this.byteArrayOutputStream.write(DeviceDriverWMF.getByte(element, 2));
            ++n2;
        }
    }

    private void writeEndOfFile() {
        this.writeRecord(0, new int[0]);
    }

    private void wmfSetMapMode(int mapMode) {
        this.writeRecord(259, new int[]{mapMode});
    }

    private void wmfSetROp2(int mapMode) {
        this.writeRecord(260, new int[]{mapMode});
    }

    private void wmfSetWindowOrgExt(int x, int y) {
        this.writeRecord(523, new int[]{y, x});
    }

    private void wmfSetWindowExtExt(int x, int y) {
        this.writeRecord(524, new int[]{y, x});
    }

    private void wmfPolyline(Points points) {
        if (points.size() > 1) {
            int[] args = new int[points.size() * 2 + 1];
            args[0] = points.size();
            int i = 1;
            while (i <= points.size()) {
                args[(i - 1) * 2 + 1] = DeviceDriverWMF.limitTo16BitSigned(points.get((int)(i - 1)).x);
                args[(i - 1) * 2 + 2] = DeviceDriverWMF.limitTo16BitSigned(points.get((int)(i - 1)).y);
                ++i;
            }
            this.writeRecord(805, args);
        } else {
            logger.warn("Invalid arguments for function: wmfPolyline");
        }
    }

    private void wmfPolygon(Points points) {
        if (points.size() > 1) {
            int[] args = new int[points.size() * 2 + 1];
            args[0] = points.size();
            int i = 1;
            while (i <= points.size()) {
                args[(i - 1) * 2 + 1] = DeviceDriverWMF.limitTo16BitSigned(points.get((int)(i - 1)).x);
                args[(i - 1) * 2 + 2] = DeviceDriverWMF.limitTo16BitSigned(points.get((int)(i - 1)).y);
                ++i;
            }
            this.writeRecord(804, args);
        } else {
            logger.warn("Invalid arguments for function: wmfPolygon");
        }
    }

    private void wmfExtTextOut(Point position, String text) {
        int textLength = text.length();
        int numberOfWORDSForText = 0;
        numberOfWORDSForText = textLength % 2 == 0 ? textLength / 2 : (textLength + 1) / 2;
        int numberOfArguments = 4 + numberOfWORDSForText;
        int[] args = new int[numberOfArguments];
        args[0] = DeviceDriverWMF.limitTo16BitSigned(position.y);
        args[1] = DeviceDriverWMF.limitTo16BitSigned(position.x);
        args[2] = DeviceDriverWMF.getIntegerValueForWord(text.length(), 1);
        args[3] = DeviceDriverWMF.getIntegerValueForWord(text.length(), 2);
        int i = 0;
        while (i < numberOfWORDSForText) {
            byte[] textbytes = null;
            try {
                textbytes = text.getBytes("windows-1252");
            }
            catch (UnsupportedEncodingException e) {
                logger.debug("Unable to encode WMF characters correctly (\"windows-1252\") .", (Throwable)e);
                try {
                    textbytes = text.getBytes("ISO-8859-1");
                }
                catch (UnsupportedEncodingException e1) {
                    logger.debug("Unable to encode WMF characters correctly (\"ISO-8859-1\").", (Throwable)e1);
                    textbytes = text.getBytes();
                }
            }
            args[4 + i] = textLength % 2 != 0 && i == numberOfWORDSForText - 1 ? textbytes[i * 2] & 0xFF : textbytes[i * 2] & 0xFF | textbytes[i * 2 + 1] << 8;
            ++i;
        }
        this.writeRecord(2610, args);
    }

    private void wmfSelectObject(int objectNumber) {
        this.writeRecord(301, new int[]{objectNumber});
    }

    private void wmfCreatePenIndirect(int style, int width, Color color) {
        int[] nArray = new int[5];
        nArray[0] = style;
        nArray[1] = width;
        nArray[3] = DeviceDriverWMF.getWMFColorValue(color, 1);
        nArray[4] = DeviceDriverWMF.getWMFColorValue(color, 2);
        this.writeRecord(762, nArray);
    }

    private void wmfCreateBrushIndirect(int style, Color color, int hatch) {
        this.writeRecord(764, new int[]{style, DeviceDriverWMF.getWMFColorValue(color, 1), DeviceDriverWMF.getWMFColorValue(color, 2), hatch});
    }

    private void wmfSetPolyfillMode(int mode) {
        this.writeRecord(262, new int[1]);
    }

    private void wmfDIBBitBltForTransparency(Rectangle rect) {
        int x = (int)Math.floor(rect.x());
        int y = (int)Math.floor(rect.y());
        int x2 = (int)Math.ceil(rect.x() + rect.w());
        int y2 = (int)Math.ceil(rect.y() + rect.h());
        int w = x2 - x + 1;
        int h = y2 - y + 1;
        int[] nArray = new int[9];
        nArray[0] = 73;
        nArray[1] = Integer.parseInt("01011010", 2);
        nArray[5] = h;
        nArray[6] = w;
        nArray[7] = y;
        nArray[8] = x;
        this.writeRecord(2368, nArray);
    }

    private void wmfCreatePatternBrush(int alpha) {
        this.FILL_STYLE.clear();
        this.FILL_STYLE.fill(alpha);
        int[] nArray = new int[42];
        nArray[0] = 5;
        nArray[2] = 40;
        nArray[4] = 8;
        nArray[6] = 8;
        nArray[8] = 1;
        nArray[9] = 1;
        nArray[12] = 32;
        nArray[24] = 65535;
        nArray[25] = 255;
        nArray[26] = this.FILL_STYLE.getMask(0);
        nArray[28] = this.FILL_STYLE.getMask(1);
        nArray[30] = this.FILL_STYLE.getMask(2);
        nArray[32] = this.FILL_STYLE.getMask(3);
        nArray[34] = this.FILL_STYLE.getMask(4);
        nArray[36] = this.FILL_STYLE.getMask(5);
        nArray[38] = this.FILL_STYLE.getMask(6);
        nArray[40] = this.FILL_STYLE.getMask(7);
        this.writeRecord(322, nArray);
    }

    private FillStyleNode createFillStyleNode(int size) {
        return this.createFillStyleNode(size, 0, 0);
    }

    private FillStyleNode createFillStyleNode(int size, int offX, int offY) {
        FillStyleNode node;
        if (size == 1) {
            node = new FillStylePixel(offX, offY);
        } else {
            int childSize = size >> 1;
            FillStyleNode upperLeft = this.createFillStyleNode(childSize, offX, offY);
            FillStyleNode upperRight = this.createFillStyleNode(childSize, offX + childSize, offY);
            FillStyleNode lowerLeft = this.createFillStyleNode(childSize, offX, offY + childSize);
            FillStyleNode lowerRight = this.createFillStyleNode(childSize, offX + childSize, offY + childSize);
            node = new FillStyleContainer(upperLeft, upperRight, lowerLeft, lowerRight);
        }
        return node;
    }

    private void wmfCreateFontIndirect(int height, int width, int escapement, int orientation, int weight, boolean isItalic, boolean isUnderlined, boolean isStrikedOut, int charSet, int outPrecision, int clipPrecision, int quality, int pitchAndFamily, String fontName) {
        byte[] encodedTypefaceName;
        try {
            encodedTypefaceName = fontName.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Unable to encode fonts typeface name correctly (\"ISO-8859-1\").", (Throwable)e);
            encodedTypefaceName = fontName.getBytes();
        }
        byte[] nullTerminatedEncodedTypefaceName = new byte[encodedTypefaceName.length + 1];
        System.arraycopy(encodedTypefaceName, 0, nullTerminatedEncodedTypefaceName, 0, encodedTypefaceName.length);
        nullTerminatedEncodedTypefaceName[nullTerminatedEncodedTypefaceName.length - 1] = 0;
        if (nullTerminatedEncodedTypefaceName.length > 32) {
            logger.error("Unable to encode fonts typeface name \"" + fontName + "\" correctly because its encoding would require more than 32 bytes - will truncate it.");
            nullTerminatedEncodedTypefaceName = new byte[32];
            System.arraycopy(encodedTypefaceName, 0, nullTerminatedEncodedTypefaceName, 0, 31);
            nullTerminatedEncodedTypefaceName[31] = 0;
        }
        int numberOfWORDSForFontName = nullTerminatedEncodedTypefaceName.length % 2 == 0 ? nullTerminatedEncodedTypefaceName.length / 2 : (nullTerminatedEncodedTypefaceName.length + 1) / 2;
        int[] args = new int[9 + numberOfWORDSForFontName];
        int isItalicAndOrUnderlined = 0;
        isItalicAndOrUnderlined = isUnderlined ? (isItalic ? 257 : 256) : (isItalic ? 1 : 0);
        int isStrikedOutAndCharSet = 0;
        isStrikedOutAndCharSet = isStrikedOut ? charSet * 256 + 1 : charSet * 256;
        int outAndClipPrecision = 0;
        outAndClipPrecision = outPrecision + clipPrecision * 256;
        int qualityAndPitchAndFamily = 0;
        qualityAndPitchAndFamily = quality + pitchAndFamily * 256;
        args[0] = height;
        args[1] = width;
        args[2] = escapement;
        args[3] = orientation;
        args[4] = weight;
        args[5] = isItalicAndOrUnderlined;
        args[6] = isStrikedOutAndCharSet;
        args[7] = outAndClipPrecision;
        args[8] = qualityAndPitchAndFamily;
        int i = 0;
        while (i < numberOfWORDSForFontName) {
            args[9 + i] = i != numberOfWORDSForFontName - 1 ? nullTerminatedEncodedTypefaceName[i * 2] & 0xFF | nullTerminatedEncodedTypefaceName[i * 2 + 1] << 8 : (nullTerminatedEncodedTypefaceName.length % 2 == 0 ? nullTerminatedEncodedTypefaceName[i * 2] & 0xFF | nullTerminatedEncodedTypefaceName[i * 2 + 1] << 8 : nullTerminatedEncodedTypefaceName[i * 2] & 0xFF);
            ++i;
        }
        this.writeRecord(763, args);
    }

    private void wmfDeleteObject(int objectNumber) {
        this.writeRecord(496, new int[]{objectNumber});
    }

    private void wmfSaveDeviceContext() {
        this.writeRecord(30, new int[0]);
    }

    private void wmfSetStretchBLTMode(int mode) {
        this.writeRecord(263, new int[]{mode});
    }

    private void wmfSetBkMode(int backgroundMode) {
        this.writeRecord(258, new int[]{backgroundMode});
    }

    private void wmfSetTextAlign(int textAlignmentMode) {
        int[] nArray = new int[2];
        nArray[0] = textAlignmentMode;
        this.writeRecord(302, nArray);
    }

    private void wmfSetTextColor(Color color) {
        this.writeRecord(521, new int[]{DeviceDriverWMF.getWMFColorValue(color, 1), DeviceDriverWMF.getWMFColorValue(color, 2)});
    }

    private void wmfStretchBLT(IOffscreenBitmap image, int sourceX, int sourceY, int sourceW, int sourceH, Rectangle destination) {
        int bitCount = 24;
        boolean planes = true;
        int numberOfWordsForPixelsPerRow = (sourceW * 1 * 24 + 31) / 32 * 2;
        int numberOfWordsForPixels = numberOfWordsForPixelsPerRow * sourceH;
        int[] args = new int[30 + numberOfWordsForPixels];
        args[0] = 32;
        args[1] = 204;
        args[2] = sourceH;
        args[3] = sourceW;
        args[4] = sourceY;
        args[5] = sourceX;
        double x1 = Math.round(destination.x());
        double y1 = Math.round(destination.y());
        double x2 = Math.round(destination.x() + destination.w());
        double y2 = Math.round(destination.y() + destination.h());
        double w = x2 - x1;
        double h = y2 - y1;
        args[6] = DeviceDriverWMF.limitTo16BitSigned(h);
        args[7] = DeviceDriverWMF.limitTo16BitSigned(w);
        args[8] = DeviceDriverWMF.limitTo16BitSigned(y1);
        args[9] = DeviceDriverWMF.limitTo16BitSigned(x1);
        args[10] = DeviceDriverWMF.getIntegerValueForWord(40, 1);
        args[11] = DeviceDriverWMF.getIntegerValueForWord(40, 2);
        args[12] = DeviceDriverWMF.getIntegerValueForWord(sourceW, 1);
        args[13] = DeviceDriverWMF.getIntegerValueForWord(sourceW, 2);
        args[14] = DeviceDriverWMF.getIntegerValueForWord(sourceH, 1);
        args[15] = DeviceDriverWMF.getIntegerValueForWord(sourceH, 2);
        args[16] = 1;
        args[17] = 24;
        args[18] = DeviceDriverWMF.getIntegerValueForWord(0, 1);
        args[19] = DeviceDriverWMF.getIntegerValueForWord(0, 2);
        args[20] = DeviceDriverWMF.getIntegerValueForWord(0, 1);
        args[21] = DeviceDriverWMF.getIntegerValueForWord(0, 2);
        args[22] = DeviceDriverWMF.getIntegerValueForWord(0, 1);
        args[23] = DeviceDriverWMF.getIntegerValueForWord(0, 2);
        args[24] = DeviceDriverWMF.getIntegerValueForWord(0, 1);
        args[25] = DeviceDriverWMF.getIntegerValueForWord(0, 2);
        args[26] = DeviceDriverWMF.getIntegerValueForWord(0, 1);
        args[27] = DeviceDriverWMF.getIntegerValueForWord(0, 2);
        args[28] = DeviceDriverWMF.getIntegerValueForWord(0, 1);
        args[29] = DeviceDriverWMF.getIntegerValueForWord(0, 1);
        try {
            int blueBitDepth;
            int greenBitDepth;
            int redBitDepth;
            IImageData imageData = image.getSnapshot();
            IPalette palette = imageData.getPalette();
            PixelData colorDepth = imageData.getBitDepth();
            PixelData currentPixelData = new PixelData();
            if (palette == null) {
                redBitDepth = colorDepth.r;
                greenBitDepth = colorDepth.g;
                blueBitDepth = colorDepth.b;
            } else {
                redBitDepth = 8;
                greenBitDepth = 8;
                blueBitDepth = 8;
            }
            int currentRed = 0;
            int currentGreen = 0;
            int currentBlue = 0;
            int rowNumber = sourceH - 1;
            while (rowNumber >= 0) {
                int collumnNumber = 0;
                while (collumnNumber < sourceW) {
                    int adataWordOffset = numberOfWordsForPixelsPerRow * (sourceH - 1 - rowNumber) + collumnNumber * 3 / 2;
                    imageData.getPixel(collumnNumber, rowNumber, currentPixelData);
                    if (palette != null) {
                        currentRed = palette.getColors()[currentPixelData.colorIndex].r;
                        currentGreen = palette.getColors()[currentPixelData.colorIndex].g;
                        currentBlue = palette.getColors()[currentPixelData.colorIndex].b;
                    } else {
                        currentRed = Color.convertBitDepth(currentPixelData.r, redBitDepth, 8);
                        currentGreen = Color.convertBitDepth(currentPixelData.g, greenBitDepth, 8);
                        currentBlue = Color.convertBitDepth(currentPixelData.b, blueBitDepth, 8);
                    }
                    if (currentRed > 255 || currentGreen > 255 || currentBlue > 255) {
                        logger.warn("Invalid ranges for color values (r=" + currentRed + ", g=" + currentGreen + ", b=" + currentBlue + ") at (x=" + collumnNumber + ", y=" + rowNumber + ".");
                        assert (false);
                        currentRed &= 0xFF;
                        currentGreen &= 0xFF;
                        currentBlue &= 0xFF;
                    }
                    if (collumnNumber % 2 == 0) {
                        args[30 + adataWordOffset] = 256 * currentGreen + currentBlue;
                        int n = 30 + adataWordOffset + 1;
                        args[n] = args[n] | currentRed;
                    } else {
                        int n = 30 + adataWordOffset;
                        args[n] = args[n] | 256 * currentBlue;
                        args[30 + adataWordOffset + 1] = 256 * currentRed + currentGreen;
                    }
                    ++collumnNumber;
                }
                --rowNumber;
            }
        }
        catch (EXImageTooBig exception) {
            logger.error("Image too big for WMF export: " + exception);
        }
        this.writeRecord(2881, args);
    }

    private void wmfRestoreDeviceContext(int stateNumber) {
        this.writeRecord(295, new int[]{stateNumber});
    }

    private static int getWMFColorValue(Color color, int partNumber) {
        int red = color.r;
        int green = color.g;
        int blue = color.b;
        if (red > 255 || green > 255 || blue > 255) {
            logger.warn("Invalid ranges for color values.");
            return 0;
        }
        if (partNumber == 1) {
            return green * 256 + red;
        }
        return blue;
    }

    private void updatePen(int style) {
        int width = (int)this.getLineWidth();
        Color color = this.getLineColor();
        WMFPen newPen = new WMFPen(style, width, color);
        if (this.currentPen == null || !newPen.equals(this.currentPen)) {
            if (this.currentPen != null) {
                this.currentPen.delete();
                this.currentPen = null;
            }
            newPen.createAndActivate();
            this.currentPen = newPen;
        }
    }

    private void updateBrush() {
        int style = 0;
        Color color = this.getFillColor();
        int hatch = 0;
        WMFBrush newBrush = new WMFBrush(style, color, hatch);
        if (this.currentBrush == null || !newBrush.equals(this.currentBrush)) {
            if (this.currentBrush != null) {
                this.currentBrush.delete();
                this.currentBrush = null;
            }
            newBrush.createAndActivate();
            this.currentBrush = newBrush;
        } else if (this.currentBrush != null && this.patternBrushIsActive) {
            this.currentBrush.activate();
        }
    }

    private void updatePatternBrush() {
        int alpha = this.getFillAlpha();
        WMFPatternBrush newPatternBrush = new WMFPatternBrush(alpha);
        if (this.currentPatternBrush == null || !newPatternBrush.equals(this.currentPatternBrush)) {
            if (this.currentPatternBrush != null) {
                this.currentPatternBrush.delete();
                this.currentPatternBrush = null;
            }
            newPatternBrush.createAndActivate();
            this.currentPatternBrush = newPatternBrush;
        } else if (this.currentPatternBrush != null && !this.patternBrushIsActive) {
            this.currentPatternBrush.activate();
        }
    }

    private void updateAlignment(int newAlignment) {
        if (newAlignment != this.currentAlignment) {
            int textAlignmentMode;
            switch (newAlignment) {
                case 2: {
                    textAlignmentMode = 30;
                    break;
                }
                case 4: {
                    textAlignmentMode = 26;
                    break;
                }
                default: {
                    textAlignmentMode = 24;
                }
            }
            this.wmfSetTextAlign(textAlignmentMode);
            this.currentAlignment = newAlignment;
        }
    }

    private void updateFont(int escapement) {
        double textEmHeigt = this.getTextTop() - this.getTextDescent();
        int height = (int)textEmHeigt;
        int width = 0;
        int orientation = 0;
        boolean isBold = this.isTextBold();
        boolean isItalic = this.isTextItalic();
        boolean isUnderlined = false;
        boolean isStrikedOut = false;
        int charSet = 0;
        int outPrecision = 7;
        int clipPrecision = 0;
        int quality = 4;
        int pitchAndFamily = 0;
        String fontName = this.getTextFontName();
        WMFFont newFont = new WMFFont(height, width, escapement, orientation, isBold, isItalic, isUnderlined, isStrikedOut, charSet, outPrecision, clipPrecision, quality, pitchAndFamily, fontName);
        if (this.currentFont == null || !newFont.equals(this.currentFont)) {
            if (this.currentFont != null) {
                this.currentFont.delete();
                this.currentFont = null;
            }
            newFont.createAndActivate();
            this.currentFont = newFont;
        }
    }

    private void updateTextColor() {
        Color newTextColor = this.getTextColor();
        this.updateTextColor(newTextColor);
    }

    private void updateTextColor(Color newTextColor) {
        if (this.currentTextColor == null || !newTextColor.equalsColor(this.currentTextColor)) {
            this.wmfSetTextColor(newTextColor);
            this.currentTextColor = newTextColor;
        }
    }

    @Override
    protected void fillPoints(Points points) {
        int alpha = this.getFillAlpha();
        boolean isTransparent = alpha > 0 && alpha < 255;
        this.updatePen(5);
        this.updateBrush();
        Points pointsT = points.transform(this.currentTransformation);
        if (isTransparent) {
            this.beginTransparency(pointsT);
        }
        this.wmfPolygon(pointsT);
        if (isTransparent) {
            this.endTransparency(pointsT);
        }
    }

    private void beginTransparency(Points points) {
        Rectangle bounds = points.getBounds();
        this.wmfDIBBitBltForTransparency(bounds);
        this.wmfSetROp2(9);
        this.updateTextColor(Color.WHITE);
        this.updatePatternBrush();
        this.wmfSetPolyfillMode(1);
    }

    private void endTransparency(Points points) {
        this.wmfSetPolyfillMode(1);
        this.updateBrush();
        this.updateTextColor(Color.BLACK);
        this.wmfSetROp2(13);
        Rectangle bounds = points.getBounds();
        this.wmfDIBBitBltForTransparency(bounds);
    }

    @Override
    public void plot(Point point) {
        this.updatePen(0);
        Point pT = point.transform(this.currentTransformation);
        Points points = new Points();
        points.add(pT);
        points.add(pT);
        this.wmfPolyline(points);
    }

    @Override
    public void line(Line line) {
        this.updatePen(0);
        Points points = new Points();
        points.add(line.start);
        points.add(line.end);
        Points pointsT = points.transform(this.currentTransformation);
        this.wmfPolyline(pointsT);
    }

    @Override
    public void arc(Arc arc) {
        this.updatePen(0);
        Points points = arc.getPointsApproximated(50, 1.0);
        if (points.size() == 1) {
            points.add(points.get(0));
        }
        Points pointsT = points.transform(this.currentTransformation);
        this.wmfPolyline(pointsT);
    }

    @Override
    public void skipPlot(Point point) {
    }

    @Override
    public void skipLine(Line line) {
    }

    @Override
    public void skipArc(Arc arc) {
    }

    @Override
    public boolean isNotInterestedInRealTextDrawing() {
        return false;
    }

    @Override
    public void text(Point p, double textLength, String text, TurnedRectangle clippingHint) {
        Point pT = p.transform(this.currentTransformation);
        Direction direction = this.getTextDirection();
        Direction dT = GeoVector.GeoVector_1_0.turn(direction).transform(p, this.currentTransformation).getDirection();
        int escapement = (int)Math.round(dT.getAngle() * 10.0);
        this.updateFont(escapement);
        this.updateAlignment(this.getTextAlignment());
        this.updateTextColor();
        this.wmfExtTextOut(pT, text);
    }

    @Override
    public boolean supportsNullImage() {
        return false;
    }

    @Override
    public void drawImage(IOffscreenBitmap image, int sourceX, int sourceY, int sourceW, int sourceH, TurnedRectangle turnedScaleToRectangleO, int alpha) {
        Rectangle targetRectangle;
        IOffscreenBitmap turnedImage;
        TurnedRectangle turnedScaleToRectangle = turnedScaleToRectangleO.transform(this.currentTransformation);
        Direction direction = turnedScaleToRectangle.getDirection();
        double angle = direction.getAngle();
        double scale = Geo.isZero(Geo.getNormalizedAngle(angle + 1.0E-10) % 90.0 - 1.0E-10) ? 1.0 : 2.0;
        Dimension turnedImageTurnedDimension = new Dimension((double)sourceW * scale, (double)sourceH * scale);
        TurnedRectangle temp = new TurnedRectangle(Point.ORIGIN, turnedImageTurnedDimension, direction);
        Rectangle tempOuter = temp.getOuterBounds();
        Point center = new Point(tempOuter.w() / 2.0, tempOuter.h() / 2.0);
        TurnedRectangle turnedImageTurnedRectangle = new TurnedRectangle(center, turnedImageTurnedDimension, direction);
        Rectangle turnedImageOuterRectangle = turnedImageTurnedRectangle.getOuterBounds();
        int offscreenW = (int)Math.round(turnedImageOuterRectangle.lowerRight.x);
        int offscreenH = (int)Math.round(turnedImageOuterRectangle.lowerRight.y);
        IRenderer renderer = image.getRenderer();
        try {
            turnedImage = renderer.createOffscreenBitmap(offscreenW, offscreenH, Color.TRANSPARENT, image.isLossyImage() && direction.isOrthogonal());
            IDeviceDriverOffscreenBitmap deviceDriver = turnedImage.createDeviceDriver();
            deviceDriver.drawImage(image, sourceX, sourceY, sourceW, sourceH, turnedImageTurnedRectangle, alpha);
            deviceDriver.dispose();
            targetRectangle = turnedScaleToRectangle.getOuterBounds();
        }
        catch (EXImageTooBig e) {
            logger.error((Throwable)e);
            turnedImage = image;
            TurnedRectangle innerTargetTurnedRectangle = turnedScaleToRectangle.turnAndShrinkToBiggest(Direction.valueOf(-angle));
            targetRectangle = new Rectangle(innerTargetTurnedRectangle.getUpperLeft(), innerTargetTurnedRectangle.getLowerRight());
        }
        catch (EXNoMoreHandles e) {
            logger.error((Throwable)e);
            turnedImage = image;
            TurnedRectangle innerTargetTurnedRectangle = turnedScaleToRectangle.turnAndShrinkToBiggest(Direction.valueOf(-angle));
            targetRectangle = new Rectangle(innerTargetTurnedRectangle.getUpperLeft(), innerTargetTurnedRectangle.getLowerRight());
        }
        this.wmfSetStretchBLTMode(4);
        this.wmfStretchBLT(turnedImage, 0, 0, turnedImage.getWidthInPixels(), turnedImage.getHeightInPixels(), targetRectangle);
        if (turnedImage != image) {
            turnedImage.dispose();
        }
    }

    private class FillStyleContainer
    extends FillStyleNode {
        private final FillStyleNode[] childNodes;

        public FillStyleContainer(FillStyleNode upperLeft, FillStyleNode upperRight, FillStyleNode lowerLeft, FillStyleNode lowerRight) {
            this.childNodes = new FillStyleNode[]{upperLeft, lowerRight, lowerLeft, upperRight};
        }

        @Override
        protected int getNrOfPixels() {
            int nrOfPixels = 0;
            int i = 0;
            while (i < this.childNodes.length) {
                nrOfPixels += this.childNodes[i].getNrOfPixels();
                ++i;
            }
            return nrOfPixels;
        }

        @Override
        protected int getNrOfSetPixels() {
            int nrOfPixels = 0;
            int i = 0;
            while (i < this.childNodes.length) {
                nrOfPixels += this.childNodes[i].getNrOfSetPixels();
                ++i;
            }
            return nrOfPixels;
        }

        @Override
        protected void setOnePixel() {
            int minNrOfPixels = Integer.MAX_VALUE;
            FillStyleNode node = this.childNodes[0];
            int i = 0;
            while (i < this.childNodes.length) {
                FillStyleNode currentNode = this.childNodes[i];
                int currentNrOfPixels = currentNode.getNrOfSetPixels();
                if (currentNrOfPixels < minNrOfPixels) {
                    node = currentNode;
                    minNrOfPixels = currentNrOfPixels;
                }
                ++i;
            }
            node.setOnePixel();
        }

        @Override
        protected void clear() {
            int i = 0;
            while (i < this.childNodes.length) {
                this.childNodes[i].clear();
                ++i;
            }
        }

        @Override
        public void mask(int[] mask) {
            int i = 0;
            while (i < this.childNodes.length) {
                this.childNodes[i].mask(mask);
                ++i;
            }
        }
    }

    private class FillStyleForTransparency {
        private final int[] mask;
        private final FillStyleNode fillStyleNode;

        public FillStyleForTransparency(int size) {
            this.mask = new int[size];
            this.fillStyleNode = DeviceDriverWMF.this.createFillStyleNode(size);
        }

        public void clear() {
            this.fillStyleNode.clear();
            int i = 0;
            while (i < this.mask.length) {
                this.mask[i] = 0;
                ++i;
            }
            DeviceDriverWMF.this.fillstyle_rot = (DeviceDriverWMF.this.fillstyle_rot + 1) % 4;
        }

        public void fill(int alpha) {
            this.fillStyleNode.fill(alpha);
            this.fillStyleNode.mask(this.mask);
            if (DeviceDriverWMF.this.fillstyle_rot / 2 == 1) {
                int tmp = this.mask[0];
                int i = 1;
                while (i < this.mask.length) {
                    this.mask[i - 1] = this.mask[i];
                    ++i;
                }
                this.mask[this.mask.length - 1] = tmp;
            }
        }

        public int getMask(int line) {
            return this.mask[line];
        }
    }

    private abstract class FillStyleNode {
        private FillStyleNode() {
        }

        protected abstract int getNrOfPixels();

        protected abstract int getNrOfSetPixels();

        protected abstract void setOnePixel();

        protected abstract void clear();

        public void fill(int alpha) {
            double solidPixelRatio = 1.0 - (double)alpha / 255.0;
            int nrOfPixels = this.getNrOfPixels();
            int nrOfPixelsToSet = (int)Math.round(solidPixelRatio * (double)nrOfPixels);
            this.setPixels(nrOfPixelsToSet);
        }

        private void setPixels(int nrOfPixels) {
            int i = 0;
            while (i < nrOfPixels) {
                this.setOnePixel();
                ++i;
            }
        }

        public abstract void mask(int[] var1);
    }

    private class FillStylePixel
    extends FillStyleNode {
        private final int x;
        private final int y;
        private boolean isSet = false;

        public FillStylePixel(int x, int y) {
            this.x = x;
            this.y = y;
        }

        @Override
        protected int getNrOfPixels() {
            return 1;
        }

        @Override
        protected int getNrOfSetPixels() {
            return this.isSet ? 1 : 0;
        }

        @Override
        protected void setOnePixel() {
            this.isSet = true;
        }

        @Override
        protected void clear() {
            this.isSet = false;
        }

        @Override
        public void mask(int[] mask) {
            if (this.isSet) {
                int bitMask = 1 << 7 - this.x;
                if (DeviceDriverWMF.this.fillstyle_rot % 2 == 1) {
                    bitMask = ((bitMask & 1) == 1 ? 128 : 0) | bitMask >> 1;
                }
                int n = this.y;
                mask[n] = mask[n] | bitMask;
            }
        }
    }

    private class WMFBrush {
        private final int style;
        private final Color color;
        private final int hatch;

        private WMFBrush(int style, Color color, int hatch) {
            this.style = style;
            this.color = color;
            this.hatch = hatch;
        }

        private void delete() {
            DeviceDriverWMF.this.wmfDeleteObject(1);
        }

        public void createAndActivate() {
            DeviceDriverWMF.this.wmfCreateBrushIndirect(this.style, this.color, this.hatch);
            this.activate();
        }

        private void activate() {
            DeviceDriverWMF.this.wmfSelectObject(1);
            DeviceDriverWMF.this.patternBrushIsActive = false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.color == null ? 0 : this.color.hashCodeEqualsColor());
            result = 31 * result + this.hatch;
            result = 31 * result + this.style;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WMFBrush other = (WMFBrush)obj;
            if (this.color == null ? other.color != null : !this.color.equalsColor(other.color)) {
                return false;
            }
            if (this.hatch != other.hatch) {
                return false;
            }
            return this.style == other.style;
        }
    }

    private class WMFFont {
        private final int height;
        private final int width;
        private final int escapement;
        private final int orientation;
        private final boolean isBold;
        private final boolean isItalic;
        private final boolean isUnderlined;
        private final boolean isStrikedOut;
        private final int charSet;
        private final int outPrecision;
        private final int clipPrecision;
        private final int quality;
        private final int pitchAndFamily;
        private final String fontName;

        private WMFFont(int height, int width, int escapement, int orientation, boolean isBold, boolean isItalic, boolean isUnderlined, boolean isStrikedOut, int charSet, int outPrecision, int clipPrecision, int quality, int pitchAndFamily, String fontName) {
            this.height = height;
            this.width = width;
            this.escapement = escapement;
            this.orientation = orientation;
            this.isBold = isBold;
            this.isItalic = isItalic;
            this.isUnderlined = isUnderlined;
            this.isStrikedOut = isStrikedOut;
            this.charSet = charSet;
            this.outPrecision = outPrecision;
            this.clipPrecision = clipPrecision;
            this.quality = quality;
            this.pitchAndFamily = pitchAndFamily;
            this.fontName = fontName;
        }

        public void delete() {
            DeviceDriverWMF.this.wmfDeleteObject(2);
        }

        public void createAndActivate() {
            int textWeight = 0;
            textWeight = this.isBold ? 700 : 400;
            DeviceDriverWMF.this.wmfCreateFontIndirect(this.height, this.width, this.escapement, this.orientation, textWeight, this.isItalic, this.isUnderlined, this.isStrikedOut, this.charSet, this.outPrecision, this.clipPrecision, this.quality, this.pitchAndFamily, this.fontName);
            DeviceDriverWMF.this.wmfSelectObject(2);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.charSet;
            result = 31 * result + this.clipPrecision;
            result = 31 * result + this.escapement;
            result = 31 * result + (this.fontName == null ? 0 : this.fontName.hashCode());
            result = 31 * result + this.height;
            result = 31 * result + (this.isBold ? 1231 : 1237);
            result = 31 * result + (this.isItalic ? 1231 : 1237);
            result = 31 * result + (this.isStrikedOut ? 1231 : 1237);
            result = 31 * result + (this.isUnderlined ? 1231 : 1237);
            result = 31 * result + this.orientation;
            result = 31 * result + this.outPrecision;
            result = 31 * result + this.pitchAndFamily;
            result = 31 * result + this.quality;
            result = 31 * result + this.width;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WMFFont other = (WMFFont)obj;
            if (this.charSet != other.charSet) {
                return false;
            }
            if (this.clipPrecision != other.clipPrecision) {
                return false;
            }
            if (this.escapement != other.escapement) {
                return false;
            }
            if (this.fontName == null ? other.fontName != null : !this.fontName.equals(other.fontName)) {
                return false;
            }
            if (this.height != other.height) {
                return false;
            }
            if (this.isBold != other.isBold) {
                return false;
            }
            if (this.isItalic != other.isItalic) {
                return false;
            }
            if (this.isStrikedOut != other.isStrikedOut) {
                return false;
            }
            if (this.isUnderlined != other.isUnderlined) {
                return false;
            }
            if (this.orientation != other.orientation) {
                return false;
            }
            if (this.outPrecision != other.outPrecision) {
                return false;
            }
            if (this.pitchAndFamily != other.pitchAndFamily) {
                return false;
            }
            if (this.quality != other.quality) {
                return false;
            }
            return this.width == other.width;
        }
    }

    private class WMFPatternBrush {
        private final int alpha;

        private WMFPatternBrush(int alpha) {
            this.alpha = alpha;
        }

        private void delete() {
            DeviceDriverWMF.this.wmfDeleteObject(3);
        }

        public void createAndActivate() {
            DeviceDriverWMF.this.wmfCreatePatternBrush(this.alpha);
            this.activate();
        }

        private void activate() {
            DeviceDriverWMF.this.wmfSelectObject(3);
            DeviceDriverWMF.this.patternBrushIsActive = true;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.alpha;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WMFPatternBrush other = (WMFPatternBrush)obj;
            return this.alpha == other.alpha;
        }
    }

    private class WMFPen {
        private final int style;
        private final int width;
        private final Color color;

        private WMFPen(int style, int width, Color color) {
            this.style = style;
            this.width = width;
            this.color = color;
        }

        private void delete() {
            DeviceDriverWMF.this.wmfDeleteObject(0);
        }

        public void createAndActivate() {
            DeviceDriverWMF.this.wmfCreatePenIndirect(this.style, this.width, this.color);
            DeviceDriverWMF.this.wmfSelectObject(0);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.color == null ? 0 : this.color.hashCodeEqualsColor());
            result = 31 * result + this.style;
            result = 31 * result + this.width;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WMFPen other = (WMFPen)obj;
            if (this.color == null ? other.color != null : !this.color.equalsColor(other.color)) {
                return false;
            }
            if (this.style != other.style) {
                return false;
            }
            return this.width == other.width;
        }
    }
}

