/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry;

import com.arcway.lib.geometry.Ellipse;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.StraightLine;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;

public class Arc
extends Ellipse {
    private static final ILogger logger = Logger.getLogger(Arc.class);
    public static final boolean DIR_CLOCKWISE = true;
    public static final boolean DIR_COUNTERCLOCKWISE = false;
    public double angleStart;
    public double angleEnd;

    public static boolean getDirection(double angleStart, double angleEnd) {
        double angle = angleEnd - angleStart;
        boolean direction = angle < 0.0;
        return direction;
    }

    public Arc(Point center, double rx, double ry, double angleStart, double angleEnd) {
        super(center, rx, ry);
        this.center = Point.getAsPoint(center);
        this.rx = rx;
        this.ry = ry;
        this.angleStart = angleStart;
        this.angleEnd = angleEnd;
    }

    public Arc(double x, double y, double rx, double ry, double angleStart, double angleEnd) {
        super(x, y, rx, ry);
        this.angleStart = angleStart;
        this.angleEnd = angleEnd;
    }

    public Arc(Arc arc) {
        super(arc);
        assert (arc != null);
        this.angleStart = arc.angleStart;
        this.angleEnd = arc.angleEnd;
    }

    public Arc(Point center, double rx, double ry) {
        super(center, rx, ry);
        this.angleStart = 0.0;
        this.angleEnd = 360.0;
    }

    public Arc() {
        this.angleStart = 0.0;
        this.angleEnd = 360.0;
    }

    public Arc(Point from, Point via, Point to) {
        assert (from != null);
        assert (via != null);
        assert (to != null);
        assert (!from.equalsPoint(via));
        assert (!to.equalsPoint(via));
        assert (!GeoVector.isLinearlyDependent(new GeoVector(from, via), new GeoVector(via, to)));
        double divisorLambda2 = (via.y - to.y) * (via.x - from.x) - (via.x - to.x) * (via.y - from.y);
        double lambda2 = Math.abs(divisorLambda2) < 1.0E-10 ? 0.0 : ((to.y - from.y) * (via.y - from.y) + (to.x - from.x) * (via.x - from.x)) / divisorLambda2;
        this.center = new Point(to.x + (to.y - via.y) * lambda2, to.y + (via.x - to.x) * lambda2);
        Arc tempArc = Arc.createArcByCenterAndArcPoints(this.center, from, via, to);
        this.rx = tempArc.rx;
        this.ry = tempArc.ry;
        this.angleStart = tempArc.angleStart;
        this.angleEnd = tempArc.angleEnd;
    }

    public static Arc createArcByArcPoints(Point from, Point touchingVia, Point to) {
        assert (from != null);
        assert (touchingVia != null);
        assert (to != null);
        assert (!from.equalsPoint(touchingVia));
        assert (!to.equalsPoint(touchingVia));
        assert (!GeoVector.isLinearlyDependent(new GeoVector(from, touchingVia), new GeoVector(touchingVia, to)));
        Point center1 = new Line(from, touchingVia).getCenter();
        Point center2 = new Line(touchingVia, to).getCenter();
        Arc tempArc = new Arc(center1, touchingVia, center2);
        Point center = tempArc.center;
        return Arc.createArcByCenterAndArcPoints(center, from, touchingVia, to);
    }

    private static Arc createArcByCenterAndArcPoints(Point center, Point start, Point via, Point end) {
        double ry;
        double rx;
        assert (center != null);
        assert (start != null);
        assert (end != null);
        assert (!start.equalsPoint(center));
        assert (!end.equalsPoint(center));
        double angleFrom = GeoVector.getDifferenceVectorAngle(center, start);
        double angleTo = GeoVector.getDifferenceVectorAngle(center, end);
        double angleStart = angleFrom;
        double angleEnd = angleTo;
        GeoVector startToVia = new GeoVector(start, via);
        GeoVector viaToEnd = new GeoVector(via, end);
        double angle = GeoVector.angle(startToVia, viaToEnd);
        assert (!Geo.isZero(angle));
        if (angle > 0.0) {
            while (angleEnd < angleStart) {
                angleEnd += 360.0;
            }
        } else if (angle < 0.0) {
            while (angleEnd > angleStart) {
                angleEnd -= 360.0;
            }
        }
        double angleFromRadians = Math.toRadians(angleFrom);
        double math_sin_angleFromRadians = Math.sin(angleFromRadians);
        double angleToRadians = Math.toRadians(angleTo);
        double math_sin_angleToRadians = Math.sin(angleToRadians);
        if (Math.abs(math_sin_angleFromRadians) < Math.abs(math_sin_angleToRadians)) {
            rx = Math.abs((start.x - center.x) / Math.cos(angleFromRadians));
            ry = Math.abs((end.y - center.y) / math_sin_angleToRadians);
        } else {
            rx = Math.abs((end.x - center.x) / Math.cos(angleToRadians));
            ry = Math.abs((start.y - center.y) / math_sin_angleFromRadians);
        }
        return new Arc(center, rx, ry, angleStart, angleEnd);
    }

    public Point getFrom() {
        return this.getPointByAngle(this.angleStart);
    }

    public Point getVia() {
        StraightLine evenFrom = new StraightLine(this.center, this.getFrom()).getPerpendicular(this.getFrom());
        StraightLine evenTo = new StraightLine(this.center, this.getTo()).getPerpendicular(this.getTo());
        return evenFrom.getInterceptPoint(evenTo);
    }

    public Point getTo() {
        return this.getPointByAngle(this.angleEnd);
    }

    public double arcLength() {
        return this.getArcLengthArc(this.angleStart, this.angleEnd);
    }

    public Point getPoint(double arcLength) {
        assert (!Geo.equals(this.angleEnd, this.angleStart));
        assert (!Geo.isZero(this.rx) || !Geo.isZero(this.ry));
        double sign = (this.angleEnd - this.angleStart) / Math.abs(this.angleEnd - this.angleStart);
        double angle = this.angleStart + Geo.angleArc(this.rx, this.ry, this.angleStart, sign * arcLength);
        return this.getPointByAngle(angle);
    }

    public Points getPointsApproximated(int maxPoints, double pointsPerUnit) {
        assert (maxPoints >= 1 || Geo.isGreaterThanZero(pointsPerUnit));
        Points points = new Points();
        double angleStartRad = Math.toRadians(this.angleStart);
        double angleEndRad = Math.toRadians(this.angleEnd);
        int steps = pointsPerUnit <= 1.0E-10 ? Math.max(1, maxPoints) : (maxPoints <= 0 ? Math.max(1, (int)(Math.ceil(this.arcLength() * pointsPerUnit) + 1.0E-10)) : Math.max(1, Math.min(maxPoints, (int)(Math.ceil(this.arcLength() * pointsPerUnit) + 1.0E-10))));
        double stepSizeRad = (angleEndRad - angleStartRad) / (double)steps;
        double angleRad = angleStartRad + stepSizeRad;
        points.addPointIfDiffersFromLast(new Point(this.center.x + this.rx * Math.cos(angleStartRad), this.center.y - this.ry * Math.sin(angleStartRad)));
        int i = 2;
        while (i < steps) {
            points.addPointIfDiffersFromLast(new Point(this.center.x + this.rx * Math.cos(angleRad), this.center.y - this.ry * Math.sin(angleRad)));
            angleRad += stepSizeRad;
            ++i;
        }
        points.addPointIfDiffersFromLast(new Point(this.center.x + this.rx * Math.cos(angleEndRad), this.center.y - this.ry * Math.sin(angleEndRad)));
        return points;
    }

    public Rectangle getBounds() {
        double anglePerStep;
        double angle;
        Rectangle bounds = new Rectangle(this.getFrom(), this.getTo());
        if (this.angleStart <= this.angleEnd) {
            angle = Math.ceil(this.angleStart / 90.0) * 90.0;
            anglePerStep = 90.0;
        } else {
            angle = Math.floor(this.angleStart / 90.0) * 90.0;
            anglePerStep = -90.0;
        }
        while ((this.angleEnd - angle) * (double)Geo.sgn(anglePerStep) > 0.0) {
            bounds.union(this.getPointByAngle(angle));
            angle += anglePerStep;
        }
        return bounds;
    }

    public boolean getDirection() {
        return Arc.getDirection(this.angleStart, this.angleEnd);
    }

    public boolean equalsArc(Arc a) {
        return Geo.equals(a.rx, this.rx) && Geo.equals(a.ry, this.ry) && Geo.equals(a.angleStart, this.angleStart) && Geo.equals(a.angleEnd, this.angleEnd) && a.center.equalsPoint(this.center);
    }

    @Override
    public String toString() {
        return "Arc(center=" + this.center + ", rx=" + this.rx + ", ry=" + this.ry + ", start=" + this.angleStart + ", end=" + this.angleEnd + ")";
    }

    @Override
    @Deprecated
    public boolean equals(Object obj) {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Arc) {
            Arc a = (Arc)obj;
            return this.equalsArc(a);
        }
        return false;
    }

    @Override
    @Deprecated
    public int hashCode() {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        return new Double(this.angleStart + this.angleEnd + this.rx + this.ry).hashCode() ^ this.center.hashCode();
    }
}

