/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.widgets;

import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.eclipse.Messages;
import com.arcway.lib.eclipse.gui.dialogs.FilteredItemsSelectionDialog;
import com.arcway.lib.eclipse.gui.widgets.ImageButton;
import com.arcway.lib.eclipse.plugin.ARCWAYEclipseLibPlugin;
import com.arcway.lib.eclipse.resources.ImageCache;
import com.arcway.lib.eclipse.resources.ResourceDisposer;
import com.arcway.lib.eclipse.resources.ResourceLoader;
import com.arcway.lib.eclipse.transfer.SerializableDataTypeTransferAgent;
import com.arcway.lib.eclipse.transfer.SerializableDataTypeTransferAgentWithFixDataType;
import com.arcway.lib.eclipse.uiframework.widgets.AbstractDataWidget;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipseCompositeWidget;
import com.arcway.lib.eclipse.uiframework.widgets.dragndrop.IDropSupportingWidget;
import com.arcway.lib.eclipse.uiframework.widgets.dragndrop.SimpleWidgetDropListener;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IIterator_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.ui.editor.EnumerationItem;
import com.arcway.lib.ui.editor.IEnumerationItem_WithLabelAndIcon;
import com.arcway.lib.ui.editor.datatype.ICompositeWidget;
import com.arcway.lib.ui.editor.datatype.ITextProvider;
import com.arcway.lib.ui.editor.exception.EEXLockDenied;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.widgetAdapter.IDataWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IRelationsListValueRange;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.RelationsListWidgetRelationWidgetAdapter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class RelationsListAndButtonWidget
extends AbstractDataWidget
implements IDropSupportingWidget,
MouseListener {
    private Composite widgetComposite;
    private TableViewer tableViewer;
    private Text text;
    private final LabelProvider labelProvider = new LabelProvider();
    private final ContentProvider contentProvider = new ContentProvider();
    private IRelationsListValueRange valueRange;
    private ISet_<Object> value;
    private List<EnumerationItem> changedValues;
    private final SerializableDataTypeTransferAgent transferAgent;
    private Table table;
    private ImageButton addBtn;
    private ImageButton removeBtn;
    private static final Image addBtnImg = ResourceLoader.getImageDescriptor((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/add_obj.gif").createImage();
    private static final Image removeBtnImg = ResourceLoader.getImageDescriptor((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/rem_obj.gif").createImage();

    static {
        ResourceDisposer.markResourceAsSingleton((Resource)addBtnImg);
        ResourceDisposer.markResourceAsSingleton((Resource)removeBtnImg);
    }

    public RelationsListAndButtonWidget(WidgetParameters widgetParameters, ICompositeWidget parentWidget, IDataWidgetAdapter adapter) {
        super(widgetParameters, adapter, (IEclipseCompositeWidget)parentWidget);
        assert (parentWidget instanceof IEclipseCompositeWidget);
        RelationsListWidgetRelationWidgetAdapter typedAdpater = (RelationsListWidgetRelationWidgetAdapter)this.getWidgetAdapter();
        IDataType dataType = typedAdpater.getObjectReferenceCollectionDataType();
        this.transferAgent = new SerializableDataTypeTransferAgentWithFixDataType("RelationsWidget", dataType);
        this.changedValues = new ArrayList<EnumerationItem>();
    }

    @Override
    public void createControl(Composite parentComposite) {
        FormToolkit toolkit = this.getFormToolkit();
        this.widgetComposite = toolkit.createComposite(parentComposite);
        TableWrapData td = new TableWrapData(256);
        td.valign = 32;
        this.widgetComposite.setLayoutData((Object)td);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        this.widgetComposite.setLayout((Layout)layout);
        this.valueRange = (IRelationsListValueRange)this.getWidgetAdapter().getValueRange();
        this.value = (ISet_)this.getWidgetAdapter().getValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
        boolean isModificationPermitted = this.getWidgetAdapter().isModificationPermitted();
        boolean isModificationLocked = this.getWidgetAdapter().isModificationLocked();
        if (this.isEditable() && isModificationPermitted && isModificationLocked) {
            this.getEditableControl(toolkit);
        } else {
            this.getUneditableControl(toolkit);
        }
    }

    @Override
    public void refreshWidget_internal() {
        if (this.widgetComposite != null) {
            Control[] childControls;
            FormToolkit toolkit = this.getFormToolkit();
            Control[] controlArray = childControls = this.widgetComposite.getChildren();
            int n = childControls.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                element.dispose();
                ++n2;
            }
            this.valueRange = (IRelationsListValueRange)this.getWidgetAdapter().getValueRange();
            this.value = (ISet_)this.getWidgetAdapter().getValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
            boolean isModificationPermitted = this.getWidgetAdapter().isModificationPermitted();
            boolean isModificationLocked = this.getWidgetAdapter().isModificationLocked();
            if (this.isEditable() && isModificationPermitted && isModificationLocked) {
                this.getEditableControl(toolkit);
            } else {
                this.getUneditableControl(toolkit);
            }
            this.updateWidgetMessageDisplay();
            this.widgetComposite.getParent().pack();
        }
    }

    private String calculateRelationsStringrepresentation4TextControl() {
        StringBuilder val = new StringBuilder();
        boolean isFirst = true;
        for (IEnumerationItem_WithLabelAndIcon enumItem : this.valueRange.getValueRangeSubsetForSelectedRelations()) {
            if (!this.value.contains(enumItem.getKey())) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                val.append("\n");
            }
            val.append(enumItem.getLabel());
        }
        if (val.length() == 0) {
            val.append("-");
        }
        return val.toString();
    }

    @Override
    public void updateWidget_internal(IWidgetAdapter.WidgetUpdateMode mode) {
        if (this.tableViewer != null) {
            this.valueRange = (IRelationsListValueRange)this.getWidgetAdapter().getValueRange();
            this.value = (ISet_)this.getWidgetAdapter().getValue(mode);
            if (this.isEditable() || this.getWidgetAdapter().isModificationPermitted() || this.getWidgetAdapter().isModificationLocked()) {
                if (this.tableViewer != null) {
                    this.tableViewer.refresh();
                    int i = 0;
                    while (i < this.table.getColumnCount()) {
                        this.table.getColumn(i).pack();
                        ++i;
                    }
                    this.toggleButtonEnabledState();
                }
            } else if (this.text != null) {
                this.text.setText(this.calculateRelationsStringrepresentation4TextControl());
            }
        }
    }

    private Control getUneditableControl(FormToolkit toolkit) {
        toolkit.setBorderStyle(0);
        this.text = toolkit.createText(this.widgetComposite, this.calculateRelationsStringrepresentation4TextControl(), 74);
        TableWrapData uneditableControlTWD = new TableWrapData(256);
        uneditableControlTWD.colspan = 2;
        this.text.setLayoutData((Object)uneditableControlTWD);
        return this.text;
    }

    private Control getEditableControl(FormToolkit toolkit) {
        Composite tableComposite = toolkit.createComposite(this.widgetComposite);
        TableWrapData editableControlTWD = new TableWrapData(256);
        editableControlTWD.heightHint = 150;
        editableControlTWD.rowspan = 3;
        editableControlTWD.maxWidth = 1;
        tableComposite.setLayoutData((Object)editableControlTWD);
        TableWrapLayout layout = new TableWrapLayout();
        layout.bottomMargin = 0;
        layout.horizontalSpacing = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.topMargin = 0;
        layout.verticalSpacing = 0;
        tableComposite.setLayout((Layout)layout);
        TableWrapData tableTD = new TableWrapData(256, 256);
        int maxCardinalityForHeight = Math.min(1000, this.valueRange.getMaxCardinality());
        tableTD.heightHint = Math.max(48, Math.min(150, maxCardinalityForHeight * 20));
        tableTD.maxWidth = 1;
        this.table = toolkit.createTable(tableComposite, 67586);
        this.table.setLayoutData((Object)tableTD);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        TableViewerColumn vc0 = new TableViewerColumn(this.tableViewer, 16384);
        vc0.setLabelProvider((CellLabelProvider)this.labelProvider);
        vc0.getColumn().setWidth(100);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        this.tableViewer.setInput((Object)this);
        this.tableViewer.refresh();
        int i = 0;
        while (i < this.table.getColumnCount()) {
            this.table.getColumn(i).pack();
            ++i;
        }
        TableWrapData td = new TableWrapData(8);
        this.addBtn = new ImageButton(this.widgetComposite, Messages.getString("RelationsListAndButtonWidget.Add", this.getWidgetAdapter().getContentLocale()), addBtnImg, 0x800000);
        this.addBtn.setLayoutData(td);
        this.addBtn.addMouseListener(this);
        td = new TableWrapData(8);
        this.removeBtn = new ImageButton(this.widgetComposite, Messages.getString("RelationsListAndButtonWidget.Remove", this.getWidgetAdapter().getContentLocale()), removeBtnImg, 0x800000);
        this.removeBtn.setLayoutData(td);
        this.removeBtn.addMouseListener(this);
        this.removeBtn.setEnabled(false);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                RelationsListAndButtonWidget.this.toggleButtonEnabledState();
            }

            public void widgetSelected(SelectionEvent e) {
                RelationsListAndButtonWidget.this.toggleButtonEnabledState();
            }
        });
        this.table.addMouseListener((MouseListener)this);
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    TableItem[] selectedItems;
                    TableItem[] tableItemArray = selectedItems = RelationsListAndButtonWidget.this.table.getSelection();
                    int n = selectedItems.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        IEnumerationItem_WithLabelAndIcon enumerationItem = (IEnumerationItem_WithLabelAndIcon)item.getData();
                        RelationsListAndButtonWidget.this.changedValues.add(new EnumerationItem(enumerationItem.getKey(), null, null, false));
                        ++n2;
                    }
                    RelationsListAndButtonWidget.this.widgetModified();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        SimpleWidgetDropListener.addDropListenerToControl(this, 4, 8, (Control)this.table);
        tableComposite.update();
        this.toggleButtonEnabledState();
        return this.table;
    }

    public Object getCurrentValue() {
        return this.changedValues;
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    private void widgetModified() {
        this.getWidgetAdapter().widgetModified();
        this.changedValues = new ArrayList<EnumerationItem>();
        this.updateWidget(IWidgetAdapter.WidgetUpdateMode.DONT_UPDATE_VALUE);
    }

    @Override
    public Transfer getTransferAgent() {
        return this.transferAgent;
    }

    @Override
    public boolean hasCorrectObjectType(Object contents) {
        ICollection_ typedContents = (ICollection_)contents;
        IIterator_ i = typedContents.iterator();
        while (i.hasNext()) {
            if (!this.isRelationPossible(i.next(), false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void performDrop(Object contents) {
        ICollection_ typedContents = (ICollection_)contents;
        for (Object key : typedContents) {
            if (!this.isRelationPossible(key, true)) continue;
            this.changedValues.add(new EnumerationItem(key, null, null, true));
        }
        this.widgetModified();
    }

    private boolean isRelationPossible(Object key, boolean checkPermissionAndAcquireLock) {
        RelationsListWidgetRelationWidgetAdapter typedAdapter = (RelationsListWidgetRelationWidgetAdapter)this.getWidgetAdapter();
        IEnumerationItem_WithLabelAndIcon enumItem = this.valueRange.getValueRangeItemForKey(key);
        if (enumItem != null) {
            if (!this.value.contains(enumItem.getKey())) {
                boolean isRelationPossible = true;
                try {
                    isRelationPossible = typedAdapter.isRelationPossible(key, checkPermissionAndAcquireLock);
                }
                catch (EEXLockDenied eLD) {
                    isRelationPossible = false;
                    ITextProvider message = typedAdapter.getMessageForLockingException(eLD);
                    String localisedMessage = message.getText(PresentationContext.getVirtualMachineUserLocaleForNow());
                    MessageDialog.openInformation((Shell)this.widgetComposite.getShell(), (String)Messages.getString("RelationsListWidget2.RelationNotPossible.Title"), (String)NLS.bind((String)Messages.getString("RelationsListWidget2.RelationNotPossible.Message"), (Object)enumItem.getLabel(), (Object)localisedMessage));
                }
                return isRelationPossible;
            }
            return false;
        }
        return false;
    }

    @Override
    public Object getContentsFromTransferAgent(TransferData transferData) {
        return this.transferAgent.nativeToJava(transferData);
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        Control source = (Control)e.getSource();
        if (source.equals((Object)this.addBtn)) {
            int possibleAdds = this.valueRange.getMaxCardinality() - this.table.getItemCount();
            if (possibleAdds >= 1) {
                boolean multi = possibleAdds > 1;
                FilteredRelationContributorsSelectionDialog dialog = new FilteredRelationContributorsSelectionDialog(this.getParentComposite().getShell(), multi);
                if (dialog.open() == 0) {
                    Object[] result;
                    Object[] objectArray = result = dialog.getResult();
                    int n = result.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object enumitem = objectArray[n2];
                        this.changedValues.add(new EnumerationItem(((IEnumerationItem_WithLabelAndIcon)enumitem).getKey(), ((IEnumerationItem_WithLabelAndIcon)enumitem).getLabel(), null, true));
                        ++n2;
                    }
                    this.widgetModified();
                }
            }
        } else if (source.equals((Object)this.removeBtn)) {
            TableItem[] items;
            TableItem[] tableItemArray = items = this.table.getSelection();
            int n = items.length;
            int n3 = 0;
            while (n3 < n) {
                TableItem item = tableItemArray[n3];
                if (item == null) {
                    return;
                }
                IEnumerationItem_WithLabelAndIcon enumerationItem = (IEnumerationItem_WithLabelAndIcon)item.getData();
                this.changedValues.add(new EnumerationItem(enumerationItem.getKey(), null, null, false));
                ++n3;
            }
            this.widgetModified();
        }
    }

    private void toggleButtonEnabledState() {
        if (this.table.getItemCount() <= 0 || this.table.getSelectionCount() <= 0) {
            this.removeBtn.setEnabled(false);
        } else {
            this.removeBtn.setEnabled(true);
        }
        if (this.table.getItemCount() >= this.valueRange.getMaxCardinality()) {
            this.addBtn.setEnabled(false);
        } else {
            this.addBtn.setEnabled(true);
        }
    }

    private class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement.equals(RelationsListAndButtonWidget.this) && RelationsListAndButtonWidget.this.value.size() > 0) {
                ArrayList<IEnumerationItem_WithLabelAndIcon> elements = new ArrayList<IEnumerationItem_WithLabelAndIcon>(RelationsListAndButtonWidget.this.value.size());
                for (IEnumerationItem_WithLabelAndIcon enumItem : RelationsListAndButtonWidget.this.valueRange.getValueRangeSubsetForSelectedRelations()) {
                    if (!RelationsListAndButtonWidget.this.value.contains(enumItem.getKey())) continue;
                    elements.add(enumItem);
                }
                return elements.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class FilteredRelationContributorsSelectionDialog
    extends FilteredItemsSelectionDialog {
        public FilteredRelationContributorsSelectionDialog(Shell shell) {
            super(shell);
        }

        FilteredRelationContributorsSelectionDialog(Shell shell, boolean multi) {
            super(shell, multi);
            this.setTitle(Messages.getString("FilteredRelationContributorsSelectionDialog.title", RelationsListAndButtonWidget.this.getWidgetAdapter().getCurrentPresentationContext().getLocale()));
            this.setListLabelProvider((ILabelProvider)RelationsListAndButtonWidget.this.labelProvider);
            this.setDetailsLabelProvider((ILabelProvider)RelationsListAndButtonWidget.this.labelProvider);
        }

        @Override
        protected Control createExtendedContentArea(Composite parentComp) {
            return null;
        }

        @Override
        protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
            return new FilteredItemsSelectionDialog.ItemsFilter(this){

                @Override
                public boolean isConsistentItem(Object item) {
                    return item instanceof IEnumerationItem_WithLabelAndIcon;
                }

                @Override
                public boolean matchItem(Object item) {
                    if (!(item instanceof IEnumerationItem_WithLabelAndIcon)) {
                        return false;
                    }
                    return this.matches(FilteredRelationContributorsSelectionDialog.this.getElementName(item));
                }
            };
        }

        @Override
        protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentPrvdr, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
            for (IEnumerationItem_WithLabelAndIcon item : RelationsListAndButtonWidget.this.valueRange.getCompleteValueRange()) {
                if (RelationsListAndButtonWidget.this.value.contains(item.getKey())) continue;
                contentPrvdr.add(item, itemsFilter);
            }
        }

        @Override
        protected IDialogSettings getDialogSettings() {
            return new DialogSettings("setting");
        }

        @Override
        public String getElementName(Object item) {
            return ((IEnumerationItem_WithLabelAndIcon)item).getLabel();
        }

        @Override
        protected Comparator<IEnumerationItem_WithLabelAndIcon> getItemsComparator() {
            return null;
        }

        @Override
        protected IStatus validateItem(Object item) {
            return new Status(0, "org.eclipse.ui", 0, "", null);
        }
    }

    private class LabelProvider
    extends ColumnLabelProvider {
        public String getToolTipText(Object element) {
            if (element instanceof IEnumerationItem_WithLabelAndIcon) {
                IEnumerationItem_WithLabelAndIcon enumItem = (IEnumerationItem_WithLabelAndIcon)element;
                RelationsListWidgetRelationWidgetAdapter typedAdapter = (RelationsListWidgetRelationWidgetAdapter)RelationsListAndButtonWidget.this.getWidgetAdapter();
                return typedAdapter.getHierarchyString(enumItem);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IEnumerationItem_WithLabelAndIcon) {
                IEnumerationItem_WithLabelAndIcon item = (IEnumerationItem_WithLabelAndIcon)element;
                return item.getLabel();
            }
            if (element instanceof String) {
                return (String)element;
            }
            return null;
        }

        public Image getImage(Object element) {
            IEnumerationItem_WithLabelAndIcon item;
            IStreamResource icon16x16AsStreamResource;
            if (element instanceof IEnumerationItem_WithLabelAndIcon && (icon16x16AsStreamResource = (item = (IEnumerationItem_WithLabelAndIcon)element).getIcon()) != null) {
                return ImageCache.getImage(Display.getDefault(), icon16x16AsStreamResource);
            }
            return null;
        }
    }
}

