/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.widgets;

import com.arcway.lib.eclipse.uiframework.widgets.AbstractDataWidget;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipseCompositeWidget;
import com.arcway.lib.java.locale.LocalisationUtils;
import com.arcway.lib.ui.editor.datatype.ICompositeWidget;
import com.arcway.lib.ui.editor.parameters.DateWidgetParameters;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.widgetAdapter.IDataWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class CalendarWidget
extends AbstractDataWidget
implements SelectionListener {
    private Control control;
    private Composite widgetComposite;
    private Button button;
    private boolean dateSet;
    private final boolean isWithTimeComponent;
    private final Calendar cal;
    private DateTime timeControl;

    public CalendarWidget(WidgetParameters parameters, ICompositeWidget parent, IDataWidgetAdapter adapter) {
        super(parameters, adapter, (IEclipseCompositeWidget)parent);
        assert (parent instanceof IEclipseCompositeWidget);
        this.isWithTimeComponent = ((DateWidgetParameters)parameters).isWithTimeComponent();
        this.cal = Calendar.getInstance(this.getCurrentPresentationContext().getTimeZone(), this.getContentLocale());
    }

    @Override
    public void createControl(Composite parentComposite) {
        FormToolkit toolkit = this.getFormToolkit();
        this.widgetComposite = toolkit.createComposite(parentComposite);
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 0;
        layout.numColumns = 2;
        this.widgetComposite.setLayout((Layout)layout);
        TableWrapData td = new TableWrapData(256);
        td.grabHorizontal = true;
        td.valign = 32;
        this.widgetComposite.setLayoutData((Object)td);
        Date value = (Date)this.getWidgetAdapter().getValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
        this.dateSet = value != null;
        boolean isModificationPermitted = this.getWidgetAdapter().isModificationPermitted();
        boolean isModificationLocked = this.getWidgetAdapter().isModificationLocked();
        if (!(this.isEditable() && isModificationPermitted && isModificationLocked)) {
            this.createUneditableControl(this.getFormToolkit(), value);
        } else {
            this.createEditableControl(value);
        }
    }

    @Override
    public void updateWidget_internal(IWidgetAdapter.WidgetUpdateMode mode) {
        if (mode != IWidgetAdapter.WidgetUpdateMode.DONT_UPDATE_VALUE) {
            Date value = (Date)this.getWidgetAdapter().getValue(mode);
            if (!(this.isEditable() && this.getWidgetAdapter().isModificationPermitted() && this.getWidgetAdapter().isModificationLocked())) {
                if (this.control != null && value != null) {
                    ((Text)this.control).setText(LocalisationUtils.localizeDate((Date)value, (int)2, (Locale)this.getContentLocale()));
                }
            } else if (this.control != null) {
                ((DateTime)this.control).removeSelectionListener((SelectionListener)this);
                if (value != null) {
                    this.cal.setTime(value);
                }
                ((DateTime)this.control).setDay(this.cal.get(5));
                ((DateTime)this.control).setMonth(this.cal.get(2));
                ((DateTime)this.control).setYear(this.cal.get(1));
                this.control.setEnabled(this.dateSet);
                if (this.isWithTimeComponent) {
                    this.timeControl.removeSelectionListener((SelectionListener)this);
                    this.timeControl.setHours(this.cal.get(10));
                    this.timeControl.setMinutes(this.cal.get(12));
                    this.timeControl.setSeconds(this.cal.get(13));
                    this.timeControl.addSelectionListener((SelectionListener)this);
                    this.timeControl.setEnabled(this.dateSet);
                }
                ((DateTime)this.control).addSelectionListener((SelectionListener)this);
                if (this.button != null && !this.button.isDisposed()) {
                    this.button.removeSelectionListener((SelectionListener)this);
                    this.button.setSelection(this.dateSet);
                    this.button.addSelectionListener((SelectionListener)this);
                }
            }
        }
        this.updateWidgetMessageDisplay();
    }

    @Override
    public void refreshWidget_internal() {
        if (this.widgetComposite != null) {
            Control[] children;
            FormToolkit toolkit = this.getFormToolkit();
            Control[] controlArray = children = this.widgetComposite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                element.dispose();
                ++n2;
            }
            Date value = (Date)this.getWidgetAdapter().getValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
            boolean isModificationPermitted = this.getWidgetAdapter().isModificationPermitted();
            boolean isModificationLocked = this.getWidgetAdapter().isModificationLocked();
            if (!(this.isEditable() && isModificationPermitted && isModificationLocked)) {
                this.createUneditableControl(toolkit, value);
            } else {
                this.createEditableControl(value);
            }
            this.updateWidgetMessageDisplay();
            this.widgetComposite.getParent().pack();
        }
    }

    public Object getCurrentValue() {
        if (this.dateSet && this.control != null && this.isEditable() && this.getWidgetAdapter().isModificationPermitted()) {
            this.cal.set(((DateTime)this.control).getYear(), ((DateTime)this.control).getMonth(), ((DateTime)this.control).getDay());
            if (this.isWithTimeComponent) {
                this.cal.set(10, this.timeControl.getHours());
                this.cal.set(12, this.timeControl.getMinutes());
                this.cal.set(13, this.timeControl.getSeconds());
            }
            return this.cal.getTime();
        }
        return null;
    }

    public void setValue(Object value) {
        Date val = (Date)value;
        this.cal.setTime(val);
    }

    private void createEditableControl(Date value) {
        this.button = new Button(this.widgetComposite, 32);
        this.button.setBackground(this.widgetComposite.getDisplay().getSystemColor(1));
        this.button.setSelection(this.dateSet);
        this.button.addSelectionListener((SelectionListener)this);
        this.control = new DateTime(this.widgetComposite, 3072);
        if (value != null) {
            this.cal.setTime(value);
        }
        ((DateTime)this.control).setDay(this.cal.get(5));
        ((DateTime)this.control).setMonth(this.cal.get(2));
        ((DateTime)this.control).setYear(this.cal.get(1));
        if (this.isWithTimeComponent) {
            this.timeControl = new DateTime(this.widgetComposite, 2176);
            this.timeControl.setHours(this.cal.get(10));
            this.timeControl.setMinutes(this.cal.get(12));
            this.timeControl.setSeconds(this.cal.get(13));
            this.timeControl.addSelectionListener((SelectionListener)this);
        }
        ((DateTime)this.control).addSelectionListener((SelectionListener)this);
        TableWrapData td = new TableWrapData();
        td.valign = 16;
        this.button.setLayoutData((Object)td);
        this.control.setEnabled(this.dateSet);
        if (this.isWithTimeComponent) {
            this.timeControl.setEnabled(this.dateSet);
        }
    }

    private void createUneditableControl(FormToolkit toolkit, Date value) {
        String date = "-";
        if (this.dateSet) {
            date = this.isWithTimeComponent ? this.getCurrentPresentationContext().convertDateAndTimeWithoutSecondsToString(value, this.getContentLocale()) : this.getCurrentPresentationContext().convertDateWithoutTimeToString(value, this.getContentLocale());
        }
        this.control = toolkit.createText(this.widgetComposite, date, 8);
        TableWrapData td = new TableWrapData(256);
        this.control.setLayoutData((Object)td);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            this.dateSet = ((Button)e.getSource()).getSelection();
        }
        this.getWidgetAdapter().widgetModified();
        this.updateWidget(IWidgetAdapter.WidgetUpdateMode.DONT_UPDATE_VALUE);
    }
}

