/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.editors.repository;

import com.arcway.lib.eclipse.Messages;
import com.arcway.lib.eclipse.plugin.ARCWAYEclipseLibPlugin;
import com.arcway.lib.eclipse.resources.ImageCache;
import com.arcway.lib.eclipse.resources.ResourceLoader;
import com.arcway.lib.eclipse.uiframework.IHelpContextIDs;
import com.arcway.lib.eclipse.uiframework.MacOSXCarbonFormToolkit;
import com.arcway.lib.eclipse.uiframework.editors.EclipseWindow;
import com.arcway.lib.eclipse.uiframework.editors.EditorInput;
import com.arcway.lib.eclipse.uiframework.editors.repository.RepositoryEditorInfo;
import com.arcway.lib.eclipse.uiframework.widgets.RepositoryEditorPageWidget;
import com.arcway.lib.icons.Decorators7x8;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.java.tuples.ThreeTuple;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.operating.PeriodicTaskScheduler;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.URLResource;
import com.arcway.lib.ui.editor.IEditorController;
import com.arcway.lib.ui.editor.datatype.IEditor;
import com.arcway.lib.ui.editor.datatype.IEditorMessage;
import com.arcway.lib.ui.editor.datatype.IMessageLevel;
import com.arcway.lib.ui.editor.datatype.IPageWidget;
import com.arcway.lib.ui.editor.datatype.ITextProvider;
import com.arcway.lib.ui.modelaccess.agent.ILockAndPermissionProvider;
import com.arcway.lib.ui.window.IWindow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class RepositoryEditor
extends SharedHeaderFormEditor
implements IEditor,
ISelectionProvider,
IPartListener2,
IPageChangedListener,
ISaveablePart2 {
    private static final ILogger LOGGER = Logger.getLogger(RepositoryEditor.class);
    public static final int EDITMODE = 0;
    public static final int VIEWMODE = 1;
    public static final int CREATEMODE = 2;
    public static final int STANDALONEMODE = 3;
    public static final int STANDALONEMODE_CREATE = 4;
    public static final String ECLIPSE_EDITOR_ID = "com.arcway.lib.eclipse.editor";
    private static final ImageDescriptor editImgDiscr = ImageCache.getImageDescriptor((IStreamResource)new URLResource(ResourceLoader.getURL((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/pencil.png")));
    private static final ImageDescriptor helpImgDiscr = ImageCache.getImageDescriptor((IStreamResource)new URLResource(ResourceLoader.getURL((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/help.png")));
    private static final ImageDescriptor stopEditingImg_disabledDiscr = ImageCache.getImageDescriptor((IStreamResource)new URLResource(ResourceLoader.getURL((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/pencil_stop_disabled.png")));
    private static final ImageDescriptor stopEditingImgDiscr = ImageCache.getImageDescriptor((IStreamResource)new URLResource(ResourceLoader.getURL((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/pencil_stop.png")));
    private static final IStreamResource lockImg = new URLResource(ResourceLoader.getURL((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/lock.png"));
    private static final IStreamResource permissionImg = new URLResource(ResourceLoader.getURL((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/nopermission.png"));
    private IWindow window;
    private EditAction editButton;
    private IEditorController editorController;
    private RepositoryEditorInfo editorInfo;
    private final IStreamResource errorDecorater = Decorators7x8.ERROR;
    private ScrolledForm form;
    private boolean isVisible = true;
    private final Collection<Tuple<List<String>, IEditorMessage>> allErrors = new ArrayList<Tuple<List<String>, IEditorMessage>>();
    private final Collection<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
    private boolean needsRefresh = false;
    private int mode = 1;
    private final Set<Runnable> scheduledTasks = new HashSet<Runnable>();

    protected FormToolkit createToolkit(Display display) {
        if (MacOSXCarbonFormToolkit.areWeRunningOnMacOSXCarbon()) {
            return new MacOSXCarbonFormToolkit(display);
        }
        return super.createToolkit(display);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void bringToTop() {
        this.getSite().getPage().bringToTop((IWorkbenchPart)this);
    }

    public boolean changeMode(int editormode, boolean ignoreChanges) {
        boolean changedMode = false;
        this.removeInfoLabel();
        if (this.getMode() == 3) {
            return true;
        }
        if (editormode == 3) {
            if (this.getMode() == 3) {
                return true;
            }
            if (this.editorController.getLocks()) {
                changedMode = true;
            } else {
                changedMode = false;
                this.displayLockMessage();
                this.refresh(true);
            }
        } else if (editormode == 1) {
            if (this.getMode() == 1) {
                return true;
            }
            if (this.getMode() == 0) {
                if (this.editorController.hasCloseVetos() && !ignoreChanges) {
                    this.showVetoMessageDialog();
                    changedMode = false;
                } else if (this.isDirty() && !this.editorController.hasError() && !ignoreChanges) {
                    MessageDialog mDialog = new MessageDialog(null, Messages.getString("Editor.cancelEditingTitle", this.getCurrentPresentationContext().getLocale()), null, Messages.getString("Editor.cancelEditingText", this.getCurrentPresentationContext().getLocale()), 2, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                    if (mDialog.open() == 0) {
                        this.doSave(null);
                    } else {
                        this.editorController.reset();
                    }
                    this.editorController.releaseLocks();
                    changedMode = true;
                } else if (this.editorController.hasError()) {
                    if (ignoreChanges) {
                        this.editorController.reset();
                        this.editorController.releaseLocks();
                        changedMode = true;
                    } else {
                        changedMode = false;
                    }
                } else {
                    if (ignoreChanges) {
                        this.editorController.reset();
                    }
                    this.editorController.releaseLocks();
                    changedMode = true;
                }
            } else if (this.getMode() == 2 && this.editorController.hasError()) {
                if (ignoreChanges) {
                    this.closeEditor(false, false);
                    changedMode = true;
                } else {
                    changedMode = false;
                }
            }
        } else if (editormode == 0 && this.getMode() != 0) {
            if (this.editorController.getLocks()) {
                changedMode = true;
            } else {
                changedMode = false;
                this.displayLockMessage();
                this.refresh(true);
            }
        }
        if (changedMode) {
            this.mode = editormode;
            if (this.getMode() != 3) {
                this.editButton.updateImage();
            }
            this.refresh(true);
        }
        ISelection selection = this.getEditorSite().getSelectionProvider().getSelection();
        this.getEditorSite().getSelectionProvider().setSelection(selection);
        return changedMode;
    }

    public void closeEditor(boolean save, boolean editorIsClosing) {
        this.getSite().getPage().removePartListener((IPartListener2)this);
        this.stopAllScheduledTasks();
        this.editorController.dispose(editorIsClosing);
        super.close(save);
    }

    public void dirtyChanged() {
        this.firePropertyChange(257);
    }

    public void dispose() {
        if (this.editorInfo != null) {
            this.editorInfo.dispose();
        }
        if (this.editorController != null) {
            this.editorController.dispose(true);
            this.editorController.getModelAccess().dispose();
        }
        this.getSite().getPage().removePartListener((IPartListener2)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.editorController.save()) {
            this.updateEditorLabel();
            this.dirtyChanged();
        } else if (monitor != null) {
            monitor.setCanceled(true);
        }
    }

    public void doSaveAs() {
    }

    public PresentationContext getCurrentPresentationContext() {
        return this.getTypedEditorInput().getCurrentPresentationContext();
    }

    public IEditorController getEditorController() {
        return this.editorController;
    }

    public int getMode() {
        return this.mode;
    }

    public ISelection getSelection() {
        EditorInput editorInput = this.getTypedEditorInput();
        Object input = editorInput.getInput();
        return new StructuredSelection(input);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof EditorInput)) {
            MessageDialog md = new MessageDialog(null, Messages.getString("Editor.wrongInput", this.getCurrentPresentationContext().getLocale()), null, Messages.getString("Editor.wrongInput", this.getCurrentPresentationContext().getLocale()), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            md.open();
        }
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener((IPartListener2)this);
        this.addPageChangedListener(this);
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        EditorInput editorInput = (EditorInput)input;
        if (this.editorController != null) {
            this.editorController.getModelAccess().dispose();
            this.editorController = null;
        }
        try {
            this.editorController = editorInput.setupEditor(this);
            ILockAndPermissionProvider lockAndPermissionProvider = this.editorController.getModelAccess().getLockAndPermissionProvider();
            boolean shallSupportViewMode = lockAndPermissionProvider.shallEditorsSupportViewMode();
            if (!editorInput.exists() && shallSupportViewMode) {
                this.mode = 2;
            } else if (!editorInput.exists() && !shallSupportViewMode) {
                this.mode = 4;
            } else if (!shallSupportViewMode) {
                this.mode = 3;
            }
            this.updateEditorLabel();
        }
        catch (PartInitException e) {
            MessageDialog md = new MessageDialog(null, e.getMessage(), null, e.getMessage(), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            md.open();
        }
    }

    public boolean isDirty() {
        return this.editorController != null && (this.editorController.isDirty() || this.editorController.hasCloseVetos());
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void pageChanged(PageChangedEvent event) {
        this.form.setText(this.getPageText(this.getActivePage()));
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        if (partRef.getPart(false).equals((Object)this)) {
            this.isVisible = false;
            this.stopAllScheduledTasks();
        }
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        if (((EditorInput)this.getEditorInput()).isStartInEditModeRequested()) {
            this.changeMode(0, true);
        }
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        if (partRef.getPart(false).equals((Object)this)) {
            this.isVisible = true;
            if (this.needsRefresh) {
                this.refresh(true);
                this.needsRefresh = false;
            }
            this.startAllScheduledTasks();
        }
    }

    public void refresh(boolean refrshWidgets) {
        if (this.isVisible) {
            if (refrshWidgets) {
                this.refreshPages();
            }
            this.updateInfoLabel();
        } else {
            this.needsRefresh = true;
        }
        this.updateEditorLabel();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        for (ISelectionChangedListener listener : this.listeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
    }

    public void updateInfoLabel() {
        if (this.isVisible) {
            if (this.form != null && !this.form.isDisposed()) {
                this.form.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (RepositoryEditor.this.editorController.isModificationLocked()) {
                            ThreeTuple errorMessagesToDisplay = RepositoryEditor.this.editorController.getErrorMessagesToDisplay();
                            if (errorMessagesToDisplay != null) {
                                IMessageLevel overallMessageLevel;
                                RepositoryEditor.this.allErrors.clear();
                                RepositoryEditor.this.allErrors.addAll((Collection)errorMessagesToDisplay.getComponent3());
                                String summaryMessage = (String)errorMessagesToDisplay.getComponent1();
                                int breakIndex = summaryMessage.indexOf("\n");
                                if (breakIndex != -1) {
                                    summaryMessage = summaryMessage.substring(0, breakIndex);
                                }
                                int swtErrorLevel = (overallMessageLevel = (IMessageLevel)errorMessagesToDisplay.getComponent2()).isWarning() ? 2 : (overallMessageLevel.isInformation() ? 1 : 3);
                                if (!(RepositoryEditor.this.form.isDisposed() || RepositoryEditor.this.form.getForm().getHead().isDisposed() || summaryMessage.equals(RepositoryEditor.this.form.getMessage()))) {
                                    RepositoryEditor.this.form.setMessage(summaryMessage, swtErrorLevel);
                                }
                            } else {
                                RepositoryEditor.this.allErrors.clear();
                                RepositoryEditor.this.removeInfoLabel();
                            }
                        }
                    }
                });
            }
            this.updateTitleImage();
        }
    }

    public void updatePresentationContextToNow() {
        this.getTypedEditorInput().updatePresentationContextToNow();
    }

    protected void addPages() {
        if (this.editorController != null) {
            Collection editorPages = this.editorController.createWidgetTree();
            if (editorPages != null) {
                IWorkbenchPage workbenchPage = this.getSite().getPage();
                for (IPageWidget page : editorPages) {
                    if (!(page instanceof RepositoryEditorPageWidget)) continue;
                    ((RepositoryEditorPageWidget)page).initialize((FormEditor)this);
                    ((RepositoryEditorPageWidget)page).createWidget((Composite)this.form, workbenchPage);
                    try {
                        this.addPage((IFormPage)((RepositoryEditorPageWidget)page));
                    }
                    catch (PartInitException e) {
                        throw new RuntimeException("cannot happen", e);
                    }
                }
            }
            this.updateTitleImage();
            this.form.setText(this.getPageText(0));
        } else {
            try {
                FormPage page = new FormPage("Form Editor", "Form Editor");
                page.initialize((FormEditor)this);
                this.addPage((IFormPage)page);
            }
            catch (PartInitException e) {
                throw new RuntimeException(e);
            }
            this.close(false);
        }
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        this.form = headerForm.getForm();
        this.form.getForm().addMessageHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                RepositoryEditor.this.openAdditionalEditorInfo(((Control)e.widget).toDisplay(0, ((Control)e.widget).getBounds().height));
            }
        });
        FormToolkit toolkit = headerForm.getToolkit();
        toolkit.decorateFormHeading(this.form.getForm());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.form, IHelpContextIDs.FORMS_EDITOR_INDEX);
        this.form.setText(this.getTitle());
        if (this.getMode() != 3 && this.getMode() != 4) {
            this.editButton = new EditAction();
            this.form.getToolBarManager().add((IAction)this.editButton);
        }
        HelpAction helpButton = new HelpAction();
        this.form.getToolBarManager().add((IAction)helpButton);
        this.form.getToolBarManager().update(true);
        this.editorInfo = new RepositoryEditorInfo(this.form.getShell(), 2184, this.getCurrentPresentationContext());
    }

    private void displayLockMessage() {
        if (this.form != null && !this.form.isDisposed()) {
            this.form.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!RepositoryEditor.this.editorController.isModificationLocked()) {
                        RepositoryEditor.this.form.setMessage(Messages.getString("Editor.shellHeadlineLock", RepositoryEditor.this.getCurrentPresentationContext().getLocale()), Integer.MAX_VALUE);
                        RepositoryEditor.this.form.getForm().setImage(ImageCache.getImage(RepositoryEditor.this.form.getDisplay(), lockImg));
                    }
                }
            });
        }
    }

    private EditorInput getTypedEditorInput() {
        IEditorInput input = this.getEditorInput();
        EditorInput editorInput = (EditorInput)input;
        return editorInput;
    }

    private void openAdditionalEditorInfo(Point location) {
        Locale locale = this.getCurrentPresentationContext().getLocale();
        if (!this.editorController.isModificationLocked()) {
            this.editorInfo.setHeadline(Messages.getString("Editor.shellHeadlineLock", locale));
            this.editorInfo.setText(this.editorController.getLockMessage());
            this.editorInfo.setInfo(null);
        } else if (!this.allErrors.isEmpty()) {
            this.editorInfo.setHeadline(Messages.getString("Editor.shellHeadlineError", locale));
            this.editorInfo.setText(Messages.getString("Editor.shellTextError", locale));
            this.editorInfo.setInfo(this.allErrors);
        }
        this.editorInfo.setLocationLeftAlignment(location);
        this.editorInfo.openInfoShell();
    }

    private void refreshPages() {
        int i = 0;
        while (i < this.pages.size() - 1) {
            ((RepositoryEditorPageWidget)this.pages.get(i)).refreshWidget();
            ++i;
        }
    }

    private void removeInfoLabel() {
        if (this.form.getMessage() != null) {
            this.form.setMessage(null, 0);
            this.form.setImage(null);
        }
    }

    private void updateEditorLabel() {
        EditorInput editorInput = this.getTypedEditorInput();
        this.setPartName(editorInput.getName());
        this.setTitleToolTip(editorInput.getToolTipText());
        this.updateTitleImage();
    }

    private void updateTitleImage() {
        EditorInput editorInput = this.getTypedEditorInput();
        if (this.editorController == null) {
            LOGGER.debug("review call flow, avoid calling this method when editor controller is null", (Throwable)new Exception());
        }
        if (this.editorController != null && this.editorController.hasError()) {
            this.setTitleImage(editorInput.getTitleImage((IEditorPart)this, this.errorDecorater));
        } else {
            this.setTitleImage(editorInput.getTitleImage((IEditorPart)this, null));
        }
    }

    public boolean notInCreateMode() {
        return this.mode != 2 && this.mode != 4;
    }

    public void turnCreateEditorToEditEditor() {
        if (this.mode == 2 || this.mode == 4) {
            ILockAndPermissionProvider lockAndPermissionProvider = this.editorController.getModelAccess().getLockAndPermissionProvider();
            if (!lockAndPermissionProvider.shallEditorsSupportViewMode()) {
                this.changeMode(3, true);
            } else {
                this.changeMode(0, true);
            }
        }
    }

    public boolean needsLocks() {
        return this.mode != 1;
    }

    public synchronized IWindow getWindow() {
        if (this.window == null) {
            this.window = new EclipseWindow(this.getSite().getPage());
        }
        return this.window;
    }

    public void addScheduledTask(Runnable task) {
        this.scheduledTasks.add(task);
        if (this.isVisible) {
            PeriodicTaskScheduler.addScheduledTask((Runnable)task);
        }
    }

    public void removeScheduledTask(Runnable task) {
        this.scheduledTasks.remove(task);
        if (this.isVisible) {
            PeriodicTaskScheduler.removeScheduledTask((Runnable)task);
        }
    }

    private void stopAllScheduledTasks() {
        PeriodicTaskScheduler.removeAllScheduledTasks(this.scheduledTasks);
    }

    private void startAllScheduledTasks() {
        PeriodicTaskScheduler.addAllScheduledTasks(this.scheduledTasks);
    }

    public void handleCloseVetosChanged() {
        if (this.editButton != null) {
            this.editButton.setEnabled(this.editorController.hasCloseVetos());
        }
        this.updateInfoLabel();
        this.dirtyChanged();
    }

    public int promptToSaveOnClose() {
        if (this.editorController.hasCloseVetos()) {
            this.showVetoMessageDialog();
            return 2;
        }
        return 3;
    }

    private void showVetoMessageDialog() {
        Collection allCloseVetos = this.editorController.getAllCloseVetos();
        StringBuilder sb = new StringBuilder(allCloseVetos.size() * 50);
        sb.append(Messages.getString("Editor.vetoCloseText", this.getCurrentPresentationContext().getLocale()));
        for (Tuple entry : allCloseVetos) {
            ITextProvider textprovider = (ITextProvider)entry.getT2();
            if (textprovider == null) continue;
            sb.append("\n- ");
            sb.append((String)entry.getT1());
            sb.append(": ").append(textprovider.getText(this.getCurrentPresentationContext()));
        }
        MessageDialog mDialog = new MessageDialog(null, Messages.getString("Editor.vetoCloseTitle", this.getCurrentPresentationContext().getLocale()), null, sb.toString(), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        mDialog.open();
    }

    private class EditAction
    extends Action {
        private EditAction() {
            this.updateImage();
        }

        public void run() {
            if (RepositoryEditor.this.getMode() == 0) {
                if (RepositoryEditor.this.editorController.hasError()) {
                    RepositoryEditor.this.changeMode(1, true);
                } else {
                    RepositoryEditor.this.changeMode(1, false);
                }
            } else if (RepositoryEditor.this.getMode() == 1) {
                RepositoryEditor.this.changeMode(0, true);
            }
        }

        public void updateImage() {
            Locale locale = RepositoryEditor.this.getCurrentPresentationContext().getLocale();
            if (RepositoryEditor.this.getMode() == 0) {
                this.setImageDescriptor(stopEditingImgDiscr);
                this.setToolTipText(Messages.getString("Editor.lock", locale));
                this.setEnabled(true);
            } else if (RepositoryEditor.this.getMode() == 2) {
                this.setImageDescriptor(stopEditingImg_disabledDiscr);
                this.setToolTipText(Messages.getString("Editor.lock", locale));
                this.setEnabled(false);
            } else {
                this.setImageDescriptor(editImgDiscr);
                this.setToolTipText(Messages.getString("Editor.unlock", locale));
                this.setEnabled(true);
            }
        }
    }

    private class HelpAction
    extends Action {
        private HelpAction() {
            Locale locale = RepositoryEditor.this.getCurrentPresentationContext().getLocale();
            this.setImageDescriptor(helpImgDiscr);
            this.setToolTipText(Messages.getString("Editor.help", locale));
        }

        public void run() {
            PlatformUI.getWorkbench().getHelpSystem().displayDynamicHelp();
        }
    }
}

