/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MacOSXCarbonFormToolkit
extends FormToolkit {
    private static final ILogger LOGGER = Logger.getLogger(MacOSXCarbonFormToolkit.class);
    private static final boolean MacOSXCarbonDetected;

    static {
        String ws = Platform.getWS();
        if (ws == null) {
            LOGGER.warn("Unable to detect Windowing System - will not enable MacOSXCarbon workarounds.");
        }
        MacOSXCarbonDetected = "carbon".equals(ws);
    }

    public MacOSXCarbonFormToolkit(Display display) {
        super(display);
    }

    public Text createText(Composite parent, String value, int style) {
        if ((style & 0x40) == 64 && (style & 0x200) != 512) {
            return super.createText(parent, value, style | 0x200);
        }
        if ((style & 2) == 2 && (style & 0x200) != 512) {
            return super.createText(parent, value, style | 0x200);
        }
        return super.createText(parent, value, style);
    }

    public static boolean areWeRunningOnMacOSXCarbon() {
        return MacOSXCarbonDetected;
    }
}

