/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui.viewers;

import com.arcway.lib.eclipse.gui.EclipseSWTHelper;
import com.arcway.lib.eclipse.gui.viewers.ITableWithRowHeadingsLabelProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeViewerWithVerticalHeaders {
    private static final int VERTICAL_MARGIN_FOR_COLUMN_HEADINGS = 10;
    private static final int HORIZONTAL_MARGIN_FOR_COLUMN_HEADINGS = 5;
    private static final int DEFAULT_ROW_HEIGHT = 19;
    private final boolean withRowHeaders;
    private final boolean mayScrollHorizontally;
    private final boolean mayScrollVertically;
    private final List<String> columnTitleList = new ArrayList<String>();
    private final Composite base;
    private final StyledText topLeftCell;
    private final TreeViewer rowHeader;
    private final TableViewer columnHeader;
    private final Composite contentsScrolledComposite;
    private final ColumnViewer contents;
    private Slider horizontalScrollBar;
    private final int sliderWidth;
    private Slider verticalScrollBar;
    private final int sliderHeight;
    private Label cornerBetweenScrollBars;
    private final Color backgroundColor;
    private final Transform rotation90DegreesCounterClockwise;
    private Transform storageForDefaultTransform;
    private boolean isCurrentlyScrollingHorizontally;
    private int currentHorizontalScrollPosition;
    private int currentHorizontalScrollingSpan;
    private boolean isCurrentlyScrollingVertically;
    private int currentVerticalScrollPosition;
    private int currentVerticalScrollingSpan;
    private ITreeContentProvider contentProvider;
    private Object[] currentContentsElements;

    public TreeViewerWithVerticalHeaders(Composite parent, int columnHeadingHeight, int style) {
        this(parent, false, 0, columnHeadingHeight, null, style, 19);
    }

    public TreeViewerWithVerticalHeaders(Composite parent, int rowHeadingWidth, int columnHeadingHeight, String topLeftCellText, int style) {
        this(parent, true, rowHeadingWidth, columnHeadingHeight, topLeftCellText, style, 19);
    }

    public TreeViewerWithVerticalHeaders(Composite parent, int rowHeadingWidth, int columnHeadingHeight, String topLeftCellText, int style, int rowHeight) {
        this(parent, true, rowHeadingWidth, columnHeadingHeight, topLeftCellText, style, rowHeight);
    }

    private TreeViewerWithVerticalHeaders(final Composite parent, boolean withRowHeaders, int rowHeadingWidth, final int columnHeadingHeight, String topLeftCellText, int style, final int rowHeight) {
        this.withRowHeaders = withRowHeaders;
        this.mayScrollHorizontally = (style & 0x100) > 0;
        this.mayScrollVertically = (style & 0x200) > 0;
        this.backgroundColor = new Color((Device)parent.getDisplay(), 250, 250, 250);
        this.rotation90DegreesCounterClockwise = new Transform((Device)parent.getDisplay());
        this.rotation90DegreesCounterClockwise.rotate(-90.0f);
        this.storageForDefaultTransform = new Transform((Device)parent.getDisplay());
        this.base = new Composite(parent, 2048);
        this.base.setLayout((Layout)TreeViewerWithVerticalHeaders.createGridLayoutWithoutMarginsAndIndentation(withRowHeaders ? 2 : 1));
        this.base.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TreeViewerWithVerticalHeaders.this.backgroundColor.dispose();
                TreeViewerWithVerticalHeaders.this.rotation90DegreesCounterClockwise.dispose();
                TreeViewerWithVerticalHeaders.this.storageForDefaultTransform.dispose();
            }
        });
        if (withRowHeaders) {
            final Composite topLeftCellComposite = new Composite(this.base, 0);
            topLeftCellComposite.setLayoutData((Object)new GridData(4, 4, false, false));
            topLeftCellComposite.setLayout((Layout)TreeViewerWithVerticalHeaders.createGridLayoutWithoutMarginsAndIndentation(1));
            topLeftCellComposite.setBackground(this.backgroundColor);
            topLeftCellComposite.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent event) {
                    Color defaultForeground = event.gc.getForeground();
                    event.gc.setForeground(parent.getDisplay().getSystemColor(19));
                    Rectangle area = topLeftCellComposite.getClientArea();
                    event.gc.drawLine(area.x + area.width - 1, area.y, area.x + area.width - 1, area.y + area.height - 1);
                    event.gc.drawLine(area.x, area.y + area.height - 1, area.x + area.width - 1, area.y + area.height - 1);
                    event.gc.setForeground(defaultForeground);
                }
            });
            this.topLeftCell = new StyledText(topLeftCellComposite, 66);
            GridData topLeftCellGridData = new GridData(2, 2, true, true);
            topLeftCellGridData.widthHint = rowHeadingWidth - 10;
            this.topLeftCell.setLayoutData((Object)topLeftCellGridData);
            this.topLeftCell.setBackground(this.backgroundColor);
            this.topLeftCell.setForeground(parent.getDisplay().getSystemColor(2));
            EclipseSWTHelper.setBoldFont((Control)this.topLeftCell, true);
            this.topLeftCell.setAlignment(0x1000000);
            this.topLeftCell.setText(topLeftCellText);
            this.topLeftCell.setEditable(false);
            this.topLeftCell.setEnabled(false);
        } else {
            this.topLeftCell = null;
        }
        Composite columnHeaderComposite = new Composite(this.base, 0);
        GridData columnHeaderCompositeLayoutData = new GridData(4, 4, true, false);
        columnHeaderCompositeLayoutData.heightHint = columnHeadingHeight;
        columnHeaderComposite.setLayoutData((Object)columnHeaderCompositeLayoutData);
        this.columnHeader = new TableViewer(columnHeaderComposite, 16);
        this.columnHeader.getTable().setLinesVisible(true);
        this.columnHeader.getTable().setBackground(this.backgroundColor);
        this.columnHeader.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return new Object[]{inputElement, inputElement};
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.columnHeader.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                return (String)TreeViewerWithVerticalHeaders.this.columnTitleList.get(columnIndex);
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }
        });
        this.columnHeader.getTable().addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = columnHeadingHeight;
            }
        });
        this.columnHeader.getTable().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFFD;
                event.detail &= 0xFFFFFFFB;
                event.detail &= 0xFFFFFFDF;
                event.detail &= 0xFFFFFFEF;
            }
        });
        final HashMap map_key_wrappedText = new HashMap();
        final HashMap map_key_rotatedXPos = new HashMap();
        final HashMap map_key_rotatedYPos = new HashMap();
        this.columnHeader.getTable().addListener(42, new Listener(){

            public void handleEvent(Event event) {
                int rotatedYPos;
                int rotatedXPos;
                TableItem item = (TableItem)event.item;
                Integer key = event.index;
                String wrappedText = (String)map_key_wrappedText.get(key);
                if (wrappedText == null) {
                    Rectangle cellBounds = item.getBounds(event.index);
                    wrappedText = TreeViewerWithVerticalHeaders.wrapText(item.getText(event.index), cellBounds.height - 20, cellBounds.width - 10, event.gc);
                    Point size = event.gc.textExtent(wrappedText);
                    int xPos = cellBounds.x + Math.max(0, (cellBounds.width - size.y) / 2);
                    int yPos = cellBounds.y + cellBounds.height - 10;
                    rotatedXPos = -yPos;
                    rotatedYPos = xPos;
                    map_key_wrappedText.put(key, wrappedText);
                    map_key_rotatedXPos.put(key, rotatedXPos);
                    map_key_rotatedYPos.put(key, rotatedYPos);
                } else {
                    rotatedXPos = (Integer)map_key_rotatedXPos.get(key);
                    rotatedYPos = (Integer)map_key_rotatedYPos.get(key);
                }
                event.gc.getTransform(TreeViewerWithVerticalHeaders.this.storageForDefaultTransform);
                event.gc.setTransform(TreeViewerWithVerticalHeaders.this.rotation90DegreesCounterClockwise);
                event.gc.drawText(wrappedText, rotatedXPos, rotatedYPos, true);
                event.gc.setTransform(TreeViewerWithVerticalHeaders.this.storageForDefaultTransform);
            }
        });
        this.columnHeader.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ((Table)e.getSource()).deselectAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        if (withRowHeaders) {
            Composite rowHeaderComposite = new Composite(this.base, 0);
            GridData rowHeaderCompositeLayoutData = new GridData(4, 4, false, true);
            rowHeaderCompositeLayoutData.widthHint = rowHeadingWidth;
            rowHeaderComposite.setLayoutData((Object)rowHeaderCompositeLayoutData);
            this.rowHeader = new TreeViewer(rowHeaderComposite, 65552);
            this.rowHeader.getTree().setLinesVisible(true);
            this.rowHeader.getTree().setBackground(this.backgroundColor);
            this.rowHeader.getControl().addListener(41, new Listener(){

                public void handleEvent(Event event) {
                    event.height = rowHeight;
                }
            });
            this.rowHeader.getTree().addListener(40, new Listener(){

                public void handleEvent(Event event) {
                    event.detail &= 0xFFFFFFFB;
                }
            });
            this.rowHeader.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TreeViewerWithVerticalHeaders.this.contents.setSelection(TreeViewerWithVerticalHeaders.this.rowHeader.getSelection());
                }
            });
            TreeColumn rowHeaderColumn = new TreeColumn(this.rowHeader.getTree(), 16384);
            rowHeaderColumn.setToolTipText("");
            rowHeaderColumn.setWidth(rowHeadingWidth);
            rowHeaderColumn.setMoveable(false);
            rowHeaderColumn.setResizable(false);
        } else {
            this.rowHeader = null;
        }
        this.contentsScrolledComposite = new Composite(this.base, 0);
        this.contentsScrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite contentsComposite = new Composite(this.contentsScrolledComposite, 0);
        contentsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        int effectiveStyle = style & 0xFFFFF7FF & 0xFFFFFEFF & 0xFFFFFDFF | 0x10;
        if ((style & 0x8000) == 0) {
            effectiveStyle |= 0x10000;
        }
        if (withRowHeaders) {
            this.contents = new TableViewer(contentsComposite, effectiveStyle);
            ((TableViewer)this.contents).getTable().setLinesVisible(true);
        } else {
            this.contents = new TreeViewer(contentsComposite, effectiveStyle);
            ((TreeViewer)this.contents).getTree().setLinesVisible(true);
        }
        this.contents.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.contents.getControl().addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = rowHeight;
            }
        });
        if (withRowHeaders) {
            this.contents.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    TreeViewerWithVerticalHeaders.this.rowHeader.setSelection(event.getSelection());
                }
            });
        }
        Slider horizontalDummySlider = new Slider(this.contentsScrolledComposite, 256);
        this.sliderHeight = horizontalDummySlider.computeSize((int)-1, (int)-1).y;
        horizontalDummySlider.dispose();
        Slider verticalDummySlider = new Slider(this.contentsScrolledComposite, 512);
        this.sliderWidth = verticalDummySlider.computeSize((int)-1, (int)-1).x;
        verticalDummySlider.dispose();
        this.isCurrentlyScrollingHorizontally = false;
        this.currentHorizontalScrollPosition = 0;
        this.currentHorizontalScrollingSpan = 0;
        this.horizontalScrollBar = null;
        this.isCurrentlyScrollingVertically = false;
        this.currentVerticalScrollPosition = 0;
        this.currentVerticalScrollingSpan = 0;
        this.verticalScrollBar = null;
        this.cornerBetweenScrollBars = null;
        this.contentsScrolledComposite.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                TreeViewerWithVerticalHeaders.this.handleResize(false);
            }
        });
        this.handleResize(true);
    }

    private static GridLayout createGridLayoutWithoutMarginsAndIndentation(int columnCount) {
        GridLayout layout = new GridLayout(columnCount, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        return layout;
    }

    private void handleResize(boolean forceRefresh) {
        Point preferredSize = this.contents.getControl().computeSize(-1, -1);
        boolean scrollingBehaviourChanged = false;
        if (forceRefresh) {
            scrollingBehaviourChanged = true;
        } else {
            boolean shouldScrollVertically = false;
            boolean shouldScrollHorizontally = false;
            if (this.mayScrollVertically) {
                this.currentVerticalScrollingSpan = preferredSize.y - this.contentsScrolledComposite.getSize().y;
                boolean bl = shouldScrollVertically = this.currentVerticalScrollingSpan > 0;
            }
            if (this.mayScrollHorizontally) {
                this.currentHorizontalScrollingSpan = preferredSize.x - this.contentsScrolledComposite.getSize().x;
                boolean bl = shouldScrollHorizontally = this.currentHorizontalScrollingSpan > 0;
            }
            if (shouldScrollHorizontally) {
                this.currentVerticalScrollingSpan = preferredSize.y - (this.contentsScrolledComposite.getSize().y - this.sliderHeight);
                boolean bl = shouldScrollVertically = this.currentVerticalScrollingSpan > 0;
            }
            if (shouldScrollVertically) {
                this.currentHorizontalScrollingSpan = preferredSize.x - (this.contentsScrolledComposite.getSize().x - this.sliderWidth);
                boolean bl = shouldScrollHorizontally = this.currentHorizontalScrollingSpan > 0;
            }
            if (shouldScrollHorizontally) {
                this.currentVerticalScrollingSpan = preferredSize.y - (this.contentsScrolledComposite.getSize().y - this.sliderHeight);
                boolean bl = shouldScrollVertically = this.currentVerticalScrollingSpan > 0;
            }
            if (this.mayScrollVertically) {
                if (this.isCurrentlyScrollingVertically && !shouldScrollVertically) {
                    scrollingBehaviourChanged = true;
                    this.isCurrentlyScrollingVertically = false;
                    this.currentVerticalScrollPosition = 0;
                } else if (!this.isCurrentlyScrollingVertically && shouldScrollVertically) {
                    scrollingBehaviourChanged = true;
                    this.isCurrentlyScrollingVertically = true;
                    this.currentVerticalScrollPosition = Math.min(this.currentVerticalScrollPosition, this.currentVerticalScrollingSpan);
                } else if (this.isCurrentlyScrollingVertically && shouldScrollVertically) {
                    this.currentVerticalScrollPosition = Math.min(this.currentVerticalScrollPosition, this.currentVerticalScrollingSpan);
                }
            }
            if (this.mayScrollHorizontally) {
                if (this.isCurrentlyScrollingHorizontally && !shouldScrollHorizontally) {
                    scrollingBehaviourChanged = true;
                    this.isCurrentlyScrollingHorizontally = false;
                    this.currentHorizontalScrollPosition = 0;
                } else if (!this.isCurrentlyScrollingHorizontally && shouldScrollHorizontally) {
                    scrollingBehaviourChanged = true;
                    this.isCurrentlyScrollingHorizontally = true;
                    this.currentHorizontalScrollPosition = Math.min(this.currentHorizontalScrollPosition, this.currentHorizontalScrollingSpan);
                } else if (this.isCurrentlyScrollingHorizontally && shouldScrollHorizontally) {
                    this.currentHorizontalScrollPosition = Math.min(this.currentHorizontalScrollPosition, this.currentHorizontalScrollingSpan);
                }
            }
        }
        if (scrollingBehaviourChanged) {
            if (this.verticalScrollBar != null) {
                this.verticalScrollBar.dispose();
                this.verticalScrollBar = null;
            }
            if (this.horizontalScrollBar != null) {
                this.horizontalScrollBar.dispose();
                this.horizontalScrollBar = null;
            }
            if (this.cornerBetweenScrollBars != null) {
                this.cornerBetweenScrollBars.dispose();
                this.cornerBetweenScrollBars = null;
            }
            this.contentsScrolledComposite.setLayout((Layout)TreeViewerWithVerticalHeaders.createGridLayoutWithoutMarginsAndIndentation(this.isCurrentlyScrollingVertically ? 2 : 1));
            if (this.isCurrentlyScrollingVertically) {
                this.verticalScrollBar = this.createScrollBar(false);
            }
            if (this.isCurrentlyScrollingHorizontally) {
                this.horizontalScrollBar = this.createScrollBar(true);
                if (this.isCurrentlyScrollingVertically) {
                    this.cornerBetweenScrollBars = new Label(this.contentsScrolledComposite, 0);
                    this.cornerBetweenScrollBars.setLayoutData((Object)new GridData(4, 4, false, false));
                    this.cornerBetweenScrollBars.setBackground(this.contentsScrolledComposite.getDisplay().getSystemColor(22));
                }
            }
            this.contentsScrolledComposite.layout();
            this.contentsScrolledComposite.redraw();
        }
        if (this.isCurrentlyScrollingHorizontally) {
            this.horizontalScrollBar.setMaximum(preferredSize.x);
            this.horizontalScrollBar.setThumb(preferredSize.x - this.currentHorizontalScrollingSpan);
            this.horizontalScrollBar.setSelection(this.currentHorizontalScrollPosition);
        }
        if (this.isCurrentlyScrollingVertically) {
            this.verticalScrollBar.setMaximum(preferredSize.y);
            this.verticalScrollBar.setThumb(preferredSize.y - this.currentVerticalScrollingSpan);
            this.verticalScrollBar.setSelection(this.currentVerticalScrollPosition);
        }
        this.adjustScrollPositions();
    }

    private Slider createScrollBar(final boolean horizontal) {
        Slider scrollBar = new Slider(this.contentsScrolledComposite, horizontal ? 256 : 512);
        scrollBar.setLayoutData((Object)new GridData(4, 4, horizontal, !horizontal));
        scrollBar.setMinimum(0);
        scrollBar.setIncrement(10);
        scrollBar.setPageIncrement(800);
        scrollBar.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (horizontal) {
                    TreeViewerWithVerticalHeaders.this.currentHorizontalScrollPosition = TreeViewerWithVerticalHeaders.this.horizontalScrollBar.getSelection();
                } else {
                    TreeViewerWithVerticalHeaders.this.currentVerticalScrollPosition = TreeViewerWithVerticalHeaders.this.verticalScrollBar.getSelection();
                }
                TreeViewerWithVerticalHeaders.this.adjustScrollPositions();
            }
        });
        return scrollBar;
    }

    private void adjustScrollPositions() {
        this.contents.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Control contentsControl = TreeViewerWithVerticalHeaders.this.contents.getControl();
                Control columnHeaderControl = TreeViewerWithVerticalHeaders.this.columnHeader.getControl();
                if (!(contentsControl == null || contentsControl.isDisposed() || columnHeaderControl == null || columnHeaderControl.isDisposed() || TreeViewerWithVerticalHeaders.this.withRowHeaders && TreeViewerWithVerticalHeaders.this.rowHeader.getTree().isDisposed())) {
                    contentsControl.setLocation(-TreeViewerWithVerticalHeaders.this.currentHorizontalScrollPosition, -TreeViewerWithVerticalHeaders.this.currentVerticalScrollPosition);
                    contentsControl.setSize(TreeViewerWithVerticalHeaders.this.currentHorizontalScrollPosition + ((TreeViewerWithVerticalHeaders)TreeViewerWithVerticalHeaders.this).contentsScrolledComposite.getSize().x - (TreeViewerWithVerticalHeaders.this.isCurrentlyScrollingVertically ? ((TreeViewerWithVerticalHeaders)TreeViewerWithVerticalHeaders.this).verticalScrollBar.getSize().x : 0), TreeViewerWithVerticalHeaders.this.currentVerticalScrollPosition + ((TreeViewerWithVerticalHeaders)TreeViewerWithVerticalHeaders.this).contentsScrolledComposite.getSize().y - (TreeViewerWithVerticalHeaders.this.isCurrentlyScrollingHorizontally ? ((TreeViewerWithVerticalHeaders)TreeViewerWithVerticalHeaders.this).horizontalScrollBar.getSize().y : 0));
                    columnHeaderControl.setLocation(-TreeViewerWithVerticalHeaders.this.currentHorizontalScrollPosition, 0);
                    columnHeaderControl.setSize(TreeViewerWithVerticalHeaders.this.currentHorizontalScrollPosition + ((TreeViewerWithVerticalHeaders)TreeViewerWithVerticalHeaders.this).contentsScrolledComposite.getSize().x, ((TreeViewerWithVerticalHeaders)TreeViewerWithVerticalHeaders.this).columnHeader.getTable().getParent().getSize().y);
                    if (TreeViewerWithVerticalHeaders.this.withRowHeaders) {
                        TreeViewerWithVerticalHeaders.this.rowHeader.getTree().setLocation(0, -TreeViewerWithVerticalHeaders.this.currentVerticalScrollPosition);
                        TreeViewerWithVerticalHeaders.this.rowHeader.getTree().setSize(((TreeViewerWithVerticalHeaders)TreeViewerWithVerticalHeaders.this).rowHeader.getTree().getParent().getSize().x, TreeViewerWithVerticalHeaders.this.currentVerticalScrollPosition + ((TreeViewerWithVerticalHeaders)TreeViewerWithVerticalHeaders.this).contentsScrolledComposite.getSize().y);
                    }
                }
            }
        });
    }

    private static String wrapText(String text, int width, int height, GC gc) {
        int indexOfNextFittingWhiteSpaceCharacter;
        String wrappedText = text;
        int index = 0;
        block0: do {
            Point remainingTextWidth = gc.textExtent(wrappedText.substring(index));
            Point textHeightWithOneMoreLine = gc.textExtent(String.valueOf(wrappedText) + "\nA");
            if (remainingTextWidth.x <= width || textHeightWithOneMoreLine.y > height) break;
            indexOfNextFittingWhiteSpaceCharacter = -1;
            int indexOfRemainingText = index;
            while (true) {
                int indexOfNextWhiteSpaceCharacter;
                if ((indexOfNextWhiteSpaceCharacter = wrappedText.indexOf(" ", indexOfRemainingText)) == -1) {
                    indexOfNextWhiteSpaceCharacter = wrappedText.length();
                }
                Point textWidthUpToSpaceCharacter = gc.textExtent(wrappedText.substring(index, indexOfNextWhiteSpaceCharacter));
                if (textWidthUpToSpaceCharacter.x > width) {
                    if (indexOfNextFittingWhiteSpaceCharacter != -1) continue block0;
                    indexOfNextFittingWhiteSpaceCharacter = indexOfNextWhiteSpaceCharacter;
                    continue block0;
                }
                indexOfNextFittingWhiteSpaceCharacter = indexOfNextWhiteSpaceCharacter;
                indexOfRemainingText = indexOfNextFittingWhiteSpaceCharacter + 1;
            }
        } while ((index = indexOfNextFittingWhiteSpaceCharacter + 1) < (wrappedText = String.valueOf(wrappedText.substring(0, indexOfNextFittingWhiteSpaceCharacter)) + (indexOfNextFittingWhiteSpaceCharacter < wrappedText.length() ? "\n" + wrappedText.substring(indexOfNextFittingWhiteSpaceCharacter + 1) : "")).length());
        return wrappedText;
    }

    public Control getControl() {
        return this.base;
    }

    public void setContentProvider(IContentProvider provider) {
        assert (provider instanceof ITreeContentProvider);
        if (this.withRowHeaders) {
            this.contentProvider = (ITreeContentProvider)provider;
            this.rowHeader.setContentProvider(provider);
            this.contents.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    return (Object[])inputElement;
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }
            });
            this.rowHeader.addTreeListener(new ITreeViewerListener(){

                public void treeExpanded(TreeExpansionEvent event) {
                    TreeViewerWithVerticalHeaders.this.contents.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TreeViewerWithVerticalHeaders.this.refreshInputForContentsTreeViewer();
                            TreeViewerWithVerticalHeaders.this.handleResize(false);
                        }
                    });
                }

                public void treeCollapsed(TreeExpansionEvent event) {
                    TreeViewerWithVerticalHeaders.this.contents.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TreeViewerWithVerticalHeaders.this.refreshInputForContentsTreeViewer();
                            TreeViewerWithVerticalHeaders.this.handleResize(false);
                        }
                    });
                }
            });
        } else {
            this.contents.setContentProvider(provider);
            ((TreeViewer)this.contents).addTreeListener(new ITreeViewerListener(){

                public void treeExpanded(TreeExpansionEvent event) {
                    TreeViewerWithVerticalHeaders.this.contents.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TreeViewerWithVerticalHeaders.this.handleResize(false);
                        }
                    });
                }

                public void treeCollapsed(TreeExpansionEvent event) {
                    TreeViewerWithVerticalHeaders.this.contents.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TreeViewerWithVerticalHeaders.this.handleResize(false);
                        }
                    });
                }
            });
        }
    }

    private void refreshInputForContentsTreeViewer() {
        ArrayList<Object> elements = new ArrayList<Object>();
        TreeItem[] treeItemArray = this.rowHeader.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.addElementsForTreeItem(item, elements);
            ++n2;
        }
        this.contents.setInput((Object)elements.toArray());
    }

    private void addElementsForTreeItem(TreeItem item, ArrayList<Object> elements) {
        elements.add(item.getData());
        if (item.getExpanded()) {
            TreeItem[] treeItemArray = item.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem childItem = treeItemArray[n2];
                this.addElementsForTreeItem(childItem, elements);
                ++n2;
            }
        }
    }

    public void setLabelProvider(ITableLabelProvider labelProvider_) {
        if (this.withRowHeaders && !(labelProvider_ instanceof ITableWithRowHeadingsLabelProvider)) {
            throw new IllegalArgumentException();
        }
        final ITableWithRowHeadingsLabelProvider labelProvider = (ITableWithRowHeadingsLabelProvider)labelProvider_;
        this.contents.setLabelProvider((IBaseLabelProvider)labelProvider);
        if (this.withRowHeaders) {
            this.rowHeader.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

                public boolean isLabelProperty(Object element, String property) {
                    return labelProvider.isLabelProperty(element, property);
                }

                public Image getColumnImage(Object element, int columnIndex) {
                    return labelProvider.getRowHeadingImage(element);
                }

                public String getColumnText(Object element, int columnIndex) {
                    return labelProvider.getRowHeadingText(element);
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void removeListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }
            });
        }
    }

    public void addColumn(String title, int width, boolean movable, int style) {
        this.columnTitleList.add(title);
        TableColumn headerColumn = new TableColumn(this.columnHeader.getTable(), style);
        headerColumn.setWidth(width);
        headerColumn.setMoveable(movable);
        headerColumn.setResizable(true);
        if (this.withRowHeaders) {
            TableColumn contentsColumn = new TableColumn(((TableViewer)this.contents).getTable(), style);
            contentsColumn.setWidth(width);
            contentsColumn.setMoveable(movable);
            contentsColumn.setResizable(true);
        } else {
            TreeColumn contentsColumn = new TreeColumn(((TreeViewer)this.contents).getTree(), style);
            contentsColumn.setWidth(width);
            contentsColumn.setMoveable(movable);
            contentsColumn.setResizable(true);
        }
    }

    public final void setInput(Object input) {
        this.columnHeader.setInput(new Object());
        if (this.withRowHeaders) {
            this.rowHeader.setInput(input);
            this.currentContentsElements = this.contentProvider.getElements(input);
            this.contents.setInput((Object)this.currentContentsElements);
        } else {
            this.contents.setInput(input);
        }
        this.handleResize(false);
    }

    public void setColumnWidth(int columnIndex, int width) {
        this.columnHeader.getTable().getColumn(columnIndex).setWidth(width);
        if (this.withRowHeaders) {
            ((TableViewer)this.contents).getTable().getColumn(columnIndex).setWidth(width);
        } else {
            ((TreeViewer)this.contents).getTree().getColumn(columnIndex).setWidth(width);
        }
    }

    public MenuManager createContextMenu() {
        MenuManager contextMenuManager = new MenuManager();
        Menu contentsContextMenu = contextMenuManager.createContextMenu(this.contents.getControl());
        this.contents.getControl().setMenu(contentsContextMenu);
        return contextMenuManager;
    }

    public Composite getTreeCompositeForCellEditors() {
        if (this.withRowHeaders) {
            return ((TableViewer)this.contents).getTable();
        }
        return ((TreeViewer)this.contents).getTree();
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.contents.addDoubleClickListener(listener);
    }

    public void addDragSupport(int operations, Transfer[] transferTypes, DragSourceListener listener) {
        this.contents.addDragSupport(operations, transferTypes, listener);
    }

    public void addDropSupport(int operations, Transfer[] transferTypes, DropTargetListener listener) {
        this.contents.addDropSupport(operations, transferTypes, listener);
    }

    public void addFilter(ViewerFilter filter) {
        this.contents.addFilter(filter);
    }

    public void addHelpListener(HelpListener listener) {
        this.contents.addHelpListener(listener);
    }

    public void addOpenListener(IOpenListener listener) {
        this.contents.addOpenListener(listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.contents.addPostSelectionChangedListener(listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.contents.addSelectionChangedListener(listener);
    }

    public ViewerFilter[] getFilters() {
        return this.contents.getFilters();
    }

    public ISelection getSelection() {
        return this.contents.getSelection();
    }

    public ViewerSorter getSorter() {
        return this.contents.getSorter();
    }

    public void refresh() {
        if (this.withRowHeaders) {
            this.rowHeader.refresh();
            this.refreshInputForContentsTreeViewer();
        }
        this.contents.refresh();
        this.handleResize(false);
    }

    public void removeDoubleClickListener(IDoubleClickListener listener) {
        this.contents.removeDoubleClickListener(listener);
    }

    public void removeFilter(ViewerFilter filter) {
        this.contents.removeFilter(filter);
    }

    public void removeHelpListener(HelpListener listener) {
        this.contents.removeHelpListener(listener);
    }

    public void removeOpenListener(IOpenListener listener) {
        this.contents.removeOpenListener(listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.contents.removePostSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.contents.removeSelectionChangedListener(listener);
    }

    public void resetFilters() {
        this.contents.resetFilters();
    }

    public void revealSelection() {
        if (!this.isCurrentlyScrollingVertically) {
            return;
        }
        int upperBound = 0;
        int lowerBound = 0;
        int height = 0;
        boolean selectionExists = false;
        if (this.withRowHeaders) {
            TableItem[] selectedItems = ((TableViewer)this.contents).getTable().getSelection();
            if (selectedItems.length > 0) {
                upperBound = selectedItems[0].getBounds().y;
                height = selectedItems[0].getBounds().height;
                lowerBound = upperBound + height;
                selectionExists = true;
            }
        } else {
            TreeItem[] selectedItems = ((TreeViewer)this.contents).getTree().getSelection();
            if (selectedItems.length > 0) {
                upperBound = selectedItems[0].getBounds().y;
                height = selectedItems[0].getBounds().height;
                lowerBound = upperBound + height;
                selectionExists = true;
            }
        }
        if (selectionExists) {
            if (upperBound < -this.contents.getControl().getBounds().y) {
                this.verticalScrollBar.setSelection(upperBound);
            } else if (lowerBound > this.contents.getControl().getSize().y) {
                this.verticalScrollBar.setSelection(lowerBound - (this.contentsScrolledComposite.getSize().y - (this.isCurrentlyScrollingHorizontally ? this.horizontalScrollBar.getSize().x : 0)));
            }
            this.currentVerticalScrollPosition = this.verticalScrollBar.getSelection();
            this.adjustScrollPositions();
        }
    }

    public void setFilters(ViewerFilter[] filters) {
        this.contents.setFilters(filters);
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.contents.setSelection(selection);
        if (reveal) {
            this.revealSelection();
        }
    }

    public void setSelection(ISelection selection) {
        this.contents.setSelection(selection);
    }

    public void setSorter(ViewerSorter sorter) {
        this.contents.setSorter(sorter);
    }

    public void setUseHashlookup(boolean enable) {
        this.contents.setUseHashlookup(enable);
    }

    public Widget testFindItem(Object element) {
        return this.contents.testFindItem(element);
    }

    public Widget[] testFindItems(Object element) {
        return this.contents.testFindItems(element);
    }

    public Object getData(String key) {
        return this.contents.getData(key);
    }

    public void setData(String key, Object value) {
        this.contents.setData(key, value);
    }

    public void setCellEditors(CellEditor[] editors) {
        this.contents.setCellEditors(editors);
    }

    public void setCellModifier(ICellModifier modifier) {
        this.contents.setCellModifier(modifier);
    }

    public void setColumnProperties(String[] columnProperties) {
        this.contents.setColumnProperties(columnProperties);
    }

    public Object[] getColumnProperties() {
        return this.contents.getColumnProperties();
    }
}

