/*
 * Decompiled with CFR 0.152.
 */
package au.com.swz.swttocom.swt.types;

import au.com.swz.swttocom.swt.AbstractResourcePackage;
import au.com.swz.swttocom.swt.IManagedResourcePackageUser;
import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.IManagedAutomationObject;
import au.com.swz.swttocom.swt.types.OleEventManager;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.TYPEATTR;
import org.eclipse.swt.ole.win32.IOleAutomationAW;
import org.eclipse.swt.ole.win32.IOleAutomationSWTAdapter;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleAutomationAW;
import org.eclipse.swt.ole.win32.OleFunctionDescription;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;

public class AutomationObjectImpl
implements IManagedAutomationObject,
IManagedResourcePackageUser {
    private final ResourcePackage resourcePackage;
    private final IOleAutomationAW iOleAutomationAW;
    private String exceptionDescription = null;

    public AutomationObjectImpl(Variant variant, ResourceManager resourceManager) {
        assert (variant != null);
        assert (variant.getType() == 9);
        assert (resourceManager != null);
        this.resourcePackage = new ResourcePackage(resourceManager, this);
        this.resourcePackage.variant = variant;
        this.resourcePackage.oleAutomation = null;
        this.iOleAutomationAW = new OleAutomationAW(variant.getDispatch());
    }

    public AutomationObjectImpl(OleAutomation oleAutomation, ResourceManager resourceManager) {
        assert (oleAutomation != null);
        assert (resourceManager != null);
        this.resourcePackage = new ResourcePackage(resourceManager, this);
        this.resourcePackage.variant = null;
        this.resourcePackage.oleAutomation = oleAutomation;
        this.iOleAutomationAW = new IOleAutomationSWTAdapter(oleAutomation);
    }

    public Variant getVariant_internal() {
        assert (!this.resourcePackage.isDisposed);
        if (this.resourcePackage.variant == null) {
            this.resourcePackage.variant = new Variant(this.getOleAutomation());
        }
        return this.resourcePackage.variant;
    }

    private OleAutomation getOleAutomation_internal() {
        assert (!this.resourcePackage.isDisposed);
        if (this.resourcePackage.oleAutomation == null) {
            this.resourcePackage.oleAutomation = this.resourcePackage.variant.getAutomation();
        }
        return this.resourcePackage.oleAutomation;
    }

    @Override
    public int[] getIDsOfNames(String[] names) {
        int[] returnValue = this.iOleAutomationAW.getIDsOfNames(names);
        this.exceptionDescription = this.iOleAutomationAW.getLastError();
        return returnValue;
    }

    @Override
    public Variant getProperty(int dispIdMember) {
        Variant returnValue = this.iOleAutomationAW.getProperty(dispIdMember);
        this.exceptionDescription = this.iOleAutomationAW.getLastError();
        return returnValue;
    }

    @Override
    public Variant getProperty(int dispIdMember, Variant[] rgvarg) {
        Variant returnValue = this.iOleAutomationAW.getProperty(dispIdMember, rgvarg);
        this.exceptionDescription = this.iOleAutomationAW.getLastError();
        return returnValue;
    }

    @Override
    public Variant getProperty(int dispIdMember, Variant[] rgvarg, int[] rgdispidNamedArgs) {
        Variant returnValue = this.iOleAutomationAW.getProperty(dispIdMember, rgvarg, rgdispidNamedArgs);
        this.exceptionDescription = this.iOleAutomationAW.getLastError();
        return returnValue;
    }

    @Override
    public Variant invoke(int dispIdMember) {
        Variant returnValue = this.iOleAutomationAW.invoke(dispIdMember);
        this.exceptionDescription = this.iOleAutomationAW.getLastError();
        return returnValue;
    }

    @Override
    public Variant invoke(int dispIdMember, Variant[] rgvarg) {
        Variant returnValue = this.iOleAutomationAW.invoke(dispIdMember, rgvarg);
        this.exceptionDescription = this.iOleAutomationAW.getLastError();
        return returnValue;
    }

    @Override
    public Variant invoke(int dispIdMember, Variant[] rgvarg, int[] rgdispidNamedArgs) {
        Variant returnValue = this.iOleAutomationAW.invoke(dispIdMember, rgvarg, rgdispidNamedArgs);
        this.exceptionDescription = this.iOleAutomationAW.getLastError();
        return returnValue;
    }

    @Override
    public void invokeNoReply(int dispIdMember) {
        this.iOleAutomationAW.invokeNoReply(dispIdMember);
        this.exceptionDescription = this.iOleAutomationAW.getLastError();
    }

    @Override
    public void invokeNoReply(int dispIdMember, Variant[] rgvarg) {
        this.iOleAutomationAW.invokeNoReply(dispIdMember, rgvarg);
        this.exceptionDescription = this.iOleAutomationAW.getLastError();
    }

    @Override
    public void invokeNoReply(int dispIdMember, Variant[] rgvarg, int[] rgdispidNamedArgs) {
        this.iOleAutomationAW.invokeNoReply(dispIdMember, rgvarg, rgdispidNamedArgs);
        this.exceptionDescription = this.iOleAutomationAW.getLastError();
    }

    @Override
    public void dispose() {
        this.resourcePackage.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.resourcePackage.isDisposed();
    }

    @Override
    public void setProperty(int dispIdMember, Variant rgvarg) {
        this.iOleAutomationAW.setProperty(dispIdMember, rgvarg);
        this.exceptionDescription = this.iOleAutomationAW.getLastError();
    }

    @Override
    public void setProperty(int dispIdMember, Variant[] rgvarg) {
        this.iOleAutomationAW.setProperty(dispIdMember, rgvarg);
        this.exceptionDescription = this.iOleAutomationAW.getLastError();
    }

    @Override
    public String getLastErrorSWT() {
        return this.exceptionDescription;
    }

    public OleAutomation getOleAutomation() {
        Variant v = new Variant(this.getOleAutomation_internal());
        return v.getAutomation();
    }

    protected void addEventListener(GUID riid, int eventID, OleListener listener) {
        assert (!this.resourcePackage.isDisposed());
        if (this.resourcePackage.oleEventManager == null) {
            this.resourcePackage.oleEventManager = new OleEventManager();
        }
        this.resourcePackage.oleEventManager.addEventListener(this.getOleAutomation_internal(), riid, eventID, listener);
    }

    protected void removeEventListener(GUID riid, int eventID, OleListener listener) {
        assert (!this.resourcePackage.isDisposed);
        if (this.resourcePackage.oleEventManager != null) {
            this.resourcePackage.oleEventManager.removeEventListener(this.getOleAutomation_internal(), riid, eventID, listener);
        }
    }

    public void dump() {
        OleAutomation automation = this.getOleAutomation_internal();
        TYPEATTR typeAttr = automation.getTypeInfoAttributes();
        int i = 0;
        while (i < typeAttr.cFuncs) {
            OleFunctionDescription funcDesc = automation.getFunctionDescription(i);
            System.out.println("Function:" + funcDesc.name);
            if (funcDesc.args != null && funcDesc.args.length > 0) {
                int p = 0;
                while (p < funcDesc.args.length) {
                    System.out.println(" " + p + ":" + funcDesc.args[p].name);
                    ++p;
                }
            }
            ++i;
        }
        this.exceptionDescription = automation.getLastError();
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourcePackage.getResourceManager();
    }

    private static class ResourcePackage
    extends AbstractResourcePackage {
        private Variant variant = null;
        private OleAutomation oleAutomation = null;
        private OleEventManager oleEventManager = null;
        private boolean isDisposed = false;

        public ResourcePackage(ResourceManager resourceManager, IManagedResourcePackageUser resourcePackageUser) {
            super(resourceManager, resourcePackageUser);
        }

        @Override
        public void dispose() {
            if (!this.isDisposed) {
                this.isDisposed = true;
                if (this.oleEventManager != null) {
                    this.oleEventManager.dispose();
                    this.oleEventManager = null;
                }
                if (this.oleAutomation != null) {
                    this.oleAutomation.dispose();
                    this.oleAutomation = null;
                }
                if (this.variant != null) {
                    this.variant.dispose();
                    this.variant = null;
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.isDisposed;
        }
    }
}

