/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.ole.project.impl;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.AbstractOleEventsListener;
import com.arcway.lib.eclipse.ole.project.Project;
import com.arcway.lib.eclipse.ole.project._EProjectApp;
import com.arcway.lib.eclipse.ole.project.impl.AssignmentImpl;
import com.arcway.lib.eclipse.ole.project.impl.ResourceImpl;
import com.arcway.lib.eclipse.ole.project.impl.TaskImpl;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.Variant;

public class _EProjectAppListener
extends AbstractOleEventsListener {
    private final Set<_EProjectApp> listeners = new HashSet<_EProjectApp>();

    public _EProjectAppListener(ResourceManager resourceManager) {
        super(resourceManager);
    }

    public boolean addListener(_EProjectApp listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(_EProjectApp listener) {
        return this.listeners.remove(listener);
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void handleEvent(OleEvent oleEvent) {
        Variant[] arguments;
        switch (oleEvent.type) {
            case 1: {
                this.fireNewProject(oleEvent);
                break;
            }
            case 6: {
                this.fireProjectBeforeTaskDelete(oleEvent);
                break;
            }
            case 7: {
                this.fireProjectBeforeResourceDelete(oleEvent);
                break;
            }
            case 8: {
                this.fireProjectBeforeAssignmentDelete(oleEvent);
                break;
            }
            case 9: {
                this.fireProjectBeforeTaskChange(oleEvent);
                break;
            }
            case 10: {
                this.fireProjectBeforeResourceChange(oleEvent);
                break;
            }
            case 11: {
                this.fireProjectBeforeAssignmentChange(oleEvent);
                break;
            }
            case 12: {
                this.fireProjectBeforeTaskNew(oleEvent);
                break;
            }
            case 13: {
                this.fireProjectBeforeResourceNew(oleEvent);
                break;
            }
            case 14: {
                this.fireProjectBeforeAssignmentNew(oleEvent);
                break;
            }
            case 2: {
                this.fireProjectBeforeClose(oleEvent);
                break;
            }
            case 4: {
                this.fireProjectBeforePrint(oleEvent);
                break;
            }
            case 3: {
                this.fireProjectBeforeSave(oleEvent);
                break;
            }
            case 5: {
                this.fireProjectCalculate(oleEvent);
            }
        }
        Variant[] variantArray = arguments = oleEvent.arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Variant argument = variantArray[n2];
            argument.dispose();
            ++n2;
        }
    }

    private void fireNewProject(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        for (_EProjectApp l : this.listeners) {
            l.NewProject(pj);
        }
    }

    private void fireProjectBeforeTaskDelete(OleEvent oleEvent) {
        TaskImpl tsk = new TaskImpl(oleEvent.arguments[0], this.getResourceManager());
        boolean cancel = oleEvent.arguments[1].getBoolean();
        for (_EProjectApp l : this.listeners) {
            l.ProjectBeforeTaskDelete(tsk, cancel);
        }
    }

    private void fireProjectBeforeResourceDelete(OleEvent oleEvent) {
        ResourceImpl res = new ResourceImpl(oleEvent.arguments[0], this.getResourceManager());
        boolean cancel = oleEvent.arguments[1].getBoolean();
        for (_EProjectApp l : this.listeners) {
            l.ProjectBeforeResourceDelete(res, cancel);
        }
    }

    private void fireProjectBeforeAssignmentDelete(OleEvent oleEvent) {
        AssignmentImpl asg = new AssignmentImpl(oleEvent.arguments[0], this.getResourceManager());
        boolean cancel = oleEvent.arguments[1].getBoolean();
        for (_EProjectApp l : this.listeners) {
            l.ProjectBeforeAssignmentDelete(asg, cancel);
        }
    }

    private void fireProjectBeforeTaskChange(OleEvent oleEvent) {
        TaskImpl tsk = new TaskImpl(oleEvent.arguments[0], this.getResourceManager());
        int field = oleEvent.arguments[1].getInt();
        Variant newVal = oleEvent.arguments[2];
        boolean cancel = oleEvent.arguments[3].getBoolean();
        for (_EProjectApp l : this.listeners) {
            l.ProjectBeforeTaskChange(tsk, field, newVal, cancel);
        }
    }

    private void fireProjectBeforeResourceChange(OleEvent oleEvent) {
        ResourceImpl res = new ResourceImpl(oleEvent.arguments[0], this.getResourceManager());
        int field = oleEvent.arguments[1].getInt();
        Variant newVal = oleEvent.arguments[2];
        boolean cancel = oleEvent.arguments[3].getBoolean();
        for (_EProjectApp l : this.listeners) {
            l.ProjectBeforeResourceChange(res, field, newVal, cancel);
        }
    }

    private void fireProjectBeforeAssignmentChange(OleEvent oleEvent) {
        AssignmentImpl asg = new AssignmentImpl(oleEvent.arguments[0], this.getResourceManager());
        int field = oleEvent.arguments[1].getInt();
        Variant newVal = oleEvent.arguments[2];
        boolean cancel = oleEvent.arguments[3].getBoolean();
        for (_EProjectApp l : this.listeners) {
            l.ProjectBeforeAssignmentChange(asg, field, newVal, cancel);
        }
    }

    private void fireProjectBeforeTaskNew(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        boolean cancel = oleEvent.arguments[1].getBoolean();
        for (_EProjectApp l : this.listeners) {
            l.ProjectBeforeTaskNew(pj, cancel);
        }
    }

    private void fireProjectBeforeResourceNew(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        boolean cancel = oleEvent.arguments[1].getBoolean();
        for (_EProjectApp l : this.listeners) {
            l.ProjectBeforeResourceNew(pj, cancel);
        }
    }

    private void fireProjectBeforeAssignmentNew(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        boolean cancel = oleEvent.arguments[1].getBoolean();
        for (_EProjectApp l : this.listeners) {
            l.ProjectBeforeAssignmentNew(pj, cancel);
        }
    }

    private void fireProjectBeforeClose(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        boolean cancel = oleEvent.arguments[1].getBoolean();
        for (_EProjectApp l : this.listeners) {
            l.ProjectBeforeClose(pj, cancel);
        }
    }

    private void fireProjectBeforePrint(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        boolean cancel = oleEvent.arguments[1].getBoolean();
        for (_EProjectApp l : this.listeners) {
            l.ProjectBeforePrint(pj, cancel);
        }
    }

    private void fireProjectBeforeSave(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        boolean saveAsUi = oleEvent.arguments[1].getBoolean();
        boolean cancel = oleEvent.arguments[2].getBoolean();
        for (_EProjectApp l : this.listeners) {
            l.ProjectBeforeSave(pj, saveAsUi, cancel);
        }
    }

    private void fireProjectCalculate(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        for (_EProjectApp l : this.listeners) {
            l.ProjectCalculate(pj);
        }
    }
}

