/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.adapter.excel;

import com.arcway.lib.eclipse.ole.excel.Characters;
import com.arcway.lib.eclipse.ole.excel.Range;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.ole.win32.Variant;

public class ExcelBugWorkarounds {
    private static final int cell_get_Text_maxChunksize = 254;
    private static final int cell_get_Text_workaroundCheckTresholdLength = 1023;

    public static String cell_get_Text(Range cell) {
        int characterCount;
        String cellContent;
        Variant cellContentVariant = cell.get_Text();
        String string = cellContent = cellContentVariant != null ? cellContentVariant.getString() : "";
        assert (cellContentVariant != null);
        boolean isHashString = ExcelBugWorkarounds.isHashString(cellContent);
        if ((cellContent.length() > 1023 || isHashString) && (characterCount = ExcelBugWorkarounds.getCharacterCount(cell)) != -1 && (characterCount > cellContent.length() || isHashString)) {
            cellContent = ExcelBugWorkarounds.cell_get_Text_using_get_Characters(cell, characterCount);
        }
        return cellContent;
    }

    private static String cell_get_Text_using_get_Characters(Range cell, int characterCount) {
        StringBuilder contentBuilder = new StringBuilder();
        int remainingCharactersToRetrieve = characterCount;
        while (remainingCharactersToRetrieve > 0) {
            int chunksize = remainingCharactersToRetrieve >= 254 ? 254 : remainingCharactersToRetrieve;
            int startIndex = characterCount - remainingCharactersToRetrieve + 1;
            Characters chunkCharacters = cell.get_Characters((Object)startIndex, (Object)chunksize);
            String chunkString = chunkCharacters.get_Text();
            contentBuilder.append(chunkString);
            remainingCharactersToRetrieve -= chunksize;
        }
        assert (contentBuilder.length() == characterCount);
        return contentBuilder.toString();
    }

    private static final int getCharacterCount(Range cell) {
        try {
            return cell.get_Characters().get_Count();
        }
        catch (SWTException swtE) {
            return -1;
        }
    }

    private static final boolean assertEqualTextLength(String cellContentAsString, Range cell) {
        int characterCount = ExcelBugWorkarounds.getCharacterCount(cell);
        if (characterCount != -1) {
            boolean equal = cellContentAsString.equals(ExcelBugWorkarounds.cell_get_Text_using_get_Characters(cell, characterCount));
            return equal;
        }
        return true;
    }

    private static final boolean isHashString(String string_) {
        if (string_.length() == 0) {
            return false;
        }
        int index = 0;
        while (index < string_.length()) {
            if (string_.charAt(index) != '#') {
                return false;
            }
            ++index;
        }
        return true;
    }
}

