/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.tidy.DOMAttrMapImpl;
import org.w3c.tidy.DOMExceptionImpl;
import org.w3c.tidy.DOMNodeListImpl;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Node;

public class DOMNodeImpl
implements org.w3c.dom.Node {
    protected Node adaptee;

    protected DOMNodeImpl(Node adaptee) {
        this.adaptee = adaptee;
    }

    @Override
    public String getNodeValue() throws DOMException {
        String value = "";
        if ((this.adaptee.type == 4 || this.adaptee.type == 8 || this.adaptee.type == 2 || this.adaptee.type == 3) && this.adaptee.textarray != null && this.adaptee.start < this.adaptee.end) {
            value = Lexer.getString(this.adaptee.textarray, this.adaptee.start, this.adaptee.end - this.adaptee.start);
        }
        return value;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        if (this.adaptee.type == 4 || this.adaptee.type == 8 || this.adaptee.type == 2 || this.adaptee.type == 3) {
            byte[] textarray = Lexer.getBytes(nodeValue);
            this.adaptee.textarray = textarray;
            this.adaptee.start = 0;
            this.adaptee.end = textarray.length;
        }
    }

    @Override
    public String getNodeName() {
        return this.adaptee.element;
    }

    @Override
    public short getNodeType() {
        short result = -1;
        switch (this.adaptee.type) {
            case 0: {
                result = 9;
                break;
            }
            case 1: {
                result = 10;
                break;
            }
            case 2: {
                result = 8;
                break;
            }
            case 3: {
                result = 7;
                break;
            }
            case 4: {
                result = 3;
                break;
            }
            case 8: {
                result = 4;
                break;
            }
            case 5: 
            case 7: {
                result = 1;
            }
        }
        return result;
    }

    @Override
    public org.w3c.dom.Node getParentNode() {
        if (this.adaptee.parent != null) {
            return this.adaptee.parent.getAdapter();
        }
        return null;
    }

    @Override
    public NodeList getChildNodes() {
        return new DOMNodeListImpl(this.adaptee);
    }

    @Override
    public org.w3c.dom.Node getFirstChild() {
        if (this.adaptee.content != null) {
            return this.adaptee.content.getAdapter();
        }
        return null;
    }

    @Override
    public org.w3c.dom.Node getLastChild() {
        if (this.adaptee.last != null) {
            return this.adaptee.last.getAdapter();
        }
        return null;
    }

    @Override
    public org.w3c.dom.Node getPreviousSibling() {
        if (this.adaptee.prev != null) {
            return this.adaptee.prev.getAdapter();
        }
        return null;
    }

    @Override
    public org.w3c.dom.Node getNextSibling() {
        if (this.adaptee.next != null) {
            return this.adaptee.next.getAdapter();
        }
        return null;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return new DOMAttrMapImpl(this.adaptee.attributes);
    }

    @Override
    public Document getOwnerDocument() {
        Node node = this.adaptee;
        if (node != null && node.type == 0) {
            return null;
        }
        node = this.adaptee;
        while (node != null && node.type != 0) {
            node = node.parent;
        }
        if (node != null) {
            return (Document)node.getAdapter();
        }
        return null;
    }

    @Override
    public org.w3c.dom.Node insertBefore(org.w3c.dom.Node newChild, org.w3c.dom.Node refChild) throws DOMException {
        if (newChild == null) {
            return null;
        }
        if (!(newChild instanceof DOMNodeImpl)) {
            throw new DOMExceptionImpl(4, "newChild not instanceof DOMNodeImpl");
        }
        DOMNodeImpl newCh = (DOMNodeImpl)newChild;
        if (this.adaptee.type == 0 ? newCh.adaptee.type != 1 && newCh.adaptee.type != 3 : this.adaptee.type == 5 && newCh.adaptee.type != 5 && newCh.adaptee.type != 7 && newCh.adaptee.type != 2 && newCh.adaptee.type != 4 && newCh.adaptee.type != 8) {
            throw new DOMExceptionImpl(3, "newChild cannot be a child of this node");
        }
        if (refChild == null) {
            Node.insertNodeAtEnd(this.adaptee, newCh.adaptee);
            if (this.adaptee.type == 7) {
                this.adaptee.setType((short)5);
            }
        } else {
            Node ref = this.adaptee.content;
            while (ref != null) {
                if (ref.getAdapter() == refChild) break;
                ref = ref.next;
            }
            if (ref == null) {
                throw new DOMExceptionImpl(8, "refChild not found");
            }
            Node.insertNodeBeforeElement(ref, newCh.adaptee);
        }
        return newChild;
    }

    @Override
    public org.w3c.dom.Node replaceChild(org.w3c.dom.Node newChild, org.w3c.dom.Node oldChild) throws DOMException {
        if (newChild == null) {
            return null;
        }
        if (!(newChild instanceof DOMNodeImpl)) {
            throw new DOMExceptionImpl(4, "newChild not instanceof DOMNodeImpl");
        }
        DOMNodeImpl newCh = (DOMNodeImpl)newChild;
        if (this.adaptee.type == 0 ? newCh.adaptee.type != 1 && newCh.adaptee.type != 3 : this.adaptee.type == 5 && newCh.adaptee.type != 5 && newCh.adaptee.type != 7 && newCh.adaptee.type != 2 && newCh.adaptee.type != 4 && newCh.adaptee.type != 8) {
            throw new DOMExceptionImpl(3, "newChild cannot be a child of this node");
        }
        if (oldChild == null) {
            throw new DOMExceptionImpl(8, "oldChild not found");
        }
        Node ref = this.adaptee.content;
        while (ref != null) {
            if (ref.getAdapter() == oldChild) break;
            ref = ref.next;
        }
        if (ref == null) {
            throw new DOMExceptionImpl(8, "oldChild not found");
        }
        newCh.adaptee.next = ref.next;
        newCh.adaptee.prev = ref.prev;
        newCh.adaptee.last = ref.last;
        newCh.adaptee.parent = ref.parent;
        newCh.adaptee.content = ref.content;
        if (ref.parent != null) {
            if (ref.parent.content == ref) {
                ref.parent.content = newCh.adaptee;
            }
            if (ref.parent.last == ref) {
                ref.parent.last = newCh.adaptee;
            }
        }
        if (ref.prev != null) {
            ref.prev.next = newCh.adaptee;
        }
        if (ref.next != null) {
            ref.next.prev = newCh.adaptee;
        }
        Node n = ref.content;
        while (n != null) {
            if (n.parent == ref) {
                n.parent = newCh.adaptee;
            }
            n = n.next;
        }
        return oldChild;
    }

    @Override
    public org.w3c.dom.Node removeChild(org.w3c.dom.Node oldChild) throws DOMException {
        if (oldChild == null) {
            return null;
        }
        Node ref = this.adaptee.content;
        while (ref != null) {
            if (ref.getAdapter() == oldChild) break;
            ref = ref.next;
        }
        if (ref == null) {
            throw new DOMExceptionImpl(8, "refChild not found");
        }
        Node.discardElement(ref);
        if (this.adaptee.content == null && this.adaptee.type == 5) {
            this.adaptee.setType((short)7);
        }
        return oldChild;
    }

    @Override
    public org.w3c.dom.Node appendChild(org.w3c.dom.Node newChild) throws DOMException {
        if (newChild == null) {
            return null;
        }
        if (!(newChild instanceof DOMNodeImpl)) {
            throw new DOMExceptionImpl(4, "newChild not instanceof DOMNodeImpl");
        }
        DOMNodeImpl newCh = (DOMNodeImpl)newChild;
        if (this.adaptee.type == 0 ? newCh.adaptee.type != 1 && newCh.adaptee.type != 3 : this.adaptee.type == 5 && newCh.adaptee.type != 5 && newCh.adaptee.type != 7 && newCh.adaptee.type != 2 && newCh.adaptee.type != 4 && newCh.adaptee.type != 8) {
            throw new DOMExceptionImpl(3, "newChild cannot be a child of this node");
        }
        Node.insertNodeAtEnd(this.adaptee, newCh.adaptee);
        if (this.adaptee.type == 7) {
            this.adaptee.setType((short)5);
        }
        return newChild;
    }

    @Override
    public boolean hasChildNodes() {
        return this.adaptee.content != null;
    }

    @Override
    public org.w3c.dom.Node cloneNode(boolean deep) {
        Node node = this.adaptee.cloneNode(deep);
        node.parent = null;
        return node.getAdapter();
    }

    @Override
    public void normalize() {
    }

    public boolean supports(String feature, String version) {
        return this.isSupported(feature, version);
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return false;
    }

    @Override
    public boolean hasAttributes() {
        return this.adaptee.attributes != null;
    }
}

