/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.requirementsmodule2migrator;

import com.arcway.lib.UUIDGenerator;
import de.plans.psc.shared.message.EOPermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class PermissionMigrator {
    private static final String OLD_OPERAND_TYPE_REQUIREMENTSET = "rqm2.set";
    private static final String OLD_OPERAND_TYPE_GENERAL_RQM = "GENERAL_RQM_PERMISSIONS";
    private static final String OLD_OPERAND_UID_ALL_SETS = "ALL_SETS";
    private static final String OLD_OPERATION_EDIT_REQUIREMENTS = "editRequirements";
    private static final String OLD_OPERATION_DELETE_REQUIREMENTS = "deleteRequirements";
    private static final String OLD_OPERATION_EDIT_REQUIREMENTSETS = "editRequirementSets";
    private static final String OLD_OPERATION_DELETE_REQUIREMENTSETS = "deleteRequirementSets";
    private static final String OLD_OPERATION_LINK_REQUIREMENTS = "linkRequirements";
    private static final String OLD_OPERATION_EDIT_STATES_RANGE = "editStatesRange";
    private static final String OLD_OPERATION_EDIT_VERSION_RANGE = "editVersionRange";
    private static final String OLD_OPERATION_EDIT_CATEGORY_RANGE = "editCategoryRange";
    private static final String OLD_OPERATION_EDIT_NOTE_CATEGORY_RANGE = "editNoteCategoryRange";
    private static final String OPERATION_MODIFYATTRIBUTE_PREFIX = "modifyAttribute_";
    private static final String OPERATION_MODIFYALLATTRIBUTES = "modifyAllAttributes";
    private static final String NEW_OPERAND_TYPE_ALLSETS = "hierarchyroot";
    private static final String NEW_OPERAND_TYPE_REQUIREMENTSET = "com.arcway.cockpit.genericmodule.requirementsmodule3.requirementSet";
    private static final String NEW_OPERAND_TYPE_GENERAL_RQM = "GeneralRootNode-OperandTypeID";
    private static final String NEW_OPERAND_UID_ALL_SETS = "TreeRootNode-UID";
    private static final String NEW_OPERAND_UID_GENERAL_RQM = "GeneralRootNode-UID";
    private static final String NEW_OPERATION_EDIT_STATUS_RANGE = "Administrate-Type-status";
    private static final String NEW_OPERATION_EDIT_PRIORITY_RANGE = "Administrate-Type-priority";
    private static final String NEW_OPERATION_EDIT_NOTE_CATEGORY_RANGE = "Administrate-Type-noteCategory";
    private static final String NEW_OPERATION_EDIT_REQUIREMENTS = "Edit-Item-Of-Type-requirement";
    private static final String NEW_OPERATION_CREATE_REQUIREMENTS = "Create-Child-Of-Type-requirement";
    private static final String NEW_OPERATION_EDIT_REQUIREMENTSETS = "Edit-Item-Of-Type-requirementSet";
    private static final String NEW_OPERATION_CREATE_REQUIREMENTSETS = "Create-Child-Of-Type-requirementSet";

    public static void migratePermissions(Collection<EOPermission> permissions, Map<String, Map<String, String>> dataTypeID_2_oldAttributeTypeID_2_newCustomPropertyUID) {
        ArrayList<EOPermission> permissionsToRemove = new ArrayList<EOPermission>();
        ArrayList<EOPermission> permissionsToAdd = new ArrayList<EOPermission>();
        for (EOPermission permission : permissions) {
            EOPermission creationPermission;
            if (permission.getOperandType().equals(OLD_OPERAND_TYPE_GENERAL_RQM)) {
                permission.setOperandType(NEW_OPERAND_TYPE_GENERAL_RQM);
                permission.setOperandUID(NEW_OPERAND_UID_GENERAL_RQM);
                if (permission.getOperation().equals(OLD_OPERATION_EDIT_CATEGORY_RANGE)) {
                    permissionsToRemove.add(permission);
                    continue;
                }
                if (permission.getOperation().equals(OLD_OPERATION_EDIT_VERSION_RANGE)) {
                    permissionsToRemove.add(permission);
                    continue;
                }
                if (permission.getOperation().equals(OLD_OPERATION_EDIT_STATES_RANGE)) {
                    permission.setOperation(NEW_OPERATION_EDIT_STATUS_RANGE);
                    EOPermission prioPermission = new EOPermission(permission);
                    prioPermission.setPermissionUID(UUIDGenerator.getUniqueID());
                    prioPermission.setOperation(NEW_OPERATION_EDIT_PRIORITY_RANGE);
                    permissionsToAdd.add(prioPermission);
                    continue;
                }
                if (permission.getOperation().equals(OLD_OPERATION_EDIT_NOTE_CATEGORY_RANGE)) {
                    permission.setOperation(NEW_OPERATION_EDIT_NOTE_CATEGORY_RANGE);
                    continue;
                }
                permissionsToRemove.add(permission);
                continue;
            }
            if (!permission.getOperandType().equals(OLD_OPERAND_TYPE_REQUIREMENTSET)) continue;
            if (permission.getOperandUID().equals(OLD_OPERAND_UID_ALL_SETS)) {
                permission.setOperandType(NEW_OPERAND_TYPE_ALLSETS);
                permission.setOperandUID(NEW_OPERAND_UID_ALL_SETS);
            } else {
                permission.setOperandType(NEW_OPERAND_TYPE_REQUIREMENTSET);
            }
            if (permission.getOperation().equals(OLD_OPERATION_EDIT_REQUIREMENTS)) {
                permission.setOperation(NEW_OPERATION_EDIT_REQUIREMENTS);
                creationPermission = new EOPermission(permission);
                creationPermission.setPermissionUID(UUIDGenerator.getUniqueID());
                creationPermission.setOperation(NEW_OPERATION_CREATE_REQUIREMENTS);
                permissionsToAdd.add(creationPermission);
                continue;
            }
            if (permission.getOperation().equals(OLD_OPERATION_DELETE_REQUIREMENTS)) {
                permission.setOperation(NEW_OPERATION_EDIT_REQUIREMENTS);
                continue;
            }
            if (permission.getOperation().equals(OLD_OPERATION_EDIT_REQUIREMENTSETS)) {
                permission.setOperation(NEW_OPERATION_EDIT_REQUIREMENTSETS);
                creationPermission = new EOPermission(permission);
                creationPermission.setPermissionUID(UUIDGenerator.getUniqueID());
                creationPermission.setOperation(NEW_OPERATION_CREATE_REQUIREMENTSETS);
                permissionsToAdd.add(creationPermission);
                continue;
            }
            if (permission.getOperation().equals(OLD_OPERATION_DELETE_REQUIREMENTSETS)) {
                permission.setOperation(NEW_OPERATION_EDIT_REQUIREMENTSETS);
                continue;
            }
            if (permission.getOperation().equals(OLD_OPERATION_LINK_REQUIREMENTS)) {
                permission.setOperation(NEW_OPERATION_EDIT_REQUIREMENTS);
                continue;
            }
            if (permission.getOperation().equals(OPERATION_MODIFYALLATTRIBUTES) || permission.getOperation().startsWith(OPERATION_MODIFYATTRIBUTE_PREFIX)) {
                String customPropertyUID;
                String dataTypeID = permission.getOperation2();
                if (dataTypeID.equals(OLD_OPERAND_TYPE_REQUIREMENTSET)) {
                    permission.setOperation2(NEW_OPERAND_TYPE_REQUIREMENTSET);
                } else if (dataTypeID.equals("rqm2.requirement")) {
                    permission.setOperation2("com.arcway.cockpit.genericmodule.requirementsmodule3.requirement");
                }
                if (!permission.getOperation().startsWith(OPERATION_MODIFYATTRIBUTE_PREFIX)) continue;
                String attributeID = permission.getOperation().substring(OPERATION_MODIFYATTRIBUTE_PREFIX.length());
                if (attributeID.equals("req_title")) {
                    permission.setOperation("modifyAttribute_name");
                    continue;
                }
                if (attributeID.equals("req_description")) {
                    permission.setOperation("modifyAttribute_description");
                    continue;
                }
                if (attributeID.equals("req_id")) {
                    permission.setOperation("modifyAttribute_id");
                    continue;
                }
                if (attributeID.equals("req_priority")) {
                    permission.setOperation("modifyAttribute_priority");
                    continue;
                }
                if (attributeID.equals("RequirementState")) {
                    permission.setOperation("modifyAttribute_status");
                    continue;
                }
                if (attributeID.equals("set_name")) {
                    permission.setOperation("modifyAttribute_name");
                    continue;
                }
                if (attributeID.equals("set_description")) {
                    permission.setOperation("modifyAttribute_description");
                    continue;
                }
                if (attributeID.equals("idFormat")) {
                    permission.setOperation("modifyAttribute_idFormat");
                    continue;
                }
                Map<String, String> attributeTypeID_customPropertyUID = dataTypeID_2_oldAttributeTypeID_2_newCustomPropertyUID.get(dataTypeID);
                String string = customPropertyUID = attributeTypeID_customPropertyUID == null ? null : attributeTypeID_customPropertyUID.get(attributeID);
                if (customPropertyUID == null) continue;
                permission.setOperation(OPERATION_MODIFYATTRIBUTE_PREFIX + customPropertyUID);
                continue;
            }
            permissionsToRemove.add(permission);
        }
        HashSet<EOPermission> minimisedPermissions = new HashSet<EOPermission>(permissions);
        minimisedPermissions.removeAll(permissionsToRemove);
        minimisedPermissions.addAll(permissionsToAdd);
        permissions.clear();
        permissions.addAll(minimisedPermissions);
    }
}

