/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.rqm1.rqm1migrator;

import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version0.HistoricProjectDumpView_0_;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version0.HistoricServerDumpView_0_;
import com.arcway.cockpit.rqm1.rqm1migrator.messages.OldModulePermissionConstants;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOList;
import de.plans.psc.shared.message.EOPermission;
import java.util.ArrayList;
import java.util.Collection;

public class RQM1PermissionMigrator {
    private static final ILogger logger = Logger.getLogger(RQM1PermissionMigrator.class);

    public static void migratePermissions(EOProject_V0 project, HistoricProjectDumpView_0_ historicViewOnProjectDump) throws MigrationFailedException {
        try {
            EOList permissions = historicViewOnProjectDump.readPermissions(project);
            RQM1PermissionMigrator.migratePermissions((Collection<EOPermission>)permissions);
        }
        catch (EXDecoderException e) {
            throw new MigrationFailedException((Throwable)e);
        }
    }

    public static void migratePermissions(HistoricServerDumpView_0_ historicViewOnServerDump) {
        EOList permissions = historicViewOnServerDump.getPermissionList();
        RQM1PermissionMigrator.migratePermissions((Collection<EOPermission>)permissions);
    }

    private static void migratePermissions(Collection<EOPermission> permissions) {
        ArrayList<EOPermission> permissionsToRemove = new ArrayList<EOPermission>(permissions.size());
        ArrayList<EOPermission> permissionsToAdd = new ArrayList<EOPermission>(permissions.size());
        for (EOPermission permission : permissions) {
            EOPermission newPermission;
            String operation;
            String newOperation;
            String operandType = permission.getOperandType();
            if (operandType.equals("requirementSet")) {
                EOPermission newPermission2;
                permissionsToRemove.add(permission);
                try {
                    newPermission2 = (EOPermission)permission.clone();
                }
                catch (CloneNotSupportedException e) {
                    logger.error("EOPermission should implement the Cloneable interface", (Throwable)e);
                    continue;
                }
                newPermission2.setOperandType("rqm2.set");
                String operation2 = permission.getOperation();
                newOperation = (String)OldModulePermissionConstants.oldNewOperationsMap.get(operation2);
                if (newOperation == null) {
                    logger.warn("Unknown operation: " + operation2 + " Skipping permission");
                    continue;
                }
                newPermission2.setOperation(newOperation);
                String setUID = permission.getOperandUID();
                String newSetUID = setUID.equals("ALL_SETS") ? "ALL_SETS" : permission.getOperandUID();
                newPermission2.setOperandUID(newSetUID);
                permissionsToAdd.add(newPermission2);
            }
            if (!operandType.equals("project") || !(operation = permission.getOperation()).equals("deleteRequirementsSet") && !operation.equals("addRequirementsSet")) continue;
            permissionsToRemove.add(permission);
            try {
                newPermission = (EOPermission)permission.clone();
            }
            catch (CloneNotSupportedException e) {
                logger.error("EOPermission should implement the Cloneable interface", (Throwable)e);
                continue;
            }
            newPermission.setOperandType("rqm2.set");
            newOperation = (String)OldModulePermissionConstants.oldNewOperationsMap.get(operation);
            if (newOperation == null) {
                logger.warn("Unknown operation: " + operation + " Skipping permission");
                continue;
            }
            newPermission.setOperation(newOperation);
            newPermission.setOperandUID("ALL_SETS");
            permissionsToAdd.add(newPermission);
        }
        permissions.removeAll(permissionsToRemove);
        permissions.addAll(permissionsToAdd);
    }
}

