/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.planimporter.wizard;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.EXConstructionElementTypeUnknown;
import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.constructionelements.IConstructionElementTypeDescription;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.AttributeType;
import com.arcway.cockpit.frame.client.project.core.framedata.EXModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IImportedPlan;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElementRW;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementAttributeTypesProvider;
import com.arcway.cockpit.planimporter.Messages;
import com.arcway.cockpit.planimporter.converter.CustomAttributesConverter;
import com.arcway.cockpit.planimporter.converter.IPlansConverter;
import com.arcway.cockpit.planimporter.wizard.AssignUniqueElementsContentLabelProvider;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.eclipse.gui.viewers.UsableCheckboxTreeViewer;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentPlanElement;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentStructuredPlanElement;
import com.arcway.planagent.planimporterexporter.IDataElement;
import com.arcway.planagent.planimporterexporter.plans.Plan;
import com.arcway.planagent.planimporterexporter.plans.Plans;
import de.plans.lib.util.gui.IProgressDisplay;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class PlanImportUniqueElementPage
extends WizardPage {
    private static final ILogger logger = Logger.getLogger(PlanImportUniqueElementPage.class);
    private final IFrameProjectAgent projectAgent;
    private Plans plansToImport;
    private Set<IConstructionElementTypeDescription> ueTypes;
    private Group ueaGroup;
    private UsableCheckboxTreeViewer treeViewer;
    private AssignUniqueElementsContentLabelProvider contentprovider;
    private String errorMessage;
    private Button overwriteDescription;
    private final IPlansConverter plansConverter;
    private Composite base;
    int workReported = 0;

    public PlanImportUniqueElementPage(String pageName, IPlansConverter plansConverter, IFrameProjectAgent projectAgent) {
        super(pageName);
        this.plansConverter = plansConverter;
        this.projectAgent = projectAgent;
    }

    public void init() {
        this.setTitle(this.plansConverter.getLocalizedName(Locale.getDefault()));
        this.setDescription(Messages.getString("PlanImportUniqueElement.description"));
    }

    public void createControl(Composite parentComposite) {
        this.base = new Composite(parentComposite, 0);
        this.base.setLayoutData((Object)new GridData(1808));
        this.base.setLayout((Layout)new GridLayout(1, false));
        this.setPageComplete(false);
        this.ueaGroup = new Group(this.base, 0);
        this.ueaGroup.setText(Messages.getString("PlanImportUniqueElement.selection"));
        GridData plansGroupGridData = new GridData(768);
        plansGroupGridData.heightHint = 300;
        this.ueaGroup.setLayoutData((Object)plansGroupGridData);
        this.ueaGroup.setLayout((Layout)new GridLayout());
        this.treeViewer = new UsableCheckboxTreeViewer((Composite)this.ueaGroup);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.treeViewer.activateSelectionContextMenu();
        this.treeViewer.getTree().setEnabled(false);
        this.ueaGroup.setEnabled(false);
        this.overwriteDescription = new Button((Composite)this.ueaGroup, 32);
        this.overwriteDescription.setText(Messages.getString("PlanImportUniqueElement.OverwriteDescription"));
        this.overwriteDescription.setSelection(false);
        GridData overwriteDescriptionGridData = new GridData(768);
        this.overwriteDescription.setLayoutData((Object)overwriteDescriptionGridData);
        this.setControl((Control)this.base);
    }

    public void setPlansInput(Plans inputPlans) {
        this.errorMessage = null;
        this.ueaGroup.setEnabled(false);
        this.plansToImport = inputPlans;
        this.ueTypes = new HashSet<IConstructionElementTypeDescription>();
        Collection plansCollection = inputPlans.getCheckedPlans();
        this.checkUniqueElements(plansCollection, this.ueTypes);
        if (!plansCollection.isEmpty()) {
            this.contentprovider = new AssignUniqueElementsContentLabelProvider(this.plansToImport);
            this.treeViewer.setContentProvider((IContentProvider)this.contentprovider);
            this.treeViewer.setLabelProvider((IBaseLabelProvider)this.contentprovider);
            this.treeViewer.setInput(this.ueTypes);
            this.treeViewer.getTree().setEnabled(true);
            this.ueaGroup.setEnabled(true);
        } else {
            this.errorMessage = Messages.getString("NoPlanFoundException.message");
        }
        this.setErrorMessage(this.errorMessage);
        if (this.getPreviousPage().isPageComplete()) {
            this.setPageComplete(this.errorMessage == null);
        } else {
            this.setPageComplete(false);
        }
    }

    public IWizardPage getNextPage() {
        IWizardPage nextPage = super.getNextPage();
        if (this.getPreviousPage().isPageComplete()) {
            return nextPage;
        }
        return null;
    }

    private void checkUniqueElements(Collection<Plan> plansCollection, Set<IConstructionElementTypeDescription> planElements) {
        for (Plan object : plansCollection) {
            this.addLocalElements(object, planElements);
        }
    }

    private void addLocalElements(Plan plan, Set<IConstructionElementTypeDescription> list) {
        for (IPlanAgentPlanElement element : plan.getPlanStructure()) {
            IPlanAgentStructuredPlanElement planElement = (IPlanAgentStructuredPlanElement)element;
            String constructionElementTypeID = ExtensionMgr.getDefault().getDefaultConstructionElementTypeDescription(planElement.getPlanElementTypeID()).getConstructionElementTypeID();
            try {
                IConstructionElementTypeDescription td = ExtensionMgr.getDefault().getConstructionElementTypeDescriptionForType(constructionElementTypeID);
                if (list.contains(td)) continue;
                list.add(td);
            }
            catch (EXConstructionElementTypeUnknown eXConstructionElementTypeUnknown) {
                // empty catch block
            }
        }
    }

    public void toPerformFinish(final Map<String, IImportedPlan> plansToCreateUEOccurences, final IProgressDisplay progressDisplay) {
        this.workReported = 0;
        this.projectAgent.getModelTransactionManager().executeTransaction(new Runnable(){

            @Override
            public void run() {
                Map<Plan, ArrayList<IPlanAgentPlanElement>> selectedElements = PlanImportUniqueElementPage.this.contentprovider.getPlanElementsFromSelection(PlanImportUniqueElementPage.this.treeViewer.getCheckedButNotGrayedElements());
                Iterator<Plan> iterator = selectedElements.keySet().iterator();
                while (iterator.hasNext()) {
                    Plan element;
                    Plan plan = element = iterator.next();
                    progressDisplay.reportQuantifiedProgress(PlanImportUniqueElementPage.this.workReported++);
                    IImportedPlan importedPlan = (IImportedPlan)plansToCreateUEOccurences.get(plan.getLoadedPlan().getUid());
                    if (importedPlan == null) continue;
                    PlanImportUniqueElementPage.this.createUEOccurrences(importedPlan, plan, selectedElements.get(plan));
                }
            }
        });
    }

    private void createUEOccurrences(IImportedPlan importedPlan, Plan plan, Collection<IPlanAgentPlanElement> planElements) {
        HashMap<IPlanAgentPlanElement, IUniqueElement> planElementUIDs2UniqueElementUID = new HashMap<IPlanAgentPlanElement, IUniqueElement>(planElements.size());
        ArrayList modificationProblems = new ArrayList();
        for (IPlanAgentPlanElement pe : planElements) {
            IUniqueElement ue = importedPlan.searchUniqueElement(pe);
            if (ue == null) {
                try {
                    ue = importedPlan.createUniqueElement(pe);
                }
                catch (EXModificationProblem e) {
                    modificationProblems.addAll(modificationProblems);
                }
            }
            if (ue == null) continue;
            planElementUIDs2UniqueElementUID.put(pe, ue);
            IDataElement modelElementInformation = plan.getDataElementForPlanElement(pe.getPlanElementUID());
            if (modelElementInformation == null) continue;
            String description = modelElementInformation.getDescription();
            if (description != null && ((description = description.trim()).length() > 0 || this.overwriteDescription.getSelection())) {
                try {
                    IAttribute attribute = ue.getAttribute(UniqueElementAttributeTypesProvider.ATTRID_DESCRIPTION);
                    String oldDescription = DataTypeText.getInstanceText().getValueAsMultiLineString(attribute.getAttributeValue());
                    if (!(this.overwriteDescription.getSelection() || oldDescription == null || oldDescription.equals("") || oldDescription.equals(description))) {
                        description = String.valueOf(oldDescription) + "\n" + description;
                    }
                    if (oldDescription == null && description.length() > 0 || oldDescription != null && !description.equals(oldDescription)) {
                        Object descriptionValue = DataTypeText.getInstanceText().getAttributeValueFromString(description, null, null);
                        Attribute newAttribute = new Attribute(UniqueElementAttributeTypesProvider.ATTRID_DESCRIPTION, descriptionValue);
                        LocksAndPermissionsTransactionController locksAndPermissionsTransactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
                        ((IUniqueElementRW)ue).requestAttributeModificationPermission((IAttribute)newAttribute, (ILocksAndPermissionsTransactionController)locksAndPermissionsTransactionController);
                        Collection problems = locksAndPermissionsTransactionController.execute();
                        if (problems.isEmpty()) {
                            ((IUniqueElementRW)ue).setAttribute((IAttribute)newAttribute);
                        } else {
                            for (IModificationProblem problem : problems) {
                                String descriptionOfConsequence = NLS.bind((String)Messages.getString("PlanImportUniqueElement.attributeNotImported", Locale.getDefault()), (Object)UniqueElementAttributeTypesProvider.ATTRNAME_DESCRIPTION, (Object)ue.getElementName());
                                String humanReadableDescriptionOfCause = problem.getHumanReadableDescriptionOfCause();
                                String humanReadableDescriptionOfConsequence = String.valueOf(descriptionOfConsequence) + problem.getHumanReadableDescriptionOfConsequence();
                                modificationProblems.add(new ModificationProblem(humanReadableDescriptionOfCause, humanReadableDescriptionOfConsequence, 3));
                            }
                        }
                    }
                }
                catch (EXNoPermission e) {
                    this.errorMessage = String.valueOf(Messages.getString("PlanImportUniqueElement.noPermission", Locale.getDefault())) + " " + pe.getPlanElementUID();
                    modificationProblems.add(new ModificationProblem((Exception)((Object)e), 3, this.errorMessage));
                }
                catch (EXNoLock e) {
                    this.errorMessage = String.valueOf(Messages.getString("PlanImportUniqueElement.noLock", Locale.getDefault())) + " " + pe.getPlanElementUID();
                    modificationProblems.add(new ModificationProblem((Exception)((Object)e), 3, this.errorMessage));
                }
            }
            Collection<IAttribute> attributes = CustomAttributesConverter.convertIntoFrameAttributes(this.projectAgent, modelElementInformation, "com.arcway.cockpit.uniqueelement");
            for (IAttribute newAttribute : attributes) {
                try {
                    IAttribute oldAttribute = ue.getAttribute(newAttribute.getAttributeTypeID());
                    Object oldAttributeValue = oldAttribute.getAttributeValue();
                    Object newAttributeValue = newAttribute.getAttributeValue();
                    AttributeType attributeType = (AttributeType)ue.getAttributeType(newAttribute.getAttributeTypeID());
                    Comparator attributeTypeComparator = attributeType.getDataType().getComparator(attributeType.getValueRange());
                    if ((oldAttributeValue != null || newAttributeValue == null) && (oldAttributeValue == null || attributeTypeComparator.compare(oldAttributeValue, newAttributeValue) == 0)) continue;
                    LocksAndPermissionsTransactionController locksAndPermissionsTransactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
                    ((IUniqueElementRW)ue).requestAttributeModificationPermission(newAttribute, (ILocksAndPermissionsTransactionController)locksAndPermissionsTransactionController);
                    Collection problems = locksAndPermissionsTransactionController.execute();
                    if (problems.isEmpty()) {
                        ((IUniqueElementRW)ue).setAttribute(newAttribute);
                        continue;
                    }
                    for (IModificationProblem problem : problems) {
                        String attributeDisplayName = attributeType.getDisplayName();
                        String descriptionOfConsequence = NLS.bind((String)Messages.getString("PlanImportUniqueElement.attributeNotImported", Locale.getDefault()), (Object)attributeDisplayName, (Object)ue.getElementName());
                        String humanReadableDescriptionOfCause = problem.getHumanReadableDescriptionOfCause();
                        String humanReadableDescriptionOfConsequence = String.valueOf(descriptionOfConsequence) + problem.getHumanReadableDescriptionOfConsequence();
                        modificationProblems.add(new ModificationProblem(humanReadableDescriptionOfCause, humanReadableDescriptionOfConsequence, 3));
                    }
                }
                catch (EXNoPermission e) {
                    this.errorMessage = String.valueOf(Messages.getString("PlanImportUniqueElement.noPermission", Locale.getDefault())) + " " + pe.getPlanElementUID();
                    modificationProblems.add(new ModificationProblem((Exception)((Object)e), 3, this.errorMessage));
                }
                catch (EXNoLock e) {
                    this.errorMessage = String.valueOf(Messages.getString("PlanImportUniqueElement.noLock", Locale.getDefault())) + " " + pe.getPlanElementUID();
                    modificationProblems.add(new ModificationProblem((Exception)((Object)e), 3, this.errorMessage));
                }
            }
        }
        try {
            importedPlan.createUniqueElementOccurences(planElementUIDs2UniqueElementUID);
        }
        catch (EXModificationProblem e) {
            logger.error("EXModificationProblem", (Throwable)e);
        }
        if (!modificationProblems.isEmpty()) {
            ModificationProblemsDialog dialog = new ModificationProblemsDialog(modificationProblems, this.getShell());
            dialog.open();
        }
    }

    public void dispose() {
        this.base.dispose();
        if (this.ueTypes != null) {
            this.ueTypes.clear();
        }
    }
}

