/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.planimporter.aris2epc.converter;

import com.arcway.lib.resource.FileResourceInPackage;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AMLReader {
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private Document document;
    private final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private final File file;
    private boolean initialized = false;

    public AMLReader(File file) throws ParserConfigurationException, SAXException, IOException {
        this.factory.setIgnoringComments(true);
        this.factory.setNamespaceAware(true);
        this.factory.setValidating(true);
        this.file = file;
        this.readAMLFile();
    }

    public Document getDocument() {
        return this.document;
    }

    public Element getAMLRootElement() {
        if (this.document != null) {
            return this.document.getDocumentElement();
        }
        return null;
    }

    private void readAMLFile() throws ParserConfigurationException, SAXException, IOException {
        if (this.initialized) {
            return;
        }
        this.document = null;
        DocumentBuilder documentBuilder = this.factory.newDocumentBuilder();
        EntityResolverImpl er = new EntityResolverImpl();
        final boolean[] parseError = new boolean[1];
        documentBuilder.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                parseError[0] = true;
                throw exception;
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                parseError[0] = true;
                throw exception;
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                parseError[0] = true;
                throw exception;
            }
        });
        documentBuilder.setEntityResolver(er);
        this.document = documentBuilder.parse(this.file);
        this.document.normalizeDocument();
        if (parseError[0]) {
            return;
        }
        this.initialized = true;
    }

    private static class EntityResolverImpl
    implements EntityResolver {
        private EntityResolverImpl() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (systemId != null && systemId.endsWith("ARIS-Export.dtd")) {
                FileResourceInPackage FileResourceInPackage2 = new FileResourceInPackage(AMLReader.class, "ARIS-Export.dtd");
                try {
                    return new InputSource(FileResourceInPackage2.toInputStream());
                }
                catch (JvmExternalResourceInteractionException e) {
                    e.toIOException();
                }
            }
            return null;
        }
    }
}

