/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.platformadapter.helper;

import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.client.platformadapter.AbstractModulePlatformAdapterModule;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.Label;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.LocaleHelper;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.IModuleDataTypeDescriptionForPlatformAdapter;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.IModuleLinkTypeDescriptionForPlatformAdapter;
import com.arcway.frontend.definition.lib.interFace.declaration.label.FrontendLabel;
import com.arcway.frontend.definition.lib.interFace.label.IFrontendLabel;
import com.arcway.repository.clientadapter.interFace.ILabel;
import de.plans.lib.localisation.ILabelProvider;
import de.plans.lib.resources.IIconResource;
import de.plans.lib.util.valueranges.DiscreteValue;
import java.util.Collection;
import java.util.Locale;

public class LabelHelper {
    public static ILabel[] getLabelsForModuleType(AbstractModulePlatformAdapterModule moduleDescription) {
        ILabel[] labels = new ILabel[LocaleHelper.getSupportedLocales().length];
        int c = 0;
        while (c < LocaleHelper.getSupportedLocales().length) {
            labels[c] = new Label(LocaleHelper.getSupportedLocales()[c], moduleDescription.getModuleName(LocaleHelper.getSupportedLocales()[c]), moduleDescription.getModuleIcon());
            ++c;
        }
        return labels;
    }

    public static ILabel[] getLabelsForModuleDataType(IModuleDataTypeDescription dataTypeDescription) {
        ILabel[] labels = new ILabel[LocaleHelper.getSupportedLocales().length];
        int c = 0;
        while (c < LocaleHelper.getSupportedLocales().length) {
            labels[c] = new Label(LocaleHelper.getSupportedLocales()[c], dataTypeDescription.getTypeName(LocaleHelper.getSupportedLocales()[c]), dataTypeDescription.getTypeIcon());
            ++c;
        }
        return labels;
    }

    public static ILabel[] getLabelsForModuleDataTypes(Collection<IModuleDataTypeDescriptionForPlatformAdapter> dataTypeDescriptions) {
        ILabel[] labels = new ILabel[LocaleHelper.getSupportedLocales().length];
        int c = 0;
        while (c < LocaleHelper.getSupportedLocales().length) {
            String text = "";
            boolean first = true;
            for (IModuleDataTypeDescriptionForPlatformAdapter dataTypeDescription : dataTypeDescriptions) {
                if (!first) {
                    text = String.valueOf(text) + " & ";
                } else {
                    first = false;
                }
                text = String.valueOf(text) + dataTypeDescription.getTypeName(LocaleHelper.getSupportedLocales()[c]);
            }
            labels[c] = new Label(LocaleHelper.getSupportedLocales()[c], text, dataTypeDescriptions.size() == 1 ? dataTypeDescriptions.iterator().next().getTypeIcon() : null);
            ++c;
        }
        return labels;
    }

    public static ILabel[] getLabelsForAttribute(IModuleDataTypeDescriptionForPlatformAdapter dataTypeDescription, String attributeID) {
        ILabel[] labels = new ILabel[LocaleHelper.getSupportedLocales().length];
        int c = 0;
        while (c < LocaleHelper.getSupportedLocales().length) {
            labels[c] = new Label(LocaleHelper.getSupportedLocales()[c], dataTypeDescription.getAttributeName(attributeID, LocaleHelper.getSupportedLocales()[c]), null);
            ++c;
        }
        return labels;
    }

    public static IFrontendLabel getLabelsForDiscreteValue(DiscreteValue discreteValue, Locale projectLanguage) {
        return new FrontendLabel(discreteValue.getName(projectLanguage), Label.createStreamResourceForIconResource(discreteValue.getImageAsIconResource()));
    }

    public static ILabel[] getLabelsForModuleDataLinkType(IModuleLinkTypeDescriptionForPlatformAdapter linkTypeDescription) {
        ILabel[] labels = new ILabel[LocaleHelper.getSupportedLocales().length];
        int c = 0;
        while (c < LocaleHelper.getSupportedLocales().length) {
            labels[c] = new Label(LocaleHelper.getSupportedLocales()[c], linkTypeDescription.getLinkTypeName(LocaleHelper.getSupportedLocales()[c]), null);
            ++c;
        }
        return labels;
    }

    public static ILabel[] getLabelsForModuleDataLinkTypeLORole(IModuleLinkTypeDescriptionForPlatformAdapter linkTypeDescription) {
        ILabel[] labels = new ILabel[LocaleHelper.getSupportedLocales().length];
        int c = 0;
        while (c < LocaleHelper.getSupportedLocales().length) {
            labels[c] = new Label(LocaleHelper.getSupportedLocales()[c], linkTypeDescription.getLinkableObjectRoleName(LocaleHelper.getSupportedLocales()[c]), null);
            ++c;
        }
        return labels;
    }

    public static ILabel[] getLabelsForModuleDataLinkTypeMDRole(IModuleLinkTypeDescriptionForPlatformAdapter linkTypeDescription) {
        ILabel[] labels = new ILabel[LocaleHelper.getSupportedLocales().length];
        int c = 0;
        while (c < LocaleHelper.getSupportedLocales().length) {
            labels[c] = new Label(LocaleHelper.getSupportedLocales()[c], linkTypeDescription.getModuleDataRoleName(LocaleHelper.getSupportedLocales()[c]), null);
            ++c;
        }
        return labels;
    }

    public static ILabel[] getLabels(ILabelProvider labelProvider, IIconResource icon) {
        ILabel[] labels = new ILabel[LocaleHelper.getSupportedLocales().length];
        int c = 0;
        while (c < LocaleHelper.getSupportedLocales().length) {
            labels[c] = new Label(LocaleHelper.getSupportedLocales()[c], labelProvider.getLabel(LocaleHelper.getSupportedLocales()[c]), icon);
            ++c;
        }
        return labels;
    }
}

