/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.messages.description;

import com.arcway.cockpit.client.base.interfaces.frame.IProjectAgent;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.frame.client.global.gui.properties.AttributeTypeID;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.messages.AbstractModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import de.plans.lib.resources.IIconResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.eclipse.swt.graphics.Image;

public class ModuleDataTypeDescriptionForFrame
extends AbstractModuleDataTypeDescriptionForFrame {
    private final String typeID;
    private final String moduleID;
    private final String displayName;
    private final IIconResource icon;
    private final boolean withUserDefinedAttributeTypes;
    private final boolean withNaturalOrder;
    private final boolean withCategories;
    private final boolean isToBeDisplayedInDataView;
    private final Collection<String> permissionRelevantAttributeKeysWithDefaultPermission;
    private final Collection<String> permissionRelevantAttributeKeysWithoutDefaultPermission;
    @Deprecated
    private boolean hasCustomPropertyPermissions = true;

    @Deprecated
    public ModuleDataTypeDescriptionForFrame(String dataTypeID, String moduleID, String displayName, IIconResource icon, boolean allowUserDefinedAttributeTypes, boolean hasNaturalOrder, boolean supportsCategories, boolean isToBeDisplayedInDataView, Collection<String> permissionRelevantAttributeKeysWithDefaultPermission, Collection<String> permissionRelevantAttributeKeysWithoutDefaultPermission, boolean hasCustomPropertyPermissions) {
        this(dataTypeID, moduleID, displayName, icon, allowUserDefinedAttributeTypes, hasNaturalOrder, supportsCategories, isToBeDisplayedInDataView, permissionRelevantAttributeKeysWithDefaultPermission, permissionRelevantAttributeKeysWithoutDefaultPermission);
        this.hasCustomPropertyPermissions = hasCustomPropertyPermissions;
    }

    public ModuleDataTypeDescriptionForFrame(String dataTypeID, String moduleID, String displayName, IIconResource icon, boolean allowUserDefinedAttributeTypes, boolean hasNaturalOrder, boolean supportsCategories, boolean isToBeDisplayedInDataView, Collection<String> permissionRelevantAttributeKeysWithDefaultPermission, Collection<String> permissionRelevantAttributeKeysWithoutDefaultPermission) {
        assert (displayName != null) : "displayName must not be null";
        this.typeID = dataTypeID;
        this.moduleID = moduleID;
        this.displayName = displayName;
        this.icon = icon;
        this.isToBeDisplayedInDataView = isToBeDisplayedInDataView;
        this.withUserDefinedAttributeTypes = allowUserDefinedAttributeTypes;
        this.withNaturalOrder = hasNaturalOrder;
        this.withCategories = supportsCategories;
        this.permissionRelevantAttributeKeysWithDefaultPermission = permissionRelevantAttributeKeysWithDefaultPermission;
        this.permissionRelevantAttributeKeysWithoutDefaultPermission = permissionRelevantAttributeKeysWithoutDefaultPermission;
    }

    public ModuleDataTypeDescriptionForFrame(String moduleID, IModuleDataTypeDescription moduleDataTypeDescription, boolean allowUserDefinedAttributeTypes, boolean isToBeDisplayedInDataView, Collection<String> permissionRelevantAttributeKeysWithDefaultPermission, Collection<String> permissionRelevantAttributeKeysWithoutDefaultPermission) {
        assert (moduleDataTypeDescription != null) : "moduleDataTypeDescription must not be null";
        this.typeID = moduleDataTypeDescription.getTypeID();
        this.moduleID = moduleID;
        this.displayName = moduleDataTypeDescription.getTypeName(Locale.getDefault());
        this.icon = moduleDataTypeDescription.getTypeIcon();
        this.isToBeDisplayedInDataView = isToBeDisplayedInDataView;
        this.withNaturalOrder = moduleDataTypeDescription.isNaturalOrderUserDetermined();
        this.withUserDefinedAttributeTypes = allowUserDefinedAttributeTypes;
        this.withCategories = moduleDataTypeDescription.isSupportingCategories();
        this.permissionRelevantAttributeKeysWithDefaultPermission = permissionRelevantAttributeKeysWithDefaultPermission;
        this.permissionRelevantAttributeKeysWithoutDefaultPermission = permissionRelevantAttributeKeysWithoutDefaultPermission;
    }

    public boolean allowsUserDefinedAttributeTypes() {
        return this.withUserDefinedAttributeTypes;
    }

    public boolean hasNaturalOrder() {
        return this.withNaturalOrder;
    }

    public boolean isSupportingCategories() {
        return this.withCategories;
    }

    public boolean isToBeDisplayedInDataView() {
        return this.isToBeDisplayedInDataView;
    }

    public String getCockpitDataTypeID() {
        return this.typeID;
    }

    public String getModuleID() {
        return this.moduleID;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Image getIcon() {
        return this.icon != null ? this.icon.getImage() : null;
    }

    public IIconResource getIconAsResource() {
        return this.icon;
    }

    public Collection<IAttributeType> getAttributeTypes(IProjectAgent projectAgent) {
        return ((IFrameProjectAgent)projectAgent).getModuleUserDefinedAttributeTypesManager().getAllUserDefinedAttributeTypes(this.getCockpitDataTypeID());
    }

    public Collection<String> getAllPermissionRelevantFixedAttributeTypesWithDefaultPermission(String projectUID) {
        return this.permissionRelevantAttributeKeysWithDefaultPermission;
    }

    public Collection<String> getAllPermissionRelevantFixedAttributeTypesWithoutDefaultPermission(String projectUID) {
        return this.permissionRelevantAttributeKeysWithoutDefaultPermission;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            if (obj instanceof ModuleDataTypeDescriptionForFrame) {
                ModuleDataTypeDescriptionForFrame dataType = (ModuleDataTypeDescriptionForFrame)obj;
                return dataType.getCockpitDataTypeID().equals(this.getCockpitDataTypeID());
            }
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.getCockpitDataTypeID().hashCode();
    }

    public IAttributeType getAttributeType(IAttributeTypeID attributeTypeID, IFrameProjectAgent projectAgent) {
        for (IAttributeType attributeType : this.getAttributeTypes((IProjectAgent)projectAgent)) {
            if (!attributeType.getAttributeTypeID().equals(attributeTypeID)) continue;
            return attributeType;
        }
        return null;
    }

    public static IAttributeTypeID convertAttributeTypeID(String attributeTypeID) {
        return AttributeTypeID.getAttributeTypeID((String)attributeTypeID);
    }

    public static Collection<IAttributeTypeID> convertAttributeTypeIDs(Collection<String> attributeTypeIDs) {
        ArrayList<IAttributeTypeID> convertedIDs = new ArrayList<IAttributeTypeID>();
        for (String attributeTypeID : attributeTypeIDs) {
            IAttributeTypeID convertedID = ModuleDataTypeDescriptionForFrame.convertAttributeTypeID(attributeTypeID);
            convertedIDs.add(convertedID);
        }
        return convertedIDs;
    }

    public boolean hasCustomPropertyPermissions() {
        return this.hasCustomPropertyPermissions;
    }

    public Image getImage(ICockpitProjectData data) {
        assert (data instanceof IModuleData);
        if (data instanceof IModuleData) {
            return ((IModuleData)data).getStatusDependentIcon().getImage();
        }
        return null;
    }

    public String getDisplayName(ICockpitProjectData data) {
        assert (data instanceof IModuleData);
        if (data instanceof IModuleData) {
            return ((IModuleData)data).getDisplayRepresentation();
        }
        return "[not a module data item]";
    }
}

