/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.projections;

import com.arcway.cockpit.frame.client.global.gui.preferencePages.AbstractLicensesPreferencePage;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicense;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IProjectAgentProvider;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.lib.eclipse.gui.widgets.browser.BrowserFactory;
import com.arcway.lib.eclipse.gui.widgets.browser.IBrowser;
import java.util.Collection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractProjectionsLicenseHandler {
    public boolean checkLicense(String projectUID) {
        IFrameProjectAgent projectAgent = (IFrameProjectAgent)this.getProjectAgentProvider().getProjectAgent(projectUID);
        IClientFunctionLicenseType2 requiredLicenseType = this.getRequiredLicenseType();
        boolean hasLicense = true;
        if (requiredLicenseType != null) {
            IClientFunctionLicense license = projectAgent.getServerLicenseManager().findClientFunctionLicense((IClientFunctionLicenseType)requiredLicenseType);
            hasLicense = !requiredLicenseType.isDenial(license);
        }
        return hasLicense;
    }

    public boolean anyProjectHasLicense() {
        Collection projectAgents = this.getProjectAgentProvider().getProjectAgentsOfAllOpenProjects();
        for (IFrameProjectAgent projectAgent : projectAgents) {
            if (!this.checkLicense(projectAgent.getProjectUID())) continue;
            return true;
        }
        return false;
    }

    public Control createNoLicensePage(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)new GridData(1808));
        base.setLayout((Layout)new GridLayout());
        IBrowser browser = BrowserFactory.createBrowserOrSubstituteWidget((Composite)base, (int)0);
        browser.setHtml(AbstractLicensesPreferencePage.getHTMLTextForLimitedVersion((Color)Display.getDefault().getSystemColor(29), (int)2));
        Control browserControl = browser.getSWTControl();
        browserControl.setLayoutData((Object)new GridData(1808));
        return base;
    }

    public abstract IClientFunctionLicenseType2 getRequiredLicenseType();

    protected abstract IProjectAgentProvider getProjectAgentProvider();
}

