/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.filters;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractTextValuesFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.TableListFilterItem;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListenerManager;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import de.plans.lib.util.valueranges.IValueRangeHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ModuleDataTableListFilterItem
extends TableListFilterItem
implements IModuleProjectSwitchListener {
    private IModelControllerProvider modelControllerProvider;
    private IModelController model;
    private final String dataTypeUid;
    private Comparator comparator;
    private final boolean addOptionNotSpecified;
    private boolean useHashMap = false;
    private static final String NOT_SPECIFIED = IValueRangeHelper.NOT_SPECIFIED;

    public ModuleDataTableListFilterItem(String name, String dataTypeUid, IModuleProjectSwitchListenerManager projectSwitchListenerManager, IModelControllerProvider modelControllerProvider, AbstractTextValuesFilter filter) {
        this(name, dataTypeUid, projectSwitchListenerManager, modelControllerProvider, filter, true);
    }

    public ModuleDataTableListFilterItem(String name, String dataTypeUid, IModuleProjectSwitchListenerManager projectSwitchListenerManager, IModelControllerProvider modelControllerProvider, AbstractTextValuesFilter filter, boolean addOptionNotSpecified) {
        this(name, dataTypeUid, filter, addOptionNotSpecified);
        this.modelControllerProvider = modelControllerProvider;
        projectSwitchListenerManager.registerProjectSwitchListener((IModuleProjectSwitchListener)this);
    }

    public ModuleDataTableListFilterItem(String name, String dataTypeUid, IModelController modelController, AbstractTextValuesFilter filter) {
        this(name, dataTypeUid, modelController, filter, true);
    }

    public ModuleDataTableListFilterItem(String name, String dataTypeUid, IModelController modelController, AbstractTextValuesFilter filter, boolean addOptionNotSpecified) {
        this(name, dataTypeUid, filter, addOptionNotSpecified);
        this.modelControllerProvider = null;
        this.model = modelController;
    }

    private ModuleDataTableListFilterItem(String name, String dataTypeUid, AbstractTextValuesFilter filter, boolean addOptionNotSpecified) {
        super(name, filter);
        this.dataTypeUid = dataTypeUid;
        this.addOptionNotSpecified = addOptionNotSpecified;
    }

    public Control createContent(Composite parent) {
        if (this.model != null) {
            List itemNames;
            ArrayList<? extends IModuleData> items = new ArrayList<IModuleData>(this.model.getAllItems(this.dataTypeUid));
            if (this.comparator != null) {
                Collections.sort(items, this.comparator);
            }
            this.clearFilterValues();
            List list = itemNames = this.useHashMap ? this.fillItemNamesWithHashing(items) : this.fillItemNamesWithOutHashing(items);
            if (this.addOptionNotSpecified) {
                itemNames.add(0, "");
            }
            for (String itemName : itemNames) {
                if ("".equals(itemName)) {
                    this.addFilterValue(NOT_SPECIFIED, itemName);
                    continue;
                }
                this.addFilterValue(itemName, itemName);
            }
        } else {
            this.setFilterValues(Collections.EMPTY_LIST);
        }
        return super.createContent(parent);
    }

    private List fillItemNamesWithHashing(List moduleDataItems) {
        ArrayList<String> itemNames = new ArrayList<String>(moduleDataItems.size());
        HashSet<String> usedItems = new HashSet<String>(moduleDataItems.size());
        for (IModuleData item : moduleDataItems) {
            String[] itemNameStrings = this.extractStringAttributes(item);
            int j = 0;
            while (j < itemNameStrings.length) {
                if (itemNameStrings[j].length() > 0 && !usedItems.contains(itemNameStrings[j])) {
                    usedItems.add(itemNameStrings[j]);
                    itemNames.add(itemNameStrings[j]);
                }
                ++j;
            }
        }
        return itemNames;
    }

    private List fillItemNamesWithOutHashing(List moduleDataItems) {
        ArrayList<String> itemNames = new ArrayList<String>(moduleDataItems.size());
        for (IModuleData item : moduleDataItems) {
            String[] itemNameStrings = this.extractStringAttributes(item);
            int j = 0;
            while (j < itemNameStrings.length) {
                if (itemNameStrings[j].length() > 0 && !itemNames.contains(itemNameStrings[j])) {
                    itemNames.add(itemNameStrings[j]);
                }
                ++j;
            }
        }
        return itemNames;
    }

    public void useHashMapForDuplicateDetection(boolean enable) {
        this.useHashMap = enable;
    }

    protected String[] extractStringAttributes(IModuleData data) {
        return new String[]{data.getDisplayRepresentation()};
    }

    public void projectSwitched(String projectUID) {
        this.model = this.modelControllerProvider.getModelController(projectUID);
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }
}

