/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure;

import com.arcway.cockpit.modulelib2.client.gui.editor.specification.AbstractEditorSpecificationPart;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.IEditorSpecificationPart;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure.PageParameters;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Page
extends AbstractEditorSpecificationPart {
    private final Map<String, Table> tableMap = new HashMap<String, Table>();
    private final PageParameters pageParameters;

    public Page(List<Table> tableList, PageParameters pageParameters) {
        int tableListCounter = 1;
        for (Table part : tableList) {
            part.setIndex(tableListCounter);
            String partID = part.getID();
            this.tableMap.put(partID, part);
            ++tableListCounter;
        }
        this.pageParameters = pageParameters;
    }

    public List<Table> getTableList() {
        ArrayList<Table> list = new ArrayList<Table>(this.tableMap.values());
        Page.sortSpecificationPartList(list);
        return list;
    }

    public Table getTable(String id) {
        return this.tableMap.get(id);
    }

    public Table getTable(int index) {
        return this.getTableList().get(index);
    }

    public PageParameters getPageParameters() {
        return this.pageParameters;
    }

    public List<IEditorSpecificationPart> getChildren() {
        ArrayList<IEditorSpecificationPart> children = new ArrayList<IEditorSpecificationPart>();
        children.addAll(this.tableMap.values());
        children.add(this.pageParameters);
        return children;
    }

    @Override
    public String getTypeID() {
        return "Page";
    }
}

