/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.editdialogs;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.properties.IObjectTypeCategoryChangeListener;
import com.arcway.cockpit.frame.client.global.gui.properties.IObjectTypeCategoryChangeProvider;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.modulelib2.client.AbstractModulePlugin;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.ImageDescriptorRegistry;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IEditDialogErrorCallback;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataPropertyDialogProvider;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.eclipse.gui.LineSeparator;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class ModuleDataEditPropertyAdapter
implements IModuleDataEditDialogProvider,
IModuleDataPropertyDialogProvider,
IObjectTypeCategoryChangeProvider {
    private IEditDialogErrorCallback callback;
    private final boolean isCreationDialogue;
    private boolean hasCategoryWidget = false;
    private IModuleData item;
    private List<ObjectTypeCategory> allCategories;
    private Combo categoryCombo;
    private final Set<IObjectTypeCategoryChangeListener> objectTypeCategoryChangeListener = new HashSet<IObjectTypeCategoryChangeListener>();
    private final Runnable commit = new Runnable(){

        @Override
        public void run() {
            if (ModuleDataEditPropertyAdapter.this.hasCategoryWidget) {
                ModuleDataEditPropertyAdapter.this.getNewCategory();
            }
            ModuleDataEditPropertyAdapter.this.doCommitChanges();
        }
    };
    private static IModificationProblem MODIFICATION_PROBLEM_ITEM_DELETED = new IModificationProblem(){

        public String getHumanReadableDescriptionOfCause() {
            return Messages.getString("EditDialogues.ItemDeletedProblem.Causer");
        }

        public String getHumanReadableDescriptionOfConsequence() {
            return Messages.getString("EditDialogues.ItemDeletedProblem.Problem");
        }

        public int getSeverity() {
            return 2;
        }
    };

    public ModuleDataEditPropertyAdapter(boolean isNew) {
        this.isCreationDialogue = isNew;
    }

    @Override
    public void setCallback(IEditDialogErrorCallback callback) {
        assert (callback != null) : "callback must not be null";
        this.callback = callback;
    }

    protected IEditDialogErrorCallback getCallback() {
        return this.callback;
    }

    @Override
    public Control createDialogArea(Composite parent) {
        return this.createEditPage(parent);
    }

    @Override
    public final boolean okPressed() {
        Collection<IModificationProblem> problems = this.requestCommit();
        if (problems.isEmpty()) {
            this.commitChanges1();
            return true;
        }
        this.rollbackCommitRequest();
        IModificationProblem problem = problems.iterator().next();
        this.callback.setErrMsg(problem.getHumanReadableDescriptionOfCause());
        this.callback.setCommitable(true);
        return false;
    }

    @Override
    public final void dialogCanceled() {
        this.cancelChanges1();
    }

    @Override
    public abstract String getDataTypeID();

    @Override
    public abstract Class getDataClass();

    @Override
    public abstract String getPropertyName();

    @Override
    public Image getPropertyImage() {
        return this.getImageDescriptorRegistry().get(this.getPropertyImageDescriptor());
    }

    @Override
    public abstract ImageDescriptor getPropertyImageDescriptor();

    protected abstract ImageDescriptorRegistry getImageDescriptorRegistry();

    @Override
    public IModificationProblem initialiseAdapter(IModuleData[] items, IModuleData[] parents) {
        return this.setItems(items, parents);
    }

    @Override
    public Composite createEditPage(Composite parent) {
        this.hasCategoryWidget = false;
        Composite control = this.createEditPage_internal(parent);
        if (this.hasCategoryWidget) {
            this.setCurrentCategory();
        }
        return control;
    }

    protected abstract Composite createEditPage_internal(Composite var1);

    protected void createLabel(String text, int span, Composite parent) {
        assert (text != null) : "text is null";
        assert (parent != null) : "parent is null";
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData gridData = new GridData();
        gridData.horizontalSpan = span;
        gridData.verticalAlignment = 1;
        label.setLayoutData((Object)gridData);
    }

    protected void createLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData gridData = new GridData();
        gridData.horizontalSpan = span;
        label.setLayoutData((Object)gridData);
    }

    protected boolean isCreationDialogue() {
        return this.isCreationDialogue;
    }

    @Override
    public boolean providesPropertiesFor(IModuleData moduleData) {
        return true;
    }

    @Override
    public void commitChanges1() {
        this.getModel().executeTransaction(this.commit);
    }

    protected abstract void doCommitChanges();

    protected abstract IModelController getModel();

    protected abstract AbstractModulePlugin getPlugin();

    @Override
    public ImageDescriptor getDialogImageDescriptor() {
        return null;
    }

    @Override
    public final Image getDialogImage() {
        ImageDescriptor dialogImageDescriptor = this.getDialogImageDescriptor();
        if (dialogImageDescriptor == null) {
            return null;
        }
        AbstractModulePlugin plugin = this.getPlugin();
        return plugin.getImageDescriptorRegistry().get(dialogImageDescriptor);
    }

    protected IModificationProblem getModificationProblemItemDeleted() {
        return MODIFICATION_PROBLEM_ITEM_DELETED;
    }

    public final boolean createCategoryWidget(Composite parent, int columnExtent, IModuleData item_) {
        boolean supportsCategoryWidget = this.getCockpitDataType().isSupportingCategories();
        if (supportsCategoryWidget && !this.hasCategoryWidget) {
            Composite base;
            this.item = item_;
            String typeID = this.item.getTypeID();
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.item.getProjectUID());
            this.allCategories = projectAgent.getObjectTypeCategoriesManager().getAllCategoriesForObjectTypeSorted(typeID);
            if (columnExtent == 1) {
                base = new Composite(parent, 0);
                base.setLayout((Layout)new GridLayout(2, false));
            } else {
                base = parent;
            }
            Label label = new Label(base, 256);
            GridDataFactory.fillDefaults().align(4, 2).grab(false, false).applyTo((Control)label);
            label.setText(String.valueOf(ObjectTypeCategoryLabels.LABEL_CATEGORY) + ":");
            this.categoryCombo = new Combo(base, 12);
            GridDataFactory.fillDefaults().align(4, 2).grab(true, false).span(columnExtent > 1 ? columnExtent - 1 : 1, 1).applyTo((Control)this.categoryCombo);
            this.categoryCombo.add(ObjectTypeCategoryLabels.LABEL_DEFAULTCATEGORY);
            for (ObjectTypeCategory category : this.allCategories) {
                this.categoryCombo.add(category.getDisplayName());
            }
            this.categoryCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ModuleDataEditPropertyAdapter.this.notifyObjectTypeCategoryChangeListener();
                }
            });
            LineSeparator line = new LineSeparator(base, 0);
            GridDataFactory.fillDefaults().align(4, 2).grab(true, false).span(columnExtent > 1 ? columnExtent : 2, 1).applyTo((Control)line);
            Label space = new Label(base, 0);
            GridDataFactory.fillDefaults().align(4, 2).grab(true, false).span(columnExtent > 1 ? columnExtent : 2, 1).applyTo((Control)space);
            this.hasCategoryWidget = true;
        }
        return this.hasCategoryWidget;
    }

    public final void setCategoryEditable(boolean editable) {
        if (this.hasCategoryWidget) {
            this.categoryCombo.setEnabled(editable);
        }
    }

    private final void setCurrentCategory() {
        if (this.item.getCategoryID() == null) {
            this.categoryCombo.select(0);
        } else {
            int index = 1;
            for (ObjectTypeCategory category : this.allCategories) {
                if (category.getObjectTypeCategoryID().equals((Object)this.item.getCategoryID())) {
                    this.categoryCombo.select(index);
                }
                ++index;
            }
        }
    }

    private final void getNewCategory() {
        this.item.setCategoryID(this.getSelectedCategoryID());
    }

    private ObjectTypeCategoryID getSelectedCategoryID() {
        if (this.hasCategoryWidget) {
            int selectionIndex = this.categoryCombo.getSelectionIndex();
            if (selectionIndex == 0) {
                return null;
            }
            return this.allCategories.get(selectionIndex - 1).getObjectTypeCategoryID();
        }
        return null;
    }

    private ObjectTypeCategory getSelectedCategory() {
        ObjectTypeCategoryID categoryID = this.getSelectedCategoryID();
        ObjectTypeCategory category = null;
        if (categoryID != null) {
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.item.getProjectUID());
            category = projectAgent.getObjectTypeCategoriesManager().getCategory(categoryID);
        }
        return category;
    }

    public void addCategoryChangeListener(IObjectTypeCategoryChangeListener listener, boolean fireNotifyEventOnAdd) {
        this.objectTypeCategoryChangeListener.add(listener);
        if (fireNotifyEventOnAdd) {
            listener.categoryChanged(this.getSelectedCategory());
        }
    }

    public void removeCategoryChangeListener(IObjectTypeCategoryChangeListener listener) {
        this.objectTypeCategoryChangeListener.remove(listener);
    }

    private void notifyObjectTypeCategoryChangeListener() {
        ObjectTypeCategory category = this.getSelectedCategory();
        for (IObjectTypeCategoryChangeListener listener : this.objectTypeCategoryChangeListener) {
            listener.categoryChanged(category);
        }
    }
}

