/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.dnd;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesProviderManager;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DragSource;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DropTarget;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IActiveProjectProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IProjectAgentProvider;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionMgr;
import com.arcway.cockpit.modulelib2.client.gui.dnd.IMoveDragNDropExecuter;
import com.arcway.cockpit.modulelib2.client.gui.dnd.ModuleDataInternalTransfer;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.eclipse.transfer.dnd.DropTargetParameters;
import com.arcway.lib.eclipse.transfer.dnd.IDragHandler;
import com.arcway.lib.eclipse.transfer.dnd.IDropHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractMoveDragNDropSupport
implements IModuleProjectSwitchListener,
IActiveProjectProvider,
IMoveDragNDropExecuter {
    private static final String TRANSFER_TYPE_BASE = "ModuleData_Move_";
    private final Transfer transfer;
    protected IModelController modelController;
    private static ModuleDataMoveTransferContent transferData = null;

    public AbstractMoveDragNDropSupport(IModelController modelController) {
        this.modelController = modelController;
        this.transfer = new ModuleDataInternalTransfer(TRANSFER_TYPE_BASE + UUIDGenerator.getUniqueID());
    }

    public DragSource getDragSource() {
        return new DragSource(this.getDragOperations(), this.getTransfers(), this.getDragHandler(), this.getRequiredLicenseType(), this.getProjectManager(), (IActiveProjectProvider)this);
    }

    public DropTarget getDropTarget() {
        return new DropTarget(this.getDropOperations(), this.getTransfers(), this.getDropHandler(), this.getRequiredLicenseType(), this.getProjectManager(), (IActiveProjectProvider)this);
    }

    private int getDragOperations() {
        return 18;
    }

    private int getDropOperations() {
        return 18;
    }

    private Set<Transfer> getTransfers() {
        return Collections.singleton(this.transfer);
    }

    private IDragHandler getDragHandler() {
        IDragHandler dragHandler = new IDragHandler(){

            public boolean isDragPossible(DragSourceEvent event, ISelectionProvider selectionProvider) {
                transferData = null;
                ISelection selection = selectionProvider.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return false;
                }
                List selectedItems = ((IStructuredSelection)selection).toList();
                Collection possibleParentDataTypes = AbstractMoveDragNDropSupport.this.checkSourceData(selectedItems);
                if (possibleParentDataTypes == null) {
                    return false;
                }
                transferData = new ModuleDataMoveTransferContent(selectedItems, possibleParentDataTypes, AbstractMoveDragNDropSupport.this.modelController.getProjectUID());
                return true;
            }

            public Object getDragData(DragSourceEvent event, ISelectionProvider selectionProvider) {
                return transferData.uid;
            }

            public void finishDrag(DragSourceEvent event, ISelectionProvider selectionProvider) {
                transferData = null;
            }
        };
        return dragHandler;
    }

    private IDropHandler getDropHandler() {
        IDropHandler dropHandler = new IDropHandler(){

            public boolean isDropPossible(DropTargetEvent event, int location, Control targetControl, DropTargetParameters parametersToChoose) {
                if (transferData == null) {
                    return false;
                }
                if (event.item == null || event.item.getData() != null && event.item.getData() instanceof IModuleData) {
                    TransferData dataType = AbstractMoveDragNDropSupport.this.extractRequiredDatatype(event.dataTypes);
                    if (dataType == null) {
                        return false;
                    }
                    parametersToChoose.requestedTransferType = dataType;
                    int operation = AbstractMoveDragNDropSupport.this.extractRequiredOperation(event.operations, event.detail);
                    if (operation == 0) {
                        return false;
                    }
                    parametersToChoose.requestedOperation = operation;
                    if (location != 3 && (location != 4 || event.item != null)) {
                        return false;
                    }
                    if (transferData != null && transferData.projectUID != null && transferData.projectUID.equals(AbstractMoveDragNDropSupport.this.modelController.getProjectUID())) {
                        IModuleData targetData = null;
                        if (event.item != null) {
                            targetData = (IModuleData)event.item.getData();
                        }
                        if (!AbstractMoveDragNDropSupport.this.checkTarget(transferData.moduleData, targetData, transferData.possibleParentDataTypes)) {
                            return false;
                        }
                        parametersToChoose.requestedFeedbackTypes = 25;
                        return true;
                    }
                    return false;
                }
                return false;
            }

            public boolean performDrop(DropTargetEvent event, int location, Control targetControl) {
                IModuleData target = event.item != null ? (IModuleData)event.item.getData() : null;
                ArrayList sourceData = new ArrayList(transferData.moduleData);
                AbstractMoveDragNDropSupport.this.doMove(sourceData, target, targetControl.getShell());
                return true;
            }
        };
        return dropHandler;
    }

    private int extractRequiredOperation(int operations, int requestedOperation) {
        if (requestedOperation == 16) {
            if ((operations & 0x10) != 0 || (operations & 2) != 0) {
                return 2;
            }
            return 0;
        }
        if ((requestedOperation & 2) != 0) {
            return 2;
        }
        return 0;
    }

    private TransferData extractRequiredDatatype(TransferData[] dataTypes) {
        TransferData[] transferDataArray = dataTypes;
        int n = dataTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData dataType = transferDataArray[n2];
            if (this.transfer.isSupportedType(dataType)) {
                return dataType;
            }
            ++n2;
        }
        return null;
    }

    private Collection checkSourceData(Collection sourceData) {
        Collection possibleParentDataTypes = null;
        for (Object sourceItem : sourceData) {
            if (!(sourceItem instanceof IModuleData)) {
                return null;
            }
            IModuleData moduleData = (IModuleData)sourceItem;
            if (possibleParentDataTypes == null) {
                possibleParentDataTypes = this.getPossibleParentDataTypes(moduleData.getTypeID());
            } else {
                possibleParentDataTypes.retainAll(this.getPossibleParentDataTypes(moduleData.getTypeID()));
            }
            if (this.isMovable(moduleData)) continue;
            return null;
        }
        if (possibleParentDataTypes != null && possibleParentDataTypes.isEmpty()) {
            possibleParentDataTypes = null;
        }
        return possibleParentDataTypes;
    }

    private boolean checkTarget(Collection sourceData, IModuleData target, Collection possibleParentDataTypes) {
        String parentTypeID = target != null ? target.getTypeID() : "hierarchyroot";
        if (!possibleParentDataTypes.contains(parentTypeID)) {
            return false;
        }
        return this.isMovePossible(sourceData, target, false);
    }

    @Override
    public Collection doMove(Collection sourceData, final IModuleData target, Shell shell) {
        if (!this.getDragSource().licenseAvailable()) {
            return Collections.EMPTY_LIST;
        }
        if (!this.getDropTarget().licenseAvailable()) {
            return Collections.EMPTY_LIST;
        }
        final ArrayList itemsToMove = new ArrayList(sourceData);
        if (!this.checkPermissionsAndAquireLocks(itemsToMove, target, shell)) {
            return Collections.EMPTY_LIST;
        }
        this.modelController.executeTransaction(new Runnable(){

            @Override
            public void run() {
                AbstractMoveDragNDropSupport.this.moveItems(itemsToMove, target);
            }
        });
        return itemsToMove;
    }

    @Override
    public boolean isMovePossible(Collection items, IModuleData newParent, boolean checkParentDataType) {
        Collection possibleParentDataTypes;
        if (!this.getDragSource().licenseAvailable()) {
            return false;
        }
        if (!this.getDropTarget().licenseAvailable()) {
            return false;
        }
        if (checkParentDataType && ((possibleParentDataTypes = this.checkSourceData(items)) == null || newParent != null && !possibleParentDataTypes.contains(newParent.getTypeID()) || newParent == null && !possibleParentDataTypes.contains("hierarchyroot"))) {
            return false;
        }
        for (Object item : items) {
            if (!(item instanceof IModuleData)) {
                return false;
            }
            if (!this.isMovable((IModuleData)item, newParent)) {
                return false;
            }
            if (!(newParent != null ? newParent.equals(item) || this.modelController.getAllAscendants(newParent).contains(item) : this.modelController.getParent((IModuleData)item) == null)) continue;
            return false;
        }
        return true;
    }

    protected boolean checkPermissionsAndAquireLocks(Collection sourceData, IModuleData target, Shell shell) {
        LockAccess moveLock;
        AbstractLockManager lockManager = this.modelController.getLockMgr();
        AbstractPermissionMgr permissionMgr = this.modelController.getPermissionMgr();
        HashSet<IModuleData> itemsWithoutPermission = new HashSet<IModuleData>();
        HashSet<IModuleData> itemsWithoutLock = new HashSet<IModuleData>();
        HashSet<LockAccess> preMovingLocks = new HashSet<LockAccess>(sourceData.size());
        Iterator i = sourceData.iterator();
        while (i.hasNext()) {
            IModuleData element = (IModuleData)i.next();
            if (permissionMgr.mayEditItemStructurally(element, this.modelController.getParent(element)) && permissionMgr.mayCreateChildren(target, element.getTypeID())) {
                LockAccess lock = lockManager.acquireMoveLockBeforeMoving((ICockpitProjectData)element, this.getDatatypeForMoveLock(), false);
                if (lock.hasLock()) {
                    preMovingLocks.add(lock);
                    continue;
                }
                i.remove();
                itemsWithoutLock.add(element);
                continue;
            }
            i.remove();
            itemsWithoutPermission.add(element);
        }
        if (target != null && !(moveLock = lockManager.acquireMoveLock((ICockpitProjectData)target, false)).hasLock()) {
            MessageDialog.openInformation((Shell)shell, (String)Messages.getString("MoveDragNDropSupport.TargetLockedTitle"), (String)Messages.getString("MoveDragNDropSupport.TargetLockedMessage"));
            this.releaseLocks(preMovingLocks);
            return false;
        }
        if (!sourceData.isEmpty()) {
            String message;
            if (!itemsWithoutPermission.isEmpty()) {
                message = this.createMovePermissionMessage(itemsWithoutPermission, Messages.getString("MoveDragNDropSupport.NoPermissionProblem"));
                if (!MessageDialog.openConfirm((Shell)shell, (String)Messages.getString("MoveDragNDropSupport.NoPermissionTitle"), (String)message)) {
                    this.releaseLocks(preMovingLocks);
                    return false;
                }
            }
            if (!itemsWithoutLock.isEmpty()) {
                message = this.createMovePermissionMessage(itemsWithoutLock, Messages.getString("MoveDragNDropSupport.NoLockProblem"));
                if (!MessageDialog.openConfirm((Shell)shell, (String)Messages.getString("MoveDragNDropSupport.NoLockTitle"), (String)message)) {
                    this.releaseLocks(preMovingLocks);
                    return false;
                }
            }
        } else {
            MessageDialog.openInformation((Shell)shell, (String)Messages.getString("MoveDragNDropSupport.NoMovableItemsTitle"), (String)Messages.getString("MoveDragNDropSupport.NoMovableItemsMessage"));
            return false;
        }
        return true;
    }

    private String createMovePermissionMessage(Collection droppedItems, String reason) {
        boolean paneTooSmall;
        int maxItemsToBeWrittenOut = 5;
        String message = String.valueOf(Messages.getString("MoveDragNDropSupport.MoveAnywayProblem")) + reason;
        boolean bl = paneTooSmall = maxItemsToBeWrittenOut < droppedItems.size();
        if (paneTooSmall) {
            --maxItemsToBeWrittenOut;
        }
        Iterator i = droppedItems.iterator();
        while (i.hasNext() && maxItemsToBeWrittenOut > 0) {
            IModuleData element = (IModuleData)i.next();
            message = String.valueOf(message) + "\n" + element.getDisplayRepresentation();
        }
        if (paneTooSmall) {
            message = String.valueOf(message) + "\n...";
        }
        message = String.valueOf(message) + "\n" + Messages.getString("MoveDragNDropSupport.MoveAnywayQuestion");
        return message;
    }

    private void releaseLocks(Collection preMovingLocks) {
        for (LockAccess lock : preMovingLocks) {
            lock.releaseLocks();
        }
    }

    private void moveItems(Collection sourceData, IModuleData target) {
        HashMap movedItemsByDataType = new HashMap();
        HashMap<IModuleData, IModuleData> sourceDataWithOldParent = new HashMap<IModuleData, IModuleData>();
        for (IModuleData element : sourceData) {
            String newLinkTypeID;
            String oldLinkTypeID;
            IModuleData oldParent = this.modelController.getParent(element);
            if (oldParent != null && (oldLinkTypeID = this.getHierarchyLinkType(oldParent.getTypeID(), element.getTypeID())) != null) {
                this.modelController.deleteLink(oldParent.getUID(), element.getUID(), oldLinkTypeID);
            }
            sourceDataWithOldParent.put(element, oldParent);
            if (target != null && (newLinkTypeID = this.getHierarchyLinkType(target.getTypeID(), element.getTypeID())) != null) {
                this.modelController.createLink(target.getUID(), element, newLinkTypeID);
            }
            this.addModuleDataItemToDataTypeMap(movedItemsByDataType, element);
        }
        this.modelController.movedItems(sourceDataWithOldParent, target);
        IPropertyChangesProviderManager propertiesManager = this.modelController.getProjectAgent().getPropertyChangesProviderManager();
        for (Map.Entry entry : movedItemsByDataType.entrySet()) {
            Collection itemCollection = (Collection)entry.getValue();
            if (itemCollection.isEmpty()) continue;
            propertiesManager.modelRefreshed((IPropertyChanges)new PropertyChanges(null, itemCollection, null), itemCollection.iterator().next().getClass());
        }
    }

    private void addModuleDataItemToDataTypeMap(Map map, IModuleData item) {
        if (map.containsKey(item.getTypeID())) {
            ((Collection)map.get(item.getTypeID())).add(item);
        } else {
            ArrayList<IModuleData> newList = new ArrayList<IModuleData>();
            newList.add(item);
            map.put(item.getTypeID(), newList);
        }
    }

    protected abstract Collection getPossibleParentDataTypes(String var1);

    protected abstract String getDatatypeForMoveLock();

    protected abstract String getHierarchyLinkType(String var1, String var2);

    protected boolean isMovable(IModuleData item) {
        assert (item != null);
        return true;
    }

    protected boolean isMovable(IModuleData item, IModuleData newParent) {
        assert (item != null);
        assert (newParent == null || newParent.getProjectUID() != null);
        return true;
    }

    protected abstract IProjectAgentProvider getProjectManager();

    protected abstract IModelControllerProvider getModelControllerProvider();

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return null;
    }

    public void projectSwitched(String projectUID) {
        this.modelController = this.getModelControllerProvider().getModelController(projectUID);
    }

    public String getActiveProject() {
        return this.modelController != null ? this.modelController.getProjectUID() : null;
    }

    private class ModuleDataMoveTransferContent {
        public String uid;
        public String projectUID;
        public Collection moduleData;
        public Collection possibleParentDataTypes;

        public ModuleDataMoveTransferContent(Collection data, Collection possibleParentDataTypes, String projectUID) {
            this.moduleData = data;
            this.possibleParentDataTypes = possibleParentDataTypes;
            this.projectUID = projectUID;
            this.uid = UUIDGenerator.getUniqueID();
        }
    }
}

