/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes;

import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListenerManager;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.IDiscreteAttributeHandler;

public abstract class AbstractModuleHandler
implements IDiscreteAttributeHandler,
IModuleProjectSwitchListener {
    private final IModelControllerProvider modelControllerProvider;
    private IModelController modelController;
    private final String menuName;
    private final String dataTypeID;
    private final boolean checkPermissions;

    public AbstractModuleHandler(IModuleProjectSwitchListenerManager projectSwitchListenerManager, IModelControllerProvider modelControllerProvider, String menuName, String dataTypeID, boolean checkPermissions) {
        this.menuName = menuName;
        this.dataTypeID = dataTypeID;
        this.modelControllerProvider = modelControllerProvider;
        this.checkPermissions = checkPermissions;
        projectSwitchListenerManager.registerProjectSwitchListener((IModuleProjectSwitchListener)this);
        this.modelController = modelControllerProvider.getModelController(projectSwitchListenerManager.getCurrentlyAssociatedProject());
    }

    @Override
    public String getMenuEntryName() {
        return this.menuName;
    }

    public void projectSwitched(String projectUID) {
        this.modelController = this.modelControllerProvider.getModelController(projectUID);
    }

    @Override
    public void changeMultipleValues(final Runnable runnable) {
        this.modelController.executeTransaction(new Runnable(){

            @Override
            public void run() {
                AbstractModuleHandler.this.startChange();
                try {
                    runnable.run();
                }
                finally {
                    AbstractModuleHandler.this.finishChange();
                }
            }
        });
    }

    protected void startChange() {
    }

    protected void finishChange() {
    }

    protected final IModelController getModelController() {
        return this.modelController;
    }

    protected String getDataTypeID() {
        return this.dataTypeID;
    }

    public boolean isCheckPermissions() {
        return this.checkPermissions;
    }
}

