/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui;

import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import de.plans.lib.util.gui.elements.UIETextField;
import java.util.Collection;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractNewItemDialog
extends TitleAreaDialog
implements ModifyListener {
    protected Collection existingItems;
    protected IModuleData item;
    protected UIETextField name;
    private final String dialogErrorStringItemExists;
    private final String dialogStringTitle;
    private final String dialogStringMessage;
    private final String itemLabelString;

    public AbstractNewItemDialog(Shell parentShell, Collection existingItems, String dialogStringTitle, String dialogStringMessage, String itemLabelString, String errorStringItemExists) {
        super(parentShell);
        this.existingItems = existingItems;
        this.dialogErrorStringItemExists = errorStringItemExists;
        this.dialogStringMessage = dialogStringMessage;
        this.dialogStringTitle = dialogStringTitle;
        this.itemLabelString = itemLabelString;
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText(this.dialogStringTitle);
        this.setTitle(this.dialogStringTitle);
        this.setMessage(this.dialogStringMessage);
        Composite editArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        editArea.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        editArea.setLayoutData((Object)gridData);
        Label labelItem = new Label(editArea, 0);
        labelItem.setText(this.itemLabelString);
        Control widget = this.name.getControl(editArea);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        widget.setLayoutData((Object)gridData);
        this.setValues();
        this.name.addModifyListener((ModifyListener)this);
        return editArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.handleModifications(null, false);
    }

    public void modifyText(ModifyEvent e) {
        this.handleModifications(e, true);
    }

    protected abstract void getValues();

    protected abstract void setValues();

    private void handleModifications(ModifyEvent e, boolean showErrorMessage) {
        String checkResult = "";
        String nameCheckResult = this.name.checkCurrentValue();
        if (nameCheckResult != null) {
            checkResult = String.valueOf(checkResult) + nameCheckResult;
        }
        if (this.wouldCreateDuplicate(this.existingItems)) {
            checkResult = String.valueOf(checkResult) + this.dialogErrorStringItemExists;
        }
        if (checkResult.equals("")) {
            if (showErrorMessage) {
                this.setMessage(this.dialogStringMessage);
            }
            this.getButton(0).setEnabled(true);
        } else {
            if (showErrorMessage) {
                this.setMessage(checkResult, 3);
            }
            this.getButton(0).setEnabled(false);
        }
    }

    private boolean wouldCreateDuplicate(Collection items) {
        String currentValue = this.name.getCurrentValue().trim();
        return items.contains(currentValue);
    }

    protected void okPressed() {
        this.getValues();
        super.okPressed();
    }

    public IModuleData getItem() {
        return this.item;
    }
}

