/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.dataexchange.adapter.exporter;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.FilterDialogPart;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.filters.FilterHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;

public class FilterPage
extends WizardPage {
    private final List<IFilterItem> filterItems;
    private final FilterDialogPart filterDialogPart;

    public FilterPage(IModelController modelController, Collection<IFilterItem> fixAttributeFilterItems, Collection<String> customPropertyFilterDataTypes) {
        super("filters", Messages.getString("ExportWizard_FilterPage.Title"), Icons.getImageDescriptorForBigExportLogo());
        this.setMessage(Messages.getString("ExportWizard_FilterPage.Message"));
        this.filterItems = new LinkedList<IFilterItem>(fixAttributeFilterItems);
        this.filterDialogPart = new FilterDialogPart();
        for (String dataTypeID : customPropertyFilterDataTypes) {
            FilterHelper.getCustomPropertyFilters(dataTypeID, this.filterItems, modelController);
        }
        for (IFilterItem filterItem : this.filterItems) {
            this.filterDialogPart.addItem(filterItem);
        }
    }

    public void createControl(Composite parent) {
        this.setControl(this.filterDialogPart.createContent(parent));
    }

    public Collection<AbstractFilter> getFilterItems() {
        ArrayList<AbstractFilter> filters = new ArrayList<AbstractFilter>();
        for (IFilterItem filterItem : this.filterItems) {
            filters.add(filterItem.getFilter());
        }
        return filters;
    }
}

