/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.dataexchange;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.modulelib2.client.core.crossmodulelinks.CrossModuleLinkManager;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractDataFacade;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.dataexchange.IProjectLocaleProvider;
import com.arcway.cockpit.modulelib2.client.messages.AbstractModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;

public class CrossModuleLinksDataFacade {
    private final Collection<AbstractFilter> filters;
    private final IProjectLocaleProvider projectLocaleProvider;

    public CrossModuleLinksDataFacade(IProjectLocaleProvider projectLocaleProvider, Collection<AbstractFilter> filterCollection) {
        this.projectLocaleProvider = projectLocaleProvider;
        this.filters = filterCollection;
    }

    public Collection<AbstractImExModuleData> getModuleDataItems(AbstractImExModuleData linkableObject, String crossModuleLinkTypeID) {
        AbstractModuleData linkableObject_asMD = linkableObject.getModuleData();
        CrossModuleLinkManager crossModuleLinkManager = CrossModuleLinkManager.getInstance(linkableObject_asMD.getProjectUID());
        Collection<IModuleData> moduleDataItems = crossModuleLinkManager.getModuleDataItems(linkableObject_asMD, crossModuleLinkTypeID);
        ArrayList<AbstractImExModuleData> exportableModuleDataItems = new ArrayList<AbstractImExModuleData>(moduleDataItems.size());
        Locale projectLocale = this.projectLocaleProvider.getProjectLocale();
        for (IModuleData moduleDataItem : moduleDataItems) {
            AbstractDataFacade responsibleDataFacade = crossModuleLinkManager.getResponsibleDataFacade(moduleDataItem.getTypeID());
            if (AbstractDataFacade.filter(Collections.singleton(moduleDataItem), this.filters).isEmpty()) continue;
            exportableModuleDataItems.add(responsibleDataFacade.getExportableItem(moduleDataItem, projectLocale, this.filters));
        }
        return exportableModuleDataItems;
    }

    public Collection<AbstractImExModuleData> getLinkableObjects(AbstractImExModuleData moduleDataItem, String crossModuleLinkTypeID) {
        AbstractModuleData moduleDataItem_asMD = moduleDataItem.getModuleData();
        CrossModuleLinkManager crossModuleLinkManager = CrossModuleLinkManager.getInstance(moduleDataItem_asMD.getProjectUID());
        Collection<IModuleData> linkableObjects = crossModuleLinkManager.getLinkableObjects(moduleDataItem_asMD, crossModuleLinkTypeID);
        ArrayList<AbstractImExModuleData> exportableLinkableObjects = new ArrayList<AbstractImExModuleData>(linkableObjects.size());
        Locale projectLocale = this.projectLocaleProvider.getProjectLocale();
        for (IModuleData linkableObject : linkableObjects) {
            AbstractDataFacade responsibleDataFacade = crossModuleLinkManager.getResponsibleDataFacade(linkableObject.getTypeID());
            if (AbstractDataFacade.filter(Collections.singleton(linkableObject), this.filters).isEmpty()) continue;
            exportableLinkableObjects.add(responsibleDataFacade.getExportableItem(linkableObject, projectLocale, this.filters));
        }
        return exportableLinkableObjects;
    }

    public String getCockpitTypeID(AbstractImExModuleData exportableItem) {
        return exportableItem.getModuleData().getTypeID();
    }
}

