/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.dataexchange;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractModuleAttributeAgent;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.dataexchange.ImValue;
import com.arcway.cockpit.modulelib2.client.messages.AbstractModuleData;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractImExModuleData {
    private IAttributeOwner customPropOwner;
    private AbstractModuleAttributeAgent modificationManager;
    private AbstractModuleData moduleData;
    private IFrameProjectAgent projectAgent;
    private String UID;
    private String creationDate;
    private Long creationDate_ms;
    private String creator;
    private String lastModificationDate;
    private Long lastModificationDate_ms;
    private String lastModifier;
    private String modificationCount;
    private int commitCount;
    private ObjectTypeCategoryID categoryID;
    private Map<String, ImValue> map_customPropertyID_value;
    private boolean hasObjectTypeCategoryBeenImported = false;
    private ObjectTypeCategoryID importedObjectTypeCategoryID;

    public AbstractImExModuleData() {
        this.map_customPropertyID_value = new HashMap<String, ImValue>();
    }

    public AbstractImExModuleData(AbstractModuleData moduleData, IModelController modelController, Locale locale) {
        this.customPropOwner = modelController.getAttributeOwner(moduleData);
        this.modificationManager = modelController.getAttributeModificationManager(moduleData);
        this.moduleData = moduleData;
        this.projectAgent = (IFrameProjectAgent)modelController.getProjectAgent();
        this.creator = moduleData.getCreator().getDisplayStringRepresentation();
        this.creationDate = moduleData.getCreationTime().getDisplayStringRepresentation(locale);
        this.creationDate_ms = moduleData.getCreationTime().getValue();
        this.lastModifier = moduleData.getModifier().getDisplayStringRepresentation();
        this.lastModificationDate = moduleData.getModificationTime().getDisplayStringRepresentation(locale);
        this.lastModificationDate_ms = moduleData.getModificationTime().getValue();
        this.modificationCount = Integer.toString(moduleData.getModificationCount());
        this.commitCount = moduleData.getCommitCount();
        this.categoryID = moduleData.getCategoryID();
    }

    protected AbstractModuleData getModuleData() {
        return this.moduleData;
    }

    public ICockpitProjectData asCockpitProjectData() {
        return this.moduleData;
    }

    public IAttributeOwner getCustomPropertiesExtension_forReading() {
        return this.customPropOwner;
    }

    public AbstractModuleAttributeAgent getCustomPropertiesExtension_forWriting() {
        return this.modificationManager;
    }

    public IFrameProjectAgent getProjectAgent() {
        return this.projectAgent;
    }

    public void setProjectAgent(IFrameProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
    }

    public String getUID() {
        if (this.UID != null) {
            return this.UID;
        }
        if (this.moduleData != null) {
            return this.moduleData.getUID();
        }
        return null;
    }

    public void setUID(String UID) {
        this.UID = UID;
    }

    public void addCustomPropertyValue(String customPropertyID, ImValue value) {
        this.map_customPropertyID_value.put(customPropertyID, value);
    }

    public Map<String, ImValue> getCustomPropertyValues() {
        return this.map_customPropertyID_value;
    }

    public void setImportedObjectTypeCategoryID(ObjectTypeCategoryID importedObjectTypeCategoryID) {
        this.hasObjectTypeCategoryBeenImported = true;
        this.importedObjectTypeCategoryID = importedObjectTypeCategoryID;
    }

    public boolean hasObjectTypeCategoryBeenImported() {
        return this.hasObjectTypeCategoryBeenImported;
    }

    public ObjectTypeCategoryID getImportedObjectTypeCategoryID() {
        return this.importedObjectTypeCategoryID;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public Long getCreationDate_ms() {
        return this.creationDate_ms;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getLastModificationDate() {
        return this.lastModificationDate;
    }

    public Long getLastModificationDate_ms() {
        return this.lastModificationDate_ms;
    }

    public String getLastModifier() {
        return this.lastModifier;
    }

    public String getModificationCount() {
        return this.modificationCount;
    }

    public int getCommitCount() {
        return this.commitCount;
    }

    public ObjectTypeCategoryID getCategoryID() {
        return this.categoryID;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            if (obj instanceof AbstractImExModuleData) {
                AbstractImExModuleData data = (AbstractImExModuleData)obj;
                return data.getUID().equals(this.getUID());
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.getUID() != null) {
            return this.getUID().hashCode();
        }
        return super.hashCode();
    }
}

