/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.core.project;

import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.IRequesterForServerData;
import com.arcway.cockpit.modulelib2.shared.messages.EOModuleData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.primitiveTypes.EOString;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOServerResponse;

public class ServerProxy {
    private static final ILogger logger = Logger.getLogger(ServerProxy.class);
    private IModuleProjectAgent projectAgent;

    public void construct(IModuleProjectAgent p_projectAgent) {
        assert (p_projectAgent != null);
        this.projectAgent = p_projectAgent;
    }

    public IRequesterForServerData getRequesterToGetModuleDataFromServer(final String dataTypeID) {
        return new IRequesterForServerData(){

            public EOClientRequest createRequest() {
                if (!$assertionsDisabled && dataTypeID == null) {
                    throw new AssertionError((Object)"dataTypeUID is null");
                }
                EOList reqParam = new EOList();
                reqParam.add((EncodableObjectBase)new EOString(ServerProxy.this.projectAgent.getProjectUID(), "parameter.1"));
                reqParam.add((EncodableObjectBase)new EOString(dataTypeID, "parameter.2"));
                return new EOClientRequest("modulelib.standardmoduledata", "modulelib.getdataoftype", (EncodableObjectBase)reqParam);
            }

            public EOList<? extends EOModuleData> handleResponse(EOServerResponse response) {
                if (!$assertionsDisabled && response == null) {
                    throw new AssertionError((Object)"eoServerResponse is null");
                }
                EOList allModuleDataItemsOfType = new EOList();
                EncodableObjectBase responseData = response.getResponseData();
                if (responseData instanceof EOList) {
                    return (EOList)responseData;
                }
                if (responseData != null) {
                    logger.warn("Unexpected type of response for \"get all\" request: " + responseData.getClass().getName());
                } else {
                    logger.warn("Null response for \"get all\" request");
                }
                return allModuleDataItemsOfType;
            }
        };
    }
}

