/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.core.project;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider2;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractModuleDataLabelProvider
implements IDataLabelProvider2<String> {
    private static final ILogger LOGGER = Logger.getLogger(AbstractModuleDataLabelProvider.class);
    private final AbstractDataMgr dataManager;

    public AbstractModuleDataLabelProvider(AbstractDataMgr dataManager) {
        this.dataManager = dataManager;
    }

    public final Image getImageForItem(Object element) {
        IModuleData item = this.determineModuleDataItem(element);
        if (item != null) {
            return this.getImageForItem_internal(item);
        }
        return null;
    }

    public final String getLabelForItem(Object element) {
        IModuleData item = this.determineModuleDataItem(element);
        if (item != null) {
            return this.getLabelForItem_internal(item);
        }
        return null;
    }

    private IModuleData determineModuleDataItem(Object element) {
        IModuleData item = null;
        if (element instanceof IModuleData) {
            item = (IModuleData)element;
        } else if (element instanceof IAttributeOwner) {
            IAttributeOwner attributeOwner = (IAttributeOwner)element;
            item = (IModuleData)this.dataManager.getItem(attributeOwner.getTypeID(), attributeOwner.getUID());
            if (item == null) {
                LOGGER.warn("Can not find attribute owner in module model for label or image determination (type id=" + attributeOwner.getTypeID() + " / uid=" + attributeOwner.getUID() + ")");
            }
        } else {
            LOGGER.warn("Unknown item for label or image determination (class=" + element.getClass().getName() + ")");
            return null;
        }
        return item;
    }

    public abstract Image getImageForItem_internal(IModuleData var1);

    public abstract String getLabelForItem_internal(IModuleData var1);
}

