/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.interFace.client.eclipse.interFace;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.planviewers.planexport.PlanExporter;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.interFace.client.eclipse.interFace.COCKPITEclipseClientController;
import com.arcway.cockpit.interFace.client.eclipse.interFace.COCKPITObjectUID;
import com.arcway.cockpit.interFace.client.eclipse.interFace.EXProjectNotOpen;
import com.arcway.cockpit.interFace.client.eclipse.interFace.EXProjectUnknown;
import com.arcway.cockpit.interFace.client.eclipse.interFace.EXUnknownObject;
import com.arcway.cockpit.interFace.client.eclipse.interFace.ICOCKPITObjectInformation;
import com.arcway.lib.graphics.image.ImageCoDec;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.java.Assert;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.util.gui.IProgressDisplay;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

class COCKPITObjectInformationFetcher
implements ICOCKPITObjectInformation {
    private static final ILogger logger = Logger.getLogger(COCKPITObjectInformationFetcher.class);
    private final COCKPITObjectUID objectUID;

    public COCKPITObjectInformationFetcher(COCKPITObjectUID objectUID) {
        Assert.checkArgumentBeeingNotNull((Object)objectUID);
        this.objectUID = objectUID;
    }

    @Override
    public COCKPITObjectUID getCOCKPITObjectUID() {
        return this.objectUID;
    }

    @Override
    public String getProjectUID() {
        return this.objectUID.getProjectUID();
    }

    @Override
    public ICockpitProjectData getICockpitProjectData() throws EXUnknownObject, EXProjectUnknown, EXProjectNotOpen {
        IFrameProjectAgent projectAgent = COCKPITEclipseClientController.getProjectAgentOfOpenProject(this.objectUID);
        ICockpitProjectData cockpitProjectData = COCKPITEclipseClientController.getCockpitProjectData(projectAgent, this.objectUID);
        return cockpitProjectData;
    }

    @Override
    public String getDisplayName() throws EXUnknownObject, EXProjectUnknown, EXProjectNotOpen {
        IFrameProjectAgent projectAgent = COCKPITEclipseClientController.getProjectAgentOfOpenProject(this.objectUID);
        ICockpitProjectData cockpitProjectData = COCKPITEclipseClientController.getCockpitProjectData(projectAgent, this.objectUID);
        IFrameDataManager dm = COCKPITEclipseClientController.getDataManager(projectAgent, this.objectUID);
        IDataLabelProvider labelProvider = dm.getDataLabelProvider();
        String displayName = labelProvider == null ? this.objectUID.toUIDString() : labelProvider.getText((Object)cockpitProjectData);
        return displayName;
    }

    @Override
    public ImageDescriptor getIcon() throws EXProjectUnknown, EXProjectNotOpen, EXUnknownObject {
        Image image;
        IFrameProjectAgent projectAgent = COCKPITEclipseClientController.getProjectAgentOfOpenProject(this.objectUID);
        ICockpitProjectData cockpitProjectData = COCKPITEclipseClientController.getCockpitProjectData(projectAgent, this.objectUID);
        ImageDescriptor displayName = null;
        IFrameDataManager dm = COCKPITEclipseClientController.getDataManager(projectAgent, this.objectUID);
        IDataLabelProvider labelProvider = dm.getDataLabelProvider();
        if (labelProvider != null && (image = labelProvider.getImage((Object)cockpitProjectData)) != null) {
            final ImageData imageData = image.getImageData();
            displayName = new ImageDescriptor(){

                public ImageData getImageData() {
                    return imageData;
                }
            };
        }
        return displayName;
    }

    @Override
    public String export(OutputStream outp) throws EXUnknownObject, EXProjectUnknown, EXProjectNotOpen {
        IFrameProjectAgent projectAgent = COCKPITEclipseClientController.getProjectAgentOfOpenProject(this.objectUID);
        ICockpitProjectData cockpitProjectData = COCKPITEclipseClientController.getCockpitProjectData(projectAgent, this.objectUID);
        IPlan planToShow = null;
        if (cockpitProjectData instanceof IPlan) {
            IPlan plan;
            planToShow = plan = (IPlan)cockpitProjectData;
        } else if (cockpitProjectData instanceof IUniqueElement) {
            IUniqueElement uniqueElement = (IUniqueElement)cockpitProjectData;
            Collection refiningPlans = projectAgent.getUniqueElementRelationshipManager().getRefiningPlans(uniqueElement);
            Iterator i = refiningPlans.iterator();
            if (i.hasNext()) {
                IPlan plan;
                planToShow = plan = (IPlan)i.next();
            } else {
                Collection occurencePlans = projectAgent.getFrameUniqueElementMgr().getPlansOfUniqueElement(uniqueElement);
                Iterator j = occurencePlans.iterator();
                if (j.hasNext()) {
                    IPlan plan;
                    planToShow = plan = (IPlan)j.next();
                }
            }
        }
        String exportFileName = null;
        if (planToShow != null) {
            try {
                File tempFile = File.createTempFile("Preview", String.valueOf('.') + ImageCoDec.PNG.getFileExtension());
                tempFile.deleteOnExit();
                if (PlanExporter.createPNGImage((IPlan)planToShow, (double)72.0, (int)920, (boolean)true, (ICockpitProjectData)cockpitProjectData, (File)tempFile, (IProgressDisplay)IProgressDisplay.DUMMY)) {
                    DataCopyHelper.copyFile((File)tempFile, (OutputStream)outp, (boolean)false);
                }
                exportFileName = tempFile.getName();
                FileHelper.deleteExistingFileOrDirectory((File)tempFile);
            }
            catch (IOException e) {
                logger.error("Exception when creating preview.", (Throwable)e);
            }
            catch (JvmExternalResourceInteractionException e) {
                logger.error("Exception when creating preview.", (Throwable)e);
            }
        }
        return exportFileName;
    }
}

