/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure;

import com.arcway.cockpit.genericmodule.client.infrastructure.specification.AbstractModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.IModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Attribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.EnumerationValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EnumerationAttribute
extends AbstractModuleSpecificationPart
implements Attribute {
    private final String attributeID;
    private final String attributeName;
    private final Map<String, EnumerationValue> enumerationValueMap;
    private final List<EnumerationValue> enumerationValueList;

    public EnumerationAttribute(String attributeID, String attributeName, List<EnumerationValue> enumerationValueList) {
        this.attributeID = attributeID;
        this.attributeName = attributeName;
        this.enumerationValueMap = new HashMap<String, EnumerationValue>();
        this.enumerationValueList = new ArrayList<EnumerationValue>();
        int enumerationValueListCounter = 1;
        for (EnumerationValue part : enumerationValueList) {
            part.setIndex(enumerationValueListCounter);
            String partID = part.getID();
            this.enumerationValueMap.put(partID, part);
            this.enumerationValueList.add(part);
            ++enumerationValueListCounter;
        }
    }

    public String getAttributeID() {
        return this.attributeID;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public List<EnumerationValue> getEnumerationValueList() {
        return this.enumerationValueList;
    }

    public EnumerationValue getEnumerationValue(String id) {
        return this.enumerationValueMap.get(id);
    }

    public EnumerationValue getEnumerationValue(int index) {
        return this.getEnumerationValueList().get(index);
    }

    @Override
    public String getID() {
        return this.attributeID;
    }

    @Override
    public List<IModuleSpecificationPart> getChildren() {
        ArrayList<IModuleSpecificationPart> children = new ArrayList<IModuleSpecificationPart>();
        children.addAll(this.getEnumerationValueList());
        return children;
    }

    @Override
    public String getTypeID() {
        return "EnumerationAttribute";
    }
}

