/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.menu.actions;

import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.ModuleIdentification;
import com.arcway.cockpit.genericmodule.client.core.permissions.PermissionManager;
import com.arcway.cockpit.genericmodule.client.gui.dataview.DataView;
import com.arcway.cockpit.genericmodule.client.gui.dataview.ViewIDCreator;
import com.arcway.cockpit.genericmodule.client.gui.menu.actions.ParentSelectionDialogueContentProvider;
import com.arcway.cockpit.genericmodule.client.gui.menu.actions.ParentSelectionDialogueLabelProvider;
import com.arcway.cockpit.genericmodule.client.gui.menu.actions.ParentSelectionDialogueSelectionValidator;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.Messages;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.TableTreeDataView;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.itemeditors.ItemEditorManager;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.eclipse.gui.dialogs.UsableElementTreeSelectionDialogue;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class ActionNewItemViaModelElement
extends Action {
    private IModelController modelCtrl;
    private final List<IUniqueElement> uniqueElements;
    private final Shell activeShell;
    private final IWorkbenchPart activePart;
    private final String moduleID;
    private final ObjectType linkedObjectType;
    private final ModuleSpecification moduleSpecification;

    public ActionNewItemViaModelElement(Shell activeShell, IWorkbenchPart activePart, List<IUniqueElement> uniqueElements, String moduleID, ObjectType linkedObjectType) {
        this.activeShell = activeShell;
        this.activePart = activePart;
        this.uniqueElements = uniqueElements;
        this.moduleID = moduleID;
        this.linkedObjectType = linkedObjectType;
        if (uniqueElements.size() > 0) {
            String projectUID = uniqueElements.get(0).getProjectUID();
            this.modelCtrl = GenericModulePlugin.getDefault().getProjectManager(moduleID).getModelController(projectUID);
        }
        this.moduleSpecification = SpecificationProvider.getDefault().getModuleSpecification(moduleID);
    }

    public void run() {
        assert (this.modelCtrl != null);
        DataView dataView = null;
        for (TableTreeDataView view : this.moduleSpecification.getModuleUISpecification().getViewListOfType(TableTreeDataView.class)) {
            dataView = (DataView)this.activePart.getSite().getPage().findView(ViewIDCreator.getViewID(this.moduleID, view));
            if (dataView != null) break;
        }
        ModuleLockManager lockManager = (ModuleLockManager)this.modelCtrl.getLockMgr();
        PermissionManager permissionManager = (PermissionManager)this.modelCtrl.getPermissionMgr();
        ParentSelectionDialogueContentProvider contentProvider = new ParentSelectionDialogueContentProvider(this.modelCtrl, dataView, this.linkedObjectType);
        ParentSelectionDialogueLabelProvider labelProvider = new ParentSelectionDialogueLabelProvider();
        ParentSelectionDialogueSelectionValidator validator = new ParentSelectionDialogueSelectionValidator(this.linkedObjectType, lockManager, permissionManager);
        UsableElementTreeSelectionDialogue parentSelectionDialogue = new UsableElementTreeSelectionDialogue(this.activeShell, (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        parentSelectionDialogue.setValidator((ISelectionStatusValidator)validator);
        parentSelectionDialogue.setAllowMultiple(false);
        parentSelectionDialogue.setDoubleClickSelects(true);
        parentSelectionDialogue.setMessage(Messages.getString("ActionDelegateNewItemViaModelElement.DialogMessage"));
        parentSelectionDialogue.setTitle(Messages.getString("ActionDelegateNewItemViaModelElement.DialogTitle"));
        parentSelectionDialogue.setAutoExpandLevel(3);
        parentSelectionDialogue.setInput(ParentSelectionDialogueContentProvider.INPUT);
        if (parentSelectionDialogue.open() == 0) {
            ArrayList<String> modelElementUIDs = new ArrayList<String>();
            for (IUniqueElement uniqueElement : this.uniqueElements) {
                modelElementUIDs.add(uniqueElement.getUID());
            }
            if (parentSelectionDialogue.getFirstResult() != ParentSelectionDialogueContentProvider.ROOT) {
                GenericModuleData newParent = (GenericModuleData)((Object)parentSelectionDialogue.getFirstResult());
                ItemEditorManager.openEditorForCreatingChildItem((IModelController)this.modelCtrl, (String)ModuleIdentification.getModuleIDForPlatform(this.moduleID), (String)ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, this.linkedObjectType.getObjectTypeID()), (IModuleData)newParent, modelElementUIDs);
            } else {
                ItemEditorManager.openEditorForCreatingRootItem((IModelController)this.modelCtrl, (String)ModuleIdentification.getModuleIDForPlatform(this.moduleID), (String)ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, this.linkedObjectType.getObjectTypeID()), modelElementUIDs);
            }
        }
    }
}

