/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.dataview;

import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.AbstractModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Attribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.CalculatedAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.EnumerationAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.IDAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedFrameDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedModuleDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.SimpleAttribute;
import com.arcway.cockpit.modulelib2.client.core.ProjectMgr;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.search.AbstractModuleSearchStringGenerator;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.frontend.definition.lib.interFace.label.IExpiringFrontendLabel;
import java.util.Collection;

public class SearchStringGenerator
extends AbstractModuleSearchStringGenerator {
    private final String moduleID;
    private final ObjectType objectType;

    public SearchStringGenerator(String moduleID, ObjectType objectType) {
        this.moduleID = moduleID;
        this.objectType = objectType;
    }

    public void appendSearchStringForFixAttributes(StringBuilder searchString, IModuleData item) {
        String separator = "";
        IModelController modelController = this.getProjectManager().getModelController(item.getProjectUID());
        for (Attribute attribute : this.objectType.getAttributeList()) {
            AbstractModuleSpecificationPart linkedAttribute;
            if (attribute instanceof IDAttribute) {
                IDAttribute idAttribute = (IDAttribute)attribute;
                searchString.append(separator);
                searchString.append(item.getAttribute(idAttribute.getAttributeID()).getDisplayStringRepresentation());
                separator = "\n";
            }
            if (attribute instanceof SimpleAttribute) {
                SimpleAttribute simpleAttribute = (SimpleAttribute)attribute;
                searchString.append(separator);
                searchString.append(item.getAttribute(simpleAttribute.getAttributeID()).getDisplayStringRepresentation());
                separator = "\n";
            }
            if (attribute instanceof EnumerationAttribute) {
                EnumerationAttribute enumAttribute = (EnumerationAttribute)attribute;
                searchString.append(separator);
                searchString.append(item.getAttribute(enumAttribute.getAttributeID()).getDisplayStringRepresentation());
                separator = "\n";
            }
            if (attribute instanceof LinkedModuleDataAttribute) {
                linkedAttribute = (LinkedModuleDataAttribute)attribute;
                Collection moduleDataCollection = modelController.getLinkableObjects(item, item.getTypeDescription().getLinkTypeIDForLinkedModuleDataAttribute(((LinkedModuleDataAttribute)linkedAttribute).getAttributeID()));
                if (moduleDataCollection.size() == 1) {
                    IModuleData moduleData = (IModuleData)moduleDataCollection.iterator().next();
                    searchString.append(separator);
                    searchString.append(moduleData.getDisplayRepresentation());
                    separator = "\n";
                } else assert (moduleDataCollection.isEmpty());
            }
            if (attribute instanceof LinkedFrameDataAttribute) {
                linkedAttribute = (LinkedFrameDataAttribute)attribute;
                IExpiringFrontendLabel label = modelController.getPlatformAccessAgent().getLabelOfLinkedFrameDataItem(item, ((LinkedFrameDataAttribute)linkedAttribute).getAttributeID());
                if (label != null && label.getText() != null) {
                    searchString.append(separator);
                    searchString.append(label.getText());
                    separator = "\n";
                }
            }
            if (!(attribute instanceof CalculatedAttribute)) continue;
            CalculatedAttribute calculatedAttribute = (CalculatedAttribute)attribute;
            searchString.append(separator);
            searchString.append(item.getAttribute(calculatedAttribute.getAttributeID()).getDisplayStringRepresentation());
            separator = "\n";
        }
    }

    protected ProjectMgr getProjectManager() {
        return GenericModulePlugin.getDefault().getProjectManager(this.moduleID);
    }
}

