/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.adapter;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EnumerationEntry;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeDate;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeEnumerationNEW;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IModuleUserDefinedAttributeTypesManager;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.GMLinkTypeHelper_Shared;
import com.arcway.cockpit.genericmodule.client.core.datamanagement.ImExGenericModuleData;
import com.arcway.cockpit.genericmodule.client.core.permissions.PermissionManager;
import com.arcway.cockpit.genericmodule.client.gui.adapter.GenericModuleImportableData;
import com.arcway.cockpit.genericmodule.client.gui.adapter.IGenericModuleImportAdapter;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.Messages;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Importer;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ParentType;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.genericmodule.client.messages.description.GenericModuleDataTypeDescription;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.INewIDReceiver;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.dataexchange.ImValue;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.ExportOrImportResult;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.AbstractImporterManager;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.IImportableData;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.RepositorySnippetImporter;
import com.arcway.cockpit.modulelib2.client.messages.CustomModuleAttribute;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.IModuleDataAttribute;
import com.arcway.cockpit.modulelib2.client.messages.attributes.IModuleDataAttributeDiscrete;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeBoolean;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDuration;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeInteger;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeLong;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeNonEmptyString;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeTimestamp;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.lib.java.collectionmaps.CollectionMap;
import com.arcway.lib.java.collectionmaps.ListMap;
import com.arcway.lib.java.collections.CollectionUtils;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.clientadapter.interFace.EXCockpitLockDenied;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.importexport.IRepositorySnippetRO;
import de.plans.lib.eclipse.PlugInClassExtensionFactory;
import de.plans.lib.eclipse.PlugInClassExtensionFactoryException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ImporterManager
extends AbstractImporterManager
implements IExecutableExtension {
    private static final ILogger logger = Logger.getLogger(ImporterManager.class);
    private static final String EXTENSION_POINT_ID = "importer";
    private static final String EXTENSION_KEY_ATTRIBUTE = "ImporterID";
    private static final String EXTENSION_ADAPTER_ATTRIBUTE = "ImportAdapter";
    private PlugInClassExtensionFactory extensionFactory;
    private String moduleID;
    private ModuleSpecification moduleSpecification;
    private GMLinkTypeHelper_Shared linkTypeHelper;
    private Map<String, String> map_importerID_objectTypeID;
    private Map<String, String> map_importerID_parentPath;
    private ExportOrImportResult result;
    private GenericModuleData parentsParent;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.moduleID = SpecificationProvider.getDefault().getModuleID(data);
        this.moduleSpecification = SpecificationProvider.getDefault().getModuleSpecification(this.moduleID);
        this.linkTypeHelper = GMLinkTypeHelper_Shared.getDefault(this.moduleID);
        try {
            this.extensionFactory = new PlugInClassExtensionFactory(false, GenericModulePlugin.getDefault().getBundle().getSymbolicName(), EXTENSION_POINT_ID, EXTENSION_KEY_ATTRIBUTE, EXTENSION_ADAPTER_ATTRIBUTE);
            this.map_importerID_objectTypeID = new HashMap<String, String>();
            this.map_importerID_parentPath = new HashMap<String, String>();
            for (Importer importerSpec : this.moduleSpecification.getModuleUISpecification().getImporterList()) {
                String adapterID = importerSpec.getIdOfAdapter();
                String objectTypeID = importerSpec.getIdOfObjectType();
                String parentPath = importerSpec.getParentPath();
                IGenericModuleImportAdapter importAdapter = null;
                try {
                    importAdapter = (IGenericModuleImportAdapter)this.extensionFactory.create(adapterID);
                }
                catch (PlugInClassExtensionFactoryException plugInClassExtensionFactoryException) {
                    // empty catch block
                }
                if (importAdapter != null) {
                    importAdapter.construct(this.moduleID, objectTypeID);
                    String importerID = String.valueOf(adapterID) + "." + this.moduleID + "." + objectTypeID;
                    this.map_importerID_objectTypeID.put(importerID, objectTypeID);
                    this.map_importerID_parentPath.put(importerID, parentPath);
                    this.putImporter(importerID, importAdapter);
                    continue;
                }
                logger.warn("Couldn't instantiate generic module importer (probably not installed): " + importerSpec.getIdOfAdapter());
            }
        }
        catch (PlugInClassExtensionFactoryException e) {
            logger.error("Couldn't find generic module exporter extension point.", (Throwable)e);
        }
        catch (CoreException e) {
            logger.error("Core exception reading generic module exporter extension point.", (Throwable)e);
        }
    }

    protected void construct() {
    }

    protected IModelController getModelControllerForProject(String projectUID_) {
        return GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(projectUID_);
    }

    private IModuleProjectAgent getProjectAgentForProject(String projectUID_) {
        return GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getProjectAgent(projectUID_);
    }

    protected ExportOrImportResult importData(String projectUID, String importerID, IImportableData dataToBeImported) {
        assert (dataToBeImported instanceof GenericModuleImportableData);
        if (!((GenericModuleImportableData)dataToBeImported).canImport) {
            return new ExportOrImportResult(false, Messages.getString("ImporterManager.ImportAborted"));
        }
        if (((GenericModuleImportableData)dataToBeImported).repositorySnippet != null) {
            return RepositorySnippetImporter.importData((IRepositorySnippetRO)((GenericModuleImportableData)dataToBeImported).repositorySnippet, (IRepositoryInterfaceRO)ProjectMgr.getProjectMgr().getProjectAgent(projectUID).getRepositoryInterface(), (Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        }
        final Map<String, List<ImExGenericModuleData>> mapToBeImported = ((GenericModuleImportableData)dataToBeImported).map_parentItem_childItemsToImport;
        final boolean importEnumsPerID = ((GenericModuleImportableData)dataToBeImported).isUsingIDsForEnumerationValues();
        final IModelController modelController = this.getModelControllerForProject(projectUID);
        IModuleProjectAgent projectAgent = this.getProjectAgentForProject(projectUID);
        String objectTypeID = this.map_importerID_objectTypeID.get(importerID);
        ObjectType objectType = this.moduleSpecification.getModuleDataSpecification().getObjectType(objectTypeID);
        final GenericModuleDataTypeDescription typeDescription = GenericModuleDataTypeDescription.getTypeDescription(this.moduleID, objectType);
        final HashMap<String, GenericModuleData> map_parentName_parent = new HashMap<String, GenericModuleData>();
        for (ParentType parentType : objectType.getParentTypeList()) {
            Collection allParentsOfType = null;
            if (parentType.getParentObjectTypeID().equals("hierarchyroot")) {
                allParentsOfType = CollectionUtils.getTypedCollection((Collection)modelController.getAllRootItems(), GenericModuleData.class);
                allParentsOfType.retainAll(modelController.getAllItems(ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, objectTypeID)));
            } else if (!parentType.getParentObjectTypeID().equals("noparent")) {
                allParentsOfType = CollectionUtils.getTypedCollection((Collection)modelController.getAllItems(ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, parentType.getParentObjectTypeID())), GenericModuleData.class);
            }
            if (allParentsOfType == null) continue;
            for (GenericModuleData parent : allParentsOfType) {
                map_parentName_parent.put(parent.getDisplayRepresentation(), parent);
            }
        }
        final HashMap<String, GenericModuleData> map_itemID_item = new HashMap<String, GenericModuleData>();
        final String idAttributeID = typeDescription.getIDAttribute();
        if (idAttributeID != null) {
            Collection allItems = CollectionUtils.getTypedCollection((Collection)modelController.getAllItems(typeDescription.getTypeID()), GenericModuleData.class);
            for (GenericModuleData item : allItems) {
                map_itemID_item.put(item.getAttribute(idAttributeID).getDisplayStringRepresentation(), item);
            }
        }
        this.result = null;
        this.parentsParent = null;
        final AbstractLockManager lockManager = modelController.getLockMgr();
        final PermissionManager permissionManager = (PermissionManager)modelController.getPermissionMgr();
        final String parentPath = this.map_importerID_parentPath.get(importerID);
        modelController.executeTransaction(new Runnable(){

            @Override
            public void run() {
                boolean skippedAnyItems = false;
                HashSet createdItems = new HashSet();
                HashSet createdLinks = new HashSet();
                ListMap idGenerationTaskMap = new ListMap();
                for (Map.Entry entry : mapToBeImported.entrySet()) {
                    String parentName = (String)entry.getKey();
                    List itemList = (List)entry.getValue();
                    for (ImExGenericModuleData importedItem : itemList) {
                        boolean success;
                        GenericModuleData itemToBeUpdated;
                        String idAttributeValue;
                        if (idAttributeID != null && (idAttributeValue = importedItem.getImportedAttributeValue(idAttributeID)) != null && (itemToBeUpdated = (GenericModuleData)((Object)map_itemID_item.get(idAttributeValue))) != null) {
                            boolean success2 = ImporterManager.updateItem(itemToBeUpdated, importedItem, importEnumsPerID, modelController, lockManager, permissionManager);
                            if (success2) continue;
                            skippedAnyItems = true;
                            continue;
                        }
                        GenericModuleData parent = null;
                        if (parentPath != null && parentPath.length() > 0 && (parent = (GenericModuleData)((Object)map_parentName_parent.get(parentName))) == null) {
                            parent = ImporterManager.this.createNewParent(parentName, parentPath, modelController, lockManager, permissionManager, createdItems, createdLinks);
                            if (parent != null) {
                                map_parentName_parent.put(parentName, parent);
                            } else {
                                skippedAnyItems = true;
                                continue;
                            }
                        }
                        if (success = ImporterManager.this.createNewItem(parent, importedItem, importEnumsPerID, (CollectionMap<IModuleData, INewIDReceiver>)((CollectionMap)idGenerationTaskMap), modelController, lockManager, permissionManager, createdItems, createdLinks)) continue;
                        skippedAnyItems = true;
                    }
                }
                try {
                    ImporterManager.doGenerateNewIDs((CollectionMap<IModuleData, INewIDReceiver>)((CollectionMap)idGenerationTaskMap), (IModuleDataTypeDescription)typeDescription, modelController);
                }
                catch (EXCockpitLockDenied e) {
                    modelController.undoItemCreation(createdItems, createdLinks);
                    skippedAnyItems = true;
                }
                String message = !skippedAnyItems ? null : Messages.getString("ImporterManager.InfoDialog.SkippedItems.Message");
                ImporterManager.this.result = new ExportOrImportResult(true, message);
            }
        });
        return this.result;
    }

    private static boolean updateItem(GenericModuleData itemToBeUpdated, ImExGenericModuleData importedItem, boolean importEnumsPerID, IModelController modelController, AbstractLockManager lockManager, PermissionManager permissionManager) {
        if (importedItem.hasObjectTypeCategoryBeenImported() && !permissionManager.mayEditStructurally(itemToBeUpdated)) {
            return false;
        }
        for (String attributeID : importedItem.getImportedFixAttributeValues().keySet()) {
            if (permissionManager.mayEditAttribute((IModuleData)itemToBeUpdated, attributeID)) continue;
            return false;
        }
        IModuleData parent = modelController.getParent((IModuleData)itemToBeUpdated);
        for (String attributeID : importedItem.getCustomPropertyValues().keySet()) {
            IModuleUserDefinedAttributeTypesManager customPropertiesManager = modelController.getProjectAgent().getModuleUserDefinedAttributeTypesManager();
            if (permissionManager.mayEditAttribute((IModuleData)itemToBeUpdated, parent, customPropertiesManager.getUserDefinedAttributeType(attributeID))) continue;
            return false;
        }
        LockAccess la = lockManager.acquireEditLock((ICockpitProjectData)itemToBeUpdated, false);
        if (!la.hasLock()) {
            la.releaseLocks();
            return false;
        }
        boolean anythingHasChanged = ImporterManager.fillAttributes(itemToBeUpdated, importedItem, importEnumsPerID, modelController, false, null, null, null);
        if (anythingHasChanged) {
            modelController.itemPropertiesModified((IModuleData)itemToBeUpdated, null);
        }
        return true;
    }

    private GenericModuleData createNewParent(String parentName, String parentPath, IModelController modelController, AbstractLockManager lockManager, PermissionManager permissionManager, Collection<IModuleData> createdItems, Collection<EOLink> createdLinks) {
        String[] parentPathArray = parentPath.split("/");
        if (this.parentsParent == null) {
            GenericModuleData grandParent = null;
            int parentPathIndex = 0;
            while (parentPathIndex < parentPathArray.length - 1) {
                ObjectType parentObjectType = this.moduleSpecification.getModuleDataSpecification().getObjectType(parentPathArray[parentPathIndex]);
                if (parentObjectType != null) {
                    String name = Messages.getString("ImporterManager.ImportedDataFolderName");
                    GenericModuleDataTypeDescription parentTypeDescription = GenericModuleDataTypeDescription.getTypeDescription(this.moduleID, parentObjectType);
                    if (parentObjectType.getLabelAttributeID().equals(parentTypeDescription.getIDAttribute())) {
                        try {
                            name = ImporterManager.generateItemsUniqueID_immediateGeneration((IModuleDataTypeDescription)parentTypeDescription, name, grandParent, modelController, lockManager);
                        }
                        catch (EXCockpitLockDenied e) {
                            return null;
                        }
                    }
                    if ((grandParent = this.createChildItemAfterCheckingPermissionsAndLocks(grandParent, name, parentObjectType, modelController, lockManager, permissionManager, createdItems, createdLinks)) == null) {
                        return null;
                    }
                } else {
                    return null;
                }
                ++parentPathIndex;
            }
            this.parentsParent = grandParent;
        }
        if (parentName == null) {
            return this.parentsParent;
        }
        ObjectType parentObjectType = this.moduleSpecification.getModuleDataSpecification().getObjectType(parentPathArray[parentPathArray.length - 1]);
        if (parentObjectType != null) {
            String name = parentName;
            GenericModuleDataTypeDescription parentTypeDescription = GenericModuleDataTypeDescription.getTypeDescription(this.moduleID, parentObjectType);
            if (parentObjectType.getLabelAttributeID().equals(parentTypeDescription.getIDAttribute())) {
                try {
                    name = ImporterManager.generateItemsUniqueID_immediateGeneration((IModuleDataTypeDescription)parentTypeDescription, name, this.parentsParent, modelController, lockManager);
                }
                catch (EXCockpitLockDenied e) {
                    return null;
                }
            }
            return this.createChildItemAfterCheckingPermissionsAndLocks(this.parentsParent, name, parentObjectType, modelController, lockManager, permissionManager, createdItems, createdLinks);
        }
        return null;
    }

    private static String generateItemsUniqueID_immediateGeneration(IModuleDataTypeDescription itemTypeDescription, String wishedID, GenericModuleData parent, IModelController modelController, AbstractLockManager lockManager) throws EXCockpitLockDenied {
        if (ImporterManager.isWishedIDUnique(itemTypeDescription, wishedID, modelController, lockManager)) {
            return wishedID;
        }
        return modelController.generateNewID(itemTypeDescription, 0, (IModuleData)parent, true, null);
    }

    private static boolean generateItemsUniqueID_bulkGeneration(final GenericModuleData item, String wishedID, GenericModuleData parent, CollectionMap<IModuleData, INewIDReceiver> idGenerationTaskMap, final IModelController modelController, AbstractLockManager lockManager) {
        if (wishedID != null && wishedID.trim().length() > 0 && ImporterManager.isWishedIDUnique(item.getTypeDescription(), wishedID, modelController, lockManager)) {
            return item.getAttribute(item.getTypeDescription().getIDAttribute()).setValueViaDisplayStringRepresentation(wishedID).hasValueChanged();
        }
        idGenerationTaskMap.add((Object)parent, (Object)new INewIDReceiver(){

            public void setNewID(String newID) {
                item.getAttribute(item.getTypeDescription().getIDAttribute()).setValueViaDisplayStringRepresentation(newID);
                modelController.itemPropertiesModified((IModuleData)item, null);
            }

            public void setLock(LockAccess lock) {
            }
        });
        return false;
    }

    private static boolean isWishedIDUnique(IModuleDataTypeDescription itemTypeDescription, String wishedID, IModelController modelController, AbstractLockManager lockManager) {
        if (modelController.getItemByID(itemTypeDescription.getTypeID(), wishedID) == null) {
            LockAccess la = lockManager.acquireUniqueIDLock(wishedID, itemTypeDescription.getTypeID());
            if (!la.hasLock()) {
                la.releaseLocks();
                return false;
            }
            return true;
        }
        return false;
    }

    private GenericModuleData createChildItemAfterCheckingPermissionsAndLocks(GenericModuleData parent, String name, ObjectType objectType, IModelController modelController, AbstractLockManager lockManager, PermissionManager permissionManager, Collection<IModuleData> createdItems, Collection<EOLink> createdLinks) {
        IStatus status;
        LockAccess la;
        if (parent != null ? !permissionManager.mayCreateChildItemsBelow(parent, objectType.getObjectTypeID()) : !permissionManager.mayCreateRootItemsOfType(objectType.getObjectTypeID())) {
            return null;
        }
        if (parent != null && !(la = lockManager.acquireInsertLock((ICockpitProjectData)parent, false)).hasLock()) {
            la.releaseLocks();
            return null;
        }
        GenericModuleData childItem = new GenericModuleData(this.moduleID, objectType, parent == null);
        childItem.setProjectUID(modelController.getProjectUID());
        if (name != null) {
            childItem.setDisplayRepresentation(name);
        }
        modelController.addItem((IModuleData)childItem);
        createdItems.add((IModuleData)childItem);
        if (parent != null && (status = modelController.createLink(parent.getUID(), (IModuleData)childItem, this.linkTypeHelper.getHierarchyLinkTypeID(parent.getTypeID(), childItem.getTypeID()))).isOK()) {
            createdLinks.add(new EOLink(parent.getProjectUID(), parent.getUID(), childItem.getUID(), "", this.linkTypeHelper.getHierarchyLinkTypeID(parent.getTypeID(), childItem.getTypeID())));
        }
        return childItem;
    }

    private boolean createNewItem(GenericModuleData parent, ImExGenericModuleData importedItem, boolean importEnumsPerID, CollectionMap<IModuleData, INewIDReceiver> idGenerationTaskMap, IModelController modelController, AbstractLockManager lockManager, PermissionManager permissionManager, Collection<IModuleData> createdItems, Collection<EOLink> cretedLinks) {
        GenericModuleData newItem = this.createChildItemAfterCheckingPermissionsAndLocks(parent, null, this.moduleSpecification.getModuleDataSpecification().getObjectType(importedItem.getObjectTypeID()), modelController, lockManager, permissionManager, createdItems, cretedLinks);
        if (newItem != null) {
            ImporterManager.fillAttributes(newItem, importedItem, importEnumsPerID, modelController, true, idGenerationTaskMap, parent, lockManager);
            modelController.itemPropertiesModified((IModuleData)newItem, null);
            return true;
        }
        return false;
    }

    private static boolean fillAttributes(GenericModuleData item, ImExGenericModuleData importedItem, boolean importEnumsPerID, IModelController modelController, boolean hasToFillIDAttributeWithUniqueValue, CollectionMap<IModuleData, INewIDReceiver> idGenerationTaskMap, GenericModuleData parent, AbstractLockManager lockManager) {
        boolean anythingHasChanged = false;
        if (importedItem.hasObjectTypeCategoryBeenImported()) {
            item.setCategoryID(importedItem.getImportedObjectTypeCategoryID());
            anythingHasChanged = true;
        }
        boolean idAttributeSet = false;
        for (String attributeID : importedItem.getImportedFixAttributeValues().keySet()) {
            IRepositoryObjectReference itemToBeLinked;
            block33: {
                String linkedCockpitTypeID;
                ImValue value;
                block32: {
                    block29: {
                        IModuleData itemToBeLinked2;
                        String linkTypeID;
                        block31: {
                            String linkedAttributeTypeID;
                            block30: {
                                value = importedItem.getImportedFixAttributeValues().get(attributeID);
                                IModuleDataAttribute attribute = item.getAttribute(attributeID);
                                if (attribute instanceof IModuleDataAttributeDiscrete) {
                                    if (importEnumsPerID) {
                                        if (value.getValueAsID() == null) continue;
                                        anythingHasChanged |= attribute.setValueViaUniqueStringRepresentation(value.getValueAsID().toString());
                                        continue;
                                    }
                                    if (value.getValueAsString() == null) continue;
                                    anythingHasChanged |= attribute.setValueViaDisplayStringRepresentation(value.getValueAsString()).hasValueChanged();
                                    continue;
                                }
                                if (attribute != null) {
                                    String effectiveValue = value.getValueAsString();
                                    if (hasToFillIDAttributeWithUniqueValue && attributeID.equals(item.getTypeDescription().getIDAttribute())) {
                                        idAttributeSet = true;
                                        anythingHasChanged |= ImporterManager.generateItemsUniqueID_bulkGeneration(item, effectiveValue, parent, idGenerationTaskMap, modelController, lockManager);
                                        continue;
                                    }
                                    if (attribute instanceof ModuleDataAttributeTimestamp) {
                                        if (effectiveValue.length() > 0) {
                                            anythingHasChanged |= ((ModuleDataAttributeTimestamp)attribute).setValueViaDisplayStringRepresentation(effectiveValue, modelController.getProjectLanguage()).hasValueChanged();
                                            continue;
                                        }
                                        anythingHasChanged |= ((ModuleDataAttributeTimestamp)attribute).setValueViaUniqueStringRepresentation(null);
                                        continue;
                                    }
                                    if (attribute instanceof ModuleDataAttributeNonEmptyString) {
                                        String valueToBeSet = effectiveValue != null && effectiveValue.trim().length() > 0 ? effectiveValue : "[" + Messages.getString("ImporterManager.ReplacementValue.EmptyStringImported", modelController.getProjectLanguage()) + "]";
                                        anythingHasChanged |= attribute.setValueViaDisplayStringRepresentation(valueToBeSet).hasValueChanged();
                                        continue;
                                    }
                                    if (effectiveValue.length() == 0 && attribute instanceof ModuleDataAttributeBoolean) {
                                        anythingHasChanged |= attribute.setValueViaUniqueStringRepresentation("false");
                                        continue;
                                    }
                                    if (effectiveValue.length() == 0 && (attribute instanceof ModuleDataAttributeDuration || attribute instanceof ModuleDataAttributeInteger || attribute instanceof ModuleDataAttributeLong)) {
                                        anythingHasChanged |= attribute.setValueViaUniqueStringRepresentation("0");
                                        continue;
                                    }
                                    anythingHasChanged |= attribute.setValueViaDisplayStringRepresentation(effectiveValue).hasValueChanged();
                                    continue;
                                }
                                if (!item.getTypeDescription().isLinkedModuleDataAttribute(attributeID)) break block29;
                                linkTypeID = item.getTypeDescription().getLinkTypeIDForLinkedModuleDataAttribute(attributeID);
                                linkedAttributeTypeID = item.getTypeDescription().getModuleDataTypeIDForLinkedModuleDataAttribute(attributeID);
                                itemToBeLinked2 = null;
                                if (!importEnumsPerID) break block30;
                                if (value.getValueAsID().equals("")) break block31;
                                itemToBeLinked2 = modelController.getItem(linkedAttributeTypeID, (String)value.getValueAsID());
                                break block31;
                            }
                            if (!value.getValueAsString().equals("")) {
                                Collection allLinkableAttributes = modelController.getAllItems(linkedAttributeTypeID);
                                for (IModuleData potentialAttribute : allLinkableAttributes) {
                                    if (!potentialAttribute.getDisplayRepresentation().equals(value.getValueAsString())) continue;
                                    itemToBeLinked2 = potentialAttribute;
                                    break;
                                }
                            }
                        }
                        IModuleData currentlyLinkedItem = null;
                        Collection currentlyLinkedItemCollection = modelController.getLinkableObjects((IModuleData)item, linkTypeID);
                        if (!currentlyLinkedItemCollection.isEmpty()) {
                            assert (currentlyLinkedItemCollection.size() == 1);
                            currentlyLinkedItem = (IModuleData)currentlyLinkedItemCollection.iterator().next();
                        }
                        if (!(currentlyLinkedItem == null && itemToBeLinked2 != null || currentlyLinkedItem != null && itemToBeLinked2 == null) && (currentlyLinkedItem == null || itemToBeLinked2 == null || currentlyLinkedItem.getUID().equals(itemToBeLinked2.getUID()))) continue;
                        if (currentlyLinkedItem != null) {
                            modelController.deleteLink(currentlyLinkedItem.getUID(), item.getUID(), linkTypeID);
                        }
                        if (itemToBeLinked2 != null) {
                            modelController.createLink(itemToBeLinked2.getUID(), (IModuleData)item, linkTypeID);
                        }
                        anythingHasChanged = true;
                        continue;
                    }
                    if (!item.getTypeDescription().isLinkedFrameDataAttribute(attributeID)) continue;
                    linkedCockpitTypeID = item.getTypeDescription().getFrameDataTypeIDForLinkedFrameDataAttribute(attributeID);
                    itemToBeLinked = null;
                    if (!importEnumsPerID) break block32;
                    if (value.getValueAsID() == null || value.getValueAsID().equals("")) break block33;
                    itemToBeLinked = (IRepositoryObjectReference)value.getValueAsID();
                    break block33;
                }
                if (!value.getValueAsString().equals("")) {
                    Collection allLinkableAttributes = modelController.getPlatformAccessAgent().getAllFrameDataItems(linkedCockpitTypeID);
                    for (IRepositoryObjectReference potentialAttribute : allLinkableAttributes) {
                        if (!modelController.getPlatformAccessAgent().getLabelForPlatformObject(potentialAttribute).getText().equals(value.getValueAsString())) continue;
                        itemToBeLinked = potentialAttribute;
                        break;
                    }
                }
            }
            anythingHasChanged |= modelController.getPlatformAccessAgent().changeLinkToFrameItem((IModuleData)item, attributeID, itemToBeLinked).hasValueChanged();
        }
        if (hasToFillIDAttributeWithUniqueValue && item.getTypeDescription().getIDAttribute() != null && !idAttributeSet) {
            anythingHasChanged |= ImporterManager.generateItemsUniqueID_bulkGeneration(item, null, parent, idGenerationTaskMap, modelController, lockManager);
        }
        IModuleUserDefinedAttributeTypesManager customPropertiesManager = modelController.getProjectAgent().getModuleUserDefinedAttributeTypesManager();
        for (String attributeID : importedItem.getCustomPropertyValues().keySet()) {
            ImValue value = (ImValue)importedItem.getCustomPropertyValues().get(attributeID);
            IAttributeType customPropertyType = customPropertiesManager.getUserDefinedAttributeType(attributeID);
            IAttributeTypeDataType customPropertyDataType = customPropertyType.getDataType();
            IAttribute oldCustomProperty = item.getCustomAttribute(customPropertyType);
            Object newValue = null;
            boolean problemDeterminingCustomPropertyValue = false;
            if (!(customPropertyDataType instanceof DataTypeEnumerationNEW)) {
                newValue = customPropertyDataType instanceof DataTypeDate ? ((DataTypeDate)customPropertyDataType).getAttributeValueFromString(value.getValueAsString(), modelController.getProjectLanguage()) : customPropertyDataType.getAttributeValueFromString(value.getValueAsString(), null, null);
            } else if (importEnumsPerID) {
                if (value.getValueAsID() != null && ((String)value.getValueAsID()).length() > 0) {
                    List possibleValues = CollectionUtils.getTypedList((List)((List)customPropertyType.getValueRange().getValueRange()), EnumerationEntry.class);
                    boolean matchingValueFound = false;
                    for (EnumerationEntry entry : possibleValues) {
                        if (!entry.getID().equals(value.getValueAsID().toString())) continue;
                        newValue = Collections.singletonList(entry);
                        matchingValueFound = true;
                        break;
                    }
                    problemDeterminingCustomPropertyValue = !matchingValueFound;
                } else {
                    newValue = Collections.EMPTY_LIST;
                }
            } else {
                newValue = customPropertyDataType.getAttributeValueFromString(value.getValueAsString(), customPropertyType.getValueRange(), null);
            }
            if (!problemDeterminingCustomPropertyValue) {
                Object oldValue;
                Object object = oldValue = oldCustomProperty != null ? oldCustomProperty.getAttributeValue() : null;
                if (!(oldValue == null && newValue != null || oldValue != null && newValue == null) && (oldValue == null || newValue == null || oldValue.equals(newValue))) continue;
                CustomModuleAttribute newCustomProperty = new CustomModuleAttribute(customPropertyType.getAttributeTypeID(), newValue);
                customPropertyType.getDataType().notifyAboutValueNotBeeingInUseAnymore(oldValue);
                customPropertyType.getDataType().notifyAboutValueBeeingInUse(newValue);
                item.setCustomAttribute(customPropertyType, newCustomProperty);
                anythingHasChanged = true;
                continue;
            }
            logger.warn("Generic Module Excel Importer: Could not import custom property value: " + value.getValueAsString() + " for " + customPropertyType.getHumanReadableID());
        }
        return anythingHasChanged;
    }

    private static void doGenerateNewIDs(CollectionMap<IModuleData, INewIDReceiver> idGenerationTaskMap, IModuleDataTypeDescription typeDescription, IModelController modelController) throws EXCockpitLockDenied {
        modelController.generateNewIDs(idGenerationTaskMap, typeDescription, 0, true, false);
    }
}

