/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frameserverproxy.menu.handlers;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.dialogs.ServerPropertiesDialog;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.planeditors.IExternalPlanEditorControllerExtension;
import com.arcway.cockpit.frame.client.project.planeditors.PlanEditorManager;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.shared.message.EOServer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class CHServerProperties
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell;
        String projectUID;
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        String activePartID = HandlerUtil.getActivePartId((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        ServerConnection serverConnection = null;
        if (activePartID.equals("com.arcway.planagent.planeditor")) {
            IExternalPlanEditorControllerExtension controllerExtension = PlanEditorManager.findPlanEditorControllerExtensionInAllProjects((IEditorPart)((IEditorPart)activePart));
            IPlan plan = controllerExtension.getPlan();
            projectUID = plan.getProjectUID();
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
            String serverID = projectAgent.getServerID();
            serverConnection = ProjectMgr.getProjectMgr().getServerConnectionByServerID(serverID);
        } else if (selection instanceof IStructuredSelection) {
            Object o = ((IStructuredSelection)selection).getFirstElement();
            if (o instanceof ServerConnection) {
                serverConnection = (ServerConnection)o;
            } else if (o instanceof IFrameProjectAgent) {
                IFrameProjectAgent projectAgent = (IFrameProjectAgent)o;
                String serverID = projectAgent.getServerID();
                serverConnection = ProjectMgr.getProjectMgr().getServerConnectionByServerID(serverID);
            } else if (o instanceof ICockpitProjectData) {
                ICockpitProjectData projectData = (ICockpitProjectData)o;
                projectUID = projectData.getProjectUID();
                ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
                String serverID = projectAgent.getServerID();
                serverConnection = ProjectMgr.getProjectMgr().getServerConnectionByServerID(serverID);
            }
        }
        if (serverConnection != null && (shell = HandlerUtil.getActiveShell((ExecutionEvent)event)) != null) {
            EOServer server = serverConnection.getServerData();
            ServerPropertiesDialog dialog = new ServerPropertiesDialog(server, shell, 2);
            dialog.open();
        }
        return null;
    }
}

