/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frameserverproxy.gui.dump;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.ServerPermissionChecker;
import com.arcway.cockpit.frame.client.project.Project;
import com.arcway.cockpit.frame.client.project.ProjectAttributeTypeProvider;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.MigrationManager;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttribute;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttributeTypeID;
import com.arcway.cockpit.frameserverproxy.client.dump.DumpManager;
import com.arcway.cockpit.frameserverproxy.gui.dump.DumpAnalyser;
import com.arcway.cockpit.frameserverproxy.gui.dump.ProjectRestoreOptionsPage;
import com.arcway.cockpit.frameserverproxy.gui.dump.ProjectSelectionPage;
import com.arcway.cockpit.frameserverproxy.gui.dump.ServerSelectionPage;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.eclipse.gui.dialogs.ArcwayWizardDialog;
import com.arcway.lib.eclipse.gui.dialogs.IArcwayWizard;
import com.arcway.lib.eclipse.gui.dialogs.wizardpages.FileSelectionPage;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.primitiveTypes.EOString;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.client.dialogs.swt.ExceptionDialog;
import de.plans.psc.shared.DumpFileAccessException;
import de.plans.psc.shared.DumpFileHasInvalidFileTypeException;
import de.plans.psc.shared.serverexceptions.EXMessageException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class RestoreProjectWizard
extends Wizard
implements IArcwayWizard {
    private static final ILogger LOGGER = Logger.getLogger(RestoreProjectWizard.class);
    private static final String PAGE_ID_ServerSelectionPage = "RestoreProjectWizard-ServerSelectionPage";
    private static final String PAGE_ID_FileSelectionPage = "RestoreProjectWizard-FileSelectionPage";
    private static final String PAGE_ID_ProjectSelectionPage = "RestoreProjectWizard-ProjectSelectionPage";
    private static final String PAGE_ID_ProjectRestoreOptionsPage = "RestoreProjectWizard-ProjectRestoreOptionsPage";
    private final DumpManager dumpManager;
    private final ServerSelectionPage serverSelectionPage;
    private final FileSelectionPage fileSelectionPage;
    private final ProjectSelectionPage projectSelectionPage;
    private final ProjectRestoreOptionsPage projectRestoreOptionsPage;
    private final ServerConnection[] serverConnections;
    private ServerConnection selectedServerConnection;
    private File selectedDumpFile;
    private DumpAnalyser dumpAnalysisData;
    private EOProject selectedProject;
    private IProjectRestoreJob restoreJob;

    public RestoreProjectWizard(List<ServerConnection> serverConnections, DumpManager dumpManager) {
        this.setWindowTitle(Messages.getString((String)"RestoreProjectWizard.WindowTitle"));
        this.dumpManager = dumpManager;
        this.serverSelectionPage = new ServerSelectionPage(PAGE_ID_ServerSelectionPage);
        this.addPage((IWizardPage)this.serverSelectionPage);
        this.fileSelectionPage = new FileSelectionPage(Messages.getString((String)"RestoreProjectWizard.FileSelectionPage.Title"), Messages.getString((String)"RestoreProjectWizard.FileSelectionPage.Message"), Arrays.asList("zip"), true, false, true, PAGE_ID_FileSelectionPage);
        this.addPage((IWizardPage)this.fileSelectionPage);
        this.projectSelectionPage = new ProjectSelectionPage(PAGE_ID_ProjectSelectionPage);
        this.addPage((IWizardPage)this.projectSelectionPage);
        this.projectRestoreOptionsPage = new ProjectRestoreOptionsPage(PAGE_ID_ProjectRestoreOptionsPage);
        this.addPage((IWizardPage)this.projectRestoreOptionsPage);
        this.serverConnections = serverConnections.toArray(new ServerConnection[serverConnections.size()]);
    }

    public IWizardPage getStartingPage() {
        if (this.serverConnections.length > 1 || this.serverConnections.length == 1 && ServerConnectionVerifier.SingleInstance.isServerConnectionSuitable(this.serverConnections[0], false) != null) {
            this.serverSelectionPage.reinit(ServerConnectionVerifier.SingleInstance, this.serverConnections);
            return this.serverSelectionPage;
        }
        if (this.serverConnections.length == 1) {
            this.selectedServerConnection = this.serverConnections[0];
            return this.fileSelectionPage;
        }
        assert (false);
        this.selectedServerConnection = null;
        return null;
    }

    public void nextPageRequested() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == this.serverSelectionPage) {
            this.selectedServerConnection = this.serverSelectionPage.getSelectedServerConnection();
        } else if (currentPage == this.fileSelectionPage) {
            if (this.dumpAnalysisData != null && !this.dumpAnalysisData.getInputDumpFile().equals(this.selectedDumpFile)) {
                this.dumpAnalysisData.dispose();
                this.dumpAnalysisData = null;
                this.selectedProject = null;
            }
            this.selectedDumpFile = new File(this.fileSelectionPage.getFileName());
            if (this.dumpAnalysisData == null || !this.dumpAnalysisData.getInputDumpFile().equals(this.selectedDumpFile)) {
                MessageDialog messageDialogue = null;
                try {
                    messageDialogue = MigrationManager.startWaitDialogue((Shell)this.getShell());
                    String dumpType = DumpAnalyser.guessDumpType(this.selectedDumpFile);
                    if (dumpType == null) {
                        dumpType = "cockpit.project-dump";
                    }
                    this.dumpAnalysisData = new DumpAnalyser(this.selectedDumpFile, dumpType);
                }
                finally {
                    MigrationManager.stopWaitDialogue((MessageDialog)messageDialogue);
                }
                if (this.dumpAnalysisData.getDumpType() == null) {
                    this.showNotAUseableDumpFileDialog();
                } else if ("cockpit.project-dump".equals(this.dumpAnalysisData.getDumpType())) {
                    this.selectedProject = this.dumpAnalysisData.getProjects()[0];
                    this.projectSelectionPage.reinit(this.dumpAnalysisData.getProjects());
                    this.projectRestoreOptionsPage.reinit(Project.getProjectName((EOProject)this.selectedProject), new ProjectNameValidator(this.selectedServerConnection));
                } else if ("psc.server-dump".equals(this.dumpAnalysisData.getDumpType())) {
                    this.projectSelectionPage.reinit(this.dumpAnalysisData.getProjects());
                } else assert (false);
            }
        } else if (currentPage == this.projectSelectionPage) {
            this.selectedProject = this.projectSelectionPage.getSelectedProject();
            this.projectRestoreOptionsPage.reinit(Project.getProjectName((EOProject)this.selectedProject), new ProjectNameValidator(this.selectedServerConnection));
        } else if (currentPage != this.projectRestoreOptionsPage) assert (false);
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        assert (currentPage == this.getContainer().getCurrentPage());
        if (currentPage == this.serverSelectionPage) {
            if (this.selectedServerConnection == null || !this.selectedServerConnection.isConnected()) {
                return this.serverSelectionPage;
            }
            return this.fileSelectionPage;
        }
        if (currentPage == this.fileSelectionPage) {
            if (this.dumpAnalysisData != null) {
                if (this.dumpAnalysisData.getDumpType() == null) {
                    return this.fileSelectionPage;
                }
                if ("cockpit.project-dump".equals(this.dumpAnalysisData.getDumpType())) {
                    return this.projectRestoreOptionsPage;
                }
                if ("psc.server-dump".equals(this.dumpAnalysisData.getDumpType())) {
                    return this.projectSelectionPage;
                }
                assert (false);
                return currentPage;
            }
            return this.projectSelectionPage;
        }
        if (currentPage == this.projectSelectionPage) {
            return this.projectRestoreOptionsPage;
        }
        if (currentPage == this.projectRestoreOptionsPage) {
            return null;
        }
        assert (false);
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage currentPage) {
        assert (currentPage == this.getContainer().getCurrentPage());
        if (currentPage == this.serverSelectionPage) {
            return null;
        }
        if (currentPage == this.fileSelectionPage) {
            if (this.serverConnections.length > 1) {
                return this.serverSelectionPage;
            }
            return null;
        }
        if (currentPage == this.projectSelectionPage) {
            return this.fileSelectionPage;
        }
        if (currentPage == this.projectRestoreOptionsPage) {
            if (this.dumpAnalysisData != null && this.dumpAnalysisData.getProjects().length > 1) {
                return this.projectSelectionPage;
            }
            return this.fileSelectionPage;
        }
        assert (false);
        return currentPage;
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() == this.projectRestoreOptionsPage && this.projectRestoreOptionsPage.isPageComplete()) {
            if (!ServerPermissionChecker.mayCreateProjects((String)this.selectedServerConnection.getServerID(), (boolean)false)) {
                this.projectRestoreOptionsPage.setErrorMessage(Messages.getString((String)"RestoreProjectWizard.You_have_no_permission_to_create_projects_on_this_server"));
                return false;
            }
            this.projectRestoreOptionsPage.setErrorMessage(null);
            return true;
        }
        return false;
    }

    public boolean performFinish() {
        if (this.projectRestoreOptionsPage != this.getContainer().getCurrentPage() || !this.projectRestoreOptionsPage.isPageComplete()) {
            return false;
        }
        if (!ServerPermissionChecker.mayCreateProjects((String)this.selectedServerConnection.getServerID(), (boolean)false)) {
            return false;
        }
        try {
            EOProject eoProject;
            File dumpFile;
            MessageDialog messageDialogue = null;
            try {
                messageDialogue = MigrationManager.startWaitDialogue((Shell)this.getShell());
                dumpFile = this.dumpAnalysisData.getProjectDumpFile(this.selectedProject);
            }
            finally {
                MigrationManager.stopWaitDialogue((MessageDialog)messageDialogue);
            }
            ProjectRestoreOptionsPage.RestoreOptions restoreOptions = this.projectRestoreOptionsPage.getRestoreOptions();
            if (restoreOptions.getRestoreIdentity() == ProjectRestoreOptionsPage.RestoreOptions.RestoreIdentity.AsNew) {
                eoProject = new EOProject();
                eoProject.setUID(UUIDGenerator.getUniqueID());
                EOString eoName = new EOString(restoreOptions.getProjectName());
                EOAttributeTypeID nameAttributeTypeID = new EOAttributeTypeID(ProjectAttributeTypeProvider.ATTRID_NAME.getUID(), "name");
                EOAttribute nameAttribute = new EOAttribute();
                nameAttribute.setAttributeTypeID(nameAttributeTypeID);
                nameAttribute.setValueAsEO((EOEncodableObject)eoName);
                eoProject.addAttribute(nameAttribute);
            } else {
                eoProject = null;
            }
            final IProjectManagerServerProxy serverProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(this.selectedServerConnection.getServerID());
            this.restoreJob = new IProjectRestoreJob(){

                @Override
                public void run(Shell shell) {
                    try {
                        boolean success = serverProxy.restoreProject(eoProject, dumpFile, shell);
                        try {
                            FileHelper.deleteFileOrDirectory((File)dumpFile);
                        }
                        catch (JvmExternalResourceInteractionException e) {
                            LOGGER.debug("Unable to delete obsolete ProjectDumpTempFile ", (Throwable)e);
                        }
                        if (success) {
                            MessageDialog.openInformation((Shell)shell, (String)Messages.getString((String)"RestoreProjectWizard.ProjectRestoredSuccessfully.Title"), (String)Messages.getString((String)"RestoreProjectWizard.ProjectRestoredSuccessfully.Message"));
                        }
                    }
                    catch (ServerNotAvailableException e) {
                        LOGGER.warn((Throwable)e);
                        ExceptionDialog exDialog = new ExceptionDialog(shell, (Throwable)e);
                        exDialog.open();
                    }
                    catch (EXServerException e) {
                        LOGGER.warn((Throwable)e);
                        if (e instanceof EXMessageException && e.getId().equals("InvalidDumpFormatVersion")) {
                            RestoreProjectWizard.this.dumpManager.showIncompatibleDumpErrorMessage(shell);
                        } else {
                            ExceptionDialog exDialog = new ExceptionDialog(shell, e);
                            exDialog.open();
                        }
                    }
                    catch (LoginCanceledException e) {
                    }
                    catch (UnknownServerException e) {
                        LOGGER.warn((Throwable)e);
                        ExceptionDialog exDialog = new ExceptionDialog(shell, (Throwable)e);
                        exDialog.open();
                    }
                }
            };
        }
        catch (DumpFileHasInvalidFileTypeException dhiftE) {
            LOGGER.warn((Throwable)dhiftE);
            this.dumpManager.showInvalidDumpFileTypeErrorMessage(true, this.getShell());
        }
        catch (DumpFileAccessException dfaE) {
            LOGGER.warn((Throwable)dfaE);
            this.dumpManager.showInvalidDumpErrorMessage(this.getShell());
        }
        catch (MigrationFailedException mfE) {
            LOGGER.warn((Throwable)mfE);
            this.dumpManager.showInvalidDumpErrorMessage(this.getShell());
        }
        return true;
    }

    public void dispose() {
        if (this.dumpAnalysisData != null) {
            this.dumpAnalysisData.dispose();
        }
    }

    public IProjectRestoreJob getRestoreJob() {
        return this.restoreJob;
    }

    public static void executeRestoreProjectWizard(Shell parentShell, List<ServerConnection> serverConnections, DumpManager dumpManager) {
        RestoreProjectWizard mainExportWizard = new RestoreProjectWizard(serverConnections, dumpManager);
        ArcwayWizardDialog dialog = new ArcwayWizardDialog(parentShell, (IWizard)mainExportWizard);
        dialog.setPageSize(400, 200);
        dialog.open();
        IProjectRestoreJob restoreJob = mainExportWizard.getRestoreJob();
        if (restoreJob != null) {
            restoreJob.run(parentShell);
        }
    }

    private void showNotAUseableDumpFileDialog() {
        MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"RestoreProjectWizard.dumpFileInvalid.title"), (String)Messages.getString((String)"RestoreProjectWizard.dumpFileInvalid.message"));
    }

    public boolean canCancel() {
        return true;
    }

    public boolean canClose() {
        return true;
    }

    public boolean showHelpOnPreventedClose() {
        return false;
    }

    private static interface IProjectRestoreJob {
        public void run(Shell var1);
    }

    private static class ProjectNameValidator
    implements ProjectRestoreOptionsPage.IProjectNameValidator {
        private final ServerConnection serverConnection;
        private final Map<String, Collection<EOProject>> map_server_projects = new HashMap<String, Collection<EOProject>>();

        public ProjectNameValidator(ServerConnection serverConnection) {
            this.serverConnection = serverConnection;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean isEnteredProjectNameValid(String newName, boolean withServerCaching) {
            assert (newName != null) : "newName can't be null";
            try {
                EOProject project;
                Collection<EOProject> projectList;
                if (!withServerCaching || !this.map_server_projects.containsKey(this.serverConnection.getServerID())) {
                    projectList = ProjectMgr.getProjectMgr().getEOProjectsOnServer(this.serverConnection.getServerID());
                    this.map_server_projects.put(this.serverConnection.getServerID(), projectList);
                }
                projectList = this.map_server_projects.get(this.serverConnection.getServerID());
                Iterator<EOProject> iterator = projectList.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    return true;
                } while (!Project.getProjectName((EOProject)(project = iterator.next())).equals(newName));
                return false;
            }
            catch (Exception e) {
                return true;
            }
        }
    }

    private static class ServerConnectionVerifier
    implements ServerSelectionPage.IServerConnectionVerifier {
        public static final ServerConnectionVerifier SingleInstance = new ServerConnectionVerifier();

        private ServerConnectionVerifier() {
        }

        @Override
        public String isServerConnectionSuitable(ServerConnection selectedServerConnection, boolean triggerLogin) {
            if (triggerLogin && selectedServerConnection != null && !selectedServerConnection.isConnected()) {
                ProjectMgr.getProjectMgr().connectToServer(selectedServerConnection.getServerID());
            }
            if (selectedServerConnection == null) {
                assert (false);
                return "<no connection selected>";
            }
            if (!selectedServerConnection.isConnected()) {
                return Messages.getString((String)"RestoreProjectWizard.You_need_to_connected_to_the_server_to_create_projects");
            }
            if (!ServerPermissionChecker.mayCreateProjects((String)selectedServerConnection.getServerID(), (boolean)false)) {
                return Messages.getString((String)"RestoreProjectWizard.You_have_no_permission_to_create_projects_on_this_server");
            }
            return null;
        }
    }
}

