/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frameserverproxy.gui.dump;

import com.arcway.cockpit.frame.client.global.Messages;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ProjectRestoreOptionsPage
extends WizardPage {
    private Button radioBtnAsDumped;
    private Button radioBtnAsNewProject;
    private Text projectName;
    private String originalProjectName;
    private IProjectNameValidator projectNameValidator;
    private RestoreOptions restoreOptions = new RestoreOptions(RestoreOptions.RestoreIdentity.AsDumped, null);

    public ProjectRestoreOptionsPage(String pageID) {
        super(pageID);
        this.reinit("", null);
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.getString((String)"ProjectRestoreOptionsPage.Title"));
        this.setMessage(Messages.getString((String)"ProjectRestoreOptionsPage.Message"));
        Composite detailArea = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        detailArea.setLayoutData((Object)gridData);
        GridLayout topGridLayout = new GridLayout();
        topGridLayout.numColumns = 3;
        detailArea.setLayout((Layout)topGridLayout);
        new Label(detailArea, 0);
        Composite radioBtnGroup = new Composite(detailArea, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        radioBtnGroup.setLayoutData((Object)gridData);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        radioBtnGroup.setLayout((Layout)gl);
        this.radioBtnAsDumped = new Button(radioBtnGroup, 16);
        this.radioBtnAsDumped.setText(Messages.getString((String)"ProjectRestoreOptionsPage.as_dumped"));
        this.radioBtnAsNewProject = new Button(radioBtnGroup, 16);
        this.radioBtnAsNewProject.setText(Messages.getString((String)"ProjectRestoreOptionsPage.as_new_project"));
        new Label(detailArea, 0);
        Label lblProjectName = new Label(detailArea, 0);
        lblProjectName.setText(Messages.getString((String)"ProjectRestoreOptionsPage.Project_name"));
        this.projectName = new Text(detailArea, 2048);
        this.projectName.setLayoutData((Object)new GridData(768));
        this.projectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectRestoreOptionsPage.this.checkValues();
            }
        });
        new Label(detailArea, 0);
        this.reinit(this.originalProjectName, this.projectNameValidator);
        this.radioBtnAsDumped.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectRestoreOptionsPage.this.enableWidgets(RestoreOptions.RestoreIdentity.AsDumped);
            }
        });
        this.radioBtnAsNewProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectRestoreOptionsPage.this.enableWidgets(RestoreOptions.RestoreIdentity.AsNew);
            }
        });
        this.setControl((Control)detailArea);
    }

    private void checkValues() {
        String problemMsg = this.radioBtnAsNewProject.getSelection() && this.projectName.getText().trim().length() == 0 ? Messages.getString((String)"ProjectRestoreOptionsPage.New_project_name_must_not_be_empty") : (this.projectNameValidator != null && !this.projectNameValidator.isEnteredProjectNameValid(this.projectName.getText(), true) ? Messages.getString((String)"ProjectRestoreOptionsPage.A_project_with_the_specified_name_already_exists_on_this_server") : null);
        if (problemMsg == null) {
            this.restoreOptions = this.radioBtnAsNewProject.getSelection() ? new RestoreOptions(RestoreOptions.RestoreIdentity.AsNew, this.projectName.getText()) : new RestoreOptions(RestoreOptions.RestoreIdentity.AsDumped, null);
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(problemMsg);
            this.setPageComplete(false);
        }
    }

    public void reinit(String p_originalProjectName, IProjectNameValidator p_projectNameValidator) {
        this.originalProjectName = p_originalProjectName;
        this.projectNameValidator = p_projectNameValidator;
        if (this.radioBtnAsDumped != null) {
            this.projectName.setText(p_originalProjectName);
            this.enableWidgets(RestoreOptions.RestoreIdentity.AsDumped);
        }
    }

    private void enableWidgets(RestoreOptions.RestoreIdentity restoreIdentity) {
        switch (restoreIdentity) {
            case AsDumped: {
                this.radioBtnAsDumped.setSelection(true);
                this.radioBtnAsNewProject.setSelection(false);
                this.projectName.setText(this.originalProjectName);
                this.projectName.setEditable(false);
                break;
            }
            case AsNew: {
                this.radioBtnAsDumped.setSelection(false);
                this.radioBtnAsNewProject.setSelection(true);
                this.projectName.setEditable(true);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.checkValues();
    }

    public RestoreOptions getRestoreOptions() {
        return this.restoreOptions;
    }

    static interface IProjectNameValidator {
        public boolean isEnteredProjectNameValid(String var1, boolean var2);
    }

    public static class RestoreOptions {
        private final RestoreIdentity restoreIdentity;
        private final String projectName;

        public RestoreOptions(RestoreIdentity restoreIdentity, String projectName) {
            this.restoreIdentity = restoreIdentity;
            this.projectName = projectName;
        }

        public RestoreIdentity getRestoreIdentity() {
            return this.restoreIdentity;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public static enum RestoreIdentity {
            AsDumped,
            AsNew;

        }
    }
}

