/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frameserverproxy.gui.dump;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.lib.io.FileSystemDefaultPaths;
import de.plans.psc.client.communication.ServerConnection;
import java.io.File;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DumpRestoreServerDialog
extends TitleAreaDialog {
    List<ServerConnection> serverConnections;
    private Composite detailArea;
    private org.eclipse.swt.widgets.List serverList;
    private Text dumpFileName;
    private Button btnSelectDumpFile;
    private int selectedServerIndex = -1;
    private File dumpFile;
    boolean useForDump = true;

    public DumpRestoreServerDialog(Shell shell, List<ServerConnection> serverConnections, boolean useForDump) {
        super(shell);
        this.serverConnections = serverConnections;
        this.useForDump = useForDump;
    }

    protected Control createDialogArea(Composite parent) {
        if (this.useForDump) {
            this.setTitle(Messages.getString((String)"DumpRestoreServerDialog.Dump_Server_1"));
            this.setMessage(Messages.getString((String)"DumpRestoreServerDialog.Select_the_server_and_the_dump_file._2"));
        } else {
            this.setTitle(Messages.getString((String)"DumpRestoreServerDialog.Restore_Server_Dump_3"));
            this.setMessage(Messages.getString((String)"DumpRestoreServerDialog.Select_the_target_server_and_the_dump_file_from_which_the_data_shall_be_restored._4"));
        }
        this.detailArea = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        this.detailArea.setLayoutData((Object)gridData);
        GridLayout topGridLayout = new GridLayout();
        topGridLayout.numColumns = 3;
        this.detailArea.setLayout((Layout)topGridLayout);
        Label lblProject = new Label(this.detailArea, 0);
        lblProject.setText(Messages.getString((String)"DumpRestoreServerDialog.Server__5"));
        gridData = new GridData(32);
        gridData = new GridData(2);
        lblProject.setLayoutData((Object)gridData);
        this.serverList = new org.eclipse.swt.widgets.List(this.detailArea, 2564);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.heightHint = 75;
        this.serverList.setLayoutData((Object)gridData);
        for (ServerConnection sc : this.serverConnections) {
            this.serverList.add(sc.getServerName());
        }
        new Label(this.detailArea, 0);
        Label pDumpFile = new Label(this.detailArea, 0);
        pDumpFile.setText(Messages.getString((String)"DumpRestoreServerDialog.Dump_File__6"));
        this.dumpFileName = new Text(this.detailArea, 2052);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.dumpFileName.setLayoutData((Object)gridData);
        this.btnSelectDumpFile = new Button(this.detailArea, 8);
        this.btnSelectDumpFile.setText("...");
        this.btnSelectDumpFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DumpRestoreServerDialog.this.selectFile();
            }
        });
        Composite radioBtnGroup = new Composite(this.detailArea, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        radioBtnGroup.setLayoutData((Object)gridData);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        radioBtnGroup.setLayout((Layout)gl);
        if (this.serverList.getItemCount() == 1) {
            this.serverList.select(0);
        }
        return this.detailArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void selectFile() {
        FileDialog dialog;
        File startDirectory;
        if (this.useForDump) {
            startDirectory = FileSystemDefaultPaths.getDefaultUserPathForSaving();
            dialog = new FileDialog(this.getShell(), 8192);
        } else {
            startDirectory = FileSystemDefaultPaths.getDefaultUserPathForLoading();
            dialog = new FileDialog(this.getShell(), 4096);
        }
        dialog.setText(Messages.getString((String)"DumpRestoreServerDialog.Please_select_the_dump_file._8"));
        dialog.setFilterPath(startDirectory.getAbsolutePath());
        dialog.setFilterExtensions(new String[]{"*.zip"});
        String fileName = dialog.open();
        if (fileName != null) {
            if (fileName.toLowerCase().endsWith(".zip")) {
                this.dumpFileName.setText(fileName);
            } else {
                this.dumpFileName.setText(String.valueOf(fileName) + ".zip");
            }
        }
    }

    private boolean checkValues() {
        if (this.serverList.getSelectionCount() == 0) {
            this.setErrorMessage(Messages.getString((String)"DumpRestoreServerDialog.Please_select_a_server._12"));
            return false;
        }
        if (this.dumpFileName.getText().length() == 0) {
            this.setErrorMessage(Messages.getString((String)"DumpRestoreServerDialog.Please_select_a_dump_file._13"));
            return false;
        }
        return true;
    }

    protected void cancelPressed() {
        this.dumpFile = null;
        this.selectedServerIndex = -1;
        this.setReturnCode(1);
        super.cancelPressed();
    }

    protected void okPressed() {
        if (this.checkValues()) {
            this.selectedServerIndex = this.serverList.getSelectionIndex();
            this.dumpFile = new File(this.dumpFileName.getText());
            this.setReturnCode(0);
            super.okPressed();
        } else {
            this.selectedServerIndex = -1;
            this.dumpFile = null;
            this.setReturnCode(1);
        }
    }

    public ServerConnection getSelectedServerConnection() {
        if (this.selectedServerIndex >= 0 && this.selectedServerIndex < this.serverConnections.size()) {
            return this.serverConnections.get(this.selectedServerIndex);
        }
        return null;
    }

    public File getDumpFile() {
        return this.dumpFile;
    }
}

