/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frameserverproxy.gui.dump;

import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.ProjectDumpFileAccess_ForClient;
import com.arcway.cockpit.frame.client.project.migration.migrators.special.UserAndGroupRenamer;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.cockpit.frameserverproxy.client.ProjectManagerServerProxy;
import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.io.RelativeFilePath;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.util.Zip;
import de.plans.lib.xml.encoding.EOList;
import de.plans.psc.client.dump.DumpFileHelper;
import de.plans.psc.client.dump.ServerDumpFileAccess_ForClient;
import de.plans.psc.shared.DumpFileAccessException;
import de.plans.psc.shared.message.EOVersionFileContent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class DumpAnalyser {
    private static final ILogger LOGGER = Logger.getLogger(DumpAnalyser.class);
    private final File inputDumpFile;
    private String actualDumpType;
    private ServerDumpFileAccess_ForClient serverDumpAccess;
    private ProjectDumpFileAccess_ForClient projectDumpFileAccess;
    private EOList<EOProject> projects;
    private boolean projectDumpFileDelivered = false;

    public DumpAnalyser(File dumpFile, String guessedDumpType) {
        this.inputDumpFile = dumpFile;
        ArrayList<String> analysisSequence = new ArrayList<String>();
        analysisSequence.add("cockpit.project-dump");
        analysisSequence.add("psc.server-dump");
        if (guessedDumpType != null) {
            boolean success = analysisSequence.remove(guessedDumpType);
            assert (success);
            analysisSequence.add(0, guessedDumpType);
        }
        LinkedHashMap<String, Throwable> problemCauses = new LinkedHashMap<String, Throwable>();
        for (String string : analysisSequence) {
            try {
                File serverDumpRootDir;
                if (string.equals("cockpit.project-dump")) {
                    this.projectDumpFileAccess = ProjectManagerServerProxy.doMigrateProjectDumpAndReturnProjectDumpFileAccess(this.inputDumpFile);
                    serverDumpRootDir = this.projectDumpFileAccess.getRootDirectoryOfUnzippedProjectDumpFile();
                    File projectsfile = new File(serverDumpRootDir, "projects.xml");
                    this.projects = UserAndGroupRenamer.readEOListFromFile((File)projectsfile);
                } else {
                    assert (string.equals("psc.server-dump"));
                    this.serverDumpAccess = ProjectManagerServerProxy.doMigrateServerDumpAndReturnServerDumpFileAccess(this.inputDumpFile);
                    serverDumpRootDir = this.serverDumpAccess.getRootDirectoryOfUnzippedServerDumpFile();
                    File frameModuleDirectory = new File(serverDumpRootDir, "COCKPIT_FRAME");
                    File projectsfile = new File(frameModuleDirectory, "projects.xml");
                    this.projects = UserAndGroupRenamer.readEOListFromFile((File)projectsfile);
                }
                this.actualDumpType = string;
                break;
            }
            catch (Throwable e) {
                this.disposeAnalysisResultData();
                problemCauses.put(string, e);
            }
        }
        if (this.actualDumpType == null) {
            LOGGER.debug("Dump could not be read due to the following reasons:");
            for (Map.Entry entry : problemCauses.entrySet()) {
                LOGGER.debug("Attemt to import it as " + (String)entry.getKey() + " failed because: ", (Throwable)entry.getValue());
            }
        }
    }

    private void disposeAnalysisResultData() {
        this.actualDumpType = null;
        if (this.serverDumpAccess != null) {
            this.serverDumpAccess.dispose();
            this.serverDumpAccess = null;
        }
        if (this.projectDumpFileAccess != null) {
            this.projectDumpFileAccess.dispose();
            this.projectDumpFileAccess = null;
        }
        this.projects = null;
    }

    public String getDumpType() {
        return this.actualDumpType;
    }

    public EOProject[] getProjects() {
        assert (this.actualDumpType != null);
        return (EOProject[])this.projects.toArray((Object[])new EOProject[this.projects.size()]);
    }

    public File getProjectDumpFile(EOProject project) throws MigrationFailedException, DumpFileAccessException {
        assert (this.projects.contains((Object)project));
        if (this.projectDumpFileDelivered) {
            assert (false) : "This method is designed to be called at most once for each DumpAnalyser";
            return null;
        }
        this.projectDumpFileDelivered = true;
        File tempFile = null;
        File resultingProjectDumpFile = null;
        try {
            tempFile = this.allocateProjectDumpTempFile();
            if (this.actualDumpType.equals("cockpit.project-dump")) {
                this.projectDumpFileAccess.saveToTarget(tempFile);
                resultingProjectDumpFile = tempFile;
            } else {
                assert (this.actualDumpType.equals("psc.server-dump"));
                ProjectDumpFileAccess_ForClient.extractProjectDump((ServerDumpFileAccess_ForClient)this.serverDumpAccess, (EOProject)project, (File)tempFile);
                resultingProjectDumpFile = tempFile;
            }
        }
        finally {
            if (resultingProjectDumpFile == null && tempFile != null) {
                try {
                    FileHelper.deleteFileOrDirectory((File)tempFile);
                }
                catch (JvmExternalResourceInteractionException e) {
                    LOGGER.debug("Unable to delete incomplete ProjectDumpTempFile ", (Throwable)e);
                }
            }
        }
        return resultingProjectDumpFile;
    }

    private File allocateProjectDumpTempFile() throws MigrationFailedException {
        try {
            File f = SessionTempDirectoryManager.createSessionTempFile((String)de.plans.lib.util.FileHelper.getFileNameWithoutExtension((String)this.inputDumpFile.getName()), (String)("." + FileHelper.getFileExtension((File)this.inputDumpFile)));
            FileHelper.deleteExistingFileOrDirectory((File)f);
            return f;
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            throw new MigrationFailedException("Could not save migrated dump.", (Throwable)jeriE);
        }
    }

    public void dispose() {
        this.disposeAnalysisResultData();
    }

    public File getInputDumpFile() {
        return this.inputDumpFile;
    }

    public static String guessDumpType(File dumpFile) {
        String[] dumpType;
        block17: {
            dumpType = new String[1];
            final SessionTempDirectoryManager.SessionTempDirectory[] tempDirectory = new SessionTempDirectoryManager.SessionTempDirectory[1];
            try {
                try {
                    tempDirectory[0] = SessionTempDirectoryManager.createSessionTempSubDirectory((String)"dumptc");
                    assert ("versions.xml".equals("versions.xml"));
                    final RelativeFilePath versionsfilePath = new RelativeFilePath(new String[]{"versions.xml"});
                    RelativeFilePath projectDumpProjectsFilePath = new RelativeFilePath(new String[]{"projects.xml"});
                    RelativeFilePath serverDumpProjectsFilePath = new RelativeFilePath(new String[]{"COCKPIT_FRAME", "projects.xml"});
                    final HashSet<RelativeFilePath> eligibleFiles = new HashSet<RelativeFilePath>();
                    eligibleFiles.add(versionsfilePath);
                    eligibleFiles.add(projectDumpProjectsFilePath);
                    eligibleFiles.add(serverDumpProjectsFilePath);
                    Zip.unzipMatchingEntriesFromFile((File)dumpFile, (File)tempDirectory[0], (Zip.IZipEntryFilter)new Zip.IZipEntryFilter(){

                        public void provisionedAcceptedFile(RelativeFilePath path) {
                            if (versionsfilePath.equals((Object)path)) {
                                try {
                                    EOVersionFileContent versionFileContent = DumpFileHelper.readVersionsFromFile((File)versionsfilePath.constructFile((File)tempDirectory[0]));
                                    if (versionFileContent != null) {
                                        dumpType[0] = versionFileContent.getFileType();
                                    }
                                }
                                catch (Exception e) {
                                    LOGGER.warn("Problem while evaluating versionFileContent during dump type detection.", (Throwable)e);
                                }
                            }
                        }

                        public boolean proceed() {
                            return dumpType[0] == null;
                        }

                        public boolean accept(RelativeFilePath path) {
                            return eligibleFiles.contains(path);
                        }
                    });
                    if (dumpType[0] == null && serverDumpProjectsFilePath.constructFile((File)tempDirectory[0]).canRead()) {
                        dumpType[0] = "psc.server-dump";
                    }
                    if (dumpType[0] == null && projectDumpProjectsFilePath.constructFile((File)tempDirectory[0]).canRead()) {
                        dumpType[0] = "cockpit.project-dump";
                    }
                }
                catch (Exception e) {
                    dumpType[0] = null;
                    LOGGER.warn("Failed to detect dump type.", (Throwable)e);
                    if (tempDirectory[0] != null) {
                        try {
                            FileHelper.deleteExistingFileOrDirectory((File)tempDirectory[0]);
                        }
                        catch (Exception e2) {
                            LOGGER.error("Unable to delete obsolete temp directory", (Throwable)e2);
                        }
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (tempDirectory[0] != null) {
                    try {
                        FileHelper.deleteExistingFileOrDirectory((File)tempDirectory[0]);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to delete obsolete temp directory", (Throwable)e);
                    }
                }
                throw throwable;
            }
            if (tempDirectory[0] != null) {
                try {
                    FileHelper.deleteExistingFileOrDirectory((File)tempDirectory[0]);
                }
                catch (Exception e) {
                    LOGGER.error("Unable to delete obsolete temp directory", (Throwable)e);
                }
            }
        }
        return dumpType[0];
    }
}

