/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frameserverproxy.gui;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.cockpit.frameserverproxy.gui.Messages;
import com.arcway.lib.eclipse.file.UrlLauncher;
import com.arcway.lib.eclipse.gui.dialogs.FileChooserDialog;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOValue;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.client.dialogs.swt.ExceptionDialog;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOGroup;
import de.plans.psc.shared.message.EOServerResponse;
import de.plans.psc.shared.message.EOUserAndGroupAndPermissions;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ServerLogPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final ILogger logger = Logger.getLogger(ServerLogPreferencePage.class);
    private Button btnDownload;
    private ServerConnection selectedServerConnection;

    protected Control createContents(Composite parent) {
        Group base = new Group(parent, 0);
        base.setLayoutData((Object)new GridData(1808));
        base.setLayout((Layout)new GridLayout());
        base.setText(Messages.getString("ServerLogPreferencePage.select_server"));
        Collection serverConnections = ProjectMgr.getProjectMgr().getConfiguredServerConnections();
        ArrayList sortedConnections = new ArrayList(serverConnections);
        Collections.sort(sortedConnections, new Comparator<ServerConnection>(){

            @Override
            public int compare(ServerConnection sc0, ServerConnection sc1) {
                return sc0.getServerName().compareToIgnoreCase(sc1.getServerName());
            }
        });
        for (final ServerConnection sc : sortedConnections) {
            Button button = new Button((Composite)base, 16);
            button.setLayoutData((Object)new GridData());
            button.setText(sc.getServerName());
            button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ServerLogPreferencePage.this.btnDownload.setEnabled(true);
                    ServerLogPreferencePage.this.selectedServerConnection = sc;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.btnDownload = new Button(parent, 0);
        this.btnDownload.setLayoutData((Object)new GridData(131072, -1, false, false));
        this.btnDownload.setText(Messages.getString("ServerLogPreferencePage.download_file"));
        this.btnDownload.setEnabled(false);
        this.btnDownload.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ServerLogPreferencePage.this.downloadLogFile();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return base;
    }

    private void downloadLogFile() {
        try {
            IProjectManagerServerProxy serverProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(this.selectedServerConnection.getServerID());
            EOUserAndGroupAndPermissions userData = serverProxy.getUserData(true);
            if (ServerLogPreferencePage.isAdmin(userData)) {
                FileChooserDialog fileChooserDialog = new FileChooserDialog(new String[]{"log"}, this.getShell());
                File saveFile = fileChooserDialog.openForSave();
                if (saveFile != null) {
                    EOClientRequest clientRequest = new EOClientRequest("Configuration", "getLogfilesDownloadIDs", null);
                    EOServerResponse response = PSCClientServiceFacade.getFacade().sendRequest(this.selectedServerConnection.getServerID(), clientRequest);
                    List transferIDs = (List)response.getResponseData();
                    if (!transferIDs.isEmpty()) {
                        EOValue transferID = (EOValue)transferIDs.get(0);
                        PSCClientServiceFacade.getFacade().downloadFiles(this.selectedServerConnection.getServerID(), Collections.singletonList(transferID.getValue()), Collections.singletonList(saveFile));
                    }
                    if (!saveFile.exists()) {
                        MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("ServerLogPreferencePage.no_log_file"), (String)Messages.getString("ServerLogPreferencePage.server_delivered_no_file"));
                    } else {
                        boolean open = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.getString("ServerLogPreferencePage.download_complete"), (String)Messages.getString("ServerLogPreferencePage.want_to_open"));
                        if (open) {
                            UrlLauncher.launchFile_noEx((File)saveFile, null);
                        }
                    }
                }
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString("ServerLogPreferencePage.no_permission"), (String)Messages.getString("ServerLogPreferencePage.only_admin_allowed"));
            }
        }
        catch (Throwable th1) {
            Throwable th2 = th1 instanceof ExPrematureEndOfTransfer && th1.getCause() != null ? th1.getCause() : th1;
            if (th2 instanceof ServerNotAvailableException) {
                ServerNotAvailableException e = (ServerNotAvailableException)th2;
                ExceptionDialog exceptionDialog = new ExceptionDialog(this.getShell(), (Throwable)e);
                exceptionDialog.open();
                logger.info("Could not get server log file. " + e.getLocalizedMessage());
            }
            if (th2 instanceof EXServerException) {
                EXServerException e = (EXServerException)th2;
                ExceptionDialog exceptionDialog = new ExceptionDialog(this.getShell(), e);
                exceptionDialog.open();
                logger.error("Could not get server log file", (Throwable)e);
            }
            if (th2 instanceof LoginCanceledException) {
                LoginCanceledException e = (LoginCanceledException)th2;
                logger.info("Could not get server log file. " + e.getLocalizedMessage());
            }
            if (th2 instanceof UnknownServerException) {
                logger.error("could not execute", th2);
            }
            ExceptionDialog exceptionDialog = new ExceptionDialog(this.getShell(), th1);
            exceptionDialog.open();
            logger.error("Unexpected could not execute", th1);
        }
    }

    private static boolean isAdmin(EOUserAndGroupAndPermissions user) {
        if (user.getUser().getUserName().equals("Administrator")) {
            return true;
        }
        for (EOGroup group : user.getGroups()) {
            if (!group.getGroupName().equals("Administrators")) continue;
            return true;
        }
        return false;
    }

    public void init(IWorkbench workbench) {
        this.noDefaultAndApplyButton();
    }
}

