/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frameserverproxy.client.dump;

import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.cockpit.frameserverproxy.gui.dump.DumpProjectDialog;
import com.arcway.cockpit.frameserverproxy.gui.dump.DumpRestoreServerDialog;
import com.arcway.cockpit.frameserverproxy.gui.dump.RestoreProjectWizard;
import com.arcway.cockpit.frameserverproxy.menu.actions.ServerProjectContainer;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.fmca.client.PSCServices;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.primitiveTypes.EOString;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.DumpFileAccessException;
import de.plans.psc.shared.DumpFileHasInvalidFileTypeException;
import de.plans.psc.shared.serverexceptions.EXMessageException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class DumpManager {
    private static final ILogger logger = Logger.getLogger(DumpManager.class);
    private static DumpManager singleton;

    public static DumpManager getSingleton() {
        if (singleton == null) {
            singleton = new DumpManager();
        }
        return singleton;
    }

    private DumpManager() {
    }

    public void dumpProject(Shell shell) {
        ArrayList<ServerConnection> openServerConnections = new ArrayList<ServerConnection>();
        for (ServerConnection serverConnection : ProjectMgr.getProjectMgr().getGeneralServerProxy().getServerConnections()) {
            if (!serverConnection.isConnected()) continue;
            openServerConnections.add(serverConnection);
        }
        ArrayList<ServerProjectContainer> serverProjectList = new ArrayList<ServerProjectContainer>();
        for (ServerConnection openServerConnection : openServerConnections) {
            String serverID = openServerConnection.getServerID();
            IProjectManagerServerProxy projectManagerServerProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverID);
            if (!projectManagerServerProxy.mayDumpAndRestoreProjects()) continue;
            Throwable exception = null;
            try {
                EOList eoProjects = projectManagerServerProxy.getProjectsWithPermissionForOperation("dump", null);
                for (EOProject project : eoProjects) {
                    serverProjectList.add(new ServerProjectContainer(openServerConnection, project));
                }
            }
            catch (EXServerException e) {
                exception = e;
            }
            catch (UnknownServerException e) {
                exception = e;
            }
            catch (LoginCanceledException e) {
                exception = e;
            }
            catch (ServerNotAvailableException e) {
                exception = e;
            }
            if (exception == null) continue;
            String humanReadableDescriptionOfConsequence = Messages.getString((String)"DumpProjectDialog.CollectProjectsFailed");
            ModificationProblem mProblem = new ModificationProblem((Exception)exception, humanReadableDescriptionOfConsequence);
            ArrayList<ModificationProblem> mProblems = new ArrayList<ModificationProblem>();
            mProblems.add(mProblem);
            ModificationProblemsDialog mpDialog = new ModificationProblemsDialog(mProblems, shell);
            mpDialog.open();
        }
        if (!serverProjectList.isEmpty()) {
            DumpProjectDialog dialog = new DumpProjectDialog(shell, serverProjectList);
            int result = dialog.open();
            if (result == 0) {
                ServerProjectContainer selectedProject = dialog.getSelectedProject();
                if (selectedProject == null) {
                    return;
                }
                File dumpFile = dialog.getDumpFile();
                if (dumpFile == null) {
                    return;
                }
                try {
                    boolean locksExist;
                    String serverID = selectedProject.getServer().getServerID();
                    boolean execute = true;
                    Collection allLocksOnServer = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverID).getAllLocksOfProject(new EOString(selectedProject.getProject().getProjectUID()));
                    boolean bl = locksExist = !allLocksOnServer.isEmpty();
                    if (locksExist) {
                        execute = MessageDialog.openQuestion((Shell)shell, (String)Messages.getString((String)"DumpManager.Warning.LocksForProjectExist.Title"), (String)Messages.getString((String)"DumpManager.Warning.LocksForProjectExist.Message"));
                    }
                    if (execute && dumpFile.exists()) {
                        execute = MessageDialog.openQuestion((Shell)shell, (String)Messages.getString((String)"DumpManager.file_exists"), (String)Messages.getString((String)"DumpManager.file_will_be_overwritten"));
                    }
                    if (execute) {
                        ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverID).dumpProject(selectedProject.getProject(), dumpFile, shell, 0);
                    }
                }
                catch (EXServerException e) {
                    logger.error("dumpProject() - Server Exception while dumping project", (Throwable)e);
                    PSCServices.getServiceFacade().showException((Exception)((Object)e), Messages.getString((String)"DumpManager.Server_Exception_while_dumping_project_5"));
                }
                catch (ServerNotAvailableException e) {
                    logger.warn("dumpProject() - Server not available while dumping project", (Throwable)e);
                }
                catch (UnknownServerException e) {
                    logger.warn("dumpProject() - Unknown Server", (Throwable)e);
                }
                catch (LoginCanceledException e) {
                }
                catch (ExPrematureEndOfTransfer e) {
                    logger.error("dumpProject() - Premature End of Transfert while dumping project", (Throwable)e);
                    PSCServices.getServiceFacade().showException((Exception)((Object)e), Messages.getString((String)"DumpManager.Server_Exception_while_dumping_project_5"));
                }
            }
        } else {
            MessageDialog.openInformation((Shell)shell, (String)Messages.getString((String)"DumpManager.NoDumpableProject.Title"), (String)Messages.getString((String)"DumpManager.NoDumpableProject.Message"));
        }
    }

    public void restoreProject(Shell shell) {
        if (PSCServices.getServiceFacade().getOpenServerConnections().isEmpty()) {
            MessageDialog.openInformation((Shell)shell, (String)Messages.getString((String)"DumpManager.NoConnectedServer.Title"), (String)Messages.getString((String)"DumpManager.NoConnectedServer.Message"));
            return;
        }
        RestoreProjectWizard.executeRestoreProjectWizard(shell, PSCServices.getServiceFacade().getServerConnections(), this);
    }

    public void showInvalidDumpErrorMessage(Shell shell) {
        MessageDialog.openError((Shell)shell, (String)Messages.getString((String)"dumpManager.dumpImpossible.title"), (String)Messages.getString((String)"dumpManager.dumpImpossible.message"));
    }

    public void showInvalidDumpFileTypeErrorMessage(boolean isProjectDump, Shell shell) {
        MessageDialog.openError((Shell)shell, (String)Messages.getString((String)"dumpManager.dumpFileTypeInvalid.title"), (String)(isProjectDump ? Messages.getString((String)"dumpManager.dumpFileTypeInvalid.projectDump.message") : Messages.getString((String)"dumpManager.dumpFileTypeInvalid.serverDump.message")));
    }

    public void showIncompatibleDumpErrorMessage(Shell shell) {
        MessageDialog.openError((Shell)shell, (String)Messages.getString((String)"dumpManager.dumpFormatIncompatible.title"), (String)Messages.getString((String)"dumpManager.dumpFormatIncompatible.message"));
    }

    public void dumpServer(Shell shell) {
        List serverConnections = PSCServices.getServiceFacade().getServerConnections();
        DumpRestoreServerDialog dialog = new DumpRestoreServerDialog(shell, serverConnections, true);
        int result = dialog.open();
        if (result == 0) {
            ServerConnection connection = dialog.getSelectedServerConnection();
            boolean userHasPermissions = false;
            try {
                userHasPermissions = PSCServices.getServiceFacade().isAdminUser(connection.getServerID(), true) || PSCServices.getServiceFacade().isOperator(connection.getServerID(), true);
            }
            catch (ServerNotAvailableException e1) {
                return;
            }
            catch (EXServerException e1) {
                return;
            }
            catch (LoginCanceledException e1) {
                return;
            }
            if (!userHasPermissions) {
                PSCServices.getServiceFacade().showErrorMessage(Messages.getString((String)"DumpManager.You_need_Adminstrator_permission_to_dump_a_server_1"), connection.getServerID());
                logger.error("user has no permission to dump this server");
                return;
            }
            File dumpFile = dialog.getDumpFile();
            try {
                boolean locksExist;
                boolean execute = true;
                boolean bl = locksExist = !ProjectMgr.getProjectMgr().getProjectManagerServerProxy(connection.getServerID()).getAllLocksOnServer().isEmpty();
                if (locksExist) {
                    execute = MessageDialog.openQuestion((Shell)shell, (String)Messages.getString((String)"DumpManager.Warning.LocksForServerExist.Title"), (String)Messages.getString((String)"DumpManager.Warning.LocksForServerExist.Message"));
                }
                if (execute && dumpFile.exists()) {
                    execute = MessageDialog.openQuestion((Shell)shell, (String)Messages.getString((String)"DumpManager.file_exists"), (String)Messages.getString((String)"DumpManager.file_will_be_overwritten"));
                }
                if (execute) {
                    IProjectManagerServerProxy serverProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(connection.getServerID());
                    Set projectUIDBlackList = Collections.emptySet();
                    serverProxy.dumpServer(dumpFile, projectUIDBlackList, shell);
                }
            }
            catch (EXServerException e) {
                logger.error("dumpServer() - Server Exception while dumping Server", (Throwable)e);
                PSCServices.getServiceFacade().showException((Exception)((Object)e), Messages.getString((String)"DumpManager.Server_Exception_while_dumping_Server_32"));
            }
            catch (ServerNotAvailableException e) {
                logger.warn("dumpServer() - Server not available while dumping Server", (Throwable)e);
            }
            catch (UnknownServerException e) {
                logger.warn("dumpServer() - Unknown Server", (Throwable)e);
            }
            catch (LoginCanceledException loginCanceledException) {
                // empty catch block
            }
        }
    }

    public void restoreServer(Shell shell) {
        List serverConnections = PSCServices.getServiceFacade().getServerConnections();
        DumpRestoreServerDialog dialog = new DumpRestoreServerDialog(shell, serverConnections, false);
        int result = dialog.open();
        if (result == 0) {
            ServerConnection serverConnection = dialog.getSelectedServerConnection();
            File dumpFile = dialog.getDumpFile();
            if (serverConnection == null || dumpFile == null) {
                return;
            }
            MessageDialog confirmationDialog = new MessageDialog(shell, Messages.getString((String)"DumpManager.ConfirmationDialog.Title"), Icons.getArcWayLogo(), NLS.bind((String)Messages.getString((String)"DumpManager.ConfirmationDialog.Message"), (Object)serverConnection.getServerName()), 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.ABORT_LABEL}, 1);
            if (confirmationDialog.open() == 0) {
                try {
                    IProjectManagerServerProxy serverProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverConnection.getServerID());
                    boolean success = serverProxy.restoreServer(dumpFile, shell);
                    if (success) {
                        MessageDialog.openInformation((Shell)shell, (String)Messages.getString((String)"DumpManager.ServerRestoredSuccessfully.Title"), (String)Messages.getString((String)"DumpManager.ServerRestoredSuccessfully.Message"));
                    }
                }
                catch (EXServerException e) {
                    if (e instanceof EXMessageException && e.getId().equals("InvalidDumpFormatVersion")) {
                        this.showIncompatibleDumpErrorMessage(shell);
                    } else {
                        logger.error("restoreServer() - Server Exception while restoring server", (Throwable)e);
                        PSCServices.getServiceFacade().showException((Exception)((Object)e), Messages.getString((String)"DumpManager.Server_Exception_while_dumping_project_37"));
                    }
                }
                catch (ServerNotAvailableException e) {
                    logger.warn("restoreServer() - Server not available while restoring server", (Throwable)e);
                }
                catch (UnknownServerException e) {
                    logger.warn("restoreServer() - Unknown Server", (Throwable)e);
                }
                catch (LoginCanceledException e) {
                }
                catch (DumpFileHasInvalidFileTypeException dhiftE) {
                    logger.warn((Throwable)dhiftE);
                    this.showInvalidDumpFileTypeErrorMessage(false, shell);
                }
                catch (DumpFileAccessException dfaE) {
                    logger.warn("Exception During Migration of Dump", (Throwable)dfaE);
                    this.showInvalidDumpErrorMessage(shell);
                }
                catch (MigrationFailedException dfaE) {
                    logger.warn("Exception During Migration of Dump", (Throwable)dfaE);
                    this.showInvalidDumpErrorMessage(shell);
                }
            }
        }
    }
}

