/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frameserverproxy.client;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IProjectAgent;
import com.arcway.cockpit.frame.client.project.Project;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.cockpit.frameserverproxy.client.Messages;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.communication.ServerConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.IInputValidator;

public class ProjectNameValidator
implements IInputValidator {
    private final ILogger logger = Logger.getLogger(this.getClass());
    private final List existingNames = new ArrayList();
    private boolean invalid = false;

    public ProjectNameValidator(ServerConnection server) {
        try {
            Collection allProjects = ProjectMgr.getProjectMgr().getEOProjectsOnServer(server.getServerID());
            for (EOProject p : allProjects) {
                this.existingNames.add(Project.getProjectName((EOProject)p));
            }
        }
        catch (Throwable ta) {
            this.logger.error("could not retrieve projects from server", ta);
            this.invalid = true;
        }
    }

    public ProjectNameValidator(IProjectAgent projectAgent) {
        try {
            Collection allProjects = ProjectMgr.getProjectMgr().getEOProjectsOnServer(projectAgent.getServerID());
            for (EOProject p : allProjects) {
                if (p.getProjectUID().equals(projectAgent.getUID())) continue;
                this.existingNames.add(Project.getProjectName((EOProject)p));
            }
        }
        catch (Throwable ta) {
            this.logger.error("could not retrieve projects from server", ta);
            this.invalid = true;
        }
    }

    private String isValid(String newText, List existingProjectNames) {
        assert (existingProjectNames != null);
        if (this.invalid) {
            return Messages.getString("RenameProjectValidator.Error_while_accessing_the_server._2");
        }
        if (newText == null || newText.trim().equals("")) {
            return Messages.getString("RenameProjectValidator.The_project_name_mustn__t_be_empty._4");
        }
        if (newText.length() > 255) {
            return String.valueOf(Messages.getString("RenameProjectValidator.0")) + 255 + Messages.getString("RenameProjectValidator.1");
        }
        for (String n : existingProjectNames) {
            if (!n.equalsIgnoreCase(newText.trim())) continue;
            return String.valueOf(Messages.getString("RenameProjectValidator.There_is_already_a_project_with_the_name___6")) + newText + Messages.getString("RenameProjectValidator.__on_the_same_server._7");
        }
        return null;
    }

    public String isValid(String newText) {
        return this.isValid(newText, this.existingNames);
    }
}

