/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frameserverproxy.client;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseManager;
import com.arcway.cockpit.frame.client.global.license.ILocalClientProductLicenseManager;
import com.arcway.cockpit.frame.client.project.ExProjectOpenAbortWithMessage;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IProjectAgent;
import com.arcway.cockpit.frame.client.project.Project;
import com.arcway.cockpit.frame.client.project.ProjectAttributeTypeProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IFrameServerProxy;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.MigrationManager;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.ProjectDumpFileAccess_ForClient;
import com.arcway.cockpit.frame.client.project.migration.migrators.special.UserAndGroupRenamer;
import com.arcway.cockpit.frame.client.project.migration.migrators.special.UserGroupDataMigrationMap;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.cockpit.frame.shared.message.EORestoreParameter;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttribute;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttributeTypeID;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.frameserverproxy.client.ClientFunctionLicenseManager;
import com.arcway.cockpit.frameserverproxy.client.ClientProductLicenseManagerWithServerConnection;
import com.arcway.cockpit.frameserverproxy.client.FrameServerProxy;
import com.arcway.cockpit.frameserverproxy.client.LocalClientProductLicenseManager;
import com.arcway.cockpit.frameserverproxy.client.Messages;
import com.arcway.cockpit.frameserverproxy.client.ProjectNameValidator;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.java.To;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.fmca.client.PSCServices;
import de.plans.lib.util.INotificationBusListener;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EOValue;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.primitiveTypes.EOString;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.PSCEffectiveLicenseInfo;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.IServerStatusChangedListener;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.client.dump.ServerDumpFileAccess_ForClient;
import de.plans.psc.shared.DumpFileAccessException;
import de.plans.psc.shared.PSCRestoreDefaults;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.EOServerResponse;
import de.plans.psc.shared.message.EOUserAndGroupAndPermissions;
import de.plans.psc.shared.message.EOVersionFileContent;
import de.plans.psc.shared.serverexceptions.EXMessageException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class ProjectManagerServerProxy
implements IProjectManagerServerProxy,
IServerStatusChangedListener {
    private static final ILogger logger = Logger.getLogger(ProjectManagerServerProxy.class);
    private final ClientFunctionLicenseManager offlineClientFunctionLicenseManager = new ClientFunctionLicenseManager(this, true);
    private ServerConnection serverConnection;
    private String serverID;
    private ClientFunctionLicenseManager licenseManager;
    private static final HashMap<String, String> VERSION_DEPENDEND_DESCRIPTIONS = new HashMap();
    private static final String ATTR_TAG_PROJECT_NAME = "projectname";

    static {
        VERSION_DEPENDEND_DESCRIPTIONS.put("reload", Messages.getString("ReloadProjectAction.Label"));
        VERSION_DEPENDEND_DESCRIPTIONS.put("reloadtooltip", Messages.getString("ReloadProjectAction.ToolTip"));
        VERSION_DEPENDEND_DESCRIPTIONS.put("reloaddesc", Messages.getString("ReloadProjectAction.Description"));
        VERSION_DEPENDEND_DESCRIPTIONS.put("reloadfailed", Messages.getString("ReloadProjectAction.Failed"));
        VERSION_DEPENDEND_DESCRIPTIONS.put("commitlabel", Messages.getString("CommitAction.Label"));
        VERSION_DEPENDEND_DESCRIPTIONS.put("committooltip", Messages.getString("CommitAction.ToolTip"));
        VERSION_DEPENDEND_DESCRIPTIONS.put("commitdesc", Messages.getString("CommitAction.Description"));
        VERSION_DEPENDEND_DESCRIPTIONS.put("commitfailed", Messages.getString("CommitAction.Failed"));
    }

    public void construct(ServerConnection newServerConnection) {
        this.serverConnection = newServerConnection;
        this.serverID = newServerConnection.getServerID();
        ClientProductLicenseManagerWithServerConnection.initialisePSCLicenseSettings();
        this.licenseManager = this.offlineClientFunctionLicenseManager;
        ProjectMgr.getProjectMgr().getGeneralServerProxy().addServerStatusChangedListener((IServerStatusChangedListener)this);
    }

    public void createProjectOnServer(EOProject newProject, File projectRoot) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        EOClientRequest req = new EOClientRequest("frame.project", "frame.AddProject", (EncodableObjectBase)newProject);
        PSCServices.getServiceFacade().sendRequest(this.serverConnection.getServerID(), req);
    }

    public void deleteProjectOnServer(String projectUID) throws EXServerException, UnknownServerException, LoginCanceledException, ServerNotAvailableException {
        EOValue projectUID_EO = new EOValue(projectUID);
        EOClientRequest req = new EOClientRequest("frame.project", "frame.DeleteProject", (EncodableObjectBase)projectUID_EO);
        PSCServices.getServiceFacade().sendRequest(this.serverID, req);
    }

    public EOProject[] getAllProjectsOfServer() throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        EOClientRequest req = new EOClientRequest("frame.project", "frame.GetAllProjects", null);
        EOServerResponse res = PSCServices.getServiceFacade().sendRequest(this.serverID, req);
        if (res == null) {
            throw new ServerNotAvailableException(this.serverID, req);
        }
        EncodableObjectBase responseData = res.getResponseData();
        Collection eoProjects = (Collection)responseData;
        EOProject[] projects = new EOProject[eoProjects.size()];
        int nr = 0;
        for (EOProject eoProject : eoProjects) {
            projects[nr++] = eoProject;
        }
        return projects;
    }

    public Collection<EOLock> getAllLocksOnServer() throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        EOClientRequest request = new EOClientRequest("frame.lock", "frame.getalllocks", null);
        EOServerResponse response = PSCServices.getServiceFacade().sendRequest(this.serverID, request);
        return (Collection)response.getResponseData();
    }

    public Collection<EOLock> getAllLocksOfProject(EOString projectUID) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        EOClientRequest request = new EOClientRequest("frame.lock", "frame.getalllocksofproject", (EncodableObjectBase)projectUID);
        EOServerResponse response = PSCServices.getServiceFacade().sendRequest(this.serverID, request);
        return (Collection)response.getResponseData();
    }

    public void removeLocks(Collection<EOLock> locks) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        EOClientRequest request = new EOClientRequest("frame.lock", "frame.releaselock", (EncodableObjectBase)new EOList(locks));
        PSCServices.getServiceFacade().sendRequest(this.serverID, request);
    }

    public void reloadProject(IFrameProjectAgent projectAgent, boolean askUser, IWorkbenchPage currentPage, boolean triggerUserOnOpenActions) throws Exception {
        Shell parentShell = currentPage == null ? null : currentPage.getWorkbenchWindow().getShell();
        boolean reloadProject = true;
        if (askUser) {
            MessageDialog removeProjectDialog = new MessageDialog(parentShell, Messages.getString("ReloadProjectAction.Label"), Icons.getArcWayLogo(), Messages.getString("ReloadProjectAction.Do_you_really_want_to_discard_the_local_changes__3"), 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
            reloadProject = removeProjectDialog.open() == 0;
        }
        if (reloadProject) {
            projectAgent.discardLocalModifications(parentShell);
            projectAgent.close(null);
            boolean triggerUserOnOpenActions_internal = false;
            projectAgent.open(true, triggerUserOnOpenActions_internal, currentPage);
            PropertyChanges changes = new PropertyChanges(null, (Object)projectAgent, null);
            projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IFrameProjectAgent.class);
            if (triggerUserOnOpenActions) {
                projectAgent.triggerUserOnOpenActions(currentPage);
            }
        }
    }

    public boolean arePermissionsNeeded() {
        return true;
    }

    public EOProject createProjectSnapshotOnServer(EOProject originalProjectEO) throws EXServerException, UnknownServerException, LoginCanceledException, ServerNotAvailableException {
        PresentationContext presentationContext = PresentationContext.getVirtualMachineUserLocaleForNow();
        EOProject newProjectEO = new EOProject((EOFrameData)originalProjectEO);
        newProjectEO.setProjectUID(UUIDGenerator.getUniqueID());
        String now = presentationContext.getISODateAndTimeWithSecondsForNowAsString(new Locale(Project.getLanguage((EOProject)originalProjectEO)));
        newProjectEO.addAttribute(ProjectManagerServerProxy.getNameAttribute(originalProjectEO, String.valueOf(ProjectManagerServerProxy.getInfixSnapshot()) + now));
        EOList projectList = new EOList(2);
        projectList.add(0, (EncodableObjectBase)originalProjectEO);
        projectList.add(1, (EncodableObjectBase)newProjectEO);
        EOClientRequest req = new EOClientRequest("frame.project", "frame.CreateSnapshot", (EncodableObjectBase)projectList);
        PSCServices.getServiceFacade().sendRequest(this.serverID, req);
        return newProjectEO;
    }

    public EOProject createProjectToPublishOnServer(EOProject originalProjectEO, String projectUIDofNewProject, String projectNameProposal, Collection<EOPermission> permissionsToAdd) throws EXServerException, UnknownServerException, LoginCanceledException, ServerNotAvailableException {
        String newProjectName;
        PresentationContext presentationContext = PresentationContext.getVirtualMachineUserLocaleForNow();
        EOProject newProjectEO = new EOProject((EOFrameData)originalProjectEO);
        newProjectEO.setProjectUID(projectUIDofNewProject);
        String originalProjectName = ProjectManagerServerProxy.getProjectName(originalProjectEO);
        if (ProjectManagerServerProxy.hasAppendix(projectNameProposal, originalProjectEO, presentationContext)) {
            String appendix = ProjectManagerServerProxy.createAppendix(originalProjectEO, presentationContext);
            newProjectName = String.valueOf(originalProjectName) + appendix;
        } else {
            newProjectName = projectNameProposal;
        }
        newProjectEO.addAttribute(ProjectManagerServerProxy.getProjectNameAttribute(newProjectName));
        EOList projectList = new EOList(2);
        projectList.add(0, (EncodableObjectBase)originalProjectEO);
        projectList.add(1, (EncodableObjectBase)newProjectEO);
        EOClientRequest req = new EOClientRequest("frame.project", "frame.CreateSnapshot", (EncodableObjectBase)projectList);
        PSCServices.getServiceFacade().sendRequest(this.serverID, req);
        PSCClientServiceFacade.getFacade().updatePermissions(permissionsToAdd, null, this.serverID);
        return newProjectEO;
    }

    private static String createAppendix(EOProject originalProjectEO, PresentationContext presentationContext) {
        String now = presentationContext.getISODateAndTimeWithSecondsForNowAsString(new Locale(Project.getLanguage((EOProject)originalProjectEO)));
        String infix = ProjectManagerServerProxy.getInfixPublish();
        String appendix = String.valueOf(infix) + now;
        return appendix;
    }

    private static String getInfixSnapshot() {
        return String.valueOf(Messages.getString("ProjectManagerServerProxy.snapshot")) + " ";
    }

    private static String getInfixPublish() {
        return String.valueOf(Messages.getString("ProjectManagerServerProxy.status")) + " ";
    }

    private static boolean hasAppendix(String originalProjectName, EOProject originalProjectEO, PresentationContext presentationContext) {
        boolean hasAppendix;
        String appendix = ProjectManagerServerProxy.createAppendix(originalProjectEO, presentationContext);
        if (originalProjectName.length() > appendix.length()) {
            String appendixCandidate = originalProjectName.substring(originalProjectName.length() - appendix.length());
            String infixSnapshot = ProjectManagerServerProxy.getInfixSnapshot();
            String infixPublish = ProjectManagerServerProxy.getInfixPublish();
            String time = appendixCandidate.startsWith(infixSnapshot) ? appendixCandidate.substring(infixSnapshot.length()) : (appendixCandidate.startsWith(infixPublish) ? appendixCandidate.substring(infixPublish.length()) : null);
            hasAppendix = time != null ? time.charAt(4) == '-' && time.charAt(7) == '-' && time.charAt(10) == ' ' && time.charAt(13) == ':' && time.charAt(16) == ':' : false;
        } else {
            hasAppendix = false;
        }
        return hasAppendix;
    }

    private static EOAttribute getNameAttribute(EOProject project, String appendix) {
        String projectName = ProjectManagerServerProxy.getProjectName(project);
        String newProjectName = String.valueOf(projectName) + appendix;
        return ProjectManagerServerProxy.getProjectNameAttribute(newProjectName);
    }

    private static EOAttribute getProjectNameAttribute(String newProjectName) {
        EOString newValue = new EOString(newProjectName);
        EOAttribute newAttribute = new EOAttribute();
        newAttribute.setAttributeTypeID(new EOAttributeTypeID(ProjectAttributeTypeProvider.ATTRID_NAME.getUID(), "name"));
        newAttribute.setValueAsEO((EOEncodableObject)newValue);
        return newAttribute;
    }

    private static String getProjectName(EOProject project) {
        String projectName = null;
        for (EOAttribute attribute : project.getAttributes()) {
            if (!attribute.getAttributeTypeUID().getEOAttributeTypeID().equals(ProjectAttributeTypeProvider.ATTRID_NAME.getUID())) continue;
            projectName = ((EOString)attribute.getValueAsEO()).getString();
        }
        if (projectName == null) {
            projectName = project.getOldAttributeValue(ATTR_TAG_PROJECT_NAME);
        }
        if (projectName == null) {
            logger.warn("Couldn't determine project name.");
            projectName = "unknown name";
        }
        return projectName;
    }

    public EOUserAndGroupAndPermissions getUserData(boolean forceLogin) throws ServerNotAvailableException, EXServerException, LoginCanceledException {
        return PSCServices.getServiceFacade().getUserData(this.serverID, forceLogin);
    }

    public boolean isAdminUser(boolean forceLogin) throws ServerNotAvailableException, EXServerException, LoginCanceledException {
        return PSCServices.getServiceFacade().isAdminUser(this.serverID, forceLogin);
    }

    public boolean mayChangeUserName() {
        return false;
    }

    public void setUserName(String newName) {
    }

    public boolean offersProjectsForDownload() {
        return true;
    }

    public boolean mayDumpAndRestoreProjects() {
        return true;
    }

    public String getServerName() {
        return PSCServices.getServiceFacade().getServerName(this.serverID);
    }

    public void login(String username, String password) throws ServerNotAvailableException, EXServerException, LoginCanceledException {
        PSCServices.getServiceFacade().login(this.serverConnection, username, password);
        this.licenseManager = new ClientFunctionLicenseManager(this);
    }

    public String getServerAvailabilityState() {
        return null;
    }

    public EOProject[] getAvailableProjectsFromServer(Shell parentShell) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        EOList<EOProject> ps = this.getProjectsWithPermissionForOperation("openProject", null);
        EOProject[] projects = new EOProject[ps.size()];
        int nr = 0;
        for (EOProject project : ps) {
            projects[nr++] = project;
        }
        return projects;
    }

    public void getProjectFromServer(EOProject project, IWorkbenchPage currentPage, boolean triggerUserOnOpenActions) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, IOException, ExPrematureEndOfTransfer, ExProjectOpenAbortWithMessage {
        ProjectMgr.getProjectMgr().createNewProject(project.getUID(), Project.getProjectName((EOProject)project), Project.getLanguage((EOProject)project), this.serverID, 2, triggerUserOnOpenActions, currentPage);
    }

    public String getGetProjectFromServerLabel() {
        return Messages.getString("NewProjectAction.Project_from_server..._3");
    }

    public String getGetProjectFromServerDescription() {
        return Messages.getString("NewProjectAction.Gets_an_existing_project_from_the_selected_server_4");
    }

    public EOList<EOProject> getProjectsWithPermissionForOperation(String operation, String operation2) throws EXServerException, UnknownServerException, LoginCanceledException, ServerNotAvailableException {
        EOList parameter = new EOList();
        parameter.add((EncodableObjectBase)new EOString(operation, "parameter.1"));
        if (operation2 != null) {
            parameter.add((EncodableObjectBase)new EOString(operation2, "parameter.2"));
        }
        EOClientRequest request = new EOClientRequest("frame.project", "frame.GetAllProjectsWithPermission", (EncodableObjectBase)parameter);
        EOServerResponse res = PSCServices.getServiceFacade().sendRequest(this.serverID, request);
        return (EOList)res.getResponseData();
    }

    public IInputValidator getProjectNameValidatorForCreatingNewProjectOnServer() {
        return new ProjectNameValidator(this.serverConnection);
    }

    public IInputValidator getProjectNameValidatorForGettingProjectFromServer() {
        return new IInputValidator(){

            public String isValid(String newText) {
                return null;
            }
        };
    }

    public IInputValidator getProjectNameValidator(IProjectAgent projectAgent) {
        return new ProjectNameValidator(projectAgent);
    }

    public void subscribeListenerOnServer(INotificationBusListener listener, String notificationtype) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        PSCClientServiceFacade.getFacade().getNotificationBus().subscribeListenerOnServer(listener, notificationtype, this.serverID);
    }

    public int getNumberOfMaxProjectsOnServer() {
        return -1;
    }

    public EOServerResponse sendRequest(String reqGroup, String reqSubID, EncodableObjectBase reqParam) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        try {
            EOClientRequest request = new EOClientRequest(reqGroup, reqSubID, reqParam);
            EOServerResponse response = PSCServices.getServiceFacade().sendRequest(this.serverID, request);
            return response;
        }
        catch (ServerNotAvailableException e) {
            this.licenseManager = this.offlineClientFunctionLicenseManager;
            throw e;
        }
        catch (LoginCanceledException e) {
            this.licenseManager = this.offlineClientFunctionLicenseManager;
            throw e;
        }
        catch (UnknownServerException e) {
            this.licenseManager = this.offlineClientFunctionLicenseManager;
            throw e;
        }
        catch (EXServerException e) {
            throw e;
        }
    }

    public ILocalClientProductLicenseManager getLocalProductLicenseManager() {
        return LocalClientProductLicenseManager.getDefault();
    }

    public ClientProductLicenseManagerWithServerConnection getProductLicenseManager() {
        return this.licenseManager.getProductLicenseManager();
    }

    public IClientFunctionLicenseManager getFunctionLicenseManager() {
        return this.licenseManager;
    }

    public void addedServer(ServerConnection addedServerConnection) {
    }

    public void modifiedServer(ServerConnection modifiedServerConnection) {
    }

    public void deletedServer(ServerConnection deletedServerConnection) {
        ProjectMgr.getProjectMgr().getGeneralServerProxy().removeServerStatusChangedListener((IServerStatusChangedListener)this);
    }

    public boolean serverAboutToBeDeleted(ServerConnection serverConnectionToBeDeleted) {
        return true;
    }

    public void login(ServerConnection sc) {
        if (sc.equals(this.serverConnection)) {
            this.licenseManager = new ClientFunctionLicenseManager(this);
        }
    }

    public void logoff(ServerConnection sc) {
        if (sc.equals(this.serverConnection)) {
            this.licenseManager = this.offlineClientFunctionLicenseManager;
        }
    }

    public String getUserRealmRepositoryType() {
        return PSCServices.getServiceFacade().getUserRealmRepositoryType(this.serverID);
    }

    public boolean shallEditorsSupportViewMode() {
        return true;
    }

    public boolean canReaderCreateProjectsOnThisServer() {
        return false;
    }

    public boolean serverKeepsCopy() {
        return true;
    }

    public boolean mayCommitDiscardWithoutLocalChanges() {
        return false;
    }

    public PSCEffectiveLicenseInfo getEffectiveLicenseSetting() {
        return this.serverConnection.getLicenseInfo();
    }

    public IFrameServerProxy createServerProxy(IFrameProjectAgent projectAgent) {
        FrameServerProxy frameServerProxy = new FrameServerProxy();
        frameServerProxy.construct(projectAgent);
        return frameServerProxy;
    }

    public boolean isServerAlwaysConnected() {
        return false;
    }

    public void forceLogin() throws ServerNotAvailableException, EXServerException, LoginCanceledException {
        this.getUserData(true);
    }

    public String getVersionDependendDescription(String descriptionyKey) {
        return VERSION_DEPENDEND_DESCRIPTIONS.get(descriptionyKey);
    }

    public void dumpProject(EOProject eoProject, File dumpFile, Shell shell, int timeOutInSeconds) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException, ExPrematureEndOfTransfer {
        EOList projects = new EOList();
        projects.add((EncodableObjectBase)new EOValue(eoProject.getUID()));
        EOClientRequest req = new EOClientRequest("frame.Export", "frame.DumpProjects", (EncodableObjectBase)projects);
        EOServerResponse serverResponse = PSCServices.getServiceFacade().sendRequest(this.serverID, req, timeOutInSeconds);
        if (serverResponse == null) {
            return;
        }
        String transferID = ((EOValue)serverResponse.getResponseData()).getValue();
        ArrayList<String> transferIDs = new ArrayList<String>();
        transferIDs.add(transferID);
        ArrayList<File> files = new ArrayList<File>();
        files.add(dumpFile);
        try {
            PSCServices.getServiceFacade().downloadFiles(this.serverID, transferIDs, files);
            if (logger.isDebugEnabled()) {
                logger.debug("done() - Successfully downloaded dump file");
            }
        }
        catch (UnknownServerException e) {
            throw e;
        }
        catch (ServerNotAvailableException e) {
            throw e;
        }
        catch (EXServerException e) {
            throw e;
        }
        catch (LoginCanceledException e) {
            throw e;
        }
        catch (ExPrematureEndOfTransfer e) {
            throw e;
        }
        catch (Throwable th) {
            if (shell != null) {
                String projectName = Project.getProjectName((EOProject)eoProject);
                String humanReadableDescriptionOfConsequence = Messages.getString("ProjectManagerServerProxy.DumpProjectFailed.DescriptionOfConsequence");
                String exGenericMessage = Messages.getString("ProjectManagerServerProxy.DumpProjectFailed.RestoreProjectFailed");
                String dialaogTitle = Messages.getString("ProjectManagerServerProxy.DumpProjectFailed.Title");
                String dialogMessage = Messages.getString("ProjectManagerServerProxy.DumpProjectFailed.Message");
                ProjectManagerServerProxy.handleDumpRestoreThrowable(th, shell, projectName, humanReadableDescriptionOfConsequence, exGenericMessage, dialaogTitle, dialogMessage);
            }
            throw new RuntimeException(th);
        }
    }

    public boolean restoreProject(EOProject eoProject, File dumpFile, Shell shell) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        EOClientRequest req = new EOClientRequest("frame.Export", "frame.RequestDumpUpload", null);
        EOServerResponse serverResponse = PSCServices.getServiceFacade().sendRequest(this.serverID, req);
        if (serverResponse != null) {
            EOValue value = (EOValue)serverResponse.getResponseData();
            String transferID = value.getValue();
            ArrayList<String> transferIDs = new ArrayList<String>();
            transferIDs.add(transferID);
            ArrayList<File> files = new ArrayList<File>();
            files.add(dumpFile);
            try {
                PSCServices.getServiceFacade().uploadFiles(this.serverID, transferIDs, files);
                EORestoreParameter restoreParameter = new EORestoreParameter();
                restoreParameter.setTransferID(transferID);
                restoreParameter.setRestoreLocks(PSCRestoreDefaults.getDoRestoreLocksDefaultValue());
                if (eoProject != null) {
                    restoreParameter.setProject(eoProject);
                }
                EOClientRequest reqRestoreDump = new EOClientRequest("frame.Export", "frame.RestoreDump", (EncodableObjectBase)restoreParameter);
                PSCServices.getServiceFacade().sendRequest(this.serverID, reqRestoreDump);
                if (logger.isDebugEnabled()) {
                    logger.debug("done() - Successfully uploaded and restored dump file");
                }
                return true;
            }
            catch (Throwable th) {
                String projectName = eoProject != null ? Project.getProjectName((EOProject)eoProject) : PSCServices.getServiceFacade().getServerName(this.serverID);
                String humanReadableDescriptionOfConsequence = Messages.getString("ProjectManagerServerProxy.RestoreProjectFailed.DescriptionOfConsequence");
                String exGenericMessage = Messages.getString("ProjectManagerServerProxy.RestoreProjectFailed.RestoreProjectFailed");
                String dialaogtitle = Messages.getString("ProjectManagerServerProxy.RestoreProjectFailed.Title");
                String dialogMessage = Messages.getString("ProjectManagerServerProxy.RestoreProjectFailed.Message");
                ProjectManagerServerProxy.handleDumpRestoreThrowable(th, shell, projectName, humanReadableDescriptionOfConsequence, exGenericMessage, dialaogtitle, dialogMessage);
                return false;
            }
        }
        return false;
    }

    public static ProjectDumpFileAccess_ForClient doMigrateProjectDumpAndReturnProjectDumpFileAccess(File dumpFile) throws DumpFileAccessException, EXMessageException, MigrationFailedException {
        ProjectDumpFileAccess_ForClient projectDumpAccess = new ProjectDumpFileAccess_ForClient(dumpFile);
        int dataFormatVersion = projectDumpAccess.getVersion();
        if (dataFormatVersion > 7) {
            throw new EXMessageException("InvalidDumpFormatVersion", "");
        }
        MigrationManager.getDefault().migrateProjectDump(projectDumpAccess);
        UserGroupDataMigrationMap userGroupDataMigrationMap = new UserGroupDataMigrationMap(dumpFile);
        if (!userGroupDataMigrationMap.isIdentityMapping()) {
            UserAndGroupRenamer userAndGroupRenamer = new UserAndGroupRenamer(userGroupDataMigrationMap);
            userAndGroupRenamer.migrateProjectDump(projectDumpAccess);
        }
        return projectDumpAccess;
    }

    public void dumpServer(File dumpFile, Collection<? extends String> projectUIDBlackList, Shell shell) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        EOList blacklist;
        boolean userHasPermissions = false;
        try {
            userHasPermissions = PSCServices.getServiceFacade().isAdminUser(this.serverID, true) || PSCServices.getServiceFacade().isOperator(this.serverID, true);
        }
        catch (ServerNotAvailableException e1) {
            return;
        }
        catch (EXServerException e1) {
            return;
        }
        catch (LoginCanceledException e1) {
            return;
        }
        if (!userHasPermissions) {
            if (!ProjectMgr.getProjectMgr().isInScriptMode()) {
                PSCServices.getServiceFacade().showErrorMessage("", this.serverID);
            }
            logger.warn("user has no permission to dump this server");
            return;
        }
        if (projectUIDBlackList.isEmpty()) {
            blacklist = null;
        } else {
            blacklist = new EOList();
            for (String string : projectUIDBlackList) {
                blacklist.add((EncodableObjectBase)new EOValue(string));
            }
        }
        EOClientRequest eOClientRequest = new EOClientRequest("Dump", "DumpServer", (EncodableObjectBase)blacklist);
        EOServerResponse serverResponse = PSCServices.getServiceFacade().sendRequest(this.serverID, eOClientRequest);
        if (serverResponse == null) {
            return;
        }
        String transferID = ((EOValue)serverResponse.getResponseData()).getValue();
        ArrayList<String> transferIDs = new ArrayList<String>();
        transferIDs.add(transferID);
        ArrayList<File> files = new ArrayList<File>();
        files.add(dumpFile);
        try {
            PSCServices.getServiceFacade().downloadFiles(this.serverID, transferIDs, files);
            if (logger.isDebugEnabled()) {
                logger.debug("done() - Successfully downloaded dump file");
            }
        }
        catch (Throwable th) {
            String serverName = this.getServerName();
            String humanReadableDescriptionOfConsequence = Messages.getString("ProjectManagerServerProxy.DumpServerFailed.DescriptionOfConsequence");
            String exGenericMessage = Messages.getString("ProjectManagerServerProxy.DumpServerFailed.DumpServerFailed");
            String dialaogtitle = Messages.getString("ProjectManagerServerProxy.DumpServerFailed.Title");
            String dialogMessage = Messages.getString("ProjectManagerServerProxy.DumpServerFailed.Message");
            ProjectManagerServerProxy.handleDumpRestoreThrowable(th, shell, serverName, humanReadableDescriptionOfConsequence, exGenericMessage, dialaogtitle, dialogMessage);
        }
    }

    public boolean restoreServer(File dumpFile, Shell shell) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, DumpFileAccessException, MigrationFailedException {
        File targetFile;
        EOClientRequest req = new EOClientRequest("Dump", "MSG_SUBID_REQ_DUMP_UPLOAD", null);
        EOServerResponse serverResponse = PSCServices.getServiceFacade().sendRequest(this.serverID, req);
        if (serverResponse == null) {
            return false;
        }
        MessageDialog messageDialogue = null;
        try {
            messageDialogue = MigrationManager.startWaitDialogue((Shell)shell);
            ServerDumpFileAccess_ForClient serverDumpAccess = ProjectManagerServerProxy.doMigrateServerDumpAndReturnServerDumpFileAccess(dumpFile);
            try {
                targetFile = SessionTempDirectoryManager.createSessionTempFile((String)de.plans.lib.util.FileHelper.getFileNameWithoutExtension((String)dumpFile.getName()), (String)("." + FileHelper.getFileExtension((File)dumpFile)));
            }
            catch (JvmExternalResourceInteractionException jeriE) {
                throw new MigrationFailedException("Could not save migrated dump.", (Throwable)jeriE);
            }
            serverDumpAccess.saveToTarget(targetFile);
        }
        finally {
            MigrationManager.stopWaitDialogue((MessageDialog)messageDialogue);
        }
        String transferID = ((EOValue)serverResponse.getResponseData()).getValue();
        ArrayList<String> transferIDs = new ArrayList<String>();
        transferIDs.add(transferID);
        ArrayList<File> files = new ArrayList<File>();
        files.add(targetFile);
        try {
            PSCServices.getServiceFacade().uploadFiles(this.serverID, transferIDs, files);
            EOList requestParameter = new EOList();
            requestParameter.add((EncodableObjectBase)new EOValue(transferID));
            requestParameter.add((EncodableObjectBase)new EOValue("true"));
            requestParameter.add((EncodableObjectBase)new EOValue(PSCRestoreDefaults.getDoRestoreLocksDefaultValue() ? "true" : "false"));
            EOClientRequest clientReq = new EOClientRequest("Dump", "RestoreServer", (EncodableObjectBase)requestParameter);
            PSCServices.getServiceFacade().sendRequest(this.serverID, clientReq);
            if (logger.isDebugEnabled()) {
                logger.debug("done() - Successfully uploaded and restored dump file");
            }
            return true;
        }
        catch (Throwable th) {
            String serverName = this.getServerName();
            String humanReadableDescriptionOfConsequence = Messages.getString("ProjectManagerServerProxy.RestoreServerFailed.DescriptionOfConsequence");
            String exGenericMessage = Messages.getString("ProjectManagerServerProxy.RestoreServerFailed.RestoreServerFailed");
            String dialaogtitle = Messages.getString("ProjectManagerServerProxy.RestoreServerFailed.Title");
            String dialogMessage = Messages.getString("ProjectManagerServerProxy.RestoreServerFailed.Message");
            ProjectManagerServerProxy.handleDumpRestoreThrowable(th, shell, serverName, humanReadableDescriptionOfConsequence, exGenericMessage, dialaogtitle, dialogMessage);
            return false;
        }
        finally {
            if (!targetFile.equals(dumpFile)) {
                try {
                    FileHelper.deleteExistingFileOrDirectory((File)targetFile);
                }
                catch (JvmExternalResourceInteractionException e) {
                    logger.debug("Unable to dele obsolete server dumpfile " + targetFile, (Throwable)e);
                }
            } else assert (false);
        }
    }

    public static ServerDumpFileAccess_ForClient doMigrateServerDumpAndReturnServerDumpFileAccess(File dumpFile) throws DumpFileAccessException, EXMessageException, MigrationFailedException {
        ServerDumpFileAccess_ForClient serverDumpAccess = new ServerDumpFileAccess_ForClient(dumpFile);
        int dataFormatVersion = serverDumpAccess.getVersion("COCKPIT_FRAME");
        if (dataFormatVersion > 7) {
            throw new EXMessageException("InvalidDumpFormatVersion", "");
        }
        MigrationManager.getDefault().migrateServerDump(serverDumpAccess);
        HashMap<String, Integer> newVersions = new HashMap<String, Integer>();
        newVersions.put("COCKPIT_FRAME", 7);
        serverDumpAccess.resetVersionInformation(new EOVersionFileContent("psc.server-dump", newVersions));
        UserGroupDataMigrationMap userGroupDataMigrationMap = new UserGroupDataMigrationMap(dumpFile);
        if (!userGroupDataMigrationMap.isIdentityMapping()) {
            UserAndGroupRenamer userAndGroupRenamer = new UserAndGroupRenamer(userGroupDataMigrationMap);
            userAndGroupRenamer.migrateServerDump(serverDumpAccess);
        }
        return serverDumpAccess;
    }

    private static void handleDumpRestoreThrowable(Throwable th, Shell parentShell, String projectOrServerName, String humanReadableDescriptionOfConsequence, String exGenericMessage, String dialogTitle, String dialogMessage) {
        Exception userShownEx;
        Throwable thToHandle = th instanceof ExPrematureEndOfTransfer && th.getCause() != null ? th.getCause() : th;
        if (thToHandle instanceof Exception) {
            userShownEx = (Exception)thToHandle;
        } else {
            userShownEx = new Exception(exGenericMessage);
            userShownEx.initCause(thToHandle);
        }
        ModificationProblem mProblem = new ModificationProblem(userShownEx, 2, humanReadableDescriptionOfConsequence);
        ArrayList<ModificationProblem> mProblems = new ArrayList<ModificationProblem>();
        mProblems.add(mProblem);
        String mProblemDialogMessage = NLS.bind((String)dialogMessage, (Object)projectOrServerName);
        logger.error(To.makeNotNull((Object)dialogTitle) + "\n" + To.makeNotNull((Object)mProblemDialogMessage) + "\n" + To.makeNotNull((Object)humanReadableDescriptionOfConsequence), (Throwable)userShownEx);
        ModificationProblemsDialog mpDialog = new ModificationProblemsDialog(mProblems, dialogTitle, mProblemDialogMessage, parentShell);
        mpDialog.open();
    }
}

