/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.shared.message.genericframedata;

import com.arcway.cockpit.frame.shared.message.EOCockpitProjectData;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttribute;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EOFrameData
extends EOCockpitProjectData {
    public static final String XML_NAME = "frame.frameData";
    private Collection<EOAttribute> attributes = new ArrayList<EOAttribute>();
    private final Map oldAttributes = new HashMap();
    private final Collection oldChildren = new ArrayList();

    public EOFrameData() {
        super(XML_NAME);
    }

    public EOFrameData(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    public EOFrameData(EOFrameData frameData, String xmlName) {
        super(xmlName, frameData);
        this.attributes = new ArrayList<EOAttribute>();
        for (EOAttribute eoAttribute : frameData.getAttributes()) {
            this.attributes.add(new EOAttribute(eoAttribute));
        }
    }

    public EOFrameData(String xmlName) {
        super(xmlName);
    }

    public EOFrameData(String xmlName, XMLContext xmlContext) {
        super(xmlName, xmlContext);
    }

    public void addAttribute(EOAttribute attribute) {
        Iterator<EOAttribute> i = this.attributes.iterator();
        while (i.hasNext()) {
            EOAttribute contained = i.next();
            if (!contained.getAttributeTypeUID().getEOAttributeTypeID().equals(attribute.getAttributeTypeUID().getEOAttributeTypeID())) continue;
            i.remove();
            break;
        }
        this.attributes.add(attribute);
    }

    public Collection<EOAttribute> getAttributes() {
        return this.attributes;
    }

    public String getOldAttributeValue(String name) {
        return (String)this.oldAttributes.get(name);
    }

    protected Map getOldAttributes() {
        return this.oldAttributes;
    }

    public void clearOldAttribute(String name) {
        this.oldAttributes.remove(name);
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        boolean isAttributeOfSuperType = super.setAttributeFromXML(name, value);
        if (!isAttributeOfSuperType) {
            this.oldAttributes.put(name, value);
            return true;
        }
        return true;
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        super.appendAttributesToXML(writeContext);
        for (String name : this.oldAttributes.keySet()) {
            String value = (String)this.oldAttributes.get(name);
            this.appendAttrToXML(writeContext, name, value);
        }
    }

    @Override
    protected boolean hasChildren() {
        return super.hasChildren() || !this.attributes.isEmpty() || !this.oldChildren.isEmpty();
    }

    @Override
    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        super.writeChildrenToXML(writeContext, depth);
        for (EOAttribute attribute : this.attributes) {
            attribute.writeXMLBody(writeContext, depth);
        }
        for (EncodableObjectBase eo : this.oldChildren) {
            eo.writeXMLBody(writeContext, depth);
        }
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        boolean isChildOfSuperType = super.addChildFromXML(newChild);
        if (!isChildOfSuperType) {
            if (newChild instanceof EOAttribute) {
                this.attributes.add((EOAttribute)newChild);
                return true;
            }
            this.oldChildren.add(newChild);
            return true;
        }
        return true;
    }

    public Collection getOldChildren() {
        return this.oldChildren;
    }

    @Deprecated
    protected void setOldAttributes(Map attributes) {
        this.oldAttributes.clear();
        for (String name : attributes.keySet()) {
            String value = (String)attributes.get(name);
            this.oldAttributes.put(name, value);
        }
    }

    @Deprecated
    protected void setOldChildren(Collection children) {
        this.oldChildren.clear();
        for (Object child : children) {
            this.oldChildren.add(child);
        }
    }
}

