/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.shared.message;

import com.arcway.cockpit.frame.shared.message.EOProject;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;

public class EORestoreParameter
extends EOEncodableObject {
    public static final String XML_NAME = "frame.restoreproject";
    private String transferID;
    private boolean doRestoreLocks = false;
    private static final String ATTR_TAG_TRANSFER_ID = "transferID";
    private static final String ATTR_TAG_RESTORE_LOCKS = "restoreLocks";
    private EOProject project;

    public EORestoreParameter() {
        super(XML_NAME);
    }

    public EORestoreParameter(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        if (newChild instanceof EOProject) {
            this.project = (EOProject)newChild;
            return true;
        }
        return false;
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendAttrToXML(writeContext, ATTR_TAG_TRANSFER_ID, this.transferID);
        this.appendAttrToXML(writeContext, ATTR_TAG_RESTORE_LOCKS, this.doRestoreLocks);
    }

    protected boolean hasChildren() {
        return this.project != null;
    }

    protected boolean setAttributeFromXML(String name, String value) {
        boolean success = true;
        if (name.equals(ATTR_TAG_TRANSFER_ID)) {
            this.transferID = value;
        } else if (name.equals(ATTR_TAG_RESTORE_LOCKS)) {
            this.doRestoreLocks = Boolean.parseBoolean(value);
        } else {
            success = false;
        }
        return success;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        if (this.project != null) {
            this.project.writeXMLBody(writeContext, depth);
        }
    }

    public String getTransferID() {
        assert (this.transferID != null) : "transferID is null";
        return this.transferID;
    }

    public void setTransferID(String transferID) {
        assert (transferID != null) : "name is null";
        this.transferID = transferID;
    }

    public void setRestoreLocks(boolean doRestoreLocks) {
        this.doRestoreLocks = doRestoreLocks;
    }

    public boolean getRestoreLocks() {
        return this.doRestoreLocks;
    }

    public void setProject(EOProject project) {
        this.project = project;
    }

    public EOProject getProject() {
        return this.project;
    }
}

