/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter.plan;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans;
import com.arcway.cockpit.frame.client.project.ICockpitProject;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.PlanAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.SectionManager;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlanAddID;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlanRW;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.Plan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.PlanAttributeTypeProvider;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.planagents.PlanAgentManager;
import com.arcway.cockpit.frame.shared.ILockable;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.java.arrays.ArrayUtils;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.ui.editor.WidgetTypeID;
import com.arcway.lib.ui.editor.datatype.IWidgetTypeID;
import com.arcway.lib.ui.editor.layoutspecification.CustomPropertySpecification;
import com.arcway.lib.ui.editor.layoutspecification.IWidgetSpecification;
import com.arcway.lib.ui.editor.layoutspecification.WidgetSpecification;
import com.arcway.lib.ui.editor.parameters.FileWidgetParameters;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.parameters.importdialog.PageWidgetParameters;
import com.arcway.lib.ui.editor.specification.sequential.EntrySpecification;
import com.arcway.lib.ui.editor.specification.sequential.PageSpecification;
import com.arcway.lib.ui.editor.specification.sequential.Sequence;
import com.arcway.repository.clientadapter.implementation.adapter.Messages;
import com.arcway.repository.clientadapter.implementation.adapter.frame.AbstractDataManagerAdapter;
import com.arcway.repository.clientadapter.implementation.adapter.frame.AttributeTypeID2PropertyTypeMap;
import com.arcway.repository.clientadapter.implementation.adapter.plan.ObjectTypeDeclarationPlan;
import com.arcway.repository.clientadapter.interFace.EXCockpitLockDenied;
import com.arcway.repository.clientadapter.interFace.EXCockpitPermissionDenied;
import com.arcway.repository.clientadapter.interFace.ILabel;
import com.arcway.repository.clientadapter.interFace.INameOrIDPropertyTypeDeclaration;
import com.arcway.repository.clientadapter.interFace.IParentRelationshipAdapter;
import com.arcway.repository.clientadapter.interFace.IPropertyType;
import com.arcway.repository.cockpit.interFace.declaration.frame.plan.COTIDsPlan;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;

public abstract class DataManagerAdapterAbstractPlan
extends AbstractDataManagerAdapter {
    private final IRepositoryObjectTypeID repositoryObjectTypeID;
    private final ILabel[] labels;
    private final IPropertyType[] nonInheritedPropertyTypes;
    private final IAttributeTypeID[] nonInheritedAttributeTypeIDs;
    private final String planTypeID;
    private final SectionManager sectionManager;
    private static final ICollection_<? extends IParentRelationshipAdapter> parentRelationshipAdapters = new ArrayList_(0);

    public DataManagerAdapterAbstractPlan(IFrameProjectAgent projectAgent, IRepositoryObjectTypeID repositoryObjectTypeID, String planTypeID, ILabel[] labels, IPropertyType[] nonInheritedPropertyTypes, IAttributeTypeID[] nonInheritedAttributeTypeIDs) {
        super(projectAgent, projectAgent.getFrameSectionManager());
        this.repositoryObjectTypeID = repositoryObjectTypeID;
        this.labels = labels;
        this.nonInheritedPropertyTypes = nonInheritedPropertyTypes;
        this.nonInheritedAttributeTypeIDs = nonInheritedAttributeTypeIDs;
        this.planTypeID = planTypeID;
        this.sectionManager = (SectionManager)projectAgent.getFrameSectionManager();
    }

    @Override
    public IRepositoryObjectTypeID getRepositoryObjectTypeID() {
        return this.repositoryObjectTypeID;
    }

    @Override
    public IRepositoryObjectTypeID getRepositorySuperObjectTypeID() {
        return COTIDsPlan.OBJECT_TYPE_ID;
    }

    @Override
    public ICollection_<? extends IParentRelationshipAdapter> getParentRelationshipAdapters() {
        return parentRelationshipAdapters;
    }

    @Override
    public ILabel[] getLabels() {
        return this.labels;
    }

    @Override
    public IPropertyType[] getFixPropertyTypes() {
        return this.nonInheritedPropertyTypes;
    }

    @Override
    public String getCockpitTypeThatProvidesCustomProperties() {
        return null;
    }

    @Override
    public INameOrIDPropertyTypeDeclaration getNamePropertyTypeDeclaration() {
        return null;
    }

    @Override
    public String getCockpitDataTypeID() {
        return "com.arcway.cockpit.plan";
    }

    @Override
    protected AttributeTypeID2PropertyTypeMap createAttributeTypeID2PropertyTypeMap() {
        return new AttributeTypeID2PropertyTypeMap((IAttributeTypeID[])ArrayUtils.concatenateArrays((Object[])this.nonInheritedAttributeTypeIDs, (Object[])ObjectTypeDeclarationPlan.allAttributeTypeIDs), (IPropertyType[])ArrayUtils.concatenateArrays((Object[])this.nonInheritedPropertyTypes, (Object[])ObjectTypeDeclarationPlan.allPropertyTypes));
    }

    private ISection getAsParentSection(ICockpitProjectData parent) {
        ISection parentSection = parent instanceof ICockpitProject ? this.sectionManager.getRootSection() : (ISection)parent;
        return parentSection;
    }

    private ICockpitProjectData getParent(IPlan childPlan) {
        Object parent = this.sectionManager.getParentSection(childPlan);
        if (parent == this.sectionManager.getRootSection()) {
            parent = this.sectionManager.getProjectAgent().getProject();
        }
        return parent;
    }

    @Override
    protected IAttributeOwnerRW findAttributeOwnerRW(String cockpitDataUID) {
        IPlanRW planRW = this.sectionManager.getPlanRW(cockpitDataUID);
        if (planRW != null && !planRW.getPlantypeUID().equals(this.planTypeID)) {
            planRW = null;
        }
        return planRW;
    }

    @Override
    protected ICockpitProjectData getParentCockpitData(IAttributeOwner child) {
        return this.getParent((IPlan)child);
    }

    protected Collection<IPlan> getChildCockpitDatas(IAttributeOwner parent) {
        ISection parentSection = this.getAsParentSection((ICockpitProjectData)parent);
        return this.sectionManager.getChildPlans(parentSection, this.planTypeID);
    }

    @Override
    protected ICockpitProjectData getChildCockpitData(IAttributeOwner parent, String name) {
        ISection parentSection = this.getAsParentSection((ICockpitProjectData)parent);
        return this.sectionManager.getChildPlan(parentSection, name);
    }

    protected Collection<IPlan> getAllCockpitDatas() {
        return this.sectionManager.getPlans(this.planTypeID);
    }

    @Override
    protected IAttributeType getAttributeType(IAttributeTypeID attributeTypeID) {
        IAttributeTypesProvider attributeTypesProv = this.getProjectAgent().getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider("com.arcway.cockpit.plan");
        return attributeTypesProv.getAttributeType(attributeTypeID);
    }

    @Override
    protected ICockpitProjectData createCockpitData(String cockpitDataUID, String name, IAttributeOwner parentCockpitData, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> cockpitAttributes) throws EXCockpitPermissionDenied, EXCockpitLockDenied {
        IPlan createdCockpitData;
        ISection parentSection = this.getAsParentSection((ICockpitProjectData)parentCockpitData);
        IPlanAddID addID = this.sectionManager.requestPlanAdditionPermission(cockpitDataUID, name, this.planTypeID, parentSection, objectTypeCategoryID, cockpitAttributes);
        DataManagerAdapterAbstractPlan.handleModificationProblem(addID.getModificationProblem());
        try {
            createdCockpitData = this.sectionManager.addPlan(addID);
        }
        catch (EXNoPermission e) {
            throw new RuntimeException(e);
        }
        return createdCockpitData;
    }

    protected IAttributeTypeID[] getAttributeTypeIDs() {
        return this.nonInheritedAttributeTypeIDs;
    }

    @Override
    public boolean isCreatableGenerically() {
        return false;
    }

    @Override
    public boolean isDeletableGenerically() {
        return false;
    }

    @Override
    public boolean isModifiableGenerically() {
        return true;
    }

    @Override
    public void checkPermissionForCreate(ICockpitProjectData parentCockpitData, ILocksAndPermissionsTransactionController transactionController) {
        ISection parentSection = this.getAsParentSection(parentCockpitData);
        transactionController.addClientLicenseType(ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans.getInstance());
        transactionController.addPermission("modifyFolders", null, this.getProjectAgent().getFrameSectionManager().getOperandTree(parentSection));
    }

    @Override
    public void checkPermissionForMove(IAttributeOwner cockpitData, ICockpitProjectData newParentCockpitData, ILocksAndPermissionsTransactionController transactionController) {
        ISection newParentSection = this.getAsParentSection(newParentCockpitData);
        transactionController.addClientLicenseType(ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans.getInstance());
        this.getProjectAgent().getFrameSectionManager().requestMovePermission(cockpitData, (IAttributeOwner)newParentSection, transactionController);
    }

    @Override
    public void checkPermissionForModifyProperty(IAttributeOwner cockpitData, IAttributeType attributeType, ILocksAndPermissionsTransactionController transactionController) {
        PlanAgentManager planAgentManager;
        transactionController.addClientLicenseType(ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans.getInstance());
        PlanAttributeModificationManager modificationManager = new PlanAttributeModificationManager(this.getProjectAgent());
        assert (cockpitData instanceof Plan);
        Plan plan = (Plan)cockpitData;
        modificationManager.setPlan(plan);
        modificationManager.checkGeneralModificationPermissions(attributeType, transactionController);
        if (attributeType.getAttributeTypeID().equals(PlanAttributeTypeProvider.ATTRID_PLAN_FILE_DESCRIPTION) && (planAgentManager = this.getProjectAgent().getPlanAgentManager()).isPlanWriteAccessed(plan)) {
            String cause = Messages.getString("DataManagerAdapterAbstractPlan.EditModeCause");
            String consequence = Messages.getString("DataManagerAdapterAbstractPlan.EditModeConsequence");
            transactionController.addPermissionModificationProblem(new ModificationProblem(cause, consequence));
        }
    }

    @Override
    protected void checkPermissionForModifyObjectTypeCategory(IAttributeOwner cockpitData, ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addClientLicenseType(ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans.getInstance());
        IPlan plan = (IPlan)cockpitData;
        this.getProjectAgent().getFrameSectionManager().requestPlanEditPermission(plan, transactionController);
    }

    @Override
    public void checkPermissionForDelete(IAttributeOwner cockpitData, ILocksAndPermissionsTransactionController transactionController) {
        IPlan plan = (IPlan)cockpitData;
        transactionController.addClientLicenseType(ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans.getInstance());
        this.getProjectAgent().getFrameSectionManager().requestPlanDeletionPermission(plan, transactionController);
    }

    @Override
    protected void getLockForCreateCockpitData(ICockpitProjectData parentCockpitData, ILocksAndPermissionsTransactionController transactionController) {
        ISection parentSection = this.getAsParentSection(parentCockpitData);
        transactionController.addLockToTest(parentSection, "delete");
        transactionController.addLock(parentSection, "add");
    }

    @Override
    protected void getLockForMoveCockpitData(IAttributeOwner cockpitData, ICockpitProjectData newParentCockpitData, ILocksAndPermissionsTransactionController transactionController) {
        ISection newParentSection = this.getAsParentSection(newParentCockpitData);
        this.getProjectAgent().getFrameSectionManager().requestMovePermission(cockpitData, (IAttributeOwner)newParentSection, transactionController);
    }

    @Override
    protected void getLockForModifyCockpitData(IAttributeOwner cockpitData, ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addLockToTest((ILockable)cockpitData, "modify");
        transactionController.addLock((ILockable)cockpitData, "modify");
    }

    @Override
    protected void getLockForDeleteCockpitData(IAttributeOwner cockpitData, ILocksAndPermissionsTransactionController transactionController) {
        IPlan plan = (IPlan)cockpitData;
        this.getProjectAgent().getFrameSectionManager().requestPlanDeletionPermission(plan, transactionController);
    }

    @Override
    public Sequence getSequentialLayoutSpecification(Locale contentLocale) {
        ArrayList<PageSpecification> pageSpecifications = new ArrayList<PageSpecification>();
        ArrayList<EntrySpecification> entrySpecifications = new ArrayList<EntrySpecification>();
        WidgetSpecification widgetSpec_objectTypeCategory = WidgetSpecification.getObjectTypeCategoryWidgetSpecification();
        entrySpecifications.add(new EntrySpecification((IWidgetSpecification)widgetSpec_objectTypeCategory, true));
        WidgetSpecification widgetSpec_horizontalLine = WidgetSpecification.getDecoratorWidgetSpecification((WidgetTypeID)WidgetTypeID.HORIZONTAL_SEPARATOR);
        entrySpecifications.add(new EntrySpecification((IWidgetSpecification)widgetSpec_horizontalLine, true));
        ArrayList<String> propertyTypeIds = new ArrayList<String>();
        propertyTypeIds.add(COTIDsPlan.PROPERTY_TYPE_ID_NAME.toCanonicalString());
        WidgetParameters widgetParams = new WidgetParameters(Messages.getString("Plan.Plan.Name", contentLocale), Messages.getString("Plan.Plan.Name", contentLocale), true);
        WidgetSpecification widgetSpec = new WidgetSpecification(false, propertyTypeIds, new HashMap(), (IWidgetTypeID)WidgetTypeID.FREESTRING, widgetParams);
        EntrySpecification entrySpec = new EntrySpecification((IWidgetSpecification)widgetSpec, true);
        entrySpecifications.add(entrySpec);
        propertyTypeIds = new ArrayList();
        propertyTypeIds.add(COTIDsPlan.PROPERTY_TYPE_ID_DESCRIPTION.toCanonicalString());
        widgetParams = new WidgetParameters(Messages.getString("Plan.Plan.Description", contentLocale), Messages.getString("Plan.Plan.Description", contentLocale), true);
        widgetSpec = new WidgetSpecification(false, propertyTypeIds, new HashMap(), (IWidgetTypeID)WidgetTypeID.FREETEXT, widgetParams);
        entrySpec = new EntrySpecification((IWidgetSpecification)widgetSpec, true);
        entrySpecifications.add(entrySpec);
        propertyTypeIds = new ArrayList();
        propertyTypeIds.add(COTIDsPlan.PROPERTY_TYPE_ID_PLANFILE.toCanonicalString());
        widgetParams = new FileWidgetParameters(Messages.getString("Plan.Plan.PlanFile", contentLocale), Messages.getString("Plan.Plan.PlanFile", contentLocale), false, false, FileWidgetParameters.Mode.SHOW_AUTHOR_AND_DATE_ONLY);
        widgetSpec = new WidgetSpecification(false, propertyTypeIds, new HashMap(), (IWidgetTypeID)WidgetTypeID.FILE, widgetParams);
        entrySpec = new EntrySpecification((IWidgetSpecification)widgetSpec, true);
        entrySpecifications.add(entrySpec);
        WidgetParameters widgetParas = new WidgetParameters(Messages.getString("ImportDialogueLayout.CockpitData.CustomProperties.Label"), Messages.getString("ImportDialogueLayout.CockpitData.CustomProperties.Tooltip"), true);
        CustomPropertySpecification widgetSpec2 = new CustomPropertySpecification(widgetParas);
        EntrySpecification entrySpec2 = new EntrySpecification((IWidgetSpecification)widgetSpec2, true);
        entrySpecifications.add(entrySpec2);
        PageWidgetParameters pageParams = new PageWidgetParameters(Messages.getString("ImportDialogueLayout.CockpitData.Properties.Label"), Messages.getString("ImportDialogueLayout.CockpitData.Properties.Tooltip"), true, 0);
        PageSpecification pageSpec = new PageSpecification(entrySpecifications, (WidgetParameters)pageParams);
        pageSpecifications.add(pageSpec);
        Sequence editor = new Sequence(pageSpecifications, null);
        return editor;
    }
}

