/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter;

import com.arcway.lib.java.Assert;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterItem;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterSnapshot;
import com.arcway.repository.cockpitadapter.locks.EOPlatformLock;
import com.arcway.repository.implementation.lock.OccurrenceRepositoryRelationLockSample;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryLockSample;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.property.IRepositoryProperty;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelation;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationReference;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.registration.type.IRepositoryDeclarationItem;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.item.IRepositoryItemType;
import com.arcway.repository.interFace.registration.type.relation.IOccurrenceRepositoryRelationType;
import com.arcway.repository.lib.high.implementation.access.OccurrenceRepositoryRelationReference;
import com.arcway.repository.lib.high.implementation.access.OccurrenceRepositoryRelationSample;

public class PlatformAdapterOccurrenceRelation
extends PlatformAdapterItem
implements IOccurrenceRepositoryRelation {
    private final IOccurrenceRepositoryRelationType repositoryRelationType;
    private final IRepositoryObject occuringObject;
    private final IRepositoryProperty occurenceProperty;
    private final String occurenceID;

    public PlatformAdapterOccurrenceRelation(PlatformAdapterSnapshot snapshot, IOccurrenceRepositoryRelationType repositoryRelationType, IRepositoryObject occuringObject, IRepositoryProperty occurenceProperty, String occurenceID) {
        super(snapshot);
        Assert.checkArgumentBeeingNotNull((Object)repositoryRelationType);
        this.repositoryRelationType = repositoryRelationType;
        this.occuringObject = occuringObject;
        this.occurenceProperty = occurenceProperty;
        this.occurenceID = occurenceID;
    }

    public IRepositoryDeclarationItem getType() {
        return this.getItemType();
    }

    public IRepositoryItemType getItemType() {
        return this.getRelationType();
    }

    public IOccurrenceRepositoryRelationType getRelationType() {
        return this.repositoryRelationType;
    }

    public IRepositoryObject getOccuringObject() throws EXNotReproducibleSnapshot {
        return this.occuringObject;
    }

    public IRepositoryProperty getOccurrenceContainingProperty() throws EXNotReproducibleSnapshot {
        return this.occurenceProperty;
    }

    public String getOccurrenceID() {
        return this.occurenceID;
    }

    public IOccurrenceRepositoryRelationSample sample() throws EXNotReproducibleSnapshot {
        return new OccurrenceRepositoryRelationSample((IOccurrenceRepositoryRelation)this);
    }

    public IRepositoryPropertySetSample getSnapshotIDOfLastModification() {
        OccurrenceRepositoryRelationReference relationReference;
        try {
            relationReference = new OccurrenceRepositoryRelationReference(this.sample());
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new RuntimeException("cannot happen");
        }
        IRepositoryPropertySetSample snapshotID = RepositorySamples.getSnapshotID((IRepositoryObjectSample)this.getSnapshotImplementation().getSnapshotInformation(), (IRepositoryTypeManagerRO)this.getTypeManager());
        OccurrenceRepositoryRelationLockSample relationLockSample = new OccurrenceRepositoryRelationLockSample((IOccurrenceRepositoryRelationReference)relationReference, snapshotID);
        EOPlatformLock eoLock = this.getSnapshotImplementation().getWorkstationImplementation().createEOLock((AbstractRepositoryLockSample)relationLockSample);
        String commitUID = this.getLockManager().getCommitUID(eoLock);
        return this.getWorkstationImplementation().getSnapshotID(commitUID);
    }
}

