/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IEntry_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterObject;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterSnapshot;
import com.arcway.repository.clientadapter.interFace.ILinkManagerAdapter;
import com.arcway.repository.clientadapter.interFace.IRelation;
import com.arcway.repository.clientadapter.interFace.IRelationContributionWithRelatedObject;
import com.arcway.repository.clientadapter.lib.RelationContributionWithRelatedObject;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.data.relation.IRepositoryIterator_ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.transactions.exceptions.EXMissingCrossLinkTarget;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PlatformAdapterCockpitCrossLinkIterator
implements IRepositoryIterator_ICrossLinkRepositoryRelation {
    private static final ILogger logger = Logger.getLogger(PlatformAdapterCockpitCrossLinkIterator.class);
    private Iterator<Map.Entry<ICrossLinkRepositoryRelationType, List<IRelation>>> javaIteratorOverEntriesOfConcreteRelationType2NonEmptyListOfFoundCockpitRelations;
    private ICrossLinkRepositoryRelationType currentConcreteRelationType;
    private Iterator<IRelation> javaIteratorOverCurrentNonEmptyListOfFoundCockpitRelations;
    private PlatformAdapterSnapshot snapshot;
    private boolean isDisposed = false;

    PlatformAdapterCockpitCrossLinkIterator(ICrossLinkRepositoryRelationType relationType, IMap_<IRepositoryRelationContributionRoleID, IRepositoryPropertySetSample> roleID2ObjectIDs, PlatformAdapterSnapshot snapshot) throws EXMissingCrossLinkTarget {
        HashMap_ roleID2missingObjectIDs = new HashMap_(roleID2ObjectIDs.size(), IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER);
        IRelationContributionWithRelatedObject[] knownRelationContributions = new IRelationContributionWithRelatedObject[roleID2ObjectIDs.size()];
        int index = 0;
        for (IEntry_ roleID2ObjectID : roleID2ObjectIDs) {
            IRepositoryRelationContributionRoleID roleID = (IRepositoryRelationContributionRoleID)roleID2ObjectID.getKey();
            IRepositoryPropertySetSample objectID = (IRepositoryPropertySetSample)roleID2ObjectID.getValue();
            IRepositoryObjectType abstractObjectType = relationType.getRelationContributionType(roleID).getRelatedObjectType();
            PlatformAdapterObject repositoryObject = snapshot.findRepositoryObjectImplementation(abstractObjectType, objectID);
            if (repositoryObject == null) {
                roleID2missingObjectIDs.put((Object)roleID, (Object)objectID);
            } else {
                knownRelationContributions[index] = new RelationContributionWithRelatedObject(roleID, repositoryObject);
            }
            ++index;
        }
        if (!roleID2missingObjectIDs.isEmpty()) {
            this.dispose();
            HashMap_ roleID2existingObjectIDs = new HashMap_(roleID2ObjectIDs.size() - roleID2missingObjectIDs.size(), IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER);
            for (IEntry_ roleID2ObjectID : roleID2ObjectIDs) {
                IRepositoryRelationContributionRoleID roleID = (IRepositoryRelationContributionRoleID)roleID2ObjectID.getKey();
                if (roleID2missingObjectIDs.containsKey((Object)roleID)) continue;
                IRepositoryPropertySetSample objectID = (IRepositoryPropertySetSample)roleID2ObjectID.getValue();
                roleID2existingObjectIDs.put((Object)roleID, (Object)objectID);
            }
            throw new EXMissingCrossLinkTarget(relationType.getRepositoryRelationTypeID(), (IMap_)roleID2existingObjectIDs, (IMap_)roleID2missingObjectIDs);
        }
        this.snapshot = snapshot;
        ICollection_ relationTypes = relationType.getAllInstanciableRelationTypesOfThisType();
        HashMap<ICrossLinkRepositoryRelationType, List<IRelation>> concreteRelationType2ListOfFoundCockpitRelations = new HashMap<ICrossLinkRepositoryRelationType, List<IRelation>>();
        for (ICrossLinkRepositoryRelationType concreteRelationType : relationTypes) {
            ILinkManagerAdapter linkManagerAdapter = snapshot.getLinkManagerAdapter(concreteRelationType);
            IRelation[] cockpitRelations = linkManagerAdapter.getRelations(knownRelationContributions);
            if (cockpitRelations.length <= 0) continue;
            List<IRelation> listOfFoundCockpitRelations = Arrays.asList(cockpitRelations);
            concreteRelationType2ListOfFoundCockpitRelations.put(concreteRelationType, listOfFoundCockpitRelations);
        }
        this.javaIteratorOverEntriesOfConcreteRelationType2NonEmptyListOfFoundCockpitRelations = concreteRelationType2ListOfFoundCockpitRelations.entrySet().iterator();
        if (this.javaIteratorOverEntriesOfConcreteRelationType2NonEmptyListOfFoundCockpitRelations.hasNext()) {
            this.nextConcreteRelationType();
        } else {
            this.currentConcreteRelationType = null;
            List emptyList = Collections.emptyList();
            this.javaIteratorOverCurrentNonEmptyListOfFoundCockpitRelations = emptyList.iterator();
        }
    }

    private void nextConcreteRelationType() {
        Map.Entry<ICrossLinkRepositoryRelationType, List<IRelation>> nextEntryOfConcreteRelationType2ListOfFoundCockpitRelations = this.javaIteratorOverEntriesOfConcreteRelationType2NonEmptyListOfFoundCockpitRelations.next();
        this.currentConcreteRelationType = nextEntryOfConcreteRelationType2ListOfFoundCockpitRelations.getKey();
        List<IRelation> nextListOfFoundCockpitRelations = nextEntryOfConcreteRelationType2ListOfFoundCockpitRelations.getValue();
        this.javaIteratorOverCurrentNonEmptyListOfFoundCockpitRelations = nextListOfFoundCockpitRelations.iterator();
    }

    public void abortIteration() {
        this.dispose();
    }

    public boolean hasNext() throws EXNotReproducibleSnapshot {
        boolean hasNext;
        if (this.isDisposed) {
            hasNext = false;
        } else {
            boolean bl = hasNext = this.javaIteratorOverCurrentNonEmptyListOfFoundCockpitRelations.hasNext() || this.javaIteratorOverEntriesOfConcreteRelationType2NonEmptyListOfFoundCockpitRelations.hasNext();
            if (!hasNext) {
                this.dispose();
            }
        }
        return hasNext;
    }

    private void dispose() {
        Assert.checkState((!this.isDisposed ? 1 : 0) != 0);
        this.isDisposed = true;
        this.javaIteratorOverEntriesOfConcreteRelationType2NonEmptyListOfFoundCockpitRelations = null;
        this.currentConcreteRelationType = null;
        this.javaIteratorOverCurrentNonEmptyListOfFoundCockpitRelations = null;
        this.snapshot = null;
    }

    public ICrossLinkRepositoryRelation nextIRepositoryRelation() {
        Assert.checkState((!this.isDisposed ? 1 : 0) != 0);
        if (!this.javaIteratorOverCurrentNonEmptyListOfFoundCockpitRelations.hasNext()) {
            this.nextConcreteRelationType();
        }
        IRelation nextCockpitRelation = this.javaIteratorOverCurrentNonEmptyListOfFoundCockpitRelations.next();
        return this.snapshot.fetchRelation(this.currentConcreteRelationType, nextCockpitRelation);
    }

    protected void finalize() throws Throwable {
        if (!this.isDisposed) {
            logger.error("Iterator was finalized, but not disposed.");
        }
        super.finalize();
    }
}

