/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version4;

import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedRuntimeException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOAttribute_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOFileDescription_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOFileHistoryItem_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOFrameData_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLinkLog_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOModuleData_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOVersionedModuleData_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.V0_EOFactory;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.EOModuleDataContainerEncoder;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.EOModuleDataContainer_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.V0_EOFactory_ForModules;
import com.arcway.cockpit.frame.client.project.migration.access_both.version4.EOCommitCountAndCommitInformation_V4;
import com.arcway.cockpit.frame.client.project.migration.access_both.version4.EOCommitInformation_V4;
import com.arcway.cockpit.frame.client.project.migration.access_both.version4.EOUserInformation_V4;
import com.arcway.cockpit.frame.client.project.migration.access_both.version5.EOAttributeTypeID_V5;
import com.arcway.cockpit.frame.client.project.migration.access_both.version5.EOAttribute_V5;
import com.arcway.cockpit.frame.client.project.migration.access_both.version5.EOCockpitProjectDataContainer_V5;
import com.arcway.cockpit.frame.client.project.migration.access_both.version5.EOCockpitProjectData_V5;
import com.arcway.cockpit.frame.client.project.migration.access_both.version5.EOFileID_V5;
import com.arcway.cockpit.frame.client.project.migration.access_both.version5.EOFileMetaInformation_V5;
import com.arcway.cockpit.frame.client.project.migration.access_both.version5.EOFrameData_V5;
import com.arcway.cockpit.frame.client.project.migration.access_both.version5.EOLinkLog_V5;
import com.arcway.cockpit.frame.client.project.migration.access_both.version5.EOModuleData_V5;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version4.HistoricProjectDumpView_4_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version4.HistoricProjectFileView_4_;
import com.arcway.cockpit.modulelib2.client.migration.log.DumpLogFileEncoder;
import com.arcway.cockpit.modulelib2.client.migration.log.IDumpLogMigrator;
import com.arcway.cockpit.modulelib2.client.migration.log.LogfileMigrationHelper;
import com.arcway.cockpit.modulelib2.client.migration.log.version5.IDumpLogMigrator_V0_to_V5;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.java.tuples.KeyTuple;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.MessageDataFactoryForBasicEOs;
import de.plans.lib.xml.encoding.MultiplexEncodableObjectFactory;
import de.plans.lib.xml.primitiveTypes.EOString;
import de.plans.psc.shared.message.PSCPlainMessageDataFactory;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FileTypesAndVersionsMigrator
implements ICockpitMigrator {
    private static final ILogger LOGGER = Logger.getLogger(FileTypesAndVersionsMigrator.class);
    public static final String KEY = "FileTypesAndVersionsMigrator";
    private static final int COMMIT_COUNT_PROJECTFILE = 1;
    private static final IEncodableObjectFactory eoFactory = new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{V0_EOFactory.getDefault(), V0_EOFactory_ForModules.getDefault(), PSCPlainMessageDataFactory.getDefault()});

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public int getSourceVersion() {
        return 4;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.emptyList();
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return eoFactory;
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) throws MigrationFailedException {
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        try {
            HistoricProjectDumpView_4_ historicView = (HistoricProjectDumpView_4_)projectDump;
            List<EOProject_V0> projects = historicView.getAllProjects();
            if (projects != null) {
                for (EOProject_V0 currentProject : projects) {
                    EOList<EOCommitCountAndCommitInformation_V4> commitInformationItems = historicView.readCommitInformationItems(currentProject);
                    HashMap<KeyTuple<String, Integer>, EOFileHistoryItem_V0> map_fileUIDAndVersion_fileInfo = new HashMap<KeyTuple<String, Integer>, EOFileHistoryItem_V0>();
                    HashMap<String, Integer> map_commitUID_commitCount = new HashMap<String, Integer>();
                    commitInformationItems = this.createFileIndexAndFindAdditionalCommitInformationItems(historicView, currentProject, commitInformationItems, map_fileUIDAndVersion_fileInfo, map_commitUID_commitCount);
                    historicView.writeCommitInformationItems(currentProject, commitInformationItems);
                    this.transformFrameDataItems(Collections.singleton(currentProject), commitInformationItems, map_fileUIDAndVersion_fileInfo, map_commitUID_commitCount, null);
                    EOList plans = (EOList)historicView.readDataFile(currentProject, "plans.xml", null, eoFactory);
                    EOList planHistory = new EOList();
                    EOList<EOFrameData_V5> transformedPlans = this.transformFrameDataItems((Collection<? extends EOFrameData_V0>)plans, commitInformationItems, map_fileUIDAndVersion_fileInfo, map_commitUID_commitCount, (EOList<EOFrameData_V5>)planHistory);
                    historicView.writeDataFile(currentProject, "plans.xml", null, (EncodableObjectBase)transformedPlans);
                    EOCockpitProjectDataContainer_V5 planHistoryContainer = new EOCockpitProjectDataContainer_V5("only_a_single_datatype");
                    planHistoryContainer.setCockpitProjectDataItems((EOList<? extends EOCockpitProjectData_V5>)planHistory);
                    EOList planHistoryContainerList = new EOList();
                    planHistoryContainerList.add((EncodableObjectBase)planHistoryContainer);
                    historicView.writeDataFile(currentProject, "plans_history.xml", null, (EncodableObjectBase)planHistoryContainerList);
                    EOList sections = (EOList)historicView.readDataFile(currentProject, "sections.xml", null, eoFactory);
                    EOList<EOFrameData_V5> transformedSections = this.transformFrameDataItems((Collection<? extends EOFrameData_V0>)sections, commitInformationItems, map_fileUIDAndVersion_fileInfo, map_commitUID_commitCount, null);
                    historicView.writeDataFile(currentProject, "sections.xml", null, (EncodableObjectBase)transformedSections);
                    EOList modelElements = (EOList)historicView.readDataFile(currentProject, "uniqueElements.xml", null, eoFactory);
                    EOList<EOFrameData_V5> transformedModelElements = this.transformFrameDataItems((Collection<? extends EOFrameData_V0>)modelElements, commitInformationItems, map_fileUIDAndVersion_fileInfo, map_commitUID_commitCount, null);
                    historicView.writeDataFile(currentProject, "uniqueElements.xml", null, (EncodableObjectBase)transformedModelElements);
                    EOList stakeholders = (EOList)historicView.readDataFile(currentProject, "Stakeholders.xml", null, eoFactory);
                    EOList<EOFrameData_V5> transformedStakeholders = this.transformFrameDataItems((Collection<? extends EOFrameData_V0>)stakeholders, commitInformationItems, map_fileUIDAndVersion_fileInfo, map_commitUID_commitCount, null);
                    historicView.writeDataFile(currentProject, "Stakeholders.xml", null, (EncodableObjectBase)transformedStakeholders);
                    EOList stakeholderRoles = (EOList)historicView.readDataFile(currentProject, "Roles.xml", null, eoFactory);
                    EOList<EOFrameData_V5> transformedStakeholderRoles = this.transformFrameDataItems((Collection<? extends EOFrameData_V0>)stakeholderRoles, commitInformationItems, map_fileUIDAndVersion_fileInfo, map_commitUID_commitCount, null);
                    historicView.writeDataFile(currentProject, "Roles.xml", null, (EncodableObjectBase)transformedStakeholderRoles);
                    EOList frameDataItems = (EOList)historicView.readDataFile(currentProject, "frameData.xml", null, eoFactory);
                    EOList<EOFrameData_V5> transformedFrameDataItems = this.transformFrameDataItems((Collection<? extends EOFrameData_V0>)frameDataItems, commitInformationItems, map_fileUIDAndVersion_fileInfo, map_commitUID_commitCount, null);
                    historicView.writeDataFile(currentProject, "frameData.xml", null, (EncodableObjectBase)transformedFrameDataItems);
                    EOList moduleDataItems = (EOList)historicView.readDataFile(currentProject, "cmm_data.xml", "cmm", eoFactory);
                    EOList<EOCockpitProjectDataContainer_V5> transformedModuleDataItems = this.transformModuleDataItemsInContainers(moduleDataItems, commitInformationItems, map_fileUIDAndVersion_fileInfo);
                    historicView.writeDataFile(currentProject, "cmm_data.xml", "cmm", (EncodableObjectBase)transformedModuleDataItems);
                    this.migrateModuleDataHistory(historicView, currentProject, commitInformationItems, map_fileUIDAndVersion_fileInfo);
                    EOList<EOFileMetaInformation_V5> fileMetaInformation = FileTypesAndVersionsMigrator.getFileMetaInformation(map_fileUIDAndVersion_fileInfo, map_commitUID_commitCount, currentProject.getProjectUID());
                    historicView.writeDataFile(currentProject, "metainformation.xml", "files", (EncodableObjectBase)fileMetaInformation);
                }
            }
        }
        catch (EXDecoderException e) {
            throw new MigrationFailedException(e);
        }
    }

    private void migrateModuleDataHistory(HistoricProjectDumpView_4_ historicView, EOProject_V0 currentProject, final EOList<EOCommitCountAndCommitInformation_V4> commitInformationItems, final Map<KeyTuple<String, Integer>, EOFileHistoryItem_V0> map_fileUIDAndVersion_fileInfo) throws MigrationFailedException {
        IDumpLogMigrator_V0_to_V5 dumpLogMigrator = new IDumpLogMigrator_V0_to_V5(){

            @Override
            public IDumpLogMigrator.IIsInterested isInterestedInContainer(String dataTypeUID) {
                return new IDumpLogMigrator.IsInterested(dataTypeUID);
            }

            @Override
            public EOModuleData_V5 migrateModuleData(EOVersionedModuleData_V0 item) {
                try {
                    return FileTypesAndVersionsMigrator.this.transformModuleDataItem(item, map_fileUIDAndVersion_fileInfo, (EOList<EOCommitCountAndCommitInformation_V4>)commitInformationItems);
                }
                catch (MigrationFailedException e) {
                    throw new MigrationFailedRuntimeException(e);
                }
            }

            @Override
            public void addFurtherModuleData(String dataTypeID, EOModuleDataContainerEncoder<EOModuleData_V5, EOCockpitProjectDataContainer_V5> moduleDataEncoder) throws EXEncoderException {
            }

            @Override
            public void addFurtherModuleDataContainers(DumpLogFileEncoder<EOModuleData_V5, EOCockpitProjectDataContainer_V5> dumpLogFileEncoder) throws EXEncoderException {
            }
        };
        try {
            LogfileMigrationHelper.migrateModuleLogFile_V0_to_V5(historicView, currentProject, eoFactory, dumpLogMigrator);
        }
        catch (MigrationFailedRuntimeException e) {
            e.rethrow();
        }
    }

    private EOList<EOCockpitProjectDataContainer_V5> transformModuleDataItemsInContainers(EOList<EOModuleDataContainer_V0<?>> items, EOList<EOCommitCountAndCommitInformation_V4> commitInformationItems, Map<KeyTuple<String, Integer>, EOFileHistoryItem_V0> map_fileUIDAndVersion_fileInfo) throws MigrationFailedException {
        EOList transformedContainers = new EOList();
        for (EOModuleDataContainer_V0 container : items) {
            EOList<EOModuleData_V5> transformedItems = this.transformModuleDataItems((Collection<EOModuleData_V0>)container.getModuleDataItems(), commitInformationItems, map_fileUIDAndVersion_fileInfo);
            EOCockpitProjectDataContainer_V5 transformedContainer = new EOCockpitProjectDataContainer_V5(container.getDataTypeUID());
            transformedContainer.setCockpitProjectDataItems(transformedItems);
            transformedContainers.add((EncodableObjectBase)transformedContainer);
        }
        return transformedContainers;
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateProjectFile(projectFile);
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateProjectFile(projectFile);
    }

    private void migrateProjectFile(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        HistoricProjectFileView_4_ historicView = (HistoricProjectFileView_4_)projectFile;
        try {
            EOProject_V0 project = historicView.getProjectMetaData();
            EOList commitInformationItems = new EOList();
            commitInformationItems.add((EncodableObjectBase)new EOCommitCountAndCommitInformation_V4(1, new EOCommitInformation_V4(UUIDGenerator.getUniqueID(), new Date(System.currentTimeMillis()), new EOUserInformation_V4("", "", "", "", ""), "")));
            HashMap<KeyTuple<String, Integer>, EOFileHistoryItem_V0> map_fileUIDAndVersion_fileInfo = new HashMap<KeyTuple<String, Integer>, EOFileHistoryItem_V0>();
            this.createFileIndex(historicView, map_fileUIDAndVersion_fileInfo);
            this.transformFrameDataItems(Collections.singleton(project), (EOList<EOCommitCountAndCommitInformation_V4>)commitInformationItems, map_fileUIDAndVersion_fileInfo, null, null);
            EOList<? extends EncodableObjectBase> plans = historicView.getDataList("plans");
            EOList<EOFrameData_V5> transformedPlans = this.transformFrameDataItems((Collection<? extends EOFrameData_V0>)plans, (EOList<EOCommitCountAndCommitInformation_V4>)commitInformationItems, (Map<KeyTuple<String, Integer>, EOFileHistoryItem_V0>)map_fileUIDAndVersion_fileInfo, null, null);
            historicView.getMainData().remove(plans);
            transformedPlans.setRole("plans");
            historicView.getMainData().add(transformedPlans);
            EOList<? extends EncodableObjectBase> sections = historicView.getDataList("sections");
            EOList<EOFrameData_V5> transformedSections = this.transformFrameDataItems((Collection<? extends EOFrameData_V0>)sections, (EOList<EOCommitCountAndCommitInformation_V4>)commitInformationItems, (Map<KeyTuple<String, Integer>, EOFileHistoryItem_V0>)map_fileUIDAndVersion_fileInfo, null, null);
            historicView.getMainData().remove(sections);
            transformedSections.setRole("sections");
            historicView.getMainData().add(transformedSections);
            EOList<? extends EncodableObjectBase> modelElements = historicView.getDataList("unique elements");
            EOList<EOFrameData_V5> transformedModelElements = this.transformFrameDataItems((Collection<? extends EOFrameData_V0>)modelElements, (EOList<EOCommitCountAndCommitInformation_V4>)commitInformationItems, (Map<KeyTuple<String, Integer>, EOFileHistoryItem_V0>)map_fileUIDAndVersion_fileInfo, null, null);
            historicView.getMainData().remove(modelElements);
            transformedModelElements.setRole("unique elements");
            historicView.getMainData().add(transformedModelElements);
            EOList<? extends EncodableObjectBase> stakeholders = historicView.getDataList("stakeholders");
            EOList<EOFrameData_V5> transformedStakeholders = this.transformFrameDataItems((Collection<? extends EOFrameData_V0>)stakeholders, (EOList<EOCommitCountAndCommitInformation_V4>)commitInformationItems, (Map<KeyTuple<String, Integer>, EOFileHistoryItem_V0>)map_fileUIDAndVersion_fileInfo, null, null);
            historicView.getMainData().remove(stakeholders);
            transformedStakeholders.setRole("stakeholders");
            historicView.getMainData().add(transformedStakeholders);
            EOList<? extends EncodableObjectBase> stakeholderRoles = historicView.getDataList("stakeholder roles");
            EOList<EOFrameData_V5> transformedStakeholderRoles = this.transformFrameDataItems((Collection<? extends EOFrameData_V0>)stakeholderRoles, (EOList<EOCommitCountAndCommitInformation_V4>)commitInformationItems, (Map<KeyTuple<String, Integer>, EOFileHistoryItem_V0>)map_fileUIDAndVersion_fileInfo, null, null);
            historicView.getMainData().remove(stakeholderRoles);
            transformedStakeholderRoles.setRole("stakeholder roles");
            historicView.getMainData().add(transformedStakeholderRoles);
            EOList<? extends EncodableObjectBase> frameDataItems = historicView.getDataList("frame_data");
            EOList transformedFrameDataItems = new EOList();
            for (EOList itemsOfType : frameDataItems) {
                EOList<EOFrameData_V5> transformedItemsOfType = this.transformFrameDataItems((Collection<? extends EOFrameData_V0>)itemsOfType, (EOList<EOCommitCountAndCommitInformation_V4>)commitInformationItems, map_fileUIDAndVersion_fileInfo, null, null);
                transformedItemsOfType.setRole(itemsOfType.getRole());
                transformedFrameDataItems.add(transformedItemsOfType);
            }
            historicView.getMainData().remove(frameDataItems);
            transformedFrameDataItems.setRole("frame_data");
            historicView.getMainData().add((EncodableObjectBase)transformedFrameDataItems);
            EOList<? extends EncodableObjectBase> moduleDataItems = historicView.getDataList("module data");
            EOList transformedModuleDataItems = new EOList();
            for (EOList itemsOfType : moduleDataItems) {
                EOList<EOModuleData_V5> transformedItemsOfType = this.transformModuleDataItems((Collection<EOModuleData_V0>)itemsOfType, (EOList<EOCommitCountAndCommitInformation_V4>)commitInformationItems, map_fileUIDAndVersion_fileInfo);
                transformedItemsOfType.setRole(itemsOfType.getRole());
                transformedModuleDataItems.add(transformedItemsOfType);
            }
            historicView.getMainData().remove(moduleDataItems);
            transformedModuleDataItems.setRole("module data");
            historicView.getMainData().add((EncodableObjectBase)transformedModuleDataItems);
            EOList<EOFileMetaInformation_V5> fileMetaInformation = FileTypesAndVersionsMigrator.getFileMetaInformation(map_fileUIDAndVersion_fileInfo, null, project.getProjectUID());
            fileMetaInformation.setRole("fileMetaInformation");
            historicView.getMainData().add(fileMetaInformation);
        }
        catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
            throw new MigrationFailedException("Can't access project file.", pfaE);
        }
    }

    private EOList<EOFrameData_V5> transformFrameDataItems(Collection<? extends EOFrameData_V0> items, EOList<EOCommitCountAndCommitInformation_V4> commitInformationItems, Map<KeyTuple<String, Integer>, EOFileHistoryItem_V0> map_fileUIDAndVersion_fileInfo, Map<String, Integer> map_commitUID_commitCount, EOList<EOFrameData_V5> planHistory) throws MigrationFailedException {
        EOList transformedItems = new EOList();
        for (final EOFrameData_V0 eOFrameData_V0 : items) {
            EOFrameData_V5 transformedItem = new EOFrameData_V5(eOFrameData_V0.getTag());
            transformedItem.setUID(eOFrameData_V0.getUID());
            transformedItem.setProjectUID(eOFrameData_V0.getProjectUID());
            transformedItem.setTypeID(eOFrameData_V0.getTypeID());
            transformedItem.setModCount(eOFrameData_V0.getModCount());
            long modTime = this.determineModTime(eOFrameData_V0);
            int commitIndex = 0;
            while (commitIndex < commitInformationItems.size() - 1 && ((EOCommitCountAndCommitInformation_V4)commitInformationItems.get(commitIndex)).getCommitInformation().getCommitDate().getTime() < modTime) {
                ++commitIndex;
            }
            transformedItem.setCommitCount(((EOCommitCountAndCommitInformation_V4)commitInformationItems.get(commitIndex)).getCommitCount());
            String[] planFileOldID = new String[1];
            int[] planFileVersion = new int[1];
            String[] planFileOriginalFileName = new String[1];
            IContextLogInfoStringProvider contextLogInfoStringProvider = new IContextLogInfoStringProvider(){

                @Override
                public String getContextLogInfo() {
                    return "[ ProjectUID=" + eOFrameData_V0.getProjectUID() + ", ItemTypeID=" + eOFrameData_V0.getTypeID() + ", ItemUID=" + eOFrameData_V0.getUID() + ", ItemModCount=" + eOFrameData_V0.getModCount() + " ]";
                }
            };
            List<EOAttribute_V5> transformedAttributes = this.transformAttributes(eOFrameData_V0.getAttributes(), map_fileUIDAndVersion_fileInfo, eOFrameData_V0.getUID(), modTime, planHistory, planFileOldID, planFileVersion, planFileOriginalFileName, contextLogInfoStringProvider);
            for (EOAttribute_V5 attribute : transformedAttributes) {
                transformedItem.addAttribute(attribute);
            }
            transformedItem.setOldAttributes(eOFrameData_V0.getOldAttributes());
            transformedItem.setOldChildren(eOFrameData_V0.getOldChildren());
            transformedItems.add((EncodableObjectBase)transformedItem);
            if (planHistory == null) continue;
            if (planFileOldID[0] != null) {
                int version = planFileVersion[0];
                while (version >= 1) {
                    EOFileHistoryItem_V0 fileInfo_ = this.getFileInfo(map_fileUIDAndVersion_fileInfo, planFileOldID[0], version, contextLogInfoStringProvider);
                    String newFileID_ = fileInfo_.getFileUID();
                    String commitUID_ = fileInfo_.getNewCommitUID();
                    int commitCount_ = map_commitUID_commitCount.get(commitUID_);
                    if (version == planFileVersion[0]) {
                        transformedItem.setModCount(version);
                        transformedItem.setCommitCount(commitCount_);
                    }
                    fileInfo_.setOriginalFileName(planFileOriginalFileName[0]);
                    if (fileInfo_.getCreationDate() == null) {
                        fileInfo_.setCreationDate(new Timestamp(modTime));
                    }
                    EOFrameData_V5 historicPlan = transformedItem.copy();
                    historicPlan.setModCount(version);
                    historicPlan.setCommitCount(commitCount_);
                    historicPlan.setIsHistoricItem(true);
                    EOAttribute_V5 planFileAttribute = new EOAttribute_V5();
                    planFileAttribute.setAttributeTypeID(new EOAttributeTypeID_V5("frame.plan.planfiledescription", "planfiledescription"));
                    planFileAttribute.setValueAsEO(new EOFileID_V5(newFileID_));
                    historicPlan.addAttribute(planFileAttribute);
                    EOAttribute_V5 modifierAttribute = new EOAttribute_V5();
                    modifierAttribute.setAttributeTypeID(new EOAttributeTypeID_V5("framedata.lastEditor", "lastEditor"));
                    modifierAttribute.setValueAsEO((EOEncodableObject)new EOString(fileInfo_.getAuthor()));
                    historicPlan.addAttribute(modifierAttribute);
                    EOAttribute_V5 modificationDateAttribute = new EOAttribute_V5();
                    modificationDateAttribute.setAttributeTypeID(new EOAttributeTypeID_V5("framedata.lastEditDate", "lastEditDate"));
                    modificationDateAttribute.setValueAsEO((EOEncodableObject)new EOString(String.valueOf(fileInfo_.getCreationDate().getTime())));
                    historicPlan.addAttribute(modificationDateAttribute);
                    planHistory.add((EncodableObjectBase)historicPlan);
                    --version;
                }
                continue;
            }
            throw new MigrationFailedException("Plan without plan file attribute: " + eOFrameData_V0.getUID());
        }
        return transformedItems;
    }

    private List<EOAttribute_V5> transformAttributes(Collection<EOAttribute_V0> attributes, Map<KeyTuple<String, Integer>, EOFileHistoryItem_V0> map_fileUIDAndVersion_fileInfo, String itemUID, long itemModTime, EOList<EOFrameData_V5> planHistory, String[] planFileOldID, int[] planFileVersion, String[] planFileOriginalFileName, IContextLogInfoStringProvider contextLogInfoStringProvider) throws MigrationFailedException {
        ArrayList<EOAttribute_V5> transformedAttributes = new ArrayList<EOAttribute_V5>();
        for (EOAttribute_V0 attribute : attributes) {
            if (attribute.getValueAsEO() instanceof EOFileDescription_V0) {
                String newFileID;
                EOFileHistoryItem_V0 fileInfo;
                EOFileDescription_V0 oldFileDescription = (EOFileDescription_V0)attribute.getValueAsEO();
                String oldVersionID = oldFileDescription.getFileID().getVersionID();
                int version = -1;
                if (oldVersionID == null || oldVersionID.equals("_deleted")) {
                    if (this.isPlanFileAttribute(planHistory, attribute)) {
                        throw new MigrationFailedException("Plan without plan file: " + itemUID);
                    }
                    fileInfo = null;
                    newFileID = FileID.NO_FILE.getFileUID();
                } else {
                    try {
                        version = Integer.parseInt(oldVersionID);
                    }
                    catch (NumberFormatException nfE) {
                        throw new MigrationFailedException("Invalid file version id: " + oldVersionID + " in item " + itemUID, nfE);
                    }
                    fileInfo = this.getFileInfo(map_fileUIDAndVersion_fileInfo, oldFileDescription.getFileID().getFileID(), version, contextLogInfoStringProvider);
                    newFileID = fileInfo.getFileUID();
                }
                EOFileID_V5 newFileIDAsEO = new EOFileID_V5(newFileID);
                attribute.setValueAsEO(newFileIDAsEO);
                String originalFileName = oldFileDescription.getOriginalFilename();
                if (fileInfo != null) {
                    if (originalFileName != null && originalFileName.trim().length() > 0) {
                        fileInfo.setOriginalFileName(originalFileName);
                    }
                    if (fileInfo.getCreationDate() == null) {
                        fileInfo.setCreationDate(new Timestamp(itemModTime));
                    }
                }
                if (this.isPlanFileAttribute(planHistory, attribute)) {
                    planFileOldID[0] = oldFileDescription.getFileID().getFileID();
                    planFileVersion[0] = version;
                    planFileOriginalFileName[0] = originalFileName;
                }
            }
            EOAttribute_V5 transformedAttribute = new EOAttribute_V5();
            transformedAttribute.setAttributeTypeID(new EOAttributeTypeID_V5(attribute.getAttributeTypeUID().getUID(), attribute.getAttributeTypeUID().getHumanreadableID()));
            transformedAttribute.setValueAsEO(attribute.getValueAsEO());
            transformedAttributes.add(transformedAttribute);
        }
        return transformedAttributes;
    }

    private long determineModTime(EOFrameData_V0 item) {
        for (EOAttribute_V0 attribute : item.getAttributes()) {
            if (!attribute.getAttributeTypeUID().getUID().equals("framedata.lastEditDate")) continue;
            try {
                long modTime = Long.parseLong(((EOString)attribute.getValueAsEO()).getString());
                if (modTime == 0L) continue;
                item.setModTime(new Timestamp(modTime));
                return modTime;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Timestamp modTimeStamp = item.getModTime();
        if (modTimeStamp != null) {
            return modTimeStamp.getTime();
        }
        LOGGER.warn("Item without modification time: type = " + item.getTypeID() + " / uid = " + item.getUID());
        return System.currentTimeMillis();
    }

    private boolean isPlanFileAttribute(EOList<EOFrameData_V5> planHistory, EOAttribute_V0 attribute) {
        return planHistory != null && attribute.getAttributeTypeUID().getUID().equals("frame.plan.planfiledescription");
    }

    private EOFileHistoryItem_V0 getFileInfo(Map<KeyTuple<String, Integer>, EOFileHistoryItem_V0> map_fileUIDAndVersion_fileInfo, String fileID, int version, IContextLogInfoStringProvider contextLogInfoStringProvider) throws MigrationFailedException {
        EOFileHistoryItem_V0 fileInfo = map_fileUIDAndVersion_fileInfo.get(KeyTuple.createKeyTuple((Object)fileID, (int)version));
        if (fileInfo == null) {
            fileInfo = map_fileUIDAndVersion_fileInfo.get(new KeyTuple((Object)fileID, null));
        }
        if (fileInfo == null) {
            fileInfo = this.getFileInfoPatch(map_fileUIDAndVersion_fileInfo, fileID, version, contextLogInfoStringProvider);
        }
        if (fileInfo == null) {
            throw new MigrationFailedException("File attribute for which the referenced file does not existContextInfo=" + contextLogInfoStringProvider.getContextLogInfo() + ".");
        }
        return fileInfo;
    }

    private EOFileHistoryItem_V0 getFileInfoPatch(Map<KeyTuple<String, Integer>, EOFileHistoryItem_V0> map_fileUIDAndVersion_fileInfo, String fileID, int version, IContextLogInfoStringProvider contextLogInfoStringProvider) {
        EOFileHistoryItem_V0 nullVersionItem = null;
        ArrayList<Integer> availableVersionsWithoutNullVersion = new ArrayList<Integer>();
        for (Map.Entry<KeyTuple<String, Integer>, EOFileHistoryItem_V0> fileUIDAndVersion_fileInfo : map_fileUIDAndVersion_fileInfo.entrySet()) {
            KeyTuple<String, Integer> fileUIDAndVersion = fileUIDAndVersion_fileInfo.getKey();
            if (!fileID.equals(fileUIDAndVersion.getComponent1())) continue;
            Integer availableVersion = (Integer)fileUIDAndVersion.getComponent2();
            if (availableVersion == null) {
                nullVersionItem = fileUIDAndVersion_fileInfo.getValue();
                continue;
            }
            availableVersionsWithoutNullVersion.add(availableVersion);
        }
        Collections.sort(availableVersionsWithoutNullVersion);
        int patchVersion = -1;
        for (Integer availableVersion : availableVersionsWithoutNullVersion) {
            patchVersion = availableVersion;
            if (patchVersion >= version) break;
        }
        EOFileHistoryItem_V0 fileInfo = patchVersion != -1 ? map_fileUIDAndVersion_fileInfo.get(KeyTuple.createKeyTuple((Object)fileID, (int)patchVersion)) : nullVersionItem;
        LOGGER.error("Replaced File Version \n   ContextInfo=" + contextLogInfoStringProvider.getContextLogInfo() + "\n   fileID=" + fileID + "\n   version=" + version + "\n   patchVersion=" + patchVersion + "\n   nullVersion=" + (nullVersionItem == null ? "notAvailable" : "available") + "\n   availableVersions=" + availableVersionsWithoutNullVersion.toString());
        return fileInfo;
    }

    private EOList<EOModuleData_V5> transformModuleDataItems(Collection<EOModuleData_V0> items, EOList<EOCommitCountAndCommitInformation_V4> commitInformationItems, Map<KeyTuple<String, Integer>, EOFileHistoryItem_V0> map_fileUIDAndVersion_fileInfo) throws MigrationFailedException {
        EOList transformedItems = new EOList();
        for (EOModuleData_V0 item : items) {
            EOModuleData_V5 transformedItem = this.transformModuleDataItem(item, map_fileUIDAndVersion_fileInfo, commitInformationItems);
            transformedItems.add((EncodableObjectBase)transformedItem);
        }
        return transformedItems;
    }

    private EOModuleData_V5 transformModuleDataItem(final EOModuleData_V0 item, Map<KeyTuple<String, Integer>, EOFileHistoryItem_V0> map_fileUIDAndVersion_fileInfo, EOList<EOCommitCountAndCommitInformation_V4> commitInformationItems) throws MigrationFailedException {
        EOModuleData_V5 transformedItem = new EOModuleData_V5();
        transformedItem.setUID(item.getUid());
        transformedItem.setProjectUID(item.getProjectUID());
        transformedItem.setTypeID(item.getDataTypeUid());
        transformedItem.setModCount(item.getModCount());
        transformedItem.setIsHistoricItem(true);
        transformedItem.setWriteLinkLogsToOutput(true);
        long modTime = item.getModTime();
        int commitIndex = 0;
        while (commitIndex < commitInformationItems.size() - 1 && ((EOCommitCountAndCommitInformation_V4)commitInformationItems.get(commitIndex)).getCommitInformation().getCommitDate().getTime() < modTime) {
            ++commitIndex;
        }
        transformedItem.setCommitCount(((EOCommitCountAndCommitInformation_V4)commitInformationItems.get(commitIndex)).getCommitCount());
        transformedItem.setAttributes(item.getAttributes());
        IContextLogInfoStringProvider contextLogInfoStringProvider = new IContextLogInfoStringProvider(){

            @Override
            public String getContextLogInfo() {
                return "[ ProjectUID=" + item.getProjectUID() + ", ModuleDataItemDataTypeUid=" + item.getDataTypeUid() + ", ModuleDataItemUid=" + item.getUid() + ", ModuleDataItemModCount=" + item.getModCount() + " ]";
            }
        };
        List<EOAttribute_V5> transformedAttributes = this.transformAttributes((Collection<EOAttribute_V0>)item.getCustomAttributes(), map_fileUIDAndVersion_fileInfo, item.getUid(), modTime, null, null, null, null, contextLogInfoStringProvider);
        transformedItem.setCustomAttributes(transformedAttributes);
        if (item instanceof EOVersionedModuleData_V0) {
            transformedItem.addInLinkLogs(this.transformLinkLogs(((EOVersionedModuleData_V0)item).getInLinks()));
            transformedItem.addOutLinkLogs(this.transformLinkLogs(((EOVersionedModuleData_V0)item).getOutLinks()));
        }
        return transformedItem;
    }

    private Collection<EOLinkLog_V5> transformLinkLogs(Collection<EOLinkLog_V0> linkLogs) {
        ArrayList<EOLinkLog_V5> transformedLinkLogs = new ArrayList<EOLinkLog_V5>();
        for (EOLinkLog_V0 linkLog : linkLogs) {
            EOLinkLog_V5 transformedLinkLog = new EOLinkLog_V5(linkLog.getProjectUID(), linkLog.getLinkableObjectUID(), linkLog.getLinkableObjectVersion(), linkLog.getModuleDataUID(), linkLog.getModuleDataVersion(), "", linkLog.getLinkTypeID());
            transformedLinkLogs.add(transformedLinkLog);
        }
        return transformedLinkLogs;
    }

    private EOList<EOCommitCountAndCommitInformation_V4> createFileIndexAndFindAdditionalCommitInformationItems(HistoricProjectDumpView_4_ historicView, EOProject_V0 project, EOList<EOCommitCountAndCommitInformation_V4> commitInformationItems, Map<KeyTuple<String, Integer>, EOFileHistoryItem_V0> map_fileUIDAndVersion_fileInfo, Map<String, Integer> map_commitUID_commitCount) throws MigrationFailedException, EXDecoderException {
        ArrayList<Tuple<EOCommitCountAndCommitInformation_V4, EOFileHistoryItem_V0>> extendedCommitInformationItems = new ArrayList<Tuple<EOCommitCountAndCommitInformation_V4, EOFileHistoryItem_V0>>();
        if (commitInformationItems != null) {
            for (EOCommitCountAndCommitInformation_V4 commitInformationItem : commitInformationItems) {
                extendedCommitInformationItems.add(new Tuple((Object)commitInformationItem, null));
            }
        }
        HashMap<String, String> map_newFileUID_oldFileUID = new HashMap<String, String>();
        File projectDirectory = historicView.getProjectDirectory(project);
        File filesRootDirectory = new File(projectDirectory, "files");
        File[] fileTypeDirectories = filesRootDirectory.listFiles();
        if (fileTypeDirectories != null) {
            File[] fileArray = fileTypeDirectories;
            int n = fileTypeDirectories.length;
            int n2 = 0;
            while (n2 < n) {
                File fileTypeDirectory = fileArray[n2];
                File[] fileDirectories = fileTypeDirectory.listFiles();
                if (fileDirectories != null) {
                    File[] fileArray2 = fileDirectories;
                    int n3 = fileDirectories.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File fileDirectory = fileArray2[n4];
                        if (fileDirectory.isDirectory()) {
                            EOList historyItems = (EOList)historicView.readDataFile(fileDirectory, "versions1", (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{V0_EOFactory.getDefault(), MessageDataFactoryForBasicEOs.getDefault()}));
                            for (EOFileHistoryItem_V0 historyItem : historyItems) {
                                String oldFileUID = historyItem.getFileUID();
                                String newFileUID = UUIDGenerator.getUniqueID();
                                map_newFileUID_oldFileUID.put(newFileUID, oldFileUID);
                                map_fileUIDAndVersion_fileInfo.put((KeyTuple<String, Integer>)KeyTuple.createKeyTuple((Object)oldFileUID, (int)historyItem.getVersionNumber()), historyItem);
                                historyItem.setFileUID(newFileUID);
                                long creationTimeStamp = historyItem.getCreationDate().getTime();
                                int currentCommitInformationIndex = 0;
                                while (extendedCommitInformationItems.size() > currentCommitInformationIndex) {
                                    if (creationTimeStamp < this.determineCreationTimestamp((Tuple<EOCommitCountAndCommitInformation_V4, EOFileHistoryItem_V0>)((Tuple)extendedCommitInformationItems.get(currentCommitInformationIndex)))) break;
                                    ++currentCommitInformationIndex;
                                }
                                extendedCommitInformationItems.add(currentCommitInformationIndex, (Tuple<EOCommitCountAndCommitInformation_V4, EOFileHistoryItem_V0>)new Tuple(null, (Object)historyItem));
                                File sourceFile = new File(fileDirectory, Integer.toString(historyItem.getVersionNumber()));
                                File destinationFile = new File(filesRootDirectory, newFileUID);
                                try {
                                    DataCopyHelper.copyFile((File)sourceFile, (File)destinationFile);
                                }
                                catch (JvmExternalResourceInteractionException jeriE) {
                                    throw new MigrationFailedException("Cannot copy file in archive into files root directory: " + sourceFile.getAbsolutePath(), jeriE);
                                }
                            }
                        } else {
                            throw new MigrationFailedException("File in archive is a file, not a directory.");
                        }
                        ++n4;
                    }
                    try {
                        FileHelper.deleteExistingFileOrDirectory((File)fileTypeDirectory);
                    }
                    catch (JvmExternalResourceInteractionException jeriE) {
                        throw new MigrationFailedException("Cannot delete file type directory: " + fileTypeDirectory.getName(), jeriE);
                    }
                } else {
                    throw new MigrationFailedException("Files type directory is not a directory.");
                }
                ++n2;
            }
        } else {
            LOGGER.warn("No fileTypeDirectories found in: " + filesRootDirectory);
        }
        EOList newCommitInformationItemList = new EOList();
        int index = 0;
        while (index < extendedCommitInformationItems.size()) {
            int intervalStartIndex = index;
            EOCommitCountAndCommitInformation_V4 containedOriginalCommitItem = null;
            HashSet<String> containedPlans = new HashSet<String>();
            while (!(index >= extendedCommitInformationItems.size() || !this.haveEqualCommitComments((Tuple<EOCommitCountAndCommitInformation_V4, EOFileHistoryItem_V0>)((Tuple)extendedCommitInformationItems.get(index)), (Tuple<EOCommitCountAndCommitInformation_V4, EOFileHistoryItem_V0>)((Tuple)extendedCommitInformationItems.get(intervalStartIndex))) || !this.haveEqualCreators((Tuple<EOCommitCountAndCommitInformation_V4, EOFileHistoryItem_V0>)((Tuple)extendedCommitInformationItems.get(index)), (Tuple<EOCommitCountAndCommitInformation_V4, EOFileHistoryItem_V0>)((Tuple)extendedCommitInformationItems.get(intervalStartIndex))) || ((Tuple)extendedCommitInformationItems.get(index)).getT2() == null && containedOriginalCommitItem != null || ((Tuple)extendedCommitInformationItems.get(index)).getT2() != null && containedPlans.contains(map_newFileUID_oldFileUID.get(((EOFileHistoryItem_V0)((Object)((Tuple)extendedCommitInformationItems.get(index)).getT2())).getFileUID())))) {
                if (((Tuple)extendedCommitInformationItems.get(index)).getT2() == null) {
                    containedOriginalCommitItem = (EOCommitCountAndCommitInformation_V4)((Object)((Tuple)extendedCommitInformationItems.get(index)).getT1());
                } else {
                    containedPlans.add((String)map_newFileUID_oldFileUID.get(((EOFileHistoryItem_V0)((Object)((Tuple)extendedCommitInformationItems.get(index)).getT2())).getFileUID()));
                }
                ++index;
            }
            this.makeCommitItem(intervalStartIndex, index - 1, extendedCommitInformationItems, containedOriginalCommitItem, (EOList<EOCommitCountAndCommitInformation_V4>)newCommitInformationItemList);
        }
        int commitCount = 1;
        for (EOCommitCountAndCommitInformation_V4 commitInformationItem : newCommitInformationItemList) {
            commitInformationItem.setCommitCount(commitCount);
            map_commitUID_commitCount.put(commitInformationItem.getCommitInformation().getCommitUID(), commitCount);
            ++commitCount;
        }
        return newCommitInformationItemList;
    }

    private boolean haveEqualCommitComments(Tuple<EOCommitCountAndCommitInformation_V4, EOFileHistoryItem_V0> entryOne, Tuple<EOCommitCountAndCommitInformation_V4, EOFileHistoryItem_V0> entryTwo) {
        return this.determineCommitComment(entryOne).equals(this.determineCommitComment(entryTwo));
    }

    private String determineCommitComment(Tuple<EOCommitCountAndCommitInformation_V4, EOFileHistoryItem_V0> commitInformationOrFileHistoryItem) {
        if (commitInformationOrFileHistoryItem.getT1() != null) {
            return ((EOCommitCountAndCommitInformation_V4)((Object)commitInformationOrFileHistoryItem.getT1())).getCommitInformation().getCommitComment().trim();
        }
        if (commitInformationOrFileHistoryItem.getT2() != null) {
            return ((EOFileHistoryItem_V0)((Object)commitInformationOrFileHistoryItem.getT2())).getModificationComment().trim();
        }
        return null;
    }

    private boolean haveEqualCreators(Tuple<EOCommitCountAndCommitInformation_V4, EOFileHistoryItem_V0> entryOne, Tuple<EOCommitCountAndCommitInformation_V4, EOFileHistoryItem_V0> entryTwo) {
        if (entryOne.getT1() != null) {
            if (entryTwo.getT1() != null) {
                return ((EOCommitCountAndCommitInformation_V4)((Object)entryOne.getT1())).getCommitInformation().getCommitingUserInformation().getDistinguishedName().equals(((EOCommitCountAndCommitInformation_V4)((Object)entryTwo.getT1())).getCommitInformation().getCommitingUserInformation().getDistinguishedName());
            }
            if (entryTwo.getT2() != null) {
                return ((EOCommitCountAndCommitInformation_V4)((Object)entryOne.getT1())).getCommitInformation().getCommitingUserInformation().getDistinguishedName().equals(((EOFileHistoryItem_V0)((Object)entryTwo.getT2())).getAuthor()) || ((EOCommitCountAndCommitInformation_V4)((Object)entryOne.getT1())).getCommitInformation().getCommitingUserInformation().getLoginID().equals(((EOFileHistoryItem_V0)((Object)entryTwo.getT2())).getAuthor()) || this.ensureNonNull(((EOCommitCountAndCommitInformation_V4)((Object)entryOne.getT1())).getCommitInformation().getCommitingUserInformation().getRealName()).equals(((EOFileHistoryItem_V0)((Object)entryTwo.getT2())).getAuthor());
            }
            return false;
        }
        if (entryOne.getT2() != null) {
            if (entryTwo.getT1() != null) {
                return ((EOCommitCountAndCommitInformation_V4)((Object)entryTwo.getT1())).getCommitInformation().getCommitingUserInformation().getDistinguishedName().equals(((EOFileHistoryItem_V0)((Object)entryOne.getT2())).getAuthor()) || ((EOCommitCountAndCommitInformation_V4)((Object)entryTwo.getT1())).getCommitInformation().getCommitingUserInformation().getLoginID().equals(((EOFileHistoryItem_V0)((Object)entryOne.getT2())).getAuthor()) || this.ensureNonNull(((EOCommitCountAndCommitInformation_V4)((Object)entryTwo.getT1())).getCommitInformation().getCommitingUserInformation().getRealName()).equals(((EOFileHistoryItem_V0)((Object)entryOne.getT2())).getAuthor());
            }
            if (entryTwo.getT2() != null) {
                return ((EOFileHistoryItem_V0)((Object)entryOne.getT2())).getAuthor().equals(((EOFileHistoryItem_V0)((Object)entryTwo.getT2())).getAuthor());
            }
            return false;
        }
        return false;
    }

    private String ensureNonNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private long determineCreationTimestamp(Tuple<EOCommitCountAndCommitInformation_V4, EOFileHistoryItem_V0> commitInformationOrFileHistoryItem) {
        if (commitInformationOrFileHistoryItem.getT1() != null) {
            return ((EOCommitCountAndCommitInformation_V4)((Object)commitInformationOrFileHistoryItem.getT1())).getCommitInformation().getCommitDate().getTime();
        }
        if (commitInformationOrFileHistoryItem.getT2() != null) {
            return ((EOFileHistoryItem_V0)((Object)commitInformationOrFileHistoryItem.getT2())).getCreationDate().getTime();
        }
        return 0L;
    }

    private void makeCommitItem(int intervalStartIndex, int intervalEndIndex, List<Tuple<EOCommitCountAndCommitInformation_V4, EOFileHistoryItem_V0>> extendedCommitInformationItems, EOCommitCountAndCommitInformation_V4 containedOriginalCommitItem, EOList<EOCommitCountAndCommitInformation_V4> newCommitInformationItemList) {
        EOCommitCountAndCommitInformation_V4 commitItemForInterval;
        if (containedOriginalCommitItem != null) {
            commitItemForInterval = containedOriginalCommitItem;
        } else {
            String newCommitUID = UUIDGenerator.getUniqueID();
            EOFileHistoryItem_V0 historyItem = (EOFileHistoryItem_V0)((Object)extendedCommitInformationItems.get(intervalStartIndex).getT2());
            commitItemForInterval = new EOCommitCountAndCommitInformation_V4(1, new EOCommitInformation_V4(newCommitUID, new Date(historyItem.getCreationDate().getTime()), new EOUserInformation_V4("PSC-Server", null, "unknown", "", historyItem.getAuthor()), historyItem.getModificationComment()));
        }
        int index = intervalStartIndex;
        while (index <= intervalEndIndex) {
            EOFileHistoryItem_V0 fileHistoryItem = (EOFileHistoryItem_V0)((Object)extendedCommitInformationItems.get(index).getT2());
            if (fileHistoryItem != null) {
                fileHistoryItem.setNewCommitUID(commitItemForInterval.getCommitInformation().getCommitUID());
            }
            ++index;
        }
        newCommitInformationItemList.add((EncodableObjectBase)commitItemForInterval);
    }

    private void createFileIndex(HistoricProjectFileView_4_ historicView, Map<KeyTuple<String, Integer>, EOFileHistoryItem_V0> map_fileUIDAndVersion_fileInfo) throws MigrationFailedException {
        try {
            File filesRootDirectory = historicView.getFilesRoot();
            for (File fileTypeDirectory : historicView.getAllDirectoriesWithFiles()) {
                File[] files = fileTypeDirectory.listFiles();
                if (files != null) {
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        String newFileUID = UUIDGenerator.getUniqueID();
                        File targetFileInFileRootDirectory = new File(filesRootDirectory, newFileUID);
                        EOFileHistoryItem_V0 fileInfo = new EOFileHistoryItem_V0();
                        fileInfo.setFileUID(newFileUID);
                        fileInfo.setOriginalFileName("");
                        map_fileUIDAndVersion_fileInfo.put((KeyTuple<String, Integer>)new KeyTuple((Object)file.getName(), null), fileInfo);
                        try {
                            DataCopyHelper.copyFile((File)file, (File)targetFileInFileRootDirectory);
                        }
                        catch (JvmExternalResourceInteractionException jeriE) {
                            throw new MigrationFailedException("File in archive can not be copied: " + file.getName());
                        }
                        ++n2;
                    }
                }
                try {
                    FileHelper.deleteExistingFileOrDirectory((File)fileTypeDirectory);
                }
                catch (JvmExternalResourceInteractionException jeriE) {
                    throw new MigrationFailedException("Cannot delete file type directory: " + fileTypeDirectory.getName(), jeriE);
                }
            }
        }
        catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
            throw new MigrationFailedException("Project file could not be accessed.", pfaE);
        }
    }

    private static EOList<EOFileMetaInformation_V5> getFileMetaInformation(Map<KeyTuple<String, Integer>, EOFileHistoryItem_V0> map_fileIDANDVersion_fileInfo, Map<String, Integer> map_commitUID_commitCount, String projectUID) {
        EOList fileMetaInformation = new EOList();
        for (Map.Entry<KeyTuple<String, Integer>, EOFileHistoryItem_V0> fileEntry : map_fileIDANDVersion_fileInfo.entrySet()) {
            EOFileHistoryItem_V0 fileInfo = fileEntry.getValue();
            if (fileInfo.getCreationDate() == null) {
                LOGGER.warn("File that is not used by any object anymore: UID = " + (String)fileEntry.getKey().getComponent1());
                continue;
            }
            String fileUID = fileInfo.getFileUID();
            String originalFileName = fileInfo.getOriginalFileName();
            long creationDate = fileInfo.getCreationDate().getTime();
            int commitCount = map_commitUID_commitCount != null ? map_commitUID_commitCount.get(fileInfo.getNewCommitUID()) : 1;
            EOFileMetaInformation_V5 fileMetaInformationItem = new EOFileMetaInformation_V5(fileUID, projectUID, commitCount, originalFileName, creationDate);
            fileMetaInformation.add((EncodableObjectBase)fileMetaInformationItem);
        }
        return fileMetaInformation;
    }

    private static interface IContextLogInfoStringProvider {
        public String getContextLogInfo();
    }
}

